/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.runtime.log;

import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.remoteServer.impl.runtime.log.CloudTerminalProvider;
import com.intellij.remoteServer.impl.runtime.log.LoggingHandlerImpl;
import com.intellij.remoteServer.impl.runtime.log.TerminalHandlerBase;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConsoleTerminalHandlerImpl
extends TerminalHandlerBase {
    private static final Logger LOG = Logger.getInstance((String)("#" + ConsoleTerminalHandlerImpl.class.getName()));
    public static final CloudTerminalProvider PROVIDER = new CloudTerminalProvider(){

        @Override
        public TerminalHandlerBase createTerminal(@NotNull String presentableName, @NotNull Project project, @NotNull InputStream terminalOutput, @NotNull OutputStream terminalInput) {
            if (presentableName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentableName", "com/intellij/remoteServer/impl/runtime/log/ConsoleTerminalHandlerImpl$1", "createTerminal"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/remoteServer/impl/runtime/log/ConsoleTerminalHandlerImpl$1", "createTerminal"));
            }
            if (terminalOutput == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "terminalOutput", "com/intellij/remoteServer/impl/runtime/log/ConsoleTerminalHandlerImpl$1", "createTerminal"));
            }
            if (terminalInput == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "terminalInput", "com/intellij/remoteServer/impl/runtime/log/ConsoleTerminalHandlerImpl$1", "createTerminal"));
            }
            return new ConsoleTerminalHandlerImpl(presentableName, project, terminalOutput, terminalInput);
        }

        @Override
        public boolean isTtySupported() {
            return false;
        }
    };
    private final LoggingHandlerImpl myLoggingHandler;

    public ConsoleTerminalHandlerImpl(String presentableName, Project project, final InputStream terminalOutput, final OutputStream terminalInput) {
        super(presentableName);
        this.myLoggingHandler = new LoggingHandlerImpl(presentableName, project);
        this.myLoggingHandler.attachToProcess(new ProcessHandler(){

            protected void destroyProcessImpl() {
            }

            protected void detachProcessImpl() {
            }

            public boolean detachIsDefault() {
                return false;
            }

            @Nullable
            public OutputStream getProcessInput() {
                return terminalInput;
            }
        });
        Disposer.register((Disposable)this, (Disposable)this.myLoggingHandler);
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

            @Override
            public void run() {
                BufferedReader outputReader = new BufferedReader(new InputStreamReader(terminalOutput));
                try {
                    while (!ConsoleTerminalHandlerImpl.this.isClosed()) {
                        String line = outputReader.readLine();
                        if (line == null) {
                            break;
                        }
                        ConsoleTerminalHandlerImpl.this.myLoggingHandler.print(line + "\n");
                    }
                }
                catch (IOException e) {
                    LOG.debug((Throwable)e);
                }
                finally {
                    try {
                        outputReader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        });
    }

    @Override
    public JComponent getComponent() {
        return this.myLoggingHandler.getComponent();
    }
}

