/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher.handlers;

import com.intellij.dupLocator.iterators.ArrayBackedNodeIterator;
import com.intellij.dupLocator.iterators.CountingNodeIterator;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.structuralsearch.impl.matcher.GlobalMatchingVisitor;
import com.intellij.structuralsearch.impl.matcher.MatchContext;
import com.intellij.structuralsearch.impl.matcher.handlers.MatchingHandler;
import com.intellij.structuralsearch.impl.matcher.iterators.SsrFilteringNodeIterator;
import java.util.ArrayList;

public class DeclarationStatementHandler
extends MatchingHandler {
    private MatchingHandler myCommentHandler;

    @Override
    public boolean match(PsiElement patternNode, PsiElement matchedNode, MatchContext context) {
        if (patternNode instanceof PsiComment) {
            return this.myCommentHandler.match(patternNode, matchedNode, context);
        }
        if (!super.match(patternNode, matchedNode, context)) {
            return false;
        }
        PsiDeclarationStatement dcl = (PsiDeclarationStatement)patternNode;
        if (matchedNode instanceof PsiDeclarationStatement) {
            return GlobalMatchingVisitor.continueMatchingSequentially(new SsrFilteringNodeIterator(patternNode.getFirstChild()), new SsrFilteringNodeIterator(matchedNode.getFirstChild()), context);
        }
        PsiElement[] declared = dcl.getDeclaredElements();
        if (declared.length > 0 && !(matchedNode.getParent() instanceof PsiDeclarationStatement)) {
            PsiElement lastChild;
            if (!(matchedNode instanceof PsiField)) {
                return GlobalMatchingVisitor.continueMatchingSequentially(new ArrayBackedNodeIterator(declared), new CountingNodeIterator(declared.length, new SsrFilteringNodeIterator(matchedNode)), context);
            }
            PsiElement sibling = PsiTreeUtil.skipSiblingsBackward((PsiElement)matchedNode, (Class[])new Class[]{PsiWhiteSpace.class});
            if (PsiUtil.isJavaToken((PsiElement)sibling, (IElementType)JavaTokenType.COMMA)) {
                return false;
            }
            ArrayList<PsiElement> matchNodes = new ArrayList<PsiElement>();
            matchNodes.add(matchedNode);
            PsiElement node = matchedNode;
            node = PsiTreeUtil.skipSiblingsForward((PsiElement)node, (Class[])new Class[]{PsiWhiteSpace.class});
            while (PsiUtil.isJavaToken((PsiElement)node, (IElementType)JavaTokenType.COMMA)) {
                if ((node = PsiTreeUtil.skipSiblingsForward((PsiElement)node, (Class[])new Class[]{PsiWhiteSpace.class})) != null) {
                    matchNodes.add(node);
                }
                node = PsiTreeUtil.skipSiblingsForward((PsiElement)node, (Class[])new Class[]{PsiWhiteSpace.class});
            }
            boolean result = GlobalMatchingVisitor.continueMatchingSequentially(new ArrayBackedNodeIterator(declared), new ArrayBackedNodeIterator(matchNodes.toArray(new PsiElement[matchNodes.size()])), context);
            if (result && declared[0] instanceof PsiVariable && (lastChild = dcl.getLastChild()) instanceof PsiComment) {
                PsiElement[] fieldChildren = matchedNode.getChildren();
                result = context.getPattern().getHandler(lastChild).match(lastChild, fieldChildren[fieldChildren.length - 1], context);
            }
            return result;
        }
        return false;
    }

    @Override
    public boolean shouldAdvanceTheMatchFor(PsiElement patternElement, PsiElement matchedElement) {
        if (patternElement instanceof PsiComment && (matchedElement instanceof PsiField || matchedElement instanceof PsiClass)) {
            return false;
        }
        return super.shouldAdvanceTheMatchFor(patternElement, matchedElement);
    }

    public void setCommentHandler(MatchingHandler commentHandler) {
        this.myCommentHandler = commentHandler;
    }
}

