/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher.handlers;

import com.intellij.dupLocator.iterators.NodeIterator;
import com.intellij.dupLocator.util.NodeFilter;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.impl.matcher.CompiledPattern;
import com.intellij.structuralsearch.impl.matcher.MatchContext;
import com.intellij.structuralsearch.impl.matcher.MatchResultImpl;
import com.intellij.structuralsearch.impl.matcher.filters.DefaultFilter;
import com.intellij.structuralsearch.impl.matcher.handlers.MatchPredicate;
import com.intellij.structuralsearch.impl.matcher.handlers.SubstitutionHandler;
import com.intellij.structuralsearch.impl.matcher.predicates.BinaryPredicate;
import com.intellij.structuralsearch.impl.matcher.predicates.NotPredicate;
import com.intellij.structuralsearch.impl.matcher.predicates.RegExpPredicate;
import com.intellij.structuralsearch.impl.matcher.strategies.MatchingStrategy;
import java.util.HashSet;

public abstract class MatchingHandler
extends MatchPredicate {
    protected NodeFilter filter;
    private PsiElement pinnedElement;
    protected static ClearStateVisitor clearingVisitor = new ClearStateVisitor();

    public void setFilter(NodeFilter filter) {
        this.filter = filter;
    }

    @Override
    public boolean match(PsiElement patternNode, PsiElement matchedNode, int start, int end, MatchContext context) {
        return this.match(patternNode, matchedNode, context);
    }

    @Override
    public boolean match(PsiElement patternNode, PsiElement matchedNode, MatchContext context) {
        if (patternNode == null) {
            return matchedNode == null;
        }
        return this.canMatch(patternNode, matchedNode);
    }

    public boolean canMatch(PsiElement patternNode, PsiElement matchedNode) {
        if (this.filter != null) {
            return this.filter.accepts(matchedNode);
        }
        return DefaultFilter.accepts(patternNode, matchedNode);
    }

    public boolean matchSequentially(NodeIterator nodes, NodeIterator nodes2, MatchContext context) {
        MatchingStrategy strategy = context.getPattern().getStrategy();
        MatchingHandler.skipIfNecessary(nodes, nodes2, strategy);
        MatchingHandler.skipIfNecessary(nodes2, nodes, strategy);
        PsiElement patternElement = nodes.current();
        MatchingHandler handler = context.getPattern().getHandler(patternElement);
        if (nodes2.hasNext() && handler.match(patternElement, nodes2.current(), context)) {
            boolean shouldRewindOnMatchFailure;
            nodes.advance();
            if (this.shouldAdvanceTheMatchFor(patternElement, nodes2.current())) {
                nodes2.advance();
                MatchingHandler.skipIfNecessary(nodes, nodes2, strategy);
                shouldRewindOnMatchFailure = true;
            } else {
                shouldRewindOnMatchFailure = false;
            }
            MatchingHandler.skipIfNecessary(nodes2, nodes, strategy);
            if (nodes.hasNext()) {
                MatchingHandler nextHandler = context.getPattern().getHandler(nodes.current());
                if (nextHandler.matchSequentially(nodes, nodes2, context)) {
                    return true;
                }
                nodes.rewind();
                if (shouldRewindOnMatchFailure) {
                    nodes2.rewind();
                }
            } else {
                return handler.isMatchSequentiallySucceeded(nodes2);
            }
        }
        return false;
    }

    private static void skipIfNecessary(NodeIterator nodes, NodeIterator nodes2, MatchingStrategy strategy) {
        while (strategy.shouldSkip(nodes2.current(), nodes.current())) {
            nodes2.advance();
        }
    }

    protected boolean isMatchSequentiallySucceeded(NodeIterator nodes2) {
        return !nodes2.hasNext();
    }

    private static MatchPredicate findRegExpPredicate(MatchPredicate start) {
        if (start == null) {
            return null;
        }
        if (start instanceof RegExpPredicate) {
            return start;
        }
        if (start instanceof BinaryPredicate) {
            BinaryPredicate binary = (BinaryPredicate)start;
            MatchPredicate result = MatchingHandler.findRegExpPredicate(binary.getFirst());
            if (result != null) {
                return result;
            }
            return MatchingHandler.findRegExpPredicate(binary.getSecond());
        }
        if (start instanceof NotPredicate) {
            return null;
        }
        return null;
    }

    public static RegExpPredicate getSimpleRegExpPredicate(SubstitutionHandler handler) {
        if (handler == null) {
            return null;
        }
        return (RegExpPredicate)MatchingHandler.findRegExpPredicate(handler.getPredicate());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean matchInAnyOrder(NodeIterator patternNodes, NodeIterator matchedNodes, MatchContext context) {
        MatchResultImpl saveResult = context.hasResult() ? context.getResult() : null;
        context.setResult(null);
        try {
            if (patternNodes.hasNext() && !matchedNodes.hasNext()) {
                boolean bl = MatchingHandler.validateSatisfactionOfHandlers(patternNodes, context);
                return bl;
            }
            HashSet<PsiElement> matchedElements = null;
            while (patternNodes.hasNext()) {
                PsiElement patternNode = patternNodes.current();
                CompiledPattern pattern = context.getPattern();
                MatchingHandler handler = pattern.getHandler(patternNode);
                PsiElement startMatching = matchedNodes.current();
                while (true) {
                    PsiElement element;
                    PsiElement matchedNode;
                    PsiElement psiElement = matchedNode = (element = handler.getPinnedNode(null)) != null ? element : matchedNodes.current();
                    if (element == null) {
                        matchedNodes.advance();
                    }
                    if (!matchedNodes.hasNext()) {
                        matchedNodes.reset();
                    }
                    if (matchedElements == null || !matchedElements.contains(matchedNode)) {
                        if (handler.match(patternNode, matchedNode, context)) {
                            if (matchedElements == null) {
                                matchedElements = new HashSet<PsiElement>();
                            }
                            matchedElements.add(matchedNode);
                            if (handler.shouldAdvanceThePatternFor(patternNode, matchedNode)) {
                                break;
                            }
                        } else if (element != null) {
                            boolean bl = false;
                            return bl;
                        }
                        clearingVisitor.clearState(pattern, patternNode);
                    }
                    if (startMatching != matchedNodes.current()) continue;
                    boolean result = MatchingHandler.validateSatisfactionOfHandlers(patternNodes, context);
                    if (result && context.getMatchedElementsListener() != null) {
                        context.getMatchedElementsListener().matchedElements(matchedElements);
                    }
                    boolean bl = result;
                    return bl;
                }
                if (!handler.shouldAdvanceThePatternFor(patternNode, null)) {
                    patternNodes.rewind();
                }
                patternNodes.advance();
            }
            boolean result = MatchingHandler.validateSatisfactionOfHandlers(patternNodes, context);
            if (result && context.getMatchedElementsListener() != null) {
                context.getMatchedElementsListener().matchedElements(matchedElements);
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (saveResult != null) {
                if (context.hasResult()) {
                    saveResult.getMatches().addAll(context.getResult().getMatches());
                }
                context.setResult(saveResult);
            }
        }
    }

    protected static boolean validateSatisfactionOfHandlers(NodeIterator nodes, MatchContext context) {
        while (nodes.hasNext()) {
            PsiElement element = nodes.current();
            MatchingHandler handler = context.getPattern().getHandler(element);
            if (handler instanceof SubstitutionHandler) {
                if (!((SubstitutionHandler)handler).validate(context, StructuralSearchUtil.getProfileByPsiElement(element).getElementContextByPsi(element))) {
                    return false;
                }
            } else {
                return false;
            }
            nodes.advance();
        }
        return true;
    }

    public NodeFilter getFilter() {
        return this.filter;
    }

    public boolean shouldAdvanceThePatternFor(PsiElement patternElement, PsiElement matchedElement) {
        return true;
    }

    public boolean shouldAdvanceTheMatchFor(PsiElement patternElement, PsiElement matchedElement) {
        return true;
    }

    public void reset() {
    }

    public PsiElement getPinnedNode(PsiElement context) {
        return this.pinnedElement;
    }

    public void setPinnedElement(PsiElement pinnedElement) {
        this.pinnedElement = pinnedElement;
    }

    static class ClearStateVisitor
    extends PsiRecursiveElementWalkingVisitor {
        private CompiledPattern pattern;

        ClearStateVisitor() {
            super(true);
        }

        public void visitElement(PsiElement element) {
            MatchingHandler handler;
            if (this.pattern.isToResetHandler(element) && (handler = this.pattern.getHandlerSimple(element)) instanceof SubstitutionHandler) {
                handler.reset();
            }
            super.visitElement(element);
        }

        synchronized void clearState(CompiledPattern _pattern, PsiElement el) {
            this.pattern = _pattern;
            el.acceptChildren((PsiElementVisitor)this);
            this.pattern = null;
        }
    }
}

