/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures;

import com.intellij.codeInsight.editorActions.SelectWordHandler;
import com.intellij.codeInsight.editorActions.smartEnter.SmartEnterProcessor;
import com.intellij.codeInsight.editorActions.smartEnter.SmartEnterProcessors;
import com.intellij.codeInsight.generation.surroundWith.SurroundWithHandler;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateSettings;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.codeInsight.template.impl.actions.ListTemplatesAction;
import com.intellij.ide.DataManager;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.surroundWith.Surrounder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.refactoring.rename.inplace.VariableInplaceRenameHandler;
import com.intellij.testFramework.fixtures.CodeInsightTestFixture;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

public class CodeInsightTestUtil {
    private CodeInsightTestUtil() {
    }

    @Nullable
    public static IntentionAction findIntentionByText(@NotNull List<IntentionAction> actions, @NonNls @NotNull String text) {
        if (actions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actions", "com/intellij/testFramework/fixtures/CodeInsightTestUtil", "findIntentionByText"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/testFramework/fixtures/CodeInsightTestUtil", "findIntentionByText"));
        }
        for (IntentionAction action : actions) {
            String s = action.getText();
            if (!s.equals(text)) continue;
            return action;
        }
        return null;
    }

    public static void doIntentionTest(CodeInsightTestFixture fixture, @NonNls String file, @NonNls String actionText) {
        String extension = FileUtilRt.getExtension((String)file);
        file = FileUtil.getNameWithoutExtension((String)file);
        if (extension.isEmpty()) {
            extension = "xml";
        }
        CodeInsightTestUtil.doIntentionTest(fixture, actionText, file + "." + extension, file + "_after." + extension);
    }

    public static void doIntentionTest(final @NotNull CodeInsightTestFixture fixture, @NonNls String action, @NotNull String before, @NotNull String after) {
        if (fixture == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fixture", "com/intellij/testFramework/fixtures/CodeInsightTestUtil", "doIntentionTest"));
        }
        if (before == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "before", "com/intellij/testFramework/fixtures/CodeInsightTestUtil", "doIntentionTest"));
        }
        if (after == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "after", "com/intellij/testFramework/fixtures/CodeInsightTestUtil", "doIntentionTest"));
        }
        fixture.configureByFile(before);
        List<IntentionAction> availableIntentions = fixture.getAvailableIntentions();
        final IntentionAction intentionAction = CodeInsightTestUtil.findIntentionByText(availableIntentions, action);
        if (intentionAction == null) {
            Assert.fail((String)("Action not found: " + action + " in place: " + fixture.getElementAtCaret() + " among " + availableIntentions));
        }
        new WriteCommandAction(fixture.getProject(), new PsiFile[0]){

            protected void run(Result result) throws Throwable {
                fixture.launchAction(intentionAction);
            }
        }.execute();
        UIUtil.dispatchAllInvocationEvents();
        fixture.checkResultByFile(after, false);
    }

    public static void doWordSelectionTest(@NotNull CodeInsightTestFixture fixture, @NotNull String before, String ... after) {
        if (fixture == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fixture", "com/intellij/testFramework/fixtures/CodeInsightTestUtil", "doWordSelectionTest"));
        }
        if (before == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "before", "com/intellij/testFramework/fixtures/CodeInsightTestUtil", "doWordSelectionTest"));
        }
        assert (after != null && after.length > 0);
        fixture.configureByFile(before);
        SelectWordHandler action = new SelectWordHandler(null);
        DataContext dataContext = DataManager.getInstance().getDataContext((Component)fixture.getEditor().getComponent());
        for (String file : after) {
            action.execute(fixture.getEditor(), dataContext);
            fixture.checkResultByFile(file, false);
        }
    }

    public static void doWordSelectionTestOnDirectory(@NotNull CodeInsightTestFixture fixture, @NotNull String directoryName, @NotNull String filesExtension) {
        if (fixture == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fixture", "com/intellij/testFramework/fixtures/CodeInsightTestUtil", "doWordSelectionTestOnDirectory"));
        }
        if (directoryName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directoryName", "com/intellij/testFramework/fixtures/CodeInsightTestUtil", "doWordSelectionTestOnDirectory"));
        }
        if (filesExtension == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filesExtension", "com/intellij/testFramework/fixtures/CodeInsightTestUtil", "doWordSelectionTestOnDirectory"));
        }
        SelectWordHandler action = new SelectWordHandler(null);
        fixture.copyDirectoryToProject(directoryName, directoryName);
        fixture.configureByFile(directoryName + "/before." + filesExtension);
        int i = 1;
        while (true) {
            String fileName = directoryName + "/after" + i + "." + filesExtension;
            if (!new File(fixture.getTestDataPath() + "/" + fileName).exists()) break;
            action.execute(fixture.getEditor(), DataManager.getInstance().getDataContext((Component)fixture.getEditor().getComponent()));
            fixture.checkResultByFile(fileName);
            ++i;
        }
        junit.framework.Assert.assertTrue((String)"At least one 'after'-file required", (i > 1 ? 1 : 0) != 0);
    }

    public static void doSurroundWithTest(final @NotNull CodeInsightTestFixture fixture, final @NotNull Surrounder surrounder, @NotNull String before, @NotNull String after) {
        if (fixture == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fixture", "com/intellij/testFramework/fixtures/CodeInsightTestUtil", "doSurroundWithTest"));
        }
        if (surrounder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "surrounder", "com/intellij/testFramework/fixtures/CodeInsightTestUtil", "doSurroundWithTest"));
        }
        if (before == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "before", "com/intellij/testFramework/fixtures/CodeInsightTestUtil", "doSurroundWithTest"));
        }
        if (after == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "after", "com/intellij/testFramework/fixtures/CodeInsightTestUtil", "doSurroundWithTest"));
        }
        fixture.configureByFile(before);
        new WriteCommandAction.Simple(fixture.getProject(), new PsiFile[0]){

            protected void run() throws Throwable {
                SurroundWithHandler.invoke(fixture.getProject(), fixture.getEditor(), fixture.getFile(), surrounder);
            }
        }.execute();
        fixture.checkResultByFile(after, false);
    }

    public static void doLiveTemplateTest(final @NotNull CodeInsightTestFixture fixture, @NotNull String before, @NotNull String after) {
        if (fixture == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fixture", "com/intellij/testFramework/fixtures/CodeInsightTestUtil", "doLiveTemplateTest"));
        }
        if (before == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "before", "com/intellij/testFramework/fixtures/CodeInsightTestUtil", "doLiveTemplateTest"));
        }
        if (after == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "after", "com/intellij/testFramework/fixtures/CodeInsightTestUtil", "doLiveTemplateTest"));
        }
        fixture.configureByFile(before);
        new WriteCommandAction(fixture.getProject(), new PsiFile[0]){

            protected void run(Result result) throws Throwable {
                new ListTemplatesAction().actionPerformedImpl(fixture.getProject(), fixture.getEditor());
                LookupImpl lookup = (LookupImpl)LookupManager.getActiveLookup(fixture.getEditor());
                assert (lookup != null);
                lookup.finishLookup('\n');
            }
        }.execute();
        fixture.checkResultByFile(after, false);
    }

    public static void doSmartEnterTest(final @NotNull CodeInsightTestFixture fixture, @NotNull String before, @NotNull String after) {
        if (fixture == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fixture", "com/intellij/testFramework/fixtures/CodeInsightTestUtil", "doSmartEnterTest"));
        }
        if (before == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "before", "com/intellij/testFramework/fixtures/CodeInsightTestUtil", "doSmartEnterTest"));
        }
        if (after == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "after", "com/intellij/testFramework/fixtures/CodeInsightTestUtil", "doSmartEnterTest"));
        }
        fixture.configureByFile(before);
        final List processors = SmartEnterProcessors.INSTANCE.forKey((Object)fixture.getFile().getLanguage());
        new WriteCommandAction(fixture.getProject(), new PsiFile[0]){

            protected void run(Result result) throws Throwable {
                Editor editor = fixture.getEditor();
                for (SmartEnterProcessor processor : processors) {
                    processor.process(this.getProject(), editor, fixture.getFile());
                }
            }
        }.execute();
        fixture.checkResultByFile(after, false);
    }

    public static void doFormattingTest(final @NotNull CodeInsightTestFixture fixture, @NotNull String before, @NotNull String after) {
        if (fixture == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fixture", "com/intellij/testFramework/fixtures/CodeInsightTestUtil", "doFormattingTest"));
        }
        if (before == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "before", "com/intellij/testFramework/fixtures/CodeInsightTestUtil", "doFormattingTest"));
        }
        if (after == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "after", "com/intellij/testFramework/fixtures/CodeInsightTestUtil", "doFormattingTest"));
        }
        fixture.configureByFile(before);
        new WriteCommandAction(fixture.getProject(), new PsiFile[0]){

            protected void run(Result result) throws Throwable {
                CodeStyleManager.getInstance((Project)fixture.getProject()).reformat((PsiElement)fixture.getFile());
            }
        }.execute();
        fixture.checkResultByFile(after, false);
    }

    public static void doInlineRename(VariableInplaceRenameHandler handler, String newName, CodeInsightTestFixture fixture) {
        CodeInsightTestUtil.doInlineRename(handler, newName, fixture.getEditor(), fixture.getElementAtCaret());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doInlineRename(VariableInplaceRenameHandler handler, final String newName, @NotNull Editor editor, PsiElement elementAtCaret) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/testFramework/fixtures/CodeInsightTestUtil", "doInlineRename"));
        }
        Project project = editor.getProject();
        TemplateManagerImpl templateManager = (TemplateManagerImpl)TemplateManager.getInstance(project);
        try {
            templateManager.setTemplateTesting(true);
            handler.doRename(elementAtCaret, editor, DataManager.getInstance().getDataContext((Component)editor.getComponent()));
            if (editor instanceof EditorWindow) {
                editor = ((EditorWindow)editor).getDelegate();
            }
            TemplateState state = TemplateManagerImpl.getTemplateState(editor);
            assert (state != null);
            final TextRange range = state.getCurrentVariableRange();
            assert (range != null);
            final Editor finalEditor = editor;
            new WriteCommandAction.Simple(project, new PsiFile[0]){

                protected void run() throws Throwable {
                    finalEditor.getDocument().replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)newName);
                }
            }.execute().throwException();
            state = TemplateManagerImpl.getTemplateState(editor);
            assert (state != null);
            state.gotoEnd(false);
        }
        finally {
            templateManager.setTemplateTesting(false);
        }
    }

    public static void doInlineRenameTest(VariableInplaceRenameHandler handler, String file, String extension, String newName, CodeInsightTestFixture fixture) {
        fixture.configureByFile(file + "." + extension);
        CodeInsightTestUtil.doInlineRename(handler, newName, fixture);
        fixture.checkResultByFile(file + "_after." + extension);
    }

    public static void doActionTest(AnAction action, String file, CodeInsightTestFixture fixture) {
        String extension = FileUtilRt.getExtension((String)file);
        String name = FileUtil.getNameWithoutExtension((String)file);
        fixture.configureByFile(file);
        fixture.testAction(action);
        fixture.checkResultByFile(name + "_after." + extension);
    }

    public static void addTemplate(final Template template, Disposable parentDisposable) {
        final TemplateSettings settings = TemplateSettings.getInstance();
        settings.addTemplate(template);
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                settings.removeTemplate(template);
            }
        });
    }
}

