/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui.tree;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import org.jetbrains.annotations.NotNull;

public class NonContentFileFilter
implements VirtualFileFilter {
    private final Project project;
    private final VirtualFileFilter filter;
    private ProjectFileIndex fileIndex;

    public NonContentFileFilter(@NotNull Project project, @NotNull VirtualFileFilter filter) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/util/ui/tree/NonContentFileFilter", "<init>"));
        }
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/util/ui/tree/NonContentFileFilter", "<init>"));
        }
        this.project = project;
        this.filter = filter;
    }

    public boolean accept(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/ui/tree/NonContentFileFilter", "accept"));
        }
        if (!this.filter.accept(file)) {
            return false;
        }
        if (this.fileIndex == null) {
            this.fileIndex = ProjectRootManager.getInstance((Project)this.project).getFileIndex();
        }
        return this.fileIndex.isInContent(file);
    }
}

