/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogHashMap;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogRefManager;
import com.intellij.vcs.log.VcsLogRefs;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.EmptyPermanentGraph;
import com.intellij.vcs.log.data.RefsModel;
import com.intellij.vcs.log.data.VcsLogHashMapImpl;
import com.intellij.vcs.log.graph.GraphColorManagerImpl;
import com.intellij.vcs.log.graph.GraphCommit;
import com.intellij.vcs.log.graph.PermanentGraph;
import com.intellij.vcs.log.graph.impl.facade.PermanentGraphImpl;
import com.intellij.vcs.log.util.StopWatch;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class DataPack {
    public static final DataPack EMPTY = DataPack.createEmptyInstance();
    @NotNull
    private final RefsModel myRefsModel;
    @NotNull
    private final PermanentGraph<Integer> myPermanentGraph;
    @NotNull
    private final Map<VirtualFile, VcsLogProvider> myLogProviders;
    private boolean myFull;

    DataPack(@NotNull RefsModel refsModel, @NotNull PermanentGraph<Integer> permanentGraph, @NotNull Map<VirtualFile, VcsLogProvider> providers, boolean full) {
        if (refsModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refsModel", "com/intellij/vcs/log/data/DataPack", "<init>"));
        }
        if (permanentGraph == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "permanentGraph", "com/intellij/vcs/log/data/DataPack", "<init>"));
        }
        if (providers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "providers", "com/intellij/vcs/log/data/DataPack", "<init>"));
        }
        this.myRefsModel = refsModel;
        this.myPermanentGraph = permanentGraph;
        this.myLogProviders = providers;
        this.myFull = full;
    }

    @NotNull
    static DataPack build(@NotNull List<? extends GraphCommit<Integer>> commits, @NotNull Map<VirtualFile, Set<VcsRef>> refs, @NotNull Map<VirtualFile, VcsLogProvider> providers, @NotNull VcsLogHashMap hashMap, boolean full) {
        if (commits == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commits", "com/intellij/vcs/log/data/DataPack", "build"));
        }
        if (refs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refs", "com/intellij/vcs/log/data/DataPack", "build"));
        }
        if (providers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "providers", "com/intellij/vcs/log/data/DataPack", "build"));
        }
        if (hashMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashMap", "com/intellij/vcs/log/data/DataPack", "build"));
        }
        RefsModel refsModel = new RefsModel(refs, hashMap);
        PermanentGraph<Integer> graph = DataPack.buildPermanentGraph(commits, refsModel, hashMap, providers);
        DataPack dataPack = new DataPack(refsModel, graph, providers, full);
        if (dataPack == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/DataPack", "build"));
        }
        return dataPack;
    }

    @NotNull
    private static PermanentGraph<Integer> buildPermanentGraph(@NotNull List<? extends GraphCommit<Integer>> commits, @NotNull RefsModel refsModel, final @NotNull VcsLogHashMap hashMap, @NotNull Map<VirtualFile, VcsLogProvider> providers) {
        if (commits == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commits", "com/intellij/vcs/log/data/DataPack", "buildPermanentGraph"));
        }
        if (refsModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refsModel", "com/intellij/vcs/log/data/DataPack", "buildPermanentGraph"));
        }
        if (hashMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashMap", "com/intellij/vcs/log/data/DataPack", "buildPermanentGraph"));
        }
        if (providers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "providers", "com/intellij/vcs/log/data/DataPack", "buildPermanentGraph"));
        }
        if (commits.isEmpty()) {
            PermanentGraph<Integer> permanentGraph = EmptyPermanentGraph.getInstance();
            if (permanentGraph == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/DataPack", "buildPermanentGraph"));
            }
            return permanentGraph;
        }
        NotNullFunction<Integer, Hash> hashGetter = new NotNullFunction<Integer, Hash>(){

            @NotNull
            public Hash fun(Integer commitIndex) {
                Hash hash = hashMap.getHash(commitIndex);
                if (hash == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/DataPack$1", "fun"));
                }
                return hash;
            }
        };
        GraphColorManagerImpl colorManager = new GraphColorManagerImpl(refsModel, hashGetter, DataPack.getRefManagerMap(providers));
        Set<Integer> branches = DataPack.getBranchCommitHashIndexes(refsModel.getAllRefs(), hashMap);
        StopWatch sw = StopWatch.start("building graph");
        PermanentGraphImpl<Integer> permanentGraph = PermanentGraphImpl.newInstance(commits, colorManager, branches);
        sw.report();
        PermanentGraphImpl<Integer> permanentGraphImpl = permanentGraph;
        if (permanentGraphImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/DataPack", "buildPermanentGraph"));
        }
        return permanentGraphImpl;
    }

    @NotNull
    private static Set<Integer> getBranchCommitHashIndexes(@NotNull Collection<VcsRef> allRefs, @NotNull VcsLogHashMap hashMap) {
        if (allRefs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allRefs", "com/intellij/vcs/log/data/DataPack", "getBranchCommitHashIndexes"));
        }
        if (hashMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashMap", "com/intellij/vcs/log/data/DataPack", "getBranchCommitHashIndexes"));
        }
        HashSet<Integer> result = new HashSet<Integer>();
        for (VcsRef vcsRef : allRefs) {
            if (!vcsRef.getType().isBranch()) continue;
            result.add(hashMap.getCommitIndex(vcsRef.getCommitHash()));
        }
        HashSet<Integer> hashSet = result;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/DataPack", "getBranchCommitHashIndexes"));
        }
        return hashSet;
    }

    @NotNull
    private static Map<VirtualFile, VcsLogRefManager> getRefManagerMap(@NotNull Map<VirtualFile, VcsLogProvider> logProviders) {
        if (logProviders == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logProviders", "com/intellij/vcs/log/data/DataPack", "getRefManagerMap"));
        }
        HashMap map = ContainerUtil.newHashMap();
        for (Map.Entry<VirtualFile, VcsLogProvider> entry : logProviders.entrySet()) {
            map.put(entry.getKey(), entry.getValue().getReferenceManager());
        }
        HashMap hashMap = map;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/DataPack", "getRefManagerMap"));
        }
        return hashMap;
    }

    @NotNull
    private static DataPack createEmptyInstance() {
        RefsModel emptyModel = new RefsModel(Collections.<VirtualFile, Set<VcsRef>>emptyMap(), VcsLogHashMapImpl.EMPTY);
        DataPack dataPack = new DataPack(emptyModel, EmptyPermanentGraph.getInstance(), Collections.<VirtualFile, VcsLogProvider>emptyMap(), false);
        if (dataPack == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/DataPack", "createEmptyInstance"));
        }
        return dataPack;
    }

    @NotNull
    public VcsLogRefs getRefs() {
        RefsModel refsModel = this.myRefsModel;
        if (refsModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/DataPack", "getRefs"));
        }
        return refsModel;
    }

    @NotNull
    public RefsModel getRefsModel() {
        RefsModel refsModel = this.myRefsModel;
        if (refsModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/DataPack", "getRefsModel"));
        }
        return refsModel;
    }

    @NotNull
    public Map<VirtualFile, VcsLogProvider> getLogProviders() {
        Map<VirtualFile, VcsLogProvider> map = this.myLogProviders;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/DataPack", "getLogProviders"));
        }
        return map;
    }

    @NotNull
    public PermanentGraph<Integer> getPermanentGraph() {
        PermanentGraph<Integer> permanentGraph = this.myPermanentGraph;
        if (permanentGraph == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/DataPack", "getPermanentGraph"));
        }
        return permanentGraph;
    }

    public boolean isFull() {
        return this.myFull;
    }

    public String toString() {
        return "{DataPack. " + this.myPermanentGraph.getAllCommits().size() + " commits in " + this.myLogProviders.keySet().size() + " roots}";
    }
}

