/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui;

import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.vcs.log.VcsCommitStyleFactory;
import com.intellij.vcs.log.VcsLogHighlighter;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.data.LoadingDetails;
import com.intellij.vcs.log.data.VcsLogDataHolder;
import com.intellij.vcs.log.data.VcsLogUiProperties;
import com.intellij.vcs.log.ui.VcsLogHighlighterFactory;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;

public class MergeCommitsHighlighter
implements VcsLogHighlighter {
    private static final JBColor MERGE_COMMIT_FOREGROUND = new JBColor((Color)Gray._192, (Color)Gray._96);
    @NotNull
    private final VcsLogUiProperties myUiProperties;
    @NotNull
    private final VcsLogDataHolder myDataHolder;

    public MergeCommitsHighlighter(@NotNull VcsLogDataHolder logDataHolder, @NotNull VcsLogUiProperties uiProperties) {
        if (logDataHolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logDataHolder", "com/intellij/vcs/log/ui/MergeCommitsHighlighter", "<init>"));
        }
        if (uiProperties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uiProperties", "com/intellij/vcs/log/ui/MergeCommitsHighlighter", "<init>"));
        }
        this.myDataHolder = logDataHolder;
        this.myUiProperties = uiProperties;
    }

    @NotNull
    public VcsLogHighlighter.VcsCommitStyle getStyle(int commitIndex, boolean isSelected) {
        if (isSelected || !this.myUiProperties.isHighlighterEnabled("MERGE_COMMITS")) {
            VcsLogHighlighter.VcsCommitStyle vcsCommitStyle = VcsLogHighlighter.VcsCommitStyle.DEFAULT;
            if (vcsCommitStyle == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/MergeCommitsHighlighter", "getStyle"));
            }
            return vcsCommitStyle;
        }
        VcsShortCommitDetails details = this.myDataHolder.getMiniDetailsGetter().getCommitDataIfAvailable(commitIndex);
        if (details != null && !(details instanceof LoadingDetails) && details.getParents().size() >= 2) {
            VcsLogHighlighter.VcsCommitStyle vcsCommitStyle = VcsCommitStyleFactory.foreground((Color)MERGE_COMMIT_FOREGROUND);
            if (vcsCommitStyle == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/MergeCommitsHighlighter", "getStyle"));
            }
            return vcsCommitStyle;
        }
        VcsLogHighlighter.VcsCommitStyle vcsCommitStyle = VcsLogHighlighter.VcsCommitStyle.DEFAULT;
        if (vcsCommitStyle == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/MergeCommitsHighlighter", "getStyle"));
        }
        return vcsCommitStyle;
    }

    public static class Factory
    implements VcsLogHighlighterFactory {
        @NotNull
        private static final String ID = "MERGE_COMMITS";

        @Override
        @NotNull
        public VcsLogHighlighter createHighlighter(@NotNull VcsLogDataHolder logDataHolder, @NotNull VcsLogUiProperties uiProperties) {
            if (logDataHolder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logDataHolder", "com/intellij/vcs/log/ui/MergeCommitsHighlighter$Factory", "createHighlighter"));
            }
            if (uiProperties == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uiProperties", "com/intellij/vcs/log/ui/MergeCommitsHighlighter$Factory", "createHighlighter"));
            }
            MergeCommitsHighlighter mergeCommitsHighlighter = new MergeCommitsHighlighter(logDataHolder, uiProperties);
            if (mergeCommitsHighlighter == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/MergeCommitsHighlighter$Factory", "createHighlighter"));
            }
            return mergeCommitsHighlighter;
        }

        @Override
        @NotNull
        public String getId() {
            if (ID == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/MergeCommitsHighlighter$Factory", "getId"));
            }
            return ID;
        }

        @Override
        @NotNull
        public String getTitle() {
            if ("Merge Commits" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/MergeCommitsHighlighter$Factory", "getTitle"));
            }
            return "Merge Commits";
        }
    }
}

