/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.frame;

import com.intellij.execution.ui.layout.impl.RunnerContentUi;
import com.intellij.ide.DataManager;
import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.dnd.DnDManager;
import com.intellij.ide.dnd.DnDNativeTarget;
import com.intellij.ide.dnd.DnDTarget;
import com.intellij.openapi.CompositeDisposable;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.AnActionButtonUpdater;
import com.intellij.ui.CaptionPanel;
import com.intellij.ui.ClickListener;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.ListenerUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.util.Alarm;
import com.intellij.util.Consumer;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import com.intellij.xdebugger.impl.frame.XDebugView;
import com.intellij.xdebugger.impl.frame.XWatchesView;
import com.intellij.xdebugger.impl.frame.actions.XWatchesTreeActionBase;
import com.intellij.xdebugger.impl.ui.XDebugSessionData;
import com.intellij.xdebugger.impl.ui.XDebugSessionTab;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreePanel;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreeRestorer;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreeState;
import com.intellij.xdebugger.impl.ui.tree.actions.XWatchTransferable;
import com.intellij.xdebugger.impl.ui.tree.nodes.WatchNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.WatchesRootNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XDebuggerTreeNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XWatchesViewImpl
extends XDebugView
implements DnDNativeTarget,
XWatchesView {
    private final XDebuggerTreePanel myTreePanel;
    private XDebuggerTreeState myTreeState;
    private XDebuggerTreeRestorer myTreeRestorer;
    private final WatchesRootNode myRootNode;
    private final JPanel myDecoratedPanel;
    private final CompositeDisposable myDisposables;
    private boolean myRebuildNeeded;

    public XWatchesViewImpl(@NotNull XDebugSessionImpl session) {
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/xdebugger/impl/frame/XWatchesViewImpl", "<init>"));
        }
        this.myDisposables = new CompositeDisposable();
        this.myTreePanel = new XDebuggerTreePanel(session.getProject(), session.getDebugProcess().getEditorsProvider(), this, null, "XDebugger.Watches.Tree.Popup", session.getValueMarkers());
        ActionManager actionManager = ActionManager.getInstance();
        XDebuggerTree tree = this.myTreePanel.getTree();
        actionManager.getAction("XDebugger.NewWatch").registerCustomShortcutSet(CommonShortcuts.INSERT, (JComponent)((Object)tree), (Disposable)this.myDisposables);
        actionManager.getAction("XDebugger.RemoveWatch").registerCustomShortcutSet(CommonShortcuts.getDelete(), (JComponent)((Object)tree), (Disposable)this.myDisposables);
        CustomShortcutSet f2Shortcut = new CustomShortcutSet(KeyStroke.getKeyStroke(113, 0));
        actionManager.getAction("XDebugger.EditWatch").registerCustomShortcutSet((ShortcutSet)f2Shortcut, (JComponent)((Object)tree));
        AnAction copyAction = actionManager.getAction("XDebugger.CopyWatch");
        copyAction.registerCustomShortcutSet(ActionManager.getInstance().getAction("EditorDuplicate").getShortcutSet(), (JComponent)((Object)tree));
        DnDManager.getInstance().registerTarget((DnDTarget)this, (JComponent)((Object)tree));
        this.myRootNode = new WatchesRootNode(tree, this, session.getSessionData().getWatchExpressions());
        tree.setRoot(this.myRootNode, false);
        new AnAction(){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/xdebugger/impl/frame/XWatchesViewImpl$1", "actionPerformed"));
                }
                Object contents = CopyPasteManager.getInstance().getContents(XWatchTransferable.EXPRESSIONS_FLAVOR);
                if (contents instanceof List) {
                    for (Object item : (List)contents) {
                        if (!(item instanceof XExpression)) continue;
                        XWatchesViewImpl.this.addWatchExpression((XExpression)item, -1, true);
                    }
                }
            }
        }.registerCustomShortcutSet(CommonShortcuts.getPaste(), (JComponent)((Object)tree), (Disposable)this.myDisposables);
        ToolbarDecorator decorator = ToolbarDecorator.createDecorator((JTree)((Object)this.myTreePanel.getTree())).disableUpDownActions();
        decorator.setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                XWatchesViewImpl.this.executeAction("XDebugger.NewWatch");
            }
        });
        decorator.setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                XWatchesViewImpl.this.executeAction("XDebugger.RemoveWatch");
            }
        });
        decorator.addExtraAction(AnActionButton.fromAction((AnAction)copyAction));
        decorator.setMoveUpAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                List<WatchNode> nodes = XWatchesTreeActionBase.getSelectedNodes(XWatchesViewImpl.this.getTree(), WatchNode.class);
                assert (nodes.size() == 1);
                XWatchesViewImpl.this.myRootNode.moveUp(nodes.get(0));
                XWatchesViewImpl.this.updateSessionData();
            }
        });
        decorator.setMoveUpActionUpdater(new AnActionButtonUpdater(){

            public boolean isEnabled(AnActionEvent e) {
                List<WatchNode> nodes = XWatchesTreeActionBase.getSelectedNodes(XWatchesViewImpl.this.getTree(), WatchNode.class);
                if (nodes.size() != 1) {
                    return false;
                }
                return XWatchesViewImpl.this.myRootNode.getIndex(nodes.get(0)) > 0;
            }
        });
        decorator.setMoveDownAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                List<WatchNode> nodes = XWatchesTreeActionBase.getSelectedNodes(XWatchesViewImpl.this.getTree(), WatchNode.class);
                assert (nodes.size() == 1);
                XWatchesViewImpl.this.myRootNode.moveDown(nodes.get(0));
                XWatchesViewImpl.this.updateSessionData();
            }
        });
        decorator.setMoveDownActionUpdater(new AnActionButtonUpdater(){

            public boolean isEnabled(AnActionEvent e) {
                List<WatchNode> nodes = XWatchesTreeActionBase.getSelectedNodes(XWatchesViewImpl.this.getTree(), WatchNode.class);
                if (nodes.size() != 1) {
                    return false;
                }
                return XWatchesViewImpl.this.myRootNode.getIndex(nodes.get(0)) < XWatchesViewImpl.this.myRootNode.getChildCount() - 1;
            }
        });
        CustomLineBorder border = new CustomLineBorder(CaptionPanel.CNT_ACTIVE_BORDER_COLOR, SystemInfo.isMac ? 1 : 0, 0, SystemInfo.isMac ? 0 : 1, 0);
        decorator.setToolbarBorder((Border)border);
        this.myDecoratedPanel = new MyPanel(decorator.createPanel());
        this.myDecoratedPanel.setBorder(null);
        this.myTreePanel.getTree().getEmptyText().setText(XDebuggerBundle.message((String)"debugger.no.watches", (Object[])new Object[0]));
        this.installEditListeners();
    }

    private void installEditListeners() {
        final XDebuggerTree watchTree = this.myTreePanel.getTree();
        final Alarm quitePeriod = new Alarm();
        final Alarm editAlarm = new Alarm();
        final ClickListener mouseListener = new ClickListener(){

            public boolean onClick(@NotNull MouseEvent event, int clickCount) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/xdebugger/impl/frame/XWatchesViewImpl$8", "onClick"));
                }
                if (!SwingUtilities.isLeftMouseButton(event) || (event.getModifiers() & 0xF) != 0) {
                    return false;
                }
                boolean sameRow = XWatchesViewImpl.isAboveSelectedItem(event, watchTree);
                if (!sameRow || clickCount > 1) {
                    editAlarm.cancelAllRequests();
                    return false;
                }
                final AnAction editWatchAction = ActionManager.getInstance().getAction("XDebugger.EditWatch");
                Presentation presentation = editWatchAction.getTemplatePresentation().clone();
                DataContext context = DataManager.getInstance().getDataContext((Component)((Object)watchTree));
                final AnActionEvent actionEvent = new AnActionEvent(null, context, "WATCH_TREE", presentation, ActionManager.getInstance(), 0);
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        editWatchAction.actionPerformed(actionEvent);
                    }
                };
                if (editAlarm.isEmpty() && quitePeriod.isEmpty()) {
                    editAlarm.addRequest(runnable, UIUtil.getMultiClickInterval());
                } else {
                    editAlarm.cancelAllRequests();
                }
                return false;
            }
        };
        DoubleClickListener mouseEmptySpaceListener = new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent event) {
                if (!XWatchesViewImpl.isAboveSelectedItem(event, watchTree)) {
                    XWatchesViewImpl.this.myRootNode.addNewWatch();
                    return true;
                }
                return false;
            }
        };
        ListenerUtil.addClickListener((Component)((Object)watchTree), mouseListener);
        ListenerUtil.addClickListener((Component)((Object)watchTree), (ClickListener)mouseEmptySpaceListener);
        FocusListener focusListener = new FocusListener(){

            @Override
            public void focusGained(@NotNull FocusEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/xdebugger/impl/frame/XWatchesViewImpl$10", "focusGained"));
                }
                quitePeriod.addRequest(EmptyRunnable.getInstance(), UIUtil.getMultiClickInterval());
            }

            @Override
            public void focusLost(@NotNull FocusEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/xdebugger/impl/frame/XWatchesViewImpl$10", "focusLost"));
                }
                editAlarm.cancelAllRequests();
            }
        };
        ListenerUtil.addFocusListener((Component)((Object)watchTree), focusListener);
        TreeSelectionListener selectionListener = new TreeSelectionListener(){

            @Override
            public void valueChanged(@NotNull TreeSelectionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/xdebugger/impl/frame/XWatchesViewImpl$11", "valueChanged"));
                }
                quitePeriod.addRequest(EmptyRunnable.getInstance(), UIUtil.getMultiClickInterval());
            }
        };
        watchTree.addTreeSelectionListener(selectionListener);
        this.myDisposables.add(new Disposable((ClickListener)mouseEmptySpaceListener, focusListener, selectionListener){
            final /* synthetic */ ClickListener val$mouseEmptySpaceListener;
            final /* synthetic */ FocusListener val$focusListener;
            final /* synthetic */ TreeSelectionListener val$selectionListener;
            {
                this.val$mouseEmptySpaceListener = clickListener2;
                this.val$focusListener = focusListener;
                this.val$selectionListener = treeSelectionListener;
            }

            public void dispose() {
                ListenerUtil.removeClickListener((Component)((Object)watchTree), mouseListener);
                ListenerUtil.removeClickListener((Component)((Object)watchTree), this.val$mouseEmptySpaceListener);
                ListenerUtil.removeFocusListener((Component)((Object)watchTree), this.val$focusListener);
                watchTree.removeTreeSelectionListener(this.val$selectionListener);
            }
        });
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.myDisposables);
        DnDManager.getInstance().unregisterTarget((DnDTarget)this, (JComponent)((Object)this.myTreePanel.getTree()));
    }

    private static boolean isAboveSelectedItem(MouseEvent event, XDebuggerTree watchTree) {
        Rectangle bounds = watchTree.getRowBounds(watchTree.getLeadSelectionRow());
        if (bounds != null) {
            bounds.width = watchTree.getWidth();
            if (bounds.contains(event.getPoint())) {
                return true;
            }
        }
        return false;
    }

    private void executeAction(@NotNull String watch) {
        if (watch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "watch", "com/intellij/xdebugger/impl/frame/XWatchesViewImpl", "executeAction"));
        }
        AnAction action = ActionManager.getInstance().getAction(watch);
        Presentation presentation = action.getTemplatePresentation().clone();
        DataContext context = DataManager.getInstance().getDataContext((Component)((Object)this.myTreePanel.getTree()));
        AnActionEvent actionEvent = new AnActionEvent(null, context, "DebuggerToolbar", presentation, ActionManager.getInstance(), 0);
        action.actionPerformed(actionEvent);
    }

    @Override
    public void addWatchExpression(@NotNull XExpression expression, int index, boolean navigateToWatchNode) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/xdebugger/impl/frame/XWatchesViewImpl", "addWatchExpression"));
        }
        XDebugSession session = XWatchesViewImpl.getSession((Component)((Object)this.getTree()));
        this.myRootNode.addWatchExpression(session != null ? session.getDebugProcess().getEvaluator() : null, expression, index, navigateToWatchNode);
        this.updateSessionData();
        if (navigateToWatchNode && session != null) {
            XWatchesViewImpl.showWatchesTab((XDebugSessionImpl)session);
        }
    }

    private static void showWatchesTab(@NotNull XDebugSessionImpl session) {
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/xdebugger/impl/frame/XWatchesViewImpl", "showWatchesTab"));
        }
        XDebugSessionTab tab = session.getSessionTab();
        if (tab != null) {
            RunnerContentUi ui;
            tab.toFront(false, null);
            JComponent component = tab.getUi().getComponent();
            if (component instanceof DataProvider && (ui = (RunnerContentUi)RunnerContentUi.KEY.getData((DataProvider)component)) != null) {
                ui.restoreContent("WatchesContent");
            }
        }
    }

    public boolean rebuildNeeded() {
        return this.myRebuildNeeded;
    }

    @Override
    public void processSessionEvent(@NotNull XDebugView.SessionEvent event) {
        XDebugSession session;
        XStackFrame stackFrame;
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/xdebugger/impl/frame/XWatchesViewImpl", "processSessionEvent"));
        }
        if (!this.getMainPanel().isShowing() && !ApplicationManager.getApplication().isUnitTestMode()) {
            this.myRebuildNeeded = true;
            return;
        }
        this.myRebuildNeeded = false;
        XDebuggerTree tree = this.myTreePanel.getTree();
        if (event == XDebugView.SessionEvent.BEFORE_RESUME || event == XDebugView.SessionEvent.SETTINGS_CHANGED) {
            if (this.myTreeRestorer != null) {
                this.myTreeRestorer.dispose();
            }
            this.myTreeState = XDebuggerTreeState.saveState(tree);
            if (event == XDebugView.SessionEvent.BEFORE_RESUME) {
                return;
            }
        }
        XStackFrame xStackFrame = stackFrame = (session = XWatchesViewImpl.getSession(this.getMainPanel())) == null ? null : session.getCurrentStackFrame();
        if (stackFrame != null) {
            this.cancelClear();
            tree.setSourcePosition(stackFrame.getSourcePosition());
            this.myRootNode.updateWatches(stackFrame.getEvaluator());
            if (this.myTreeState != null) {
                this.myTreeRestorer = this.myTreeState.restoreState(tree);
            }
        } else {
            this.requestClear();
        }
    }

    @Override
    protected void clear() {
        this.getTree().setSourcePosition(null);
        this.myRootNode.updateWatches(null);
    }

    public XDebuggerTree getTree() {
        return this.myTreePanel.getTree();
    }

    public JPanel getMainPanel() {
        return this.myDecoratedPanel;
    }

    @Override
    public void removeWatches(List<? extends XDebuggerTreeNode> nodes) {
        List<? extends WatchNode> children = this.myRootNode.getAllChildren();
        int minIndex = Integer.MAX_VALUE;
        ArrayList<XDebuggerTreeNode> toRemove = new ArrayList<XDebuggerTreeNode>();
        if (children != null) {
            for (XDebuggerTreeNode xDebuggerTreeNode : nodes) {
                int index = children.indexOf(xDebuggerTreeNode);
                if (index == -1) continue;
                toRemove.add(xDebuggerTreeNode);
                minIndex = Math.min(minIndex, index);
            }
        }
        this.myRootNode.removeChildren(toRemove);
        List<? extends WatchNode> newChildren = this.myRootNode.getAllChildren();
        if (newChildren != null && !newChildren.isEmpty()) {
            WatchNode watchNode = minIndex < newChildren.size() ? newChildren.get(minIndex) : newChildren.get(newChildren.size() - 1);
            TreeUtil.selectNode((JTree)((Object)this.myTreePanel.getTree()), (TreeNode)watchNode);
        }
        this.updateSessionData();
    }

    @Override
    public void removeAllWatches() {
        this.myRootNode.removeAllChildren();
        this.updateSessionData();
    }

    public void updateSessionData() {
        ArrayList<XExpression> watchExpressions = new ArrayList<XExpression>();
        List<? extends WatchNode> children = this.myRootNode.getAllChildren();
        if (children != null) {
            for (WatchNode watchNode : children) {
                watchExpressions.add(watchNode.getExpression());
            }
        }
        XDebugSession session = XWatchesViewImpl.getSession((Component)((Object)this.getTree()));
        XExpression[] xExpressionArray = watchExpressions.toArray(new XExpression[watchExpressions.size()]);
        if (session != null) {
            ((XDebugSessionImpl)session).setWatchExpressions(xExpressionArray);
        } else {
            XDebugSessionData data = XWatchesViewImpl.getData(XDebugSessionData.DATA_KEY, (Component)((Object)this.getTree()));
            if (data != null) {
                data.setWatchExpressions(xExpressionArray);
            }
        }
    }

    public boolean update(DnDEvent aEvent) {
        Object object = aEvent.getAttachedObject();
        boolean possible = false;
        if (object instanceof XValueNodeImpl[]) {
            possible = true;
        } else if (object instanceof DnDNativeTarget.EventInfo) {
            possible = ((DnDNativeTarget.EventInfo)object).getTextForFlavor(DataFlavor.stringFlavor) != null;
        }
        aEvent.setDropPossible(possible, XDebuggerBundle.message((String)"xdebugger.drop.text.add.to.watches", (Object[])new Object[0]));
        return true;
    }

    public void drop(DnDEvent aEvent) {
        String text;
        Object object = aEvent.getAttachedObject();
        if (object instanceof XValueNodeImpl[]) {
            XValueNodeImpl[] nodes;
            for (XValueNodeImpl node : nodes = (XValueNodeImpl[])object) {
                ((XValue)node.getValueContainer()).calculateEvaluationExpression().done((Consumer)new Consumer<String>(){

                    public void consume(String expression) {
                        if (expression != null) {
                            XWatchesViewImpl.this.addWatchExpression(XExpressionImpl.fromText(expression), -1, false);
                        }
                    }
                });
            }
        } else if (object instanceof DnDNativeTarget.EventInfo && (text = ((DnDNativeTarget.EventInfo)object).getTextForFlavor(DataFlavor.stringFlavor)) != null) {
            this.addWatchExpression(XExpressionImpl.fromText(text), -1, false);
        }
    }

    public void cleanUpOnLeave() {
    }

    public void updateDraggedImage(Image image, Point dropPoint, Point imageOffset) {
    }

    private class MyPanel
    extends JPanel
    implements DataProvider {
        public MyPanel(JPanel panel) {
            this.setLayout(new BorderLayout());
            this.add(panel);
            panel.setBorder(null);
        }

        @Nullable
        public Object getData(@NonNls String dataId) {
            if (XWatchesView.DATA_KEY.is(dataId)) {
                return XWatchesViewImpl.this;
            }
            return null;
        }
    }
}

