/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.javadoc;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefPackage;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseGlobalInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.BaseSharedLocalInspection;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MissingPackageInfoInspectionBase
extends BaseGlobalInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("missing.package.info.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/javadoc/MissingPackageInfoInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @Nullable
    public CommonProblemDescriptor[] checkElement(@NotNull RefEntity refEntity, @NotNull AnalysisScope scope, @NotNull InspectionManager manager, @NotNull GlobalInspectionContext globalContext) {
        if (refEntity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refEntity", "com/siyeh/ig/javadoc/MissingPackageInfoInspectionBase", "checkElement"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/siyeh/ig/javadoc/MissingPackageInfoInspectionBase", "checkElement"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/siyeh/ig/javadoc/MissingPackageInfoInspectionBase", "checkElement"));
        }
        if (globalContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "globalContext", "com/siyeh/ig/javadoc/MissingPackageInfoInspectionBase", "checkElement"));
        }
        if (!(refEntity instanceof RefPackage)) {
            return null;
        }
        RefPackage refPackage = (RefPackage)refEntity;
        String packageName = refPackage.getQualifiedName();
        Project project = globalContext.getProject();
        PsiPackage aPackage = JavaPsiFacade.getInstance((Project)project).findPackage(packageName);
        if (MissingPackageInfoInspectionBase.hasPackageInfoFile(aPackage)) {
            return null;
        }
        List children = refPackage.getChildren();
        boolean hasClasses = false;
        for (RefEntity child : children) {
            if (!(child instanceof RefClass)) continue;
            hasClasses = true;
            break;
        }
        if (!hasClasses) {
            return null;
        }
        if (PsiUtil.isLanguageLevel5OrHigher((PsiElement)aPackage)) {
            return new CommonProblemDescriptor[]{manager.createProblemDescriptor(InspectionGadgetsBundle.message("missing.package.info.problem.descriptor", packageName), new QuickFix[0])};
        }
        return new CommonProblemDescriptor[]{manager.createProblemDescriptor(InspectionGadgetsBundle.message("missing.package.html.problem.descriptor", packageName), new QuickFix[0])};
    }

    @Contract(value="null -> true")
    static boolean hasPackageInfoFile(PsiPackage aPackage) {
        PsiDirectory[] directories;
        if (aPackage == null) {
            return true;
        }
        for (PsiDirectory directory : directories = aPackage.getDirectories()) {
            boolean packageDotHtmlFound;
            boolean packageInfoFound = directory.findFile("package-info.java") != null;
            boolean bl = packageDotHtmlFound = directory.findFile("package.html") != null;
            if (!packageInfoFound && !packageDotHtmlFound) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public LocalInspectionTool getSharedLocalInspectionTool() {
        return new LocalMissingPackageInfoInspectionBase(this);
    }

    protected static class LocalMissingPackageInfoInspectionBase
    extends BaseSharedLocalInspection<MissingPackageInfoInspectionBase> {
        public LocalMissingPackageInfoInspectionBase(MissingPackageInfoInspectionBase settingsDelegate) {
            super(settingsDelegate);
        }

        @Override
        @NotNull
        protected String buildErrorString(Object ... infos) {
            PsiPackageStatement packageStatement = (PsiPackageStatement)infos[0];
            if (PsiUtil.isLanguageLevel5OrHigher((PsiElement)packageStatement)) {
                String string = InspectionGadgetsBundle.message("missing.package.info.problem.descriptor", packageStatement.getPackageName());
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/javadoc/MissingPackageInfoInspectionBase$LocalMissingPackageInfoInspectionBase", "buildErrorString"));
                }
                return string;
            }
            String string = InspectionGadgetsBundle.message("missing.package.html.problem.descriptor", packageStatement.getPackageName());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/javadoc/MissingPackageInfoInspectionBase$LocalMissingPackageInfoInspectionBase", "buildErrorString"));
            }
            return string;
        }

        @Override
        public BaseInspectionVisitor buildVisitor() {
            return new BaseInspectionVisitor(){

                public void visitJavaFile(PsiJavaFile file) {
                    PsiPackageStatement packageStatement = file.getPackageStatement();
                    if (packageStatement == null) {
                        return;
                    }
                    PsiJavaCodeReferenceElement packageReference = packageStatement.getPackageReference();
                    PsiElement target = packageReference.resolve();
                    if (!(target instanceof PsiPackage)) {
                        return;
                    }
                    PsiPackage aPackage = (PsiPackage)target;
                    if (MissingPackageInfoInspectionBase.hasPackageInfoFile(aPackage)) {
                        return;
                    }
                    this.registerError((PsiElement)packageReference, packageStatement);
                }
            };
        }
    }
}

