/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.methodmetrics;

import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiWhileStatement;
import org.jetbrains.annotations.NotNull;

class NestingDepthVisitor
extends JavaRecursiveElementVisitor {
    private int m_maximumDepth = 0;
    private int m_currentDepth = 0;

    NestingDepthVisitor() {
    }

    public void visitAnonymousClass(@NotNull PsiAnonymousClass aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/siyeh/ig/methodmetrics/NestingDepthVisitor", "visitAnonymousClass"));
        }
    }

    public void visitBlockStatement(PsiBlockStatement statement) {
        boolean isAlreadyCounted;
        PsiElement parent = statement.getParent();
        boolean bl = isAlreadyCounted = parent instanceof PsiDoWhileStatement || parent instanceof PsiWhileStatement || parent instanceof PsiForStatement || parent instanceof PsiIfStatement || parent instanceof PsiSynchronizedStatement;
        if (!isAlreadyCounted) {
            this.enterScope();
        }
        super.visitBlockStatement(statement);
        if (!isAlreadyCounted) {
            this.exitScope();
        }
    }

    public void visitDoWhileStatement(@NotNull PsiDoWhileStatement statement) {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/methodmetrics/NestingDepthVisitor", "visitDoWhileStatement"));
        }
        this.enterScope();
        super.visitDoWhileStatement(statement);
        this.exitScope();
    }

    public void visitForStatement(@NotNull PsiForStatement statement) {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/methodmetrics/NestingDepthVisitor", "visitForStatement"));
        }
        this.enterScope();
        super.visitForStatement(statement);
        this.exitScope();
    }

    public void visitIfStatement(@NotNull PsiIfStatement statement) {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/methodmetrics/NestingDepthVisitor", "visitIfStatement"));
        }
        boolean isAlreadyCounted = false;
        if (statement.getParent() instanceof PsiIfStatement) {
            PsiIfStatement parent = (PsiIfStatement)statement.getParent();
            assert (parent != null);
            PsiStatement elseBranch = parent.getElseBranch();
            if (statement.equals(elseBranch)) {
                isAlreadyCounted = true;
            }
        }
        if (!isAlreadyCounted) {
            this.enterScope();
        }
        super.visitIfStatement(statement);
        if (!isAlreadyCounted) {
            this.exitScope();
        }
    }

    public void visitSynchronizedStatement(@NotNull PsiSynchronizedStatement statement) {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/methodmetrics/NestingDepthVisitor", "visitSynchronizedStatement"));
        }
        this.enterScope();
        super.visitSynchronizedStatement(statement);
        this.exitScope();
    }

    public void visitTryStatement(@NotNull PsiTryStatement statement) {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/methodmetrics/NestingDepthVisitor", "visitTryStatement"));
        }
        this.enterScope();
        super.visitTryStatement(statement);
        this.exitScope();
    }

    public void visitSwitchStatement(@NotNull PsiSwitchStatement statement) {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/methodmetrics/NestingDepthVisitor", "visitSwitchStatement"));
        }
        this.enterScope();
        super.visitSwitchStatement(statement);
        this.exitScope();
    }

    public void visitWhileStatement(@NotNull PsiWhileStatement statement) {
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/methodmetrics/NestingDepthVisitor", "visitWhileStatement"));
        }
        this.enterScope();
        super.visitWhileStatement(statement);
        this.exitScope();
    }

    private void enterScope() {
        ++this.m_currentDepth;
        this.m_maximumDepth = Math.max(this.m_maximumDepth, this.m_currentDepth);
    }

    private void exitScope() {
        --this.m_currentDepth;
    }

    public int getMaximumDepth() {
        return this.m_maximumDepth;
    }
}

