/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.BreakpointTarget;
import org.jetbrains.debugger.ScriptRegExpSupportVisitor;

public final class ScriptRegExpBreakpointTarget
extends BreakpointTarget {
    private final String regExp;
    public final String language;

    public ScriptRegExpBreakpointTarget(@NotNull String regExp, @Nullable String language) {
        if (regExp == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "regExp", "org/jetbrains/debugger/ScriptRegExpBreakpointTarget", "<init>"));
        }
        this.regExp = regExp;
        this.language = language;
    }

    @Override
    public <R> R accept(BreakpointTarget.Visitor<R> visitor) {
        if (visitor instanceof ScriptRegExpSupportVisitor) {
            return ((ScriptRegExpSupportVisitor)visitor).visitRegExp(this);
        }
        return visitor.visitUnknown(this);
    }

    @Override
    public String toString() {
        return this.regExp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.regExp.equals(((ScriptRegExpBreakpointTarget)o).regExp);
    }

    public int hashCode() {
        return this.regExp.hashCode();
    }
}

