/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.CallFrame;
import org.jetbrains.debugger.ExceptionData;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.SuspendContext;
import org.jetbrains.debugger.SuspendState;
import org.jetbrains.debugger.values.ValueManager;

public abstract class SuspendContextBase<VALUE_MANAGER extends ValueManager>
implements SuspendContext {
    protected ExceptionData exceptionData;
    protected final boolean explicitPaused;
    protected final VALUE_MANAGER valueManager;

    protected SuspendContextBase(VALUE_MANAGER manager, boolean explicitPaused) {
        this.explicitPaused = explicitPaused;
        this.valueManager = manager;
    }

    @Override
    @NotNull
    public SuspendState getState() {
        SuspendState suspendState = this.exceptionData == null ? (this.explicitPaused ? SuspendState.PAUSED : SuspendState.NORMAL) : SuspendState.EXCEPTION;
        if (suspendState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/SuspendContextBase", "getState"));
        }
        return suspendState;
    }

    @NotNull
    public final VALUE_MANAGER getValueManager() {
        VALUE_MANAGER VALUE_MANAGER = this.valueManager;
        if (VALUE_MANAGER == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/SuspendContextBase", "getValueManager"));
        }
        return VALUE_MANAGER;
    }

    @Override
    @Nullable
    public Script getScript() {
        CallFrame topFrame = this.getTopFrame();
        return topFrame == null ? null : ((ValueManager)this.valueManager).getVm().getScriptManager().getScript(topFrame);
    }
}

