/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger.sourcemap;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Url;
import com.intellij.util.UrlImpl;
import com.intellij.util.Urls;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ObjectIntHashMap;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import gnu.trove.TObjectHashingStrategy;
import gnu.trove.TObjectIntHashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.sourcemap.MappingEntry;
import org.jetbrains.debugger.sourcemap.MappingList;
import org.jetbrains.debugger.sourcemap.SourceMap;
import org.jetbrains.io.LocalFileFinder;

public class SourceResolver {
    private final List<String> rawSources;
    @Nullable
    private final List<String> sourceContents;
    final Url[] canonicalizedSources;
    private final ObjectIntHashMap<Url> canonicalizedSourcesMap;
    private TObjectIntHashMap<String> absoluteLocalPathToSourceIndex;
    private String[] sourceIndexToAbsoluteLocalPath;

    public SourceResolver(@NotNull List<String> sourceUrls, boolean trimFileScheme, @Nullable Url baseFileUrl, @Nullable List<String> sourceContents) {
        if (sourceUrls == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceUrls", "org/jetbrains/debugger/sourcemap/SourceResolver", "<init>"));
        }
        this(sourceUrls, trimFileScheme, baseFileUrl, true, sourceContents);
    }

    public SourceResolver(@NotNull List<String> sourceUrls, boolean trimFileScheme, @Nullable Url baseFileUrl, boolean baseUrlIsFile, @Nullable List<String> sourceContents) {
        if (sourceUrls == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceUrls", "org/jetbrains/debugger/sourcemap/SourceResolver", "<init>"));
        }
        this.rawSources = sourceUrls;
        this.sourceContents = sourceContents;
        this.canonicalizedSources = new Url[sourceUrls.size()];
        this.canonicalizedSourcesMap = SystemInfo.isFileSystemCaseSensitive ? new ObjectIntHashMap(this.canonicalizedSources.length) : new ObjectIntHashMap(this.canonicalizedSources.length, Urls.getCaseInsensitiveUrlHashingStrategy());
        for (int i = 0; i < sourceUrls.size(); ++i) {
            Url url;
            String rawSource = sourceUrls.get(i);
            this.canonicalizedSources[i] = url = this.canonicalizeUrl(rawSource, baseFileUrl, trimFileScheme, i, baseUrlIsFile);
            this.canonicalizedSourcesMap.put((Object)url, i);
        }
    }

    public static boolean isAbsolute(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/debugger/sourcemap/SourceResolver", "isAbsolute"));
        }
        return !path.isEmpty() && (path.charAt(0) == '/' || SystemInfo.isWindows && path.length() > 2 && path.charAt(1) == ':');
    }

    protected Url canonicalizeUrl(@NotNull String url, @Nullable Url baseUrl, boolean trimFileScheme, int sourceIndex, boolean baseUrlIsFile) {
        VirtualFile file;
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "org/jetbrains/debugger/sourcemap/SourceResolver", "canonicalizeUrl"));
        }
        if (trimFileScheme && url.startsWith("file://")) {
            return Urls.newLocalFileUrl(FileUtil.toCanonicalPath((String)VfsUtilCore.toIdeaUrl((String)url, (boolean)true).substring("file://".length()), (char)'/'));
        }
        if (baseUrl == null || url.contains("://") || url.startsWith("data:") || url.startsWith("blob:") || url.startsWith("javascript:")) {
            return Urls.parseEncoded(url);
        }
        String path = SourceResolver.canonicalizePath(url, baseUrl, baseUrlIsFile);
        if (baseUrl.getScheme() == null && baseUrl.isInLocalFileSystem()) {
            return Urls.newLocalFileUrl(path);
        }
        if (SourceResolver.isAbsolute(path) && (file = LocalFileFinder.findFile(path)) != null) {
            if (this.absoluteLocalPathToSourceIndex == null) {
                this.absoluteLocalPathToSourceIndex = SourceResolver.createStringIntMap(this.rawSources.size());
                this.sourceIndexToAbsoluteLocalPath = new String[this.rawSources.size()];
            }
            this.absoluteLocalPathToSourceIndex.put((Object)path, sourceIndex);
            this.sourceIndexToAbsoluteLocalPath[sourceIndex] = path;
            String canonicalPath = file.getCanonicalPath();
            if (canonicalPath != null && !canonicalPath.equals(path)) {
                this.absoluteLocalPathToSourceIndex.put((Object)canonicalPath, sourceIndex);
            }
            return Urls.newLocalFileUrl(path);
        }
        return new UrlImpl(baseUrl.getScheme(), baseUrl.getAuthority(), path, null);
    }

    public static String canonicalizePath(@NotNull String url, @NotNull Url baseUrl, boolean baseUrlIsFile) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "org/jetbrains/debugger/sourcemap/SourceResolver", "canonicalizePath"));
        }
        if (baseUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseUrl", "org/jetbrains/debugger/sourcemap/SourceResolver", "canonicalizePath"));
        }
        String path = url;
        if (url.charAt(0) != '/') {
            String basePath = baseUrl.getPath();
            if (baseUrlIsFile) {
                int lastSlashIndex = basePath.lastIndexOf(47);
                StringBuilder pathBuilder = new StringBuilder();
                if (lastSlashIndex == -1) {
                    pathBuilder.append('/');
                } else {
                    pathBuilder.append(basePath, 0, lastSlashIndex + 1);
                }
                path = pathBuilder.append(url).toString();
            } else {
                path = basePath + '/' + url;
            }
        }
        path = FileUtil.toCanonicalPath((String)path, (char)'/');
        return path;
    }

    @NotNull
    private static ObjectIntHashMap<String> createStringIntMap(int initialCapacity) {
        if (initialCapacity == -1) {
            initialCapacity = 4;
        }
        ObjectIntHashMap objectIntHashMap = SystemInfo.isFileSystemCaseSensitive ? new ObjectIntHashMap(initialCapacity) : new ObjectIntHashMap(initialCapacity, (TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
        if (objectIntHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/sourcemap/SourceResolver", "createStringIntMap"));
        }
        return objectIntHashMap;
    }

    @Nullable
    public Url getSource(@NotNull MappingEntry entry) {
        if (entry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "org/jetbrains/debugger/sourcemap/SourceResolver", "getSource"));
        }
        int index = entry.getSource();
        return index < 0 ? null : this.canonicalizedSources[index];
    }

    @Nullable
    public String getSourceContent(@NotNull MappingEntry entry) {
        if (entry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "org/jetbrains/debugger/sourcemap/SourceResolver", "getSourceContent"));
        }
        if (ContainerUtil.isEmpty(this.sourceContents)) {
            return null;
        }
        int index = entry.getSource();
        return index < 0 || index >= this.sourceContents.size() ? null : this.sourceContents.get(index);
    }

    @Nullable
    public String getSourceContent(int sourceIndex) {
        if (ContainerUtil.isEmpty(this.sourceContents)) {
            return null;
        }
        return sourceIndex < 0 || sourceIndex >= this.sourceContents.size() ? null : this.sourceContents.get(sourceIndex);
    }

    public int getSourceIndex(@NotNull Url url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "org/jetbrains/debugger/sourcemap/SourceResolver", "getSourceIndex"));
        }
        return ArrayUtil.indexOf((Object[])this.canonicalizedSources, (Object)url);
    }

    @Nullable
    public String getRawSource(@NotNull MappingEntry entry) {
        if (entry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "org/jetbrains/debugger/sourcemap/SourceResolver", "getRawSource"));
        }
        int index = entry.getSource();
        return index < 0 ? null : this.rawSources.get(index);
    }

    @Nullable
    public String getLocalFilePath(@NotNull MappingEntry entry) {
        if (entry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "org/jetbrains/debugger/sourcemap/SourceResolver", "getLocalFilePath"));
        }
        int index = entry.getSource();
        return index < 0 || this.sourceIndexToAbsoluteLocalPath == null ? null : this.sourceIndexToAbsoluteLocalPath[index];
    }

    @Nullable
    public MappingList findMappings(@Nullable VirtualFile sourceFile, @NotNull SourceMap sourceMap, @NotNull Resolver resolver) {
        if (sourceMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceMap", "org/jetbrains/debugger/sourcemap/SourceResolver", "findMappings"));
        }
        if (resolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolver", "org/jetbrains/debugger/sourcemap/SourceResolver", "findMappings"));
        }
        int index = resolver.resolve(sourceFile, this.canonicalizedSourcesMap);
        return index < 0 ? null : sourceMap.sourceIndexToMappings[index];
    }

    @Nullable
    public MappingList findMappings(@NotNull List<Url> sourceUrls, @NotNull SourceMap sourceMap, @Nullable VirtualFile sourceFile) {
        MappingList mappings;
        if (sourceUrls == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceUrls", "org/jetbrains/debugger/sourcemap/SourceResolver", "findMappings"));
        }
        if (sourceMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceMap", "org/jetbrains/debugger/sourcemap/SourceResolver", "findMappings"));
        }
        for (Url sourceUrl : sourceUrls) {
            int index = this.canonicalizedSourcesMap.get((Object)sourceUrl);
            if (index == -1) continue;
            return sourceMap.sourceIndexToMappings[index];
        }
        if (sourceFile != null && (mappings = this.findByFile(sourceMap, sourceFile)) != null) {
            return mappings;
        }
        return null;
    }

    @Nullable
    private static MappingList getMappingsBySource(@NotNull SourceMap sourceMap, int index) {
        if (sourceMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceMap", "org/jetbrains/debugger/sourcemap/SourceResolver", "getMappingsBySource"));
        }
        return index == -1 ? null : sourceMap.sourceIndexToMappings[index];
    }

    @Nullable
    private MappingList findByFile(@NotNull SourceMap sourceMap, @NotNull VirtualFile sourceFile) {
        String sourceFileCanonicalPath;
        if (sourceMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceMap", "org/jetbrains/debugger/sourcemap/SourceResolver", "findByFile"));
        }
        if (sourceFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceFile", "org/jetbrains/debugger/sourcemap/SourceResolver", "findByFile"));
        }
        MappingList mappings = null;
        if (this.absoluteLocalPathToSourceIndex != null && sourceFile.isInLocalFileSystem() && (mappings = SourceResolver.getMappingsBySource(sourceMap, this.absoluteLocalPathToSourceIndex.get((Object)sourceFile.getPath()))) == null && (sourceFileCanonicalPath = sourceFile.getCanonicalPath()) != null) {
            mappings = SourceResolver.getMappingsBySource(sourceMap, this.absoluteLocalPathToSourceIndex.get((Object)sourceFileCanonicalPath));
        }
        if (mappings == null) {
            int index = this.canonicalizedSourcesMap.get((Object)Urls.newFromVirtualFile(sourceFile).trimParameters());
            if (index != -1) {
                return sourceMap.sourceIndexToMappings[index];
            }
            for (int i = 0; i < this.canonicalizedSources.length; ++i) {
                Url url = this.canonicalizedSources[i];
                if (Urls.equalsIgnoreParameters(url, sourceFile)) {
                    return sourceMap.sourceIndexToMappings[i];
                }
                VirtualFile canonicalFile = sourceFile.getCanonicalFile();
                if (canonicalFile == null || canonicalFile.equals(sourceFile) || !Urls.equalsIgnoreParameters(url, canonicalFile)) continue;
                return sourceMap.sourceIndexToMappings[i];
            }
        }
        return mappings;
    }

    public static interface Resolver {
        public int resolve(@Nullable VirtualFile var1, @NotNull ObjectIntHashMap<Url> var2);
    }
}

