/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.net.NetUtils;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.ide.PooledThreadExecutor;
import org.jetbrains.io.ChannelRegistrar;
import org.jetbrains.io.DelegatingHttpRequestHandler;
import org.jetbrains.io.NettyUtil;
import org.jetbrains.io.PortUnificationServerHandler;

public class BuiltInServer
implements Disposable {
    static final Logger LOG = Logger.getInstance(BuiltInServer.class);
    private final ChannelRegistrar channelRegistrar;
    final EventLoopGroup eventLoopGroup;
    private final int port;

    public boolean isRunning() {
        return !this.channelRegistrar.isEmpty();
    }

    private BuiltInServer(@NotNull EventLoopGroup eventLoopGroup, int port) {
        if (eventLoopGroup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "eventLoopGroup", "org/jetbrains/io/BuiltInServer", "<init>"));
        }
        this.channelRegistrar = new ChannelRegistrar();
        this.eventLoopGroup = eventLoopGroup;
        this.port = port;
    }

    @NotNull
    public static BuiltInServer start(int workerCount, int firstPort, int portsCount, boolean tryAnyPort) throws Throwable {
        NioEventLoopGroup eventLoopGroup = new NioEventLoopGroup(workerCount, (Executor)PooledThreadExecutor.INSTANCE);
        ChannelRegistrar channelRegistrar = new ChannelRegistrar();
        ServerBootstrap bootstrap = NettyUtil.nioServerBootstrap((EventLoopGroup)eventLoopGroup);
        BuiltInServer.configureChildHandler(bootstrap, channelRegistrar);
        BuiltInServer builtInServer = new BuiltInServer((EventLoopGroup)eventLoopGroup, BuiltInServer.bind(firstPort, portsCount, tryAnyPort, bootstrap, channelRegistrar));
        if (builtInServer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/io/BuiltInServer", "start"));
        }
        return builtInServer;
    }

    public int getPort() {
        return this.port;
    }

    static void configureChildHandler(@NotNull ServerBootstrap bootstrap, final @NotNull ChannelRegistrar channelRegistrar) {
        if (bootstrap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bootstrap", "org/jetbrains/io/BuiltInServer", "configureChildHandler"));
        }
        if (channelRegistrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "channelRegistrar", "org/jetbrains/io/BuiltInServer", "configureChildHandler"));
        }
        final PortUnificationServerHandler portUnificationServerHandler = new PortUnificationServerHandler();
        bootstrap.childHandler((ChannelHandler)new ChannelInitializer(){

            protected void initChannel(Channel channel) throws Exception {
                channel.pipeline().addLast(new ChannelHandler[]{channelRegistrar, portUnificationServerHandler});
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int bind(int firstPort, int portsCount, boolean tryAnyPort, @NotNull ServerBootstrap bootstrap, @NotNull ChannelRegistrar channelRegistrar) throws Throwable {
        if (bootstrap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bootstrap", "org/jetbrains/io/BuiltInServer", "bind"));
        }
        if (channelRegistrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "channelRegistrar", "org/jetbrains/io/BuiltInServer", "bind"));
        }
        InetAddress loopbackAddress = NetUtils.getLoopbackAddress();
        for (int i = 0; i < portsCount; ++i) {
            ChannelFuture future;
            int port = firstPort + i;
            if (!(SystemInfo.isLinux || SystemInfo.isWindows && !SystemInfo.isWinVistaOrNewer)) {
                try {
                    ServerSocket serverSocket = new ServerSocket();
                    try {
                        serverSocket.bind(new InetSocketAddress(port), 1);
                    }
                    finally {
                        serverSocket.close();
                    }
                }
                catch (IOException ignored) {
                    continue;
                }
            }
            if ((future = bootstrap.bind(loopbackAddress, port).awaitUninterruptibly()).isSuccess()) {
                channelRegistrar.add(future.channel());
                return port;
            }
            if (tryAnyPort || i != portsCount - 1) continue;
            throw future.cause();
        }
        LOG.info("We cannot bind to our default range, so, try to bind to any free port");
        ChannelFuture future = bootstrap.bind(loopbackAddress, 0).awaitUninterruptibly();
        if (future.isSuccess()) {
            channelRegistrar.add(future.channel());
            return ((InetSocketAddress)future.channel().localAddress()).getPort();
        }
        throw future.cause();
    }

    public void dispose() {
        this.channelRegistrar.close();
        LOG.info("web server stopped");
    }

    public static void replaceDefaultHandler(@NotNull ChannelHandlerContext context, @NotNull ChannelHandler channelHandler) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/io/BuiltInServer", "replaceDefaultHandler"));
        }
        if (channelHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "channelHandler", "org/jetbrains/io/BuiltInServer", "replaceDefaultHandler"));
        }
        context.pipeline().replace(DelegatingHttpRequestHandler.class, "replacedDefaultHandler", channelHandler);
    }
}

