/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.JBCardLayout;
import com.intellij.util.ui.components.JBPanel;
import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;

public class JBSlidingPanel
extends JBPanel {
    private final ArrayList<Pair<String, Component>> mySlides = new ArrayList();
    private int mySelectedIndex = -1;

    public JBSlidingPanel() {
        this.setLayout(new JBCardLayout());
    }

    public JBCardLayout getLayout() {
        return (JBCardLayout)super.getLayout();
    }

    public Component add(String name, Component comp) {
        this.mySlides.add((Pair<String, Component>)Pair.create((Object)name, (Object)comp));
        if (this.mySelectedIndex == -1) {
            this.mySelectedIndex = 0;
        }
        return super.add(name, comp);
    }

    public ActionCallback goLeft() {
        if (this.mySelectedIndex == 0) {
            return ActionCallback.REJECTED;
        }
        --this.mySelectedIndex;
        return this.applySlide(JBCardLayout.SwipeDirection.BACKWARD);
    }

    public ActionCallback swipe(String id, JBCardLayout.SwipeDirection direction) {
        final ActionCallback done = new ActionCallback();
        this.getLayout().swipe((Container)((Object)this), id, direction, new Runnable(){

            @Override
            public void run() {
                done.setDone();
            }
        });
        return done;
    }

    public ActionCallback goRight() {
        if (this.mySelectedIndex == this.mySlides.size() - 1) {
            return ActionCallback.REJECTED;
        }
        ++this.mySelectedIndex;
        return this.applySlide(JBCardLayout.SwipeDirection.FORWARD);
    }

    private ActionCallback applySlide(JBCardLayout.SwipeDirection direction) {
        final ActionCallback callback = new ActionCallback();
        this.getLayout().swipe((Container)((Object)this), (String)this.mySlides.get((int)this.mySelectedIndex).first, direction, new Runnable(){

            @Override
            public void run() {
                callback.setDone();
            }
        });
        return callback;
    }

    @Deprecated
    public Component add(Component comp) {
        throw new AddMethodIsNotSupportedException();
    }

    @Deprecated
    public Component add(Component comp, int index) {
        throw new AddMethodIsNotSupportedException();
    }

    @Deprecated
    public void add(Component comp, Object constraints) {
        throw new AddMethodIsNotSupportedException();
    }

    @Deprecated
    public void add(Component comp, Object constraints, int index) {
        throw new AddMethodIsNotSupportedException();
    }

    private static class AddMethodIsNotSupportedException
    extends RuntimeException {
        public AddMethodIsNotSupportedException() {
            super("Use add(String, Component) method");
        }
    }
}

