/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages;

import com.intellij.navigation.NavigationItem;
import com.intellij.navigation.NavigationItemFileStatus;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.NamedPresentably;
import com.intellij.usages.UsageGroup;
import com.intellij.usages.UsageView;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class PsiElementUsageGroupBase<T extends PsiElement & NavigationItem>
implements UsageGroup,
NamedPresentably {
    private final SmartPsiElementPointer myElementPointer;
    private final String myName;
    private final Icon myIcon;

    public PsiElementUsageGroupBase(@NotNull T element, Icon icon) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/usages/PsiElementUsageGroupBase", "<init>"));
        }
        String myName = ((NavigationItem)element).getName();
        if (myName == null) {
            myName = "<anonymous>";
        }
        this.myName = myName;
        this.myElementPointer = SmartPointerManager.getInstance(element.getProject()).createSmartPsiElementPointer(element);
        this.myIcon = icon;
    }

    public PsiElementUsageGroupBase(@NotNull T element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/usages/PsiElementUsageGroupBase", "<init>"));
        }
        this(element, element.getIcon(0));
    }

    @Override
    public Icon getIcon(boolean isOpen) {
        return this.myIcon;
    }

    public T getElement() {
        return (T)this.myElementPointer.getElement();
    }

    @Override
    @NotNull
    public String getText(UsageView view) {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/PsiElementUsageGroupBase", "getText"));
        }
        return string;
    }

    @Override
    public FileStatus getFileStatus() {
        return this.isValid() ? NavigationItemFileStatus.get((NavigationItem)this.getElement()) : null;
    }

    @Override
    public boolean isValid() {
        T element = this.getElement();
        return element != null && element.isValid();
    }

    @Override
    public void navigate(boolean focus) throws UnsupportedOperationException {
        if (this.canNavigate()) {
            ((Navigatable)this.getElement()).navigate(focus);
        }
    }

    @Override
    public boolean canNavigate() {
        return this.isValid();
    }

    @Override
    public boolean canNavigateToSource() {
        return this.canNavigate();
    }

    @Override
    public void update() {
    }

    @Override
    public int compareTo(@NotNull UsageGroup o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/usages/PsiElementUsageGroupBase", "compareTo"));
        }
        String name = o instanceof NamedPresentably ? ((NamedPresentably)((Object)o)).getPresentableName() : o.getText(null);
        return this.myName.compareToIgnoreCase(name);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PsiElementUsageGroupBase)) {
            return false;
        }
        PsiElementUsageGroupBase group = (PsiElementUsageGroupBase)obj;
        if (this.isValid() && group.isValid()) {
            return this.getElement().getManager().areElementsEquivalent((PsiElement)this.getElement(), (PsiElement)group.getElement());
        }
        return Comparing.equal((String)this.myName, (String)((PsiElementUsageGroupBase)obj).myName);
    }

    public int hashCode() {
        return this.myName.hashCode();
    }

    public void calcData(DataKey key, DataSink sink) {
        T element;
        if (!this.isValid()) {
            return;
        }
        if (CommonDataKeys.PSI_ELEMENT == key) {
            sink.put(CommonDataKeys.PSI_ELEMENT, this.getElement());
        }
        if (UsageView.USAGE_INFO_KEY == key && (element = this.getElement()) != null) {
            sink.put(UsageView.USAGE_INFO_KEY, new UsageInfo((PsiElement)element));
        }
    }

    @Override
    @NotNull
    public String getPresentableName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/usages/PsiElementUsageGroupBase", "getPresentableName"));
        }
        return string;
    }
}

