/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.repository.packages;

import com.android.sdklib.internal.repository.packages.IMinToolsDependency;
import com.android.sdklib.internal.repository.packages.Package;
import com.android.sdklib.internal.repository.packages.PackageParserUtils;
import com.android.sdklib.internal.repository.sources.SdkSource;
import com.android.sdklib.repository.FullRevision;
import java.util.Properties;
import org.w3c.dom.Node;

class MinToolsMixin
implements IMinToolsDependency {
    private final FullRevision mMinToolsRevision;

    MinToolsMixin(Node packageNode) {
        this.mMinToolsRevision = PackageParserUtils.parseFullRevisionElement(PackageParserUtils.findChildElement(packageNode, "min-tools-rev"));
    }

    public MinToolsMixin(SdkSource source, Properties props, int revision, String license, String description, String descUrl, String archiveOsPath) {
        String revStr = Package.getProperty(props, "Platform.MinToolsRev", null);
        FullRevision rev = MIN_TOOLS_REV_NOT_SPECIFIED;
        if (revStr != null) {
            try {
                rev = FullRevision.parseRevision(revStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.mMinToolsRevision = rev;
    }

    @Override
    public FullRevision getMinToolsRevision() {
        return this.mMinToolsRevision;
    }

    public void saveProperties(Properties props) {
        if (!this.getMinToolsRevision().equals(MIN_TOOLS_REV_NOT_SPECIFIED)) {
            props.setProperty("Platform.MinToolsRev", this.getMinToolsRevision().toShortString());
        }
    }

    public int hashCode() {
        return this.hashCode(super.hashCode());
    }

    int hashCode(int superHashCode) {
        int prime = 31;
        int result = superHashCode;
        result = 31 * result + (this.mMinToolsRevision == null ? 0 : this.mMinToolsRevision.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof IMinToolsDependency)) {
            return false;
        }
        IMinToolsDependency other = (IMinToolsDependency)obj;
        return !(this.mMinToolsRevision == null ? other.getMinToolsRevision() != null : !this.mMinToolsRevision.equals(other.getMinToolsRevision()));
    }
}

