/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.junit3;

import com.intellij.junit3.JUnit3OutputObjectRegistry;
import com.intellij.junit3.TestResultsSender;
import com.intellij.junit3.TestRunnerUtil;
import com.intellij.rt.execution.junit.DeafStream;
import com.intellij.rt.execution.junit.IDEAJUnitListener;
import com.intellij.rt.execution.junit.IdeaTestRunner;
import com.intellij.rt.execution.junit.JUnitStarter;
import com.intellij.rt.execution.junit.TimeSender;
import com.intellij.rt.execution.junit.TreeSender;
import com.intellij.rt.execution.junit.segments.OutputObjectRegistry;
import com.intellij.rt.execution.junit.segments.PacketProcessor;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import jetbrains.buildServer.messages.serviceMessages.ServiceMessage;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestListener;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import junit.textui.ResultPrinter;
import junit.textui.TestRunner;

public class JUnit3IdeaTestRunner
extends TestRunner
implements IdeaTestRunner {
    private TestListener myTestsListener;
    private JUnit3OutputObjectRegistry myRegistry;
    private ArrayList myListeners;
    private boolean mySendTree;

    public JUnit3IdeaTestRunner() {
        super(DeafStream.DEAF_PRINT_STREAM);
    }

    public int startRunnerWithArgs(String[] args, ArrayList listeners, String name, int count, boolean sendTree) {
        this.myListeners = listeners;
        boolean bl = this.mySendTree = sendTree && !(this.myTestsListener instanceof SMTestListener);
        if (this.mySendTree) {
            this.setPrinter(new TimeSender(this.myRegistry));
        } else {
            this.setPrinter(new MockResultPrinter());
        }
        try {
            Test suite = TestRunnerUtil.getTestSuite(this, args);
            if (suite == null) {
                return -1;
            }
            TestResult result = this.doRun(suite);
            if (!result.wasSuccessful()) {
                return -1;
            }
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            return -2;
        }
    }

    public void clearStatus() {
        super.clearStatus();
    }

    public void runFailed(String message) {
        super.runFailed(message);
    }

    public void setStreams(Object segmentedOut, Object segmentedErr, int lastIdx) {
        if (JUnitStarter.SM_RUNNER) {
            this.myTestsListener = new SMTestListener();
        } else {
            this.myRegistry = new JUnit3OutputObjectRegistry((PacketProcessor)segmentedOut, lastIdx);
            this.myTestsListener = new TestResultsSender(this.myRegistry);
        }
    }

    public Object getTestToStart(String[] args, String name) {
        return TestRunnerUtil.getTestSuite(this, args);
    }

    public List getChildTests(Object description) {
        return JUnit3IdeaTestRunner.getTestCasesOf((Test)description);
    }

    public OutputObjectRegistry getRegistry() {
        return this.myRegistry;
    }

    public String getTestClassName(Object child) {
        return child instanceof TestSuite ? ((TestSuite)child).getName() : child.getClass().getName();
    }

    public String getStartDescription(Object child) {
        Test test = (Test)child;
        if (test instanceof TestCase) {
            return test.getClass().getName() + "," + ((TestCase)test).getName();
        }
        return test.toString();
    }

    protected TestResult createTestResult() {
        TestResult testResult = super.createTestResult();
        testResult.addListener(this.myTestsListener);
        try {
            for (int i = 0; i < this.myListeners.size(); ++i) {
                final IDEAJUnitListener junitListener = (IDEAJUnitListener)Class.forName((String)this.myListeners.get(i)).newInstance();
                testResult.addListener(new TestListener(){

                    public void addError(Test test, Throwable t) {
                    }

                    public void addFailure(Test test, AssertionFailedError t) {
                    }

                    public void endTest(Test test) {
                        if (test instanceof TestCase) {
                            junitListener.testFinished(test.getClass().getName(), ((TestCase)test).getName());
                        }
                    }

                    public void startTest(Test test) {
                        if (test instanceof TestCase) {
                            junitListener.testStarted(test.getClass().getName(), ((TestCase)test).getName());
                        }
                    }
                });
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return testResult;
    }

    public TestResult doRun(Test suite, boolean wait) {
        try {
            TreeSender.sendTree(this, suite, this.mySendTree);
        }
        catch (Exception e) {
            System.err.println("Internal Error occured.");
            e.printStackTrace(System.err);
        }
        TestResult testResult = super.doRun(suite, wait);
        if (this.myTestsListener instanceof SMTestListener) {
            ((SMTestListener)this.myTestsListener).finishSuite();
        }
        return testResult;
    }

    static Vector getTestCasesOf(Test test) {
        Vector testCases = new Vector();
        if (test instanceof TestRunnerUtil.SuiteMethodWrapper) {
            test = ((TestRunnerUtil.SuiteMethodWrapper)test).getSuite();
        }
        if (test instanceof TestSuite) {
            TestSuite testSuite = (TestSuite)test;
            Enumeration each = testSuite.tests();
            while (each.hasMoreElements()) {
                Object childTest = each.nextElement();
                if (childTest instanceof TestSuite && !((TestSuite)childTest).tests().hasMoreElements()) continue;
                testCases.addElement(childTest);
            }
        }
        return testCases;
    }

    private static class SMTestListener
    implements TestListener {
        private String myClassName;

        private SMTestListener() {
        }

        public void addError(Test test, Throwable e) {
            String failureMessage = e.getMessage();
            HashMap<String, String> attrs = new HashMap<String, String>();
            attrs.put("name", SMTestListener.getMethodName(test));
            attrs.put("message", failureMessage != null ? failureMessage : "");
            System.out.println(ServiceMessage.asString((String)"testFailed", attrs));
        }

        private static String getMethodName(Test test) {
            String toString = test.toString();
            int braceIdx = toString.indexOf("(");
            return braceIdx > 0 ? toString.substring(0, braceIdx) : toString;
        }

        private static String getClassName(Test test) {
            String toString = test.toString();
            int braceIdx = toString.indexOf("(");
            return braceIdx > 0 && toString.endsWith(")") ? toString.substring(braceIdx + 1, toString.length() - 1) : null;
        }

        public void addFailure(Test test, AssertionFailedError e) {
            this.addError(test, (Throwable)e);
        }

        public void endTest(Test test) {
            System.out.println("\n##teamcity[testFinished name='" + SMTestListener.getMethodName(test) + "']");
        }

        public void startTest(Test test) {
            String className = SMTestListener.getClassName(test);
            if (className != null && !className.equals(this.myClassName)) {
                this.finishSuite();
                this.myClassName = className;
                System.out.println("##teamcity[testSuiteStarted name ='" + this.myClassName + "' locationHint='java:suite://" + className + "']");
            }
            String methodName = SMTestListener.getMethodName(test);
            System.out.println("##teamcity[testStarted name='" + methodName + "' locationHint='java:test://" + className + "." + methodName + "']");
        }

        protected void finishSuite() {
            if (this.myClassName != null) {
                System.out.println("##teamcity[testSuiteFinished name='" + this.myClassName + "']");
            }
        }
    }

    public static class MockResultPrinter
    extends ResultPrinter {
        public MockResultPrinter() {
            super(DeafStream.DEAF_PRINT_STREAM);
        }
    }
}

