/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.config;

import com.intellij.openapi.externalSystem.psi.search.ExternalModuleBuildGlobalSearchScope;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.NonClasspathClassFinder;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.EverythingGlobalScope;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.GradleBuildClasspathManager;

public class GradleClassFinder
extends NonClasspathClassFinder {
    @NotNull
    private final GradleBuildClasspathManager myBuildClasspathManager;

    public GradleClassFinder(Project project, @NotNull GradleBuildClasspathManager buildClasspathManager) {
        if (buildClasspathManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildClasspathManager", "org/jetbrains/plugins/gradle/config/GradleClassFinder", "<init>"));
        }
        super(project, new String[]{"java", "groovy"});
        this.myBuildClasspathManager = buildClasspathManager;
    }

    protected List<VirtualFile> calcClassRoots() {
        throw new AssertionError();
    }

    protected List<VirtualFile> getClassRoots() {
        return this.myBuildClasspathManager.getAllClasspathEntries();
    }

    protected List<VirtualFile> getClassRoots(@Nullable GlobalSearchScope scope) {
        if (scope instanceof ExternalModuleBuildGlobalSearchScope) {
            ExternalModuleBuildGlobalSearchScope externalModuleBuildGlobalSearchScope = (ExternalModuleBuildGlobalSearchScope)scope;
            return this.myBuildClasspathManager.getModuleClasspathEntries(externalModuleBuildGlobalSearchScope.getExternalModulePath());
        }
        return this.myBuildClasspathManager.getAllClasspathEntries();
    }

    public PsiClass findClass(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "org/jetbrains/plugins/gradle/config/GradleClassFinder", "findClass"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "org/jetbrains/plugins/gradle/config/GradleClassFinder", "findClass"));
        }
        PsiClass aClass = super.findClass(qualifiedName, scope);
        if (aClass == null || scope instanceof ExternalModuleBuildGlobalSearchScope || scope instanceof EverythingGlobalScope) {
            return aClass;
        }
        PsiFile containingFile = aClass.getContainingFile();
        VirtualFile file = containingFile != null ? containingFile.getVirtualFile() : null;
        return file != null && !ProjectFileIndex.SERVICE.getInstance((Project)this.myProject).isInContent(file) ? aClass : null;
    }
}

