/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties;

import com.intellij.lang.properties.CustomResourceBundleState;
import com.intellij.lang.properties.PropertiesImplUtil;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiManager;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomResourceBundle
extends ResourceBundle {
    private static final Logger LOG = Logger.getInstance(CustomResourceBundle.class);
    private final List<PropertiesFile> myFiles;
    private final String myBaseName;

    private CustomResourceBundle(List<PropertiesFile> files, @NotNull String baseName) {
        if (baseName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseName", "com/intellij/lang/properties/CustomResourceBundle", "<init>"));
        }
        LOG.assertTrue(!files.isEmpty());
        this.myFiles = new ArrayList<PropertiesFile>(files);
        Collections.sort(this.myFiles, new Comparator<PropertiesFile>(){

            @Override
            public int compare(PropertiesFile f1, PropertiesFile f2) {
                return f1.getName().compareTo(f2.getName());
            }
        });
        this.myBaseName = baseName;
    }

    public static CustomResourceBundle fromState(CustomResourceBundleState state, Project project) {
        final PsiManager psiManager = PsiManager.getInstance((Project)project);
        List files = ContainerUtil.map(state.getFiles(VirtualFileManager.getInstance()), (Function)new Function<VirtualFile, PropertiesFile>(){

            public PropertiesFile fun(VirtualFile virtualFile) {
                return PropertiesImplUtil.getPropertiesFile(psiManager.findFile(virtualFile));
            }
        });
        return files.size() < 2 ? null : new CustomResourceBundle(files, state.getBaseName());
    }

    @Override
    @NotNull
    public List<PropertiesFile> getPropertiesFiles() {
        List<PropertiesFile> list = this.myFiles;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/CustomResourceBundle", "getPropertiesFiles"));
        }
        return list;
    }

    @Override
    @NotNull
    public PropertiesFile getDefaultPropertiesFile() {
        PropertiesFile propertiesFile = (PropertiesFile)ContainerUtil.getFirstItem(this.myFiles);
        if (propertiesFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/CustomResourceBundle", "getDefaultPropertiesFile"));
        }
        return propertiesFile;
    }

    @Override
    @NotNull
    public String getBaseName() {
        String string = this.myBaseName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/CustomResourceBundle", "getBaseName"));
        }
        return string;
    }

    @Override
    @Nullable
    public VirtualFile getBaseDirectory() {
        return null;
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.getDefaultPropertiesFile().getProject();
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/CustomResourceBundle", "getProject"));
        }
        return project;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomResourceBundle resourceBundle = (CustomResourceBundle)o;
        return resourceBundle.getPropertiesFiles().equals(resourceBundle.getPropertiesFiles()) && resourceBundle.getBaseName().equals(this.getBaseName());
    }

    public int hashCode() {
        return this.myFiles.hashCode() * 31 + this.myBaseName.hashCode();
    }
}

