/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties;

import com.intellij.lang.properties.PropertiesImplUtil;
import com.intellij.lang.properties.PropertiesUtil;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.ResourceBundleManager;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.SmartList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ResourceBundleImpl
extends ResourceBundle {
    @NotNull
    private final PropertiesFile myDefaultPropertiesFile;
    private boolean myValid;

    public ResourceBundleImpl(@NotNull PropertiesFile defaultPropertiesFile) {
        if (defaultPropertiesFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultPropertiesFile", "com/intellij/lang/properties/ResourceBundleImpl", "<init>"));
        }
        this.myValid = true;
        this.myDefaultPropertiesFile = defaultPropertiesFile;
    }

    @Override
    @NotNull
    public List<PropertiesFile> getPropertiesFiles() {
        if (ResourceBundleManager.getInstance(this.getProject()).isDefaultDissociated(this.myDefaultPropertiesFile.getVirtualFile())) {
            List<PropertiesFile> list = Collections.singletonList(this.myDefaultPropertiesFile);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/ResourceBundleImpl", "getPropertiesFiles"));
            }
            return list;
        }
        PsiFile[] children = (PsiFile[])ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiFile[]>(){

            public PsiFile[] compute() {
                return ResourceBundleImpl.this.myDefaultPropertiesFile.getParent().getFiles();
            }
        });
        String baseName = this.getBaseName();
        SmartList result = new SmartList();
        String defaultNameWithoutExtension = FileUtil.getNameWithoutExtension((String)this.myDefaultPropertiesFile.getName());
        for (PsiFile file : children) {
            PropertiesFile propertiesFile;
            if (!file.isValid() || file.getVirtualFile().getExtension() == null || !Comparing.strEqual((String)PropertiesUtil.getDefaultBaseName(file.getVirtualFile()), (String)baseName) || (propertiesFile = PropertiesImplUtil.getPropertiesFile(file)) == null) continue;
            result.add(propertiesFile);
            if (propertiesFile == this.myDefaultPropertiesFile || FileUtil.getNameWithoutExtension((String)propertiesFile.getName()).compareTo(defaultNameWithoutExtension) != 0) continue;
            List<PropertiesFile> list = Collections.singletonList(this.myDefaultPropertiesFile);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/ResourceBundleImpl", "getPropertiesFiles"));
            }
            return list;
        }
        SmartList smartList = result;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/ResourceBundleImpl", "getPropertiesFiles"));
        }
        return smartList;
    }

    @Override
    @NotNull
    public PropertiesFile getDefaultPropertiesFile() {
        PropertiesFile propertiesFile = this.myDefaultPropertiesFile;
        if (propertiesFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/ResourceBundleImpl", "getDefaultPropertiesFile"));
        }
        return propertiesFile;
    }

    @Override
    @NotNull
    public String getBaseName() {
        String string = ResourceBundleManager.getInstance(this.getProject()).getBaseName(this.myDefaultPropertiesFile.getContainingFile());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/ResourceBundleImpl", "getBaseName"));
        }
        return string;
    }

    @Override
    @NotNull
    public VirtualFile getBaseDirectory() {
        VirtualFile virtualFile = this.myDefaultPropertiesFile.getParent().getVirtualFile();
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/ResourceBundleImpl", "getBaseDirectory"));
        }
        return virtualFile;
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.myDefaultPropertiesFile.getProject();
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/properties/ResourceBundleImpl", "getProject"));
        }
        return project;
    }

    public boolean isValid() {
        return this.myValid;
    }

    public void invalidate() {
        this.myValid = false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceBundleImpl resourceBundle = (ResourceBundleImpl)o;
        return this.myDefaultPropertiesFile.equals(resourceBundle.myDefaultPropertiesFile);
    }

    public int hashCode() {
        return this.myDefaultPropertiesFile.hashCode();
    }

    public String getUrl() {
        return this.getBaseDirectory() + "/" + this.getBaseName();
    }

    public String toString() {
        return "ResourceBundleImpl:" + this.getBaseName();
    }
}

