/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.allocations;

import com.android.ddmlib.AllocationInfo;
import com.android.ddmlib.AllocationsParser;
import com.android.ddmlib.ByteBufferUtil;
import com.android.tools.idea.editors.allocations.AllocationsViewPanel;
import com.google.common.base.Throwables;
import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AllocationsEditor
implements FileEditor {
    private final AllocationsViewPanel myAllocationsViewPanel;

    public AllocationsEditor(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/editors/allocations/AllocationsEditor", "<init>"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/editors/allocations/AllocationsEditor", "<init>"));
        }
        this.myAllocationsViewPanel = new AllocationsViewPanel(project);
        this.parseAllocationsFileInBackground(project, file);
    }

    private void parseAllocationsFileInBackground(final Project project, final VirtualFile file) {
        final Task.Modal parseTask = new Task.Modal(project, "Parsing allocations file", false){
            private AllocationInfo[] myAllocations;
            private String myErrorMessage;

            public void run(@NotNull ProgressIndicator indicator) {
                ByteBuffer data;
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/android/tools/idea/editors/allocations/AllocationsEditor$1", "run"));
                }
                indicator.setIndeterminate(true);
                File allocationsFile = VfsUtilCore.virtualToIoFile((VirtualFile)file);
                try {
                    data = ByteBufferUtil.mapFile((File)allocationsFile, (long)0L, (ByteOrder)ByteOrder.BIG_ENDIAN);
                }
                catch (IOException ex) {
                    this.myErrorMessage = "Error reading from allocations file " + allocationsFile.getAbsolutePath();
                    throw new ProcessCanceledException();
                }
                try {
                    this.myAllocations = AllocationsParser.parse((ByteBuffer)data);
                }
                catch (Throwable throwable) {
                    this.myErrorMessage = "Unexpected error while parsing allocations file: " + Throwables.getRootCause((Throwable)throwable).getMessage();
                    throw new ProcessCanceledException();
                }
            }

            public void onSuccess() {
                AllocationsEditor.this.myAllocationsViewPanel.setAllocations(this.myAllocations);
            }

            public void onCancel() {
                Messages.showErrorDialog((Project)project, (String)this.myErrorMessage, (String)AllocationsEditor.this.getName());
            }
        };
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                parseTask.queue();
            }
        });
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myAllocationsViewPanel.getComponent();
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/allocations/AllocationsEditor", "getComponent"));
        }
        return jPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return null;
    }

    @NotNull
    public String getName() {
        if ("AllocationsView" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/allocations/AllocationsEditor", "getName"));
        }
        return "AllocationsView";
    }

    @NotNull
    public FileEditorState getState(@NotNull FileEditorStateLevel level) {
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "com/android/tools/idea/editors/allocations/AllocationsEditor", "getState"));
        }
        FileEditorState fileEditorState = FileEditorState.INSTANCE;
        if (fileEditorState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/allocations/AllocationsEditor", "getState"));
        }
        return fileEditorState;
    }

    public void setState(@NotNull FileEditorState state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/android/tools/idea/editors/allocations/AllocationsEditor", "setState"));
        }
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        return true;
    }

    public void selectNotify() {
    }

    public void deselectNotify() {
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/editors/allocations/AllocationsEditor", "addPropertyChangeListener"));
        }
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/editors/allocations/AllocationsEditor", "removePropertyChangeListener"));
        }
    }

    @Nullable
    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return null;
    }

    @Nullable
    public FileEditorLocation getCurrentLocation() {
        return null;
    }

    @Nullable
    public StructureViewBuilder getStructureViewBuilder() {
        return null;
    }

    public void dispose() {
    }

    @Nullable
    public <T> T getUserData(@NotNull Key<T> key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/android/tools/idea/editors/allocations/AllocationsEditor", "getUserData"));
        }
        return null;
    }

    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/android/tools/idea/editors/allocations/AllocationsEditor", "putUserData"));
        }
    }
}

