/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractice.testng.inspection;

import com.intellij.codeInsight.daemon.impl.quickfix.CreateMethodQuickFix;
import com.intellij.codeInspection.BaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateDescriptor;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiUtil;
import com.theoryinpractice.testng.DataProviderReference;
import com.theoryinpractice.testng.TestNGFramework;
import com.theoryinpractice.testng.util.TestNGUtil;
import java.io.IOException;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.testng.annotations.DataProvider;

public class TestNGDataProviderInspection
extends BaseJavaLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/theoryinpractice/testng/inspection/TestNGDataProviderInspection", "buildVisitor"));
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitAnnotation(PsiAnnotation annotation) {
                PsiAnnotationMemberValue provider;
                if (TestNGUtil.TEST_ANNOTATION_FQN.equals(annotation.getQualifiedName()) && (provider = annotation.findDeclaredAttributeValue("dataProvider")) != null && !TestNGUtil.isDisabled(annotation)) {
                    for (PsiReference reference : provider.getReferences()) {
                        if (!(reference instanceof DataProviderReference)) continue;
                        PsiElement dataProviderMethod = reference.resolve();
                        PsiElement element = reference.getElement();
                        PsiClass topLevelClass = PsiUtil.getTopLevelClass((PsiElement)element);
                        PsiClass providerClass = TestNGUtil.getProviderClass(element, topLevelClass);
                        if (!(dataProviderMethod instanceof PsiMethod)) {
                            LocalQuickFix[] fixes = isOnTheFly ? new LocalQuickFix[]{TestNGDataProviderInspection.createMethodFix(provider, providerClass, topLevelClass)} : LocalQuickFix.EMPTY_ARRAY;
                            holder.registerProblem((PsiElement)provider, "Data provider does not exist", fixes);
                            break;
                        }
                        PsiMethod providerMethod = (PsiMethod)dataProviderMethod;
                        if (providerClass == topLevelClass || providerMethod.hasModifierProperty("static")) break;
                        holder.registerProblem((PsiElement)provider, "Data provider from foreign class need to be static", new LocalQuickFix[0]);
                        break;
                    }
                }
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/theoryinpractice/testng/inspection/TestNGDataProviderInspection", "buildVisitor"));
        }
        return javaElementVisitor;
    }

    private static CreateMethodQuickFix createMethodFix(PsiAnnotationMemberValue provider, PsiClass providerClass, PsiClass topLevelClass) {
        FileTemplateDescriptor templateDesc = new TestNGFramework().getParametersMethodFileTemplateDescriptor();
        assert (templateDesc != null);
        FileTemplate fileTemplate = FileTemplateManager.getInstance((Project)provider.getProject()).getCodeTemplate(templateDesc.getFileName());
        String body = "";
        try {
            body = fileTemplate.getText(new Properties());
            body = body.replace("${BODY}", "");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (StringUtil.isEmptyOrSpaces((String)body)) {
            body = "return new Object[][]{};";
        }
        String signature = "@" + DataProvider.class.getName() + " public ";
        if (providerClass == topLevelClass) {
            signature = signature + "static ";
        }
        signature = signature + "Object[][] " + StringUtil.unquoteString((String)provider.getText()) + "()";
        return CreateMethodQuickFix.createFix((PsiClass)providerClass, (String)signature, (String)body);
    }
}

