/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractice.testng.model;

import com.intellij.execution.CantRunException;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.RuntimeConfigurationWarning;
import com.intellij.execution.testframework.SourceScope;
import com.intellij.execution.testframework.TestSearchScope;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.ClassUtil;
import com.theoryinpractice.testng.configuration.TestNGConfiguration;
import com.theoryinpractice.testng.model.TestClassFilter;
import com.theoryinpractice.testng.model.TestData;
import com.theoryinpractice.testng.model.TestNGTestObject;
import com.theoryinpractice.testng.util.TestNGUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jetbrains.annotations.Nullable;

public class TestNGTestPattern
extends TestNGTestObject {
    private static final Logger LOG = Logger.getInstance((String)("#" + TestNGTestPattern.class.getName()));

    public TestNGTestPattern(TestNGConfiguration config) {
        super(config);
    }

    @Override
    public void fillTestObjects(Map<PsiClass, Map<PsiMethod, List<String>>> classes) throws CantRunException {
        TestData data = this.myConfig.getPersistantData();
        for (String pattern : data.getPatterns()) {
            PsiClass psiClass;
            Object className;
            String methodName;
            if (pattern.contains(",")) {
                methodName = StringUtil.getShortName((String)pattern, (char)',');
                className = StringUtil.getPackageName((String)pattern, (char)',');
            } else {
                className = pattern;
                methodName = null;
            }
            if ((psiClass = (PsiClass)ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiClass>((String)className){
                final /* synthetic */ String val$className;
                {
                    this.val$className = string;
                }

                @Nullable
                public PsiClass compute() {
                    return ClassUtil.findPsiClass((PsiManager)PsiManager.getInstance((Project)TestNGTestPattern.this.myConfig.getProject()), (String)this.val$className.replace('/', '.'), null, (boolean)true, (GlobalSearchScope)TestNGTestPattern.this.getSearchScope());
                }
            })) == null) continue;
            Boolean hasTest = (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

                public Boolean compute() {
                    return TestNGUtil.hasTest((PsiModifierListOwner)psiClass);
                }
            });
            if (hasTest.booleanValue()) {
                if (StringUtil.isEmpty((String)methodName)) {
                    TestNGTestPattern.calculateDependencies(null, classes, this.getSearchScope(), psiClass);
                    continue;
                }
                TestNGTestPattern.collectTestMethods(classes, psiClass, methodName, this.getSearchScope());
                continue;
            }
            throw new CantRunException("No tests found in class " + (String)className);
        }
        if (classes.size() != data.getPatterns().size()) {
            TestSearchScope scope = this.myConfig.getPersistantData().getScope();
            final ArrayList<Pattern> compilePatterns = new ArrayList<Pattern>();
            for (String p : data.getPatterns()) {
                Pattern compilePattern;
                try {
                    compilePattern = Pattern.compile(p);
                }
                catch (PatternSyntaxException e) {
                    continue;
                }
                compilePatterns.add(compilePattern);
            }
            SourceScope sourceScope = scope.getSourceScope((ModuleBasedConfiguration)this.myConfig);
            TestClassFilter projectFilter = new TestClassFilter(sourceScope != null ? sourceScope.getGlobalSearchScope() : GlobalSearchScope.allScope((Project)this.myConfig.getProject()), this.myConfig.getProject(), true, true){

                @Override
                public boolean isAccepted(PsiClass psiClass) {
                    if (super.isAccepted(psiClass)) {
                        String qualifiedName = psiClass.getQualifiedName();
                        LOG.assertTrue(qualifiedName != null);
                        for (Pattern pattern : compilePatterns) {
                            if (!pattern.matcher(qualifiedName).matches()) continue;
                            return true;
                        }
                    }
                    return false;
                }
            };
            TestNGTestPattern.calculateDependencies(null, classes, this.getSearchScope(), TestNGUtil.getAllTestClasses(projectFilter, false));
            if (classes.size() == 0) {
                throw new CantRunException("No tests found in for patterns \"" + StringUtil.join(data.getPatterns(), (String)" || ") + '\"');
            }
        }
    }

    @Override
    public String getGeneratedName() {
        Set<String> patterns = this.myConfig.getPersistantData().getPatterns();
        int size = patterns.size();
        if (size == 0) {
            return "Temp suite";
        }
        return StringUtil.getShortName((String)patterns.iterator().next()) + (size > 1 ? " and " + (size - 1) + " more" : "");
    }

    @Override
    public String getActionName() {
        return this.getGeneratedName();
    }

    @Override
    public void checkConfiguration() throws RuntimeConfigurationException {
        Set<String> patterns = this.myConfig.getPersistantData().getPatterns();
        if (patterns.isEmpty()) {
            throw new RuntimeConfigurationWarning("No pattern selected");
        }
    }
}

