/*
 * Decompiled with CFR 0.152.
 */
package org.testng;

import java.util.Collections;
import java.util.List;
import org.testng.IDEATestNGRemoteListener;
import org.testng.ITestListener;
import org.testng.TestNG;
import org.testng.collections.Lists;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlInclude;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IDEARemoteTestNG
extends TestNG {
    private final String myParam;

    public IDEARemoteTestNG(String param) {
        this.myParam = param;
    }

    private static void calculateAllSuites(List<XmlSuite> suites, List<XmlSuite> outSuites) {
        for (XmlSuite s : suites) {
            outSuites.add(s);
            IDEARemoteTestNG.calculateAllSuites(s.getChildSuites(), outSuites);
        }
    }

    public void run() {
        try {
            this.initializeSuitesAndJarFile();
            List suites = Lists.newArrayList();
            IDEARemoteTestNG.calculateAllSuites(this.m_suites, suites);
            if (suites.size() > 0) {
                for (XmlSuite suite : suites) {
                    List tests = suite.getTests();
                    for (XmlTest test : tests) {
                        try {
                            if (this.myParam == null) continue;
                            for (XmlClass aClass : test.getXmlClasses()) {
                                for (XmlInclude include : aClass.getIncludedMethods()) {
                                    XmlInclude xmlInclude = new XmlInclude(include.getName(), Collections.singletonList(Integer.parseInt(this.myParam)), 0);
                                    aClass.setIncludedMethods(Collections.singletonList(xmlInclude));
                                }
                            }
                        }
                        catch (NumberFormatException e) {
                            System.err.println("Invocation number: expected integer but found: " + this.myParam);
                        }
                    }
                }
                IDEATestNGRemoteListener listener = new IDEATestNGRemoteListener();
                this.addListener(listener);
                this.addListener((ITestListener)listener);
                super.run();
                System.exit(0);
            } else {
                System.out.println("##teamcity[enteredTheMatrix]");
                System.err.println("Nothing found to run");
            }
        }
        catch (Throwable cause) {
            cause.printStackTrace(System.err);
        }
    }
}

