/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.eclipse.importWizard;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.StdModuleTypes;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.impl.ProjectMacrosUtil;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.impl.ModifiableModelCommitter;
import com.intellij.openapi.roots.impl.storage.ClasspathStorage;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.ModifiableArtifactModel;
import com.intellij.projectImport.ProjectImportBuilder;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.containers.HashMap;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import icons.EclipseIcons;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.Icon;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.eclipse.EclipseBundle;
import org.jetbrains.idea.eclipse.EclipseProjectFinder;
import org.jetbrains.idea.eclipse.conversion.EclipseClasspathReader;
import org.jetbrains.idea.eclipse.conversion.EclipseUserLibrariesHelper;
import org.jetbrains.idea.eclipse.importWizard.EclipseNatureImporter;
import org.jetbrains.idea.eclipse.importWizard.EclipseProjectWizardContext;
import org.jetbrains.idea.eclipse.importWizard.Options;

public class EclipseImportBuilder
extends ProjectImportBuilder<String>
implements EclipseProjectWizardContext {
    private static final Logger LOG = Logger.getInstance((String)("#" + EclipseImportBuilder.class.getName()));
    private Parameters parameters;

    @NotNull
    public String getName() {
        String string = EclipseBundle.message("eclipse.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/eclipse/importWizard/EclipseImportBuilder", "getName"));
        }
        return string;
    }

    public Icon getIcon() {
        return EclipseIcons.Eclipse;
    }

    @Override
    @Nullable
    public String getRootDirectory() {
        return this.getParameters().root;
    }

    @Override
    public boolean setRootDirectory(final String path) {
        ProgressManager.getInstance().run((Task)new Task.Modal(EclipseImportBuilder.getCurrentProject(), EclipseBundle.message("eclipse.import.scanning", new Object[0]), true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/idea/eclipse/importWizard/EclipseImportBuilder$1", "run"));
                }
                ArrayList<String> roots = new ArrayList<String>();
                EclipseProjectFinder.findModuleRoots(roots, (String)path, (Processor)new Processor<String>(){

                    public boolean process(String path) {
                        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
                        if (progressIndicator != null) {
                            if (progressIndicator.isCanceled()) {
                                return false;
                            }
                            progressIndicator.setText2(path);
                        }
                        return true;
                    }
                });
                Collections.sort(roots, new Comparator<String>(){

                    @Override
                    public int compare(String path1, String path2) {
                        String projectName1 = EclipseProjectFinder.findProjectName((String)path1);
                        String projectName2 = EclipseProjectFinder.findProjectName((String)path2);
                        return projectName1 != null && projectName2 != null ? projectName1.compareToIgnoreCase(projectName2) : 0;
                    }
                });
                EclipseImportBuilder.this.getParameters().workspace = roots;
                EclipseImportBuilder.this.getParameters().root = path;
            }

            public void onCancel() {
                EclipseImportBuilder.this.getParameters().workspace = null;
                EclipseImportBuilder.this.getParameters().root = null;
            }
        });
        this.setFileToImport(path);
        return this.getParameters().workspace != null;
    }

    public List<String> getList() {
        return this.getParameters().workspace;
    }

    public boolean isMarked(String element) {
        if (this.getParameters().projectsToConvert != null) {
            return this.getParameters().projectsToConvert.contains(element);
        }
        return !this.getParameters().existingModuleNames.contains(EclipseProjectFinder.findProjectName((String)element));
    }

    public void setList(List<String> list) {
        this.getParameters().projectsToConvert = list;
    }

    public boolean isOpenProjectSettingsAfter() {
        return this.getParameters().openModuleSettings;
    }

    public void setOpenProjectSettingsAfter(boolean on) {
        this.getParameters().openModuleSettings = on;
    }

    public void cleanup() {
        super.cleanup();
        this.parameters = null;
    }

    public boolean validate(Project currentProject, Project dstProject) {
        Ref refEx = new Ref();
        THashSet variables = new THashSet();
        THashMap naturesNames = new THashMap();
        final List<String> projectsToConvert = this.getParameters().projectsToConvert;
        boolean oneProjectToConvert = projectsToConvert.size() == 1;
        String separator = oneProjectToConvert ? "<br>" : ", ";
        ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable((Set)variables, (Map)naturesNames, separator, refEx){
            final /* synthetic */ Set val$variables;
            final /* synthetic */ Map val$naturesNames;
            final /* synthetic */ String val$separator;
            final /* synthetic */ Ref val$refEx;
            {
                this.val$variables = set;
                this.val$naturesNames = map;
                this.val$separator = string;
                this.val$refEx = ref;
            }

            @Override
            public void run() {
                try {
                    for (String path : projectsToConvert) {
                        File classPathFile = new File(path, ".classpath");
                        if (classPathFile.exists()) {
                            EclipseClasspathReader.collectVariables(this.val$variables, JDOMUtil.load((File)classPathFile), path);
                        }
                        EclipseImportBuilder.collectUnknownNatures(path, this.val$naturesNames, this.val$separator);
                    }
                }
                catch (IOException e) {
                    this.val$refEx.set((Object)e);
                }
                catch (JDOMException e) {
                    this.val$refEx.set((Object)e);
                }
            }
        }, EclipseBundle.message("eclipse.import.converting", new Object[0]), false, currentProject);
        if (!refEx.isNull()) {
            Messages.showErrorDialog((Project)dstProject, (String)((Exception)refEx.get()).getMessage(), (String)this.getTitle());
            return false;
        }
        if (!ProjectMacrosUtil.checkNonIgnoredMacros((Project)dstProject, (Set)variables)) {
            return false;
        }
        Runnable runnable = new Runnable((Map)naturesNames, oneProjectToConvert){
            final /* synthetic */ Map val$naturesNames;
            final /* synthetic */ boolean val$oneProjectToConvert;
            {
                this.val$naturesNames = map;
                this.val$oneProjectToConvert = bl;
            }

            @Override
            public void run() {
                if (!this.val$naturesNames.isEmpty()) {
                    String title = "Unknown Natures Detected";
                    String naturesByProject = this.val$oneProjectToConvert ? (String)this.val$naturesNames.values().iterator().next() : StringUtil.join(this.val$naturesNames.keySet(), (Function)new Function<String, String>(){

                        public String fun(String projectPath) {
                            return projectPath + "(" + (String)val$naturesNames.get(projectPath) + ")";
                        }
                    }, (String)"<br>");
                    Notifications.Bus.notify((Notification)new Notification("Unknown Natures Detected", "Unknown Natures Detected", "Imported projects contain unknown natures:<br>" + naturesByProject + "<br>" + "Some settings may be lost after import.", NotificationType.WARNING));
                }
            }
        };
        ApplicationManager.getApplication().invokeLater(runnable, ModalityState.NON_MODAL);
        return true;
    }

    public List<Module> commit(Project project, ModifiableModuleModel model, ModulesProvider modulesProvider, ModifiableArtifactModel artifactModel) {
        TreeSet<String> unknownLibraries = new TreeSet<String>();
        TreeSet<String> unknownJdks = new TreeSet<String>();
        HashSet<String> refsToModules = new HashSet<String>();
        ArrayList<Module> result = new ArrayList<Module>();
        HashMap module2NatureNames = new HashMap();
        try {
            int resultCode;
            final ModifiableModuleModel moduleModel = model != null ? model : ModuleManager.getInstance((Project)project).getModifiableModel();
            final ModifiableRootModel[] rootModels = new ModifiableRootModel[this.getParameters().projectsToConvert.size()];
            HashSet<File> hashSet = new HashSet<File>();
            THashSet moduleNames = new THashSet(this.getParameters().projectsToConvert.size());
            for (String path : this.getParameters().projectsToConvert) {
                File emlFile;
                Object modulesDirectory = this.getParameters().converterOptions.commonModulesDirectory;
                if (modulesDirectory == null) {
                    modulesDirectory = path;
                }
                String moduleName = EclipseProjectFinder.findProjectName((String)path);
                moduleNames.add(moduleName);
                File imlFile = new File((String)modulesDirectory + File.separator + moduleName + ".iml");
                if (imlFile.isFile()) {
                    hashSet.add(imlFile);
                }
                if (!(emlFile = new File((String)modulesDirectory + File.separator + moduleName + ".eml")).isFile()) continue;
                hashSet.add(emlFile);
            }
            if (!hashSet.isEmpty() && (resultCode = Messages.showYesNoCancelDialog((String)(ApplicationInfoEx.getInstanceEx().getFullApplicationName() + " module files found:\n" + StringUtil.join(hashSet, (Function)new Function<File, String>(){

                public String fun(File file) {
                    return file.getPath();
                }
            }, (String)"\n") + ".\n Would you like to reuse them?"), (String)"Module Files Found", (Icon)Messages.getQuestionIcon())) != 0) {
                if (resultCode == 1) {
                    LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
                    for (File file : hashSet) {
                        final VirtualFile virtualFile = localFileSystem.findFileByIoFile(file);
                        if (virtualFile != null) {
                            ApplicationManager.getApplication().runWriteAction((ThrowableComputable)new ThrowableComputable<Void, IOException>(){

                                public Void compute() throws IOException {
                                    virtualFile.delete((Object)this);
                                    return null;
                                }
                            });
                            continue;
                        }
                        FileUtil.delete((File)file);
                    }
                } else {
                    return result;
                }
            }
            int idx = 0;
            for (String path : this.getParameters().projectsToConvert) {
                String modulesDirectory = this.getParameters().converterOptions.commonModulesDirectory;
                if (modulesDirectory == null) {
                    modulesDirectory = path;
                }
                Module module = moduleModel.newModule(modulesDirectory + "/" + EclipseProjectFinder.findProjectName((String)path) + ".iml", StdModuleTypes.JAVA.getId());
                result.add(module);
                Set<String> natures = EclipseImportBuilder.collectNatures(path);
                if (natures.size() > 0) {
                    module2NatureNames.put(module, natures);
                }
                final ModifiableRootModel rootModel = ModuleRootManager.getInstance((Module)module).getModifiableModel();
                rootModels[idx++] = rootModel;
                File classpathFile = new File(path, ".classpath");
                EclipseClasspathReader classpathReader = new EclipseClasspathReader(path, project, this.getParameters().projectsToConvert, (Set<String>)moduleNames);
                classpathReader.init(rootModel);
                if (classpathFile.exists()) {
                    Element classpathElement = JDOMUtil.load((File)classpathFile);
                    classpathReader.readClasspath(rootModel, unknownLibraries, unknownJdks, refsToModules, this.getParameters().converterOptions.testPattern, classpathElement);
                } else {
                    EclipseClasspathReader.setOutputUrl(rootModel, path + "/bin");
                }
                ClasspathStorage.setStorageType((ModuleRootModel)rootModel, (String)(this.getParameters().linkConverted ? "eclipse" : "default"));
                if (model == null) continue;
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        rootModel.commit();
                    }
                });
            }
            if (model == null) {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        ModifiableModelCommitter.multiCommit((ModifiableRootModel[])rootModels, (ModifiableModuleModel)moduleModel);
                    }
                });
            }
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
        EclipseImportBuilder.scheduleNaturesImporting(project, (Map<Module, Set<String>>)module2NatureNames);
        EclipseImportBuilder.createEclipseLibrary(project, unknownLibraries, "ECLIPSE");
        StringBuilder message = new StringBuilder();
        refsToModules.removeAll(this.getParameters().existingModuleNames);
        for (String string : this.getParameters().projectsToConvert) {
            String projectName = EclipseProjectFinder.findProjectName((String)string);
            if (projectName == null) continue;
            refsToModules.remove(projectName);
            this.getParameters().existingModuleNames.add(projectName);
        }
        if (!refsToModules.isEmpty()) {
            message.append("Unknown modules detected");
            for (String string : refsToModules) {
                message.append("\n").append(string);
            }
        }
        if (!unknownJdks.isEmpty()) {
            if (message.length() > 0) {
                message.append("\nand jdks");
            } else {
                message.append("Imported project refers to unknown jdks");
            }
            for (String string : unknownJdks) {
                message.append("\n").append(string);
            }
        }
        if (!unknownLibraries.isEmpty()) {
            StringBuilder buf = new StringBuilder();
            buf.append("<html><body>");
            buf.append(EclipseBundle.message("eclipse.import.warning.undefinded.libraries", new Object[0]));
            for (String name : unknownLibraries) {
                buf.append("<br>").append(name);
            }
            if (model == null) {
                buf.append("<br><b>Please export Eclipse user libraries and import them now from resulted .userlibraries file</b>");
                buf.append("</body></html>");
                FileChooserDescriptor fileChooserDescriptor = new FileChooserDescriptor(true, false, false, false, false, false){

                    public boolean isFileSelectable(VirtualFile file) {
                        return super.isFileSelectable(file) && Comparing.strEqual((String)file.getExtension(), (String)"userlibraries");
                    }
                };
                fileChooserDescriptor.setDescription(buf.toString());
                fileChooserDescriptor.setTitle(this.getTitle());
                VirtualFile selectedFile = FileChooser.chooseFile((FileChooserDescriptor)fileChooserDescriptor, (Project)project, (VirtualFile)project.getBaseDir());
                if (selectedFile != null) {
                    try {
                        EclipseUserLibrariesHelper.readProjectLibrariesContent(selectedFile, project, unknownLibraries);
                    }
                    catch (Exception e) {
                        LOG.error((Throwable)e);
                    }
                }
            }
        }
        if (message.length() > 0) {
            Messages.showErrorDialog((Project)project, (String)message.toString(), (String)this.getTitle());
        }
        return result;
    }

    private static void scheduleNaturesImporting(final @NotNull Project project, final @NotNull Map<Module, Set<String>> module2NatureNames) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/eclipse/importWizard/EclipseImportBuilder", "scheduleNaturesImporting"));
        }
        if (module2NatureNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module2NatureNames", "org/jetbrains/idea/eclipse/importWizard/EclipseImportBuilder", "scheduleNaturesImporting"));
        }
        if (module2NatureNames.size() == 0) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                StartupManager.getInstance((Project)project).runWhenProjectIsInitialized(new Runnable(){

                    @Override
                    public void run() {
                        for (EclipseNatureImporter importer : (EclipseNatureImporter[])EclipseNatureImporter.EP_NAME.getExtensions()) {
                            String importerNatureName = importer.getNatureName();
                            ArrayList<Module> modulesToImport = new ArrayList<Module>();
                            for (Map.Entry entry : module2NatureNames.entrySet()) {
                                Module module = (Module)entry.getKey();
                                Set natureNames = (Set)entry.getValue();
                                if (!natureNames.contains(importerNatureName)) continue;
                                modulesToImport.add(module);
                            }
                            if (modulesToImport.size() <= 0) continue;
                            importer.doImport(project, modulesToImport);
                        }
                    }
                });
            }
        });
    }

    private static void createEclipseLibrary(final Project project, Collection<String> libraries, final String libraryName) {
        if (libraries.contains(libraryName)) {
            VirtualFile pluginsDir;
            FileChooserDescriptor fileChooserDescriptor = new FileChooserDescriptor(false, true, false, false, false, false){

                public Icon getIcon(VirtualFile file) {
                    return this.looksLikeEclipse(file) ? 10.dressIcon((VirtualFile)file, (Icon)EclipseIcons.Eclipse) : super.getIcon(file);
                }

                private boolean looksLikeEclipse(VirtualFile file) {
                    return file.findChild(".eclipseproduct") != null;
                }
            };
            fileChooserDescriptor.setTitle(EclipseBundle.message("eclipse.create.library.title", new Object[0]));
            fileChooserDescriptor.setDescription(EclipseBundle.message("eclipse.create.library.description", libraryName));
            VirtualFile file = FileChooser.chooseFile((FileChooserDescriptor)fileChooserDescriptor, (Project)project, null);
            if (file != null && (pluginsDir = file.findChild("plugins")) != null) {
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        LibraryTable table = LibraryTablesRegistrar.getInstance().getLibraryTableByLevel("application", project);
                        assert (table != null);
                        LibraryTable.ModifiableModel tableModel = table.getModifiableModel();
                        Library library = tableModel.createLibrary(libraryName);
                        Library.ModifiableModel libraryModel = library.getModifiableModel();
                        libraryModel.addJarDirectory(pluginsDir, true);
                        libraryModel.commit();
                        tableModel.commit();
                    }
                });
                libraries.remove(libraryName);
            }
        }
    }

    @NotNull
    public Parameters getParameters() {
        if (this.parameters == null) {
            Project project;
            this.parameters = new Parameters();
            this.parameters.existingModuleNames = new THashSet();
            if (this.isUpdate() && (project = EclipseImportBuilder.getCurrentProject()) != null) {
                for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
                    this.parameters.existingModuleNames.add(module.getName());
                }
            }
        }
        Parameters parameters = this.parameters;
        if (parameters == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/eclipse/importWizard/EclipseImportBuilder", "getParameters"));
        }
        return parameters;
    }

    public static void collectUnknownNatures(String path, Map<String, String> naturesNames, String separator) {
        Set<String> natures = EclipseImportBuilder.collectNatures(path);
        natures.removeAll(EclipseNatureImporter.getDefaultNatures());
        for (EclipseNatureImporter importer : (EclipseNatureImporter[])EclipseNatureImporter.EP_NAME.getExtensions()) {
            natures.remove(importer.getNatureName());
        }
        if (!natures.isEmpty()) {
            naturesNames.put(path, StringUtil.join(natures, (String)separator));
        }
    }

    @NotNull
    public static Set<String> collectNatures(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/idea/eclipse/importWizard/EclipseImportBuilder", "collectNatures"));
        }
        THashSet naturesNames = new THashSet();
        try {
            Element natures = JDOMUtil.load((File)new File(path, ".project")).getChild("natures");
            if (natures != null) {
                for (Element nature : natures.getChildren("nature")) {
                    String natureName = nature.getText();
                    if (StringUtil.isEmptyOrSpaces((String)natureName)) continue;
                    naturesNames.add(natureName);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        THashSet tHashSet = naturesNames;
        if (tHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/eclipse/importWizard/EclipseImportBuilder", "collectNatures"));
        }
        return tHashSet;
    }

    public static class Parameters {
        public String root;
        public List<String> workspace;
        public boolean linkConverted;
        public List<String> projectsToConvert = new ArrayList<String>();
        public boolean openModuleSettings;
        public Options converterOptions = new Options();
        public Set<String> existingModuleNames;
    }
}

