/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit;

import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProvider;
import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.junit.JUnitConfigurationType;
import com.intellij.execution.junit.JUnitUtil;
import com.intellij.execution.lineMarker.RunLineMarkerInfo;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.util.Function;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JUnitRunLineMarkerProvider
implements LineMarkerProvider {
    private static final Function<PsiElement, String> TOOLTIP_PROVIDER = new Function<PsiElement, String>(){

        public String fun(PsiElement element) {
            return "Run Test";
        }
    };

    @Nullable
    public LineMarkerInfo getLineMarkerInfo(@NotNull PsiElement e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/execution/junit/JUnitRunLineMarkerProvider", "getLineMarkerInfo"));
        }
        if (e instanceof PsiIdentifier) {
            PsiElement element = e.getParent();
            if (element instanceof PsiClass && JUnitUtil.isTestClass((PsiClass)((PsiClass)element), (boolean)false, (boolean)true)) {
                return new RunLineMarkerInfo(e, JUnitConfigurationType.getInstance().getIcon(), TOOLTIP_PROVIDER);
            }
            if (element instanceof PsiMethod && JUnitUtil.isTestMethod((Location)new PsiLocation((PsiElement)((PsiMethod)element)))) {
                return new RunLineMarkerInfo(e, JUnitConfigurationType.getInstance().getIcon(), TOOLTIP_PROVIDER);
            }
        }
        return null;
    }

    public void collectSlowLineMarkers(@NotNull List<PsiElement> elements, @NotNull Collection<LineMarkerInfo> result) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/execution/junit/JUnitRunLineMarkerProvider", "collectSlowLineMarkers"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/execution/junit/JUnitRunLineMarkerProvider", "collectSlowLineMarkers"));
        }
    }
}

