/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.CodeInsightUtilBase;
import com.intellij.codeInsight.generation.ClassMember;
import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.codeInsight.generation.GenerationInfo;
import com.intellij.codeInsight.generation.OverrideImplementUtil;
import com.intellij.codeInsight.generation.PsiElementClassMember;
import com.intellij.codeInsight.generation.TemplateGenerationInfo;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInspection.ex.GlobalInspectionContextBase;
import com.intellij.ide.util.MemberChooser;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.actions.EnterAction;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.generate.exception.GenerateCodeException;

public abstract class GenerateMembersHandlerBase
implements CodeInsightActionHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.generation.GenerateMembersHandlerBase");
    private final String myChooserTitle;
    protected boolean myToCopyJavaDoc = false;

    public GenerateMembersHandlerBase(String chooserTitle) {
        this.myChooserTitle = chooserTitle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void invoke(final @NotNull Project project, final @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/generation/GenerateMembersHandlerBase", "invoke"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/generation/GenerateMembersHandlerBase", "invoke"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/generation/GenerateMembersHandlerBase", "invoke"));
        }
        if (!CodeInsightUtilBase.prepareEditorForWrite(editor)) {
            return;
        }
        if (!FileDocumentManager.getInstance().requestWriting(editor.getDocument(), project)) {
            return;
        }
        final PsiClass aClass = OverrideImplementUtil.getContextClass(project, editor, file, false);
        if (aClass == null || aClass.isInterface()) {
            return;
        }
        LOG.assertTrue(aClass.isValid());
        LOG.assertTrue(aClass.getContainingFile() != null);
        try {
            final ClassMember[] members = this.chooseOriginalMembers(aClass, project, editor);
            if (members == null) {
                return;
            }
            WriteCommandAction.runWriteCommandAction((Project)project, (Runnable)new Runnable(){

                @Override
                public void run() {
                    final int offset = editor.getCaretModel().getOffset();
                    try {
                        GenerateMembersHandlerBase.this.doGenerate(project, editor, aClass, members);
                    }
                    catch (GenerateCodeException e) {
                        final String message = e.getMessage();
                        ApplicationManager.getApplication().invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (!editor.isDisposed()) {
                                    editor.getCaretModel().moveToOffset(offset);
                                    HintManager.getInstance().showErrorHint(editor, message);
                                }
                            }
                        }, project.getDisposed());
                    }
                }
            });
        }
        finally {
            this.cleanup();
        }
    }

    protected void cleanup() {
    }

    private void doGenerate(Project project, Editor editor, PsiClass aClass, ClassMember[] members) {
        List<? extends GenerationInfo> newMembers;
        int offset = editor.getCaretModel().getOffset();
        int col = editor.getCaretModel().getLogicalPosition().column;
        int line = editor.getCaretModel().getLogicalPosition().line;
        Document document = editor.getDocument();
        int lineStartOffset = document.getLineStartOffset(line);
        CharSequence docText = document.getCharsSequence();
        String textBeforeCaret = docText.subSequence(lineStartOffset, offset).toString();
        String afterCaret = docText.subSequence(offset, document.getLineEndOffset(line)).toString();
        if (textBeforeCaret.trim().length() > 0 && StringUtil.isEmptyOrSpaces((String)afterCaret) && !editor.getSelectionModel().hasSelection()) {
            EnterAction.insertNewLineAtCaret(editor);
            PsiDocumentManager.getInstance((Project)project).commitDocument(document);
            offset = editor.getCaretModel().getOffset();
            col = editor.getCaretModel().getLogicalPosition().column;
            line = editor.getCaretModel().getLogicalPosition().line;
        }
        editor.getCaretModel().moveToLogicalPosition(new LogicalPosition(0, 0));
        try {
            List<? extends GenerationInfo> prototypes = this.generateMemberPrototypes(aClass, members);
            newMembers = GenerateMembersUtil.insertMembersAtOffset(aClass.getContainingFile(), offset, prototypes);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return;
        }
        editor.getCaretModel().moveToLogicalPosition(new LogicalPosition(line, col));
        if (newMembers.isEmpty()) {
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                HintManager.getInstance().showErrorHint(editor, this.getNothingFoundMessage());
            }
            return;
        }
        ArrayList<PsiMember> elements = new ArrayList<PsiMember>();
        for (GenerationInfo generationInfo : newMembers) {
            PsiMember psiMember;
            if (generationInfo instanceof TemplateGenerationInfo || (psiMember = generationInfo.getPsiMember()) == null) continue;
            elements.add(psiMember);
        }
        GlobalInspectionContextBase.cleanupElements(project, null, elements.toArray(new PsiElement[elements.size()]));
        ArrayList<TemplateGenerationInfo> templates = new ArrayList<TemplateGenerationInfo>();
        for (GenerationInfo generationInfo : newMembers) {
            if (!(generationInfo instanceof TemplateGenerationInfo)) continue;
            templates.add((TemplateGenerationInfo)generationInfo);
        }
        if (!templates.isEmpty()) {
            PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(document);
            GenerateMembersHandlerBase.runTemplates(project, editor, templates, 0);
        } else if (!newMembers.isEmpty()) {
            newMembers.get(0).positionCaret(editor, false);
        }
    }

    protected String getNothingFoundMessage() {
        return "Nothing found to insert";
    }

    private static void runTemplates(final Project myProject, final Editor editor, final List<TemplateGenerationInfo> templates, final int index) {
        TemplateGenerationInfo info = templates.get(index);
        Template template = info.getTemplate();
        PsiMethod element = info.getPsiMember();
        TextRange range = element.getTextRange();
        editor.getDocument().deleteString(range.getStartOffset(), range.getEndOffset());
        int offset = range.getStartOffset();
        editor.getCaretModel().moveToOffset(offset);
        editor.getScrollingModel().scrollToCaret(ScrollType.CENTER);
        TemplateManager.getInstance(myProject).startTemplate(editor, template, new TemplateEditingAdapter(){

            @Override
            public void templateFinished(Template template, boolean brokenOff) {
                if (index + 1 < templates.size()) {
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            new WriteCommandAction(myProject, new PsiFile[0]){

                                protected void run(Result result) throws Throwable {
                                    GenerateMembersHandlerBase.runTemplates(myProject, editor, templates, index + 1);
                                }
                            }.execute();
                        }
                    });
                }
            }
        });
    }

    @Nullable
    protected ClassMember[] chooseOriginalMembers(PsiClass aClass, Project project) {
        ClassMember[] allMembers = this.getAllOriginalMembers(aClass);
        return this.chooseMembers(allMembers, false, false, project, null);
    }

    @Nullable
    protected ClassMember[] chooseOriginalMembers(PsiClass aClass, Project project, Editor editor) {
        return this.chooseOriginalMembers(aClass, project);
    }

    @Nullable
    protected ClassMember[] chooseMembers(ClassMember[] members, boolean allowEmptySelection, boolean copyJavadocCheckbox, Project project, @Nullable Editor editor) {
        MemberChooser<ClassMember> chooser = this.createMembersChooser(members, allowEmptySelection, copyJavadocCheckbox, project);
        if (editor != null) {
            int offset = editor.getCaretModel().getOffset();
            ClassMember preselection = null;
            for (ClassMember member : members) {
                TextRange textRange;
                Object owner;
                if (!(member instanceof PsiElementClassMember) || (owner = ((PsiElementClassMember)member).getElement()) == null || (textRange = owner.getTextRange()) == null || !textRange.contains(offset)) continue;
                preselection = member;
                break;
            }
            if (preselection != null) {
                chooser.selectElements(new ClassMember[]{preselection});
            }
        }
        chooser.show();
        this.myToCopyJavaDoc = chooser.isCopyJavadoc();
        List<ClassMember> list = chooser.getSelectedElements();
        return list == null ? null : list.toArray(new ClassMember[list.size()]);
    }

    protected MemberChooser<ClassMember> createMembersChooser(ClassMember[] members, boolean allowEmptySelection, boolean copyJavadocCheckbox, Project project) {
        MemberChooser<ClassMember> chooser = new MemberChooser<ClassMember>(members, allowEmptySelection, true, project, false, this.getHeaderPanel(project)){

            @Nullable
            protected String getHelpId() {
                return GenerateMembersHandlerBase.this.getHelpId();
            }
        };
        chooser.setTitle(this.myChooserTitle);
        chooser.setCopyJavadocVisible(copyJavadocCheckbox);
        return chooser;
    }

    @Nullable
    protected JComponent getHeaderPanel(Project project) {
        return null;
    }

    protected String getHelpId() {
        return null;
    }

    @NotNull
    protected List<? extends GenerationInfo> generateMemberPrototypes(PsiClass aClass, ClassMember[] members) throws IncorrectOperationException {
        ArrayList array = new ArrayList();
        for (ClassMember member : members) {
            Object[] prototypes = this.generateMemberPrototypes(aClass, member);
            if (prototypes == null) continue;
            ContainerUtil.addAll(array, (Object[])prototypes);
        }
        ArrayList arrayList = array;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/generation/GenerateMembersHandlerBase", "generateMemberPrototypes"));
        }
        return arrayList;
    }

    protected abstract ClassMember[] getAllOriginalMembers(PsiClass var1);

    protected abstract GenerationInfo[] generateMemberPrototypes(PsiClass var1, ClassMember var2) throws IncorrectOperationException;

    public boolean startInWriteAction() {
        return false;
    }
}

