/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation.surroundWith;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiParserFacade;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaJspElementType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SurroundWithUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.generation.surroundWith.SurroundWithUtil");

    private SurroundWithUtil() {
    }

    static PsiElement[] moveDeclarationsOut(PsiElement block, PsiElement[] statements, boolean generateInitializers) {
        try {
            PsiManager psiManager = block.getManager();
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)psiManager.getProject()).getElementFactory();
            ArrayList<Object> array = new ArrayList<Object>();
            for (PsiElement statement : statements) {
                PsiDeclarationStatement declaration;
                if (statement instanceof PsiDeclarationStatement && SurroundWithUtil.needToDeclareOut(statements, declaration = (PsiDeclarationStatement)statement)) {
                    PsiDeclarationStatement newDeclaration;
                    PsiAssignmentExpression expr;
                    PsiElement[] elements;
                    for (PsiElement element : elements = declaration.getDeclaredElements()) {
                        PsiVariable var = (PsiVariable)element;
                        PsiExpression initializer = var.getInitializer();
                        if (initializer == null) continue;
                        String name = var.getName();
                        PsiExpressionStatement assignment = (PsiExpressionStatement)factory.createStatementFromText(name + "=x;", null);
                        assignment = (PsiExpressionStatement)CodeStyleManager.getInstance((Project)psiManager.getProject()).reformat((PsiElement)assignment);
                        expr = (PsiAssignmentExpression)assignment.getExpression();
                        expr.getRExpression().replace((PsiElement)RefactoringUtil.convertInitializerToNormalExpression(initializer, var.getType()));
                        assignment = (PsiExpressionStatement)block.addAfter((PsiElement)assignment, (PsiElement)declaration);
                        array.add(assignment);
                    }
                    if (!array.isEmpty()) {
                        PsiElement firstStatement = (PsiElement)array.get(0);
                        newDeclaration = (PsiDeclarationStatement)block.addBefore((PsiElement)declaration, firstStatement);
                        declaration.delete();
                    } else {
                        newDeclaration = declaration;
                    }
                    for (PsiElement element1 : elements = newDeclaration.getDeclaredElements()) {
                        PsiVariable var = (PsiVariable)element1;
                        PsiExpression initializer = var.getInitializer();
                        if (initializer == null) continue;
                        if (!generateInitializers || var.hasModifierProperty("final")) {
                            initializer.delete();
                            continue;
                        }
                        String defaultValue = PsiTypesUtil.getDefaultValueOfType((PsiType)var.getType());
                        expr = factory.createExpressionFromText(defaultValue, null);
                        initializer.replace((PsiElement)expr);
                    }
                    continue;
                }
                array.add(statement);
            }
            return PsiUtilCore.toPsiElementArray(array);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return statements;
        }
    }

    private static boolean needToDeclareOut(PsiElement[] statements, PsiDeclarationStatement statement) {
        PsiElement[] elements = statement.getDeclaredElements();
        PsiElement lastStatement = statements[statements.length - 1];
        int endOffset = lastStatement.getTextRange().getEndOffset();
        for (PsiElement element : elements) {
            PsiReference lastRef;
            GlobalSearchScope projectScope;
            PsiReference[] refs;
            if (!(element instanceof PsiVariable) || (refs = (PsiReference[])ReferencesSearch.search((PsiElement)element, (SearchScope)(projectScope = GlobalSearchScope.projectScope((Project)element.getProject())), (boolean)false).toArray((Object[])PsiReference.EMPTY_ARRAY)).length <= 0 || (lastRef = refs[refs.length - 1]).getElement().getTextOffset() <= endOffset) continue;
            return true;
        }
        return false;
    }

    public static TextRange getRangeToSelect(@NotNull PsiCodeBlock block) {
        int endOffset;
        int startOffset;
        if (block == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "com/intellij/codeInsight/generation/surroundWith/SurroundWithUtil", "getRangeToSelect"));
        }
        PsiElement first = block.getFirstBodyElement();
        if (first instanceof PsiWhiteSpace) {
            first = first.getNextSibling();
        }
        if (first == null) {
            int offset = block.getTextRange().getStartOffset() + 1;
            return new TextRange(offset, offset);
        }
        PsiJavaToken rBrace = block.getRBrace();
        PsiElement last = rBrace.getPrevSibling();
        if (last instanceof PsiWhiteSpace) {
            last = last.getPrevSibling();
        }
        return (startOffset = first.getTextRange().getStartOffset()) <= (endOffset = last.getTextRange().getEndOffset()) ? new TextRange(startOffset, endOffset) : new TextRange(startOffset, startOffset);
    }

    public static void indentCommentIfNecessary(@NotNull PsiCodeBlock container, @Nullable PsiElement[] statements) {
        if (container == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "com/intellij/codeInsight/generation/surroundWith/SurroundWithUtil", "indentCommentIfNecessary"));
        }
        if (statements == null || statements.length <= 0) {
            return;
        }
        PsiElement first = statements[0];
        ASTNode node = first.getNode();
        if (node == null || !ElementType.JAVA_COMMENT_BIT_SET.contains(node.getElementType())) {
            return;
        }
        ASTNode commentWsText = node.getTreePrev();
        if (commentWsText == null || !JavaJspElementType.WHITE_SPACE_BIT_SET.contains(commentWsText.getElementType())) {
            return;
        }
        int indent = 0;
        CharSequence text = commentWsText.getChars();
        int i = text.length() - 1;
        while (i >= 0 && text.charAt(i) != '\n') {
            --i;
            ++indent;
        }
        if (indent <= 0) {
            return;
        }
        PsiElement codeBlockWsElement = null;
        ASTNode codeBlockWsNode = null;
        boolean lbraceFound = false;
        PsiParserFacade parserFacade = PsiParserFacade.SERVICE.getInstance((Project)container.getProject());
        for (PsiElement codeBlockChild = container.getFirstChild(); codeBlockChild != null; codeBlockChild = codeBlockChild.getNextSibling()) {
            ASTNode childNode = codeBlockChild.getNode();
            if (childNode == null) continue;
            if (!lbraceFound) {
                if (JavaTokenType.LBRACE != childNode.getElementType()) continue;
                lbraceFound = true;
                continue;
            }
            if (JavaJspElementType.WHITE_SPACE_BIT_SET.contains(childNode.getElementType())) {
                codeBlockWsElement = codeBlockChild;
                codeBlockWsNode = childNode;
                break;
            }
            if (JavaTokenType.RBRACE == childNode.getElementType()) break;
        }
        if (codeBlockWsElement != null) {
            CharSequence existingWhiteSpaceText = codeBlockWsNode.getChars();
            int existingWhiteSpaceEndOffset = existingWhiteSpaceText.length();
            for (int i2 = existingWhiteSpaceEndOffset - 1; i2 >= 0; --i2) {
                if (existingWhiteSpaceText.charAt(i2) != '\n') continue;
                existingWhiteSpaceEndOffset = i2;
                break;
            }
            String newWsText = text.subSequence(text.length() - indent, text.length()).toString();
            if (existingWhiteSpaceEndOffset < existingWhiteSpaceText.length()) {
                newWsText = existingWhiteSpaceText.subSequence(0, existingWhiteSpaceEndOffset + 1).toString() + newWsText;
            }
            PsiElement indentElement = parserFacade.createWhiteSpaceFromText(newWsText);
            codeBlockWsElement.replace(indentElement);
        } else {
            PsiElement indentElement = parserFacade.createWhiteSpaceFromText(text.subSequence(text.length() - indent, text.length()).toString());
            container.add(indentElement);
        }
    }
}

