/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInsight.ConditionChecker;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.ide.util.ClassFilter;
import com.intellij.ide.util.TreeClassChooser;
import com.intellij.ide.util.TreeClassChooserFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.EditorTextFieldWithBrowseButton;
import com.intellij.ui.SortedComboBoxModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MethodCheckerDetailsDialog
extends DialogWrapper
implements PropertyChangeListener,
ItemListener {
    @NotNull
    private final ConditionChecker.Type myType;
    @NotNull
    private final Project myProject;
    @NotNull
    private final ParameterDropDown parameterDropDown;
    @NotNull
    private final MethodDropDown methodDropDown;
    @NotNull
    private final ClassField classField;
    @NotNull
    private final Set<ConditionChecker> myOtherCheckers;
    @Nullable
    private final ConditionChecker myPreviouslySelectedChecker;
    @Nullable
    private ConditionChecker mySelectedChecker;

    MethodCheckerDetailsDialog(@Nullable ConditionChecker previouslySelectedChecker, @NotNull ConditionChecker.Type type, @NotNull Project project, @NotNull Component component, @NotNull Set<ConditionChecker> otherCheckersSameType, @NotNull Set<ConditionChecker> otherCheckers) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/codeInspection/dataFlow/MethodCheckerDetailsDialog", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/dataFlow/MethodCheckerDetailsDialog", "<init>"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/codeInspection/dataFlow/MethodCheckerDetailsDialog", "<init>"));
        }
        if (otherCheckersSameType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "otherCheckersSameType", "com/intellij/codeInspection/dataFlow/MethodCheckerDetailsDialog", "<init>"));
        }
        if (otherCheckers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "otherCheckers", "com/intellij/codeInspection/dataFlow/MethodCheckerDetailsDialog", "<init>"));
        }
        super(component, true);
        if (!MethodCheckerDetailsDialog.isSupported(type)) {
            throw new IllegalArgumentException("Type is invalid " + (Object)((Object)type));
        }
        this.myProject = project;
        this.myType = type;
        this.myOtherCheckers = new HashSet<ConditionChecker>(otherCheckersSameType);
        this.myOtherCheckers.addAll(otherCheckers);
        this.myPreviouslySelectedChecker = previouslySelectedChecker;
        if (this.myPreviouslySelectedChecker != null) {
            this.myOtherCheckers.remove(this.myPreviouslySelectedChecker);
        }
        PsiClass psiClass = null;
        PsiMethod psiMethod = null;
        PsiParameter psiParameter = null;
        if (previouslySelectedChecker != null) {
            PsiParameter[] parameters;
            psiClass = JavaPsiFacade.getInstance((Project)this.myProject).findClass(previouslySelectedChecker.getClassName(), GlobalSearchScope.allScope((Project)this.myProject));
            if (psiClass != null) {
                for (PsiMethod method : psiClass.findMethodsByName(previouslySelectedChecker.getMethodName(), true)) {
                    if (!previouslySelectedChecker.equals(MethodCheckerDetailsDialog.buildParameterClassListFromPsiMethod(method))) continue;
                    psiMethod = method;
                    break;
                }
            }
            if (psiMethod != null && (parameters = psiMethod.getParameterList().getParameters()).length - 1 >= previouslySelectedChecker.getCheckedParameterIndex()) {
                psiParameter = parameters[previouslySelectedChecker.getCheckedParameterIndex()];
            }
        }
        if (psiClass == null || psiMethod == null || psiParameter == null) {
            psiClass = null;
            psiMethod = null;
            psiParameter = null;
        }
        this.classField = new ClassField(this.myProject, psiClass);
        this.methodDropDown = new MethodDropDown(psiClass, psiMethod, this.myType, MethodDropDown.buildModel());
        this.parameterDropDown = new ParameterDropDown(psiMethod, psiParameter, ParameterDropDown.buildModel(), this.myType);
        this.classField.addPropertyChangeListener(this.methodDropDown);
        this.classField.addPropertyChangeListener(this.parameterDropDown);
        this.classField.addPropertyChangeListener(this);
        this.methodDropDown.addItemListener(this.parameterDropDown);
        this.methodDropDown.addItemListener(this);
        this.parameterDropDown.addItemListener(this);
        this.init();
        this.checkOkActionEnable();
        this.setTitle(MethodCheckerDetailsDialog.initTitle(type));
    }

    private static boolean isSupported(ConditionChecker.Type type) {
        return type == ConditionChecker.Type.IS_NULL_METHOD || type == ConditionChecker.Type.IS_NOT_NULL_METHOD || type == ConditionChecker.Type.ASSERT_IS_NULL_METHOD || type == ConditionChecker.Type.ASSERT_IS_NOT_NULL_METHOD || type == ConditionChecker.Type.ASSERT_TRUE_METHOD || type == ConditionChecker.Type.ASSERT_FALSE_METHOD;
    }

    private static List<String> buildParameterClassListFromPsiMethod(PsiMethod psiMethod) {
        PsiParameter[] parameters;
        ArrayList<String> parameterClasses = new ArrayList<String>();
        for (PsiParameter param : parameters = psiMethod.getParameterList().getParameters()) {
            PsiTypeElement typeElement = param.getTypeElement();
            if (typeElement == null) {
                return new ArrayList<String>();
            }
            PsiType psiType = typeElement.getType();
            parameterClasses.add(psiType.getCanonicalText());
        }
        return parameterClasses;
    }

    private static String initTitle(@NotNull ConditionChecker.Type type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/codeInspection/dataFlow/MethodCheckerDetailsDialog", "initTitle"));
        }
        if (type.equals((Object)ConditionChecker.Type.IS_NULL_METHOD)) {
            return InspectionsBundle.message((String)"configure.checker.option.isNull.add.method.checker.dialog.title", (Object[])new Object[0]);
        }
        if (type.equals((Object)ConditionChecker.Type.IS_NOT_NULL_METHOD)) {
            return InspectionsBundle.message((String)"configure.checker.option.isNotNull.add.method.checker.dialog.title", (Object[])new Object[0]);
        }
        if (type.equals((Object)ConditionChecker.Type.ASSERT_IS_NULL_METHOD)) {
            return InspectionsBundle.message((String)"configure.checker.option.assert.isNull.add.method.checker.dialog.title", (Object[])new Object[0]);
        }
        if (type.equals((Object)ConditionChecker.Type.ASSERT_IS_NOT_NULL_METHOD)) {
            return InspectionsBundle.message((String)"configure.checker.option.assert.isNotNull.add.method.checker.dialog.title", (Object[])new Object[0]);
        }
        if (type.equals((Object)ConditionChecker.Type.ASSERT_TRUE_METHOD)) {
            return InspectionsBundle.message((String)"configure.checker.option.assert.true.add.method.checker.dialog.title", (Object[])new Object[0]);
        }
        if (type.equals((Object)ConditionChecker.Type.ASSERT_FALSE_METHOD)) {
            return InspectionsBundle.message((String)"configure.checker.option.assert.false.add.method.checker.dialog.title", (Object[])new Object[0]);
        }
        throw new IllegalArgumentException("MethodCheckerDetailsDialog does not support type " + (Object)((Object)type));
    }

    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        LabeledComponent classComponent = new LabeledComponent();
        LabeledComponent methodComponent = new LabeledComponent();
        LabeledComponent parameterComponent = new LabeledComponent();
        classComponent.setText("Class");
        methodComponent.setText("Method");
        parameterComponent.setText("Parameter");
        classComponent.setComponent((JComponent)((Object)this.classField));
        methodComponent.setComponent((JComponent)this.methodDropDown);
        parameterComponent.setComponent((JComponent)this.parameterDropDown);
        panel.add((Component)classComponent);
        panel.add((Component)methodComponent);
        panel.add((Component)parameterComponent);
        return panel;
    }

    @Nullable
    ConditionChecker getConditionChecker() {
        return this.mySelectedChecker;
    }

    @Nullable
    private ConditionChecker buildConditionChecker() {
        PsiClass psiClass = this.classField.getPsiClass();
        PsiMethod psiMethod = this.methodDropDown.getSelectedPsiMethod();
        PsiParameter psiParameter = this.parameterDropDown.getSelectedPsiParameter();
        if (psiClass != null && psiMethod != null && psiParameter != null) {
            return new ConditionChecker.FromPsiBuilder(psiMethod, psiParameter, this.myType).build();
        }
        return null;
    }

    private boolean overlaps(ConditionChecker thisChecker) {
        for (ConditionChecker overlappingChecker : this.myOtherCheckers) {
            if (!thisChecker.overlaps(overlappingChecker)) continue;
            Messages.showMessageDialog((Project)this.myProject, (String)(InspectionsBundle.message((String)"configure.checker.option.overlap.error.msg", (Object[])new Object[0]) + " " + (Object)((Object)overlappingChecker.getConditionCheckType()) + " " + overlappingChecker.toString()), (String)InspectionsBundle.message((String)"configure.checker.option.overlap.error.title", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
            return true;
        }
        return false;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.checkOkActionEnable();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.checkOkActionEnable();
    }

    private void checkOkActionEnable() {
        if (this.classField.getPsiClass() == null || this.methodDropDown.getSelectedPsiMethod() == null || this.parameterDropDown.getSelectedPsiParameter() == null) {
            this.setOKActionEnabled(false);
        } else {
            this.setOKActionEnabled(true);
        }
    }

    protected void doOKAction() {
        ConditionChecker checker = this.buildConditionChecker();
        if (checker != null && !this.overlaps(checker)) {
            this.mySelectedChecker = checker.equals(this.myPreviouslySelectedChecker) ? this.myPreviouslySelectedChecker : checker;
            super.doOKAction();
        }
    }

    public boolean isOKActionEnabled() {
        if (!this.myOKAction.isEnabled()) {
            return false;
        }
        PsiClass psiClass = this.classField.getPsiClass();
        PsiMethod psiMethod = this.methodDropDown.getSelectedPsiMethod();
        PsiParameter psiParameter = this.parameterDropDown.getSelectedPsiParameter();
        return psiClass != null && psiMethod != null && psiParameter != null;
    }

    static class MethodWrapper
    implements Comparable<MethodWrapper> {
        @NotNull
        private final PsiMethod myPsiMethod;
        @NotNull
        private final String myId;

        MethodWrapper(@NotNull PsiMethod psiMethod) {
            PsiParameter[] parameters;
            if (psiMethod == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "com/intellij/codeInspection/dataFlow/MethodCheckerDetailsDialog$MethodWrapper", "<init>"));
            }
            this.myPsiMethod = psiMethod;
            ArrayList<String> parameterClassNames = new ArrayList<String>();
            for (PsiParameter psiParameter : parameters = psiMethod.getParameterList().getParameters()) {
                parameterClassNames.add(MethodWrapper.getParameterQualifiedName(psiParameter));
            }
            this.myId = MethodWrapper.initId(psiMethod.getName(), parameterClassNames);
        }

        private static String getParameterQualifiedName(PsiParameter psiParameter) {
            PsiTypeElement typeElement = psiParameter.getTypeElement();
            if (typeElement == null) {
                return "";
            }
            if (typeElement.getType() instanceof PsiPrimitiveType) {
                return ((PsiPrimitiveType)typeElement.getType()).getBoxedTypeName();
            }
            return typeElement.getType().getCanonicalText();
        }

        private static String initId(String methodName, List<String> parameterNames) {
            String shortName = methodName + "(";
            for (String parameterName : parameterNames) {
                if (parameterNames.lastIndexOf(".") > -1) {
                    shortName = shortName + parameterName.substring(parameterName.lastIndexOf(".") + 1) + ", ";
                    continue;
                }
                shortName = shortName + parameterName + ", ";
            }
            if (parameterNames.size() > 0) {
                shortName = shortName.substring(0, shortName.lastIndexOf(", "));
            }
            shortName = shortName + ")";
            return shortName;
        }

        @NotNull
        public PsiMethod getPsiMethod() {
            PsiMethod psiMethod = this.myPsiMethod;
            if (psiMethod == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/MethodCheckerDetailsDialog$MethodWrapper", "getPsiMethod"));
            }
            return psiMethod;
        }

        @NotNull
        public String getId() {
            String string = this.myId;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/MethodCheckerDetailsDialog$MethodWrapper", "getId"));
            }
            return string;
        }

        public String toString() {
            return this.myId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MethodWrapper that = (MethodWrapper)o;
            return this.myId.equals(that.myId);
        }

        public int hashCode() {
            return this.myId.hashCode();
        }

        @Override
        public int compareTo(MethodWrapper o) {
            return this.myId.compareTo(o.myId);
        }
    }

    static class ParameterDropDown
    extends JComboBox
    implements PropertyChangeListener,
    ItemListener {
        @NotNull
        private final SortedComboBoxModel<ParameterWrapper> myModel;
        @NotNull
        private final ConditionChecker.Type myType;
        @Nullable
        private PsiMethod myPsiMethod;

        public ParameterDropDown(@Nullable PsiMethod psiMethod, @Nullable PsiParameter psiParameter, @NotNull SortedComboBoxModel<ParameterWrapper> model, @NotNull ConditionChecker.Type type) {
            if (model == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/codeInspection/dataFlow/MethodCheckerDetailsDialog$ParameterDropDown", "<init>"));
            }
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/codeInspection/dataFlow/MethodCheckerDetailsDialog$ParameterDropDown", "<init>"));
            }
            super(model);
            if (!MethodCheckerDetailsDialog.isSupported(type)) {
                throw new IllegalArgumentException("Type is invalid " + (Object)((Object)type));
            }
            this.myPsiMethod = psiMethod;
            this.myModel = model;
            this.myType = type;
            if (this.myPsiMethod != null) {
                this.setEnabled(true);
                this.myModel.addAll(this.getParameterWrappers());
                if (psiParameter != null) {
                    for (ParameterWrapper wrapper : this.myModel) {
                        if (!wrapper.getPsiParameter().equals(psiParameter)) continue;
                        this.setSelectedItem(wrapper);
                    }
                }
            } else {
                this.setEnabled(false);
            }
        }

        public static SortedComboBoxModel<ParameterWrapper> buildModel() {
            return new SortedComboBoxModel((Comparator)new Comparator<ParameterWrapper>(){

                @Override
                public int compare(ParameterWrapper o1, ParameterWrapper o2) {
                    return o1.compareTo(o2);
                }
            });
        }

        List<ParameterWrapper> getParameterWrappers() {
            ArrayList<ParameterWrapper> wrappers = new ArrayList<ParameterWrapper>();
            if (this.myPsiMethod != null) {
                PsiParameterList parameterList = this.myPsiMethod.getParameterList();
                for (int i = 0; i < parameterList.getParameters().length; ++i) {
                    PsiParameter psiParameter = parameterList.getParameters()[i];
                    if (this.myType == ConditionChecker.Type.ASSERT_TRUE_METHOD || this.myType == ConditionChecker.Type.ASSERT_FALSE_METHOD) {
                        PsiType type = psiParameter.getType();
                        if (!type.equals(PsiType.BOOLEAN) && !type.getCanonicalText().equals(Boolean.class.toString())) continue;
                        wrappers.add(new ParameterWrapper(psiParameter, i));
                        continue;
                    }
                    wrappers.add(new ParameterWrapper(psiParameter, i));
                }
            }
            return wrappers;
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getSource() instanceof MethodDropDown) {
                MethodDropDown methodDropDown = (MethodDropDown)e.getSource();
                if (methodDropDown.getSelectedPsiMethod() != null) {
                    this.setEnabled(true);
                    if (this.myPsiMethod == null || !this.myPsiMethod.equals(methodDropDown.getSelectedPsiMethod())) {
                        this.myPsiMethod = methodDropDown.getSelectedPsiMethod();
                        this.myModel.clear();
                        this.myModel.addAll(this.getParameterWrappers());
                        this.myModel.setSelectedItem(null);
                    }
                } else {
                    this.myPsiMethod = null;
                    this.myModel.clear();
                    this.myModel.setSelectedItem(null);
                    this.setEnabled(false);
                }
            } else {
                throw new RuntimeException("Unexpected Configuration ParameterDropDown is only expected to receive events from MethodDropDown.");
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("ClassField.myPsiClass") && evt.getNewValue() == null) {
                this.setEnabled(false);
            }
        }

        @Nullable
        public PsiParameter getSelectedPsiParameter() {
            ParameterWrapper parameterWrapper = (ParameterWrapper)this.myModel.getSelectedItem();
            if (parameterWrapper == null) {
                return null;
            }
            return parameterWrapper.getPsiParameter();
        }

        class ParameterWrapper
        implements Comparable<ParameterWrapper> {
            @NotNull
            private final String id;
            @NotNull
            private final PsiParameter psiParameter;
            private final int index;

            ParameterWrapper(PsiParameter psiParameter, int index) {
                if (psiParameter == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiParameter", "com/intellij/codeInspection/dataFlow/MethodCheckerDetailsDialog$ParameterDropDown$ParameterWrapper", "<init>"));
                }
                this.psiParameter = psiParameter;
                this.index = index;
                PsiTypeElement typeElement = psiParameter.getTypeElement();
                String typeName = typeElement == null ? "" : (typeElement.getType() instanceof PsiPrimitiveType ? ((PsiPrimitiveType)typeElement.getType()).getBoxedTypeName() : typeElement.getType().getCanonicalText());
                this.id = typeName + " " + psiParameter.getName();
            }

            @Override
            public int compareTo(ParameterWrapper o) {
                return this.index - o.index;
            }

            public String toString() {
                return this.id;
            }

            @NotNull
            public PsiParameter getPsiParameter() {
                PsiParameter psiParameter = this.psiParameter;
                if (psiParameter == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/MethodCheckerDetailsDialog$ParameterDropDown$ParameterWrapper", "getPsiParameter"));
                }
                return psiParameter;
            }
        }
    }

    static class MethodDropDown
    extends JComboBox
    implements PropertyChangeListener {
        @NotNull
        private final ConditionChecker.Type myType;
        @NotNull
        private final SortedComboBoxModel<MethodWrapper> myModel;
        @Nullable
        private PsiClass myPsiClass;

        MethodDropDown(@Nullable PsiClass psiClass, @Nullable PsiMethod psiMethod, @NotNull ConditionChecker.Type type, @NotNull SortedComboBoxModel<MethodWrapper> model) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/codeInspection/dataFlow/MethodCheckerDetailsDialog$MethodDropDown", "<init>"));
            }
            if (model == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/codeInspection/dataFlow/MethodCheckerDetailsDialog$MethodDropDown", "<init>"));
            }
            super(model);
            if (!MethodCheckerDetailsDialog.isSupported(type)) {
                throw new IllegalArgumentException("Type is invalid " + (Object)((Object)type));
            }
            this.myPsiClass = psiClass;
            this.myType = type;
            this.myModel = model;
            this.setEnabled(this.myPsiClass != null);
            this.initValues();
            if (psiMethod != null) {
                for (MethodWrapper methodWrapper : this.myModel) {
                    if (!methodWrapper.getPsiMethod().equals(psiMethod)) continue;
                    this.setSelectedItem(methodWrapper);
                }
            }
        }

        private static boolean isMethodFromJavaLangObject(PsiMethod method) {
            if (method == null) {
                return false;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return false;
            }
            String name = containingClass.getQualifiedName();
            if (name == null) {
                return false;
            }
            return "java.lang.Object".equals(name);
        }

        @NotNull
        public static SortedComboBoxModel<MethodWrapper> buildModel() {
            SortedComboBoxModel sortedComboBoxModel = new SortedComboBoxModel((Comparator)new Comparator<MethodWrapper>(){

                @Override
                public int compare(MethodWrapper o1, MethodWrapper o2) {
                    return o1.compareTo(o2);
                }
            });
            if (sortedComboBoxModel == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/MethodCheckerDetailsDialog$MethodDropDown", "buildModel"));
            }
            return sortedComboBoxModel;
        }

        private void initValues() {
            if (this.myPsiClass != null) {
                PsiMethod[] allMethods;
                this.myModel.clear();
                this.myModel.setSelectedItem(null);
                for (PsiMethod method : allMethods = this.myPsiClass.getAllMethods()) {
                    MethodWrapper methodWrapper = new MethodWrapper(method);
                    if (!this.qualifies(method) || this.myModel.getItems().contains(methodWrapper)) continue;
                    this.myModel.add((Object)methodWrapper);
                }
            }
        }

        public boolean qualifies(PsiMethod psiMethod) {
            if (MethodDropDown.isMethodFromJavaLangObject(psiMethod)) {
                return false;
            }
            PsiParameter[] parameters = psiMethod.getParameterList().getParameters();
            if (parameters.length < 1) {
                return false;
            }
            if (this.myType == ConditionChecker.Type.IS_NULL_METHOD || this.myType == ConditionChecker.Type.IS_NOT_NULL_METHOD) {
                PsiType returnType = psiMethod.getReturnType();
                if (!(returnType == PsiType.BOOLEAN || returnType != null && returnType.getCanonicalText().equals(Boolean.class.toString()))) {
                    return false;
                }
            } else if (this.myType == ConditionChecker.Type.ASSERT_TRUE_METHOD || this.myType == ConditionChecker.Type.ASSERT_FALSE_METHOD) {
                boolean booleanParamExists = false;
                for (PsiParameter psiParameter : parameters) {
                    PsiType type = psiParameter.getType();
                    if (!type.equals(PsiType.BOOLEAN) && !type.getCanonicalText().equals(Boolean.class.toString())) continue;
                    booleanParamExists = true;
                    break;
                }
                if (!booleanParamExists) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("ClassField.myPsiClass")) {
                if (evt.getNewValue() == null) {
                    this.clear();
                } else {
                    this.setEnabled(true);
                    if (this.myPsiClass == null || !this.myPsiClass.equals(evt.getNewValue())) {
                        this.myPsiClass = (PsiClass)evt.getNewValue();
                        this.initValues();
                    }
                }
            }
        }

        public void clear() {
            this.myModel.clear();
            this.myModel.setSelectedItem(null);
            this.setEnabled(false);
            this.myPsiClass = null;
        }

        @Nullable
        public PsiMethod getSelectedPsiMethod() {
            MethodWrapper methodWrapper = (MethodWrapper)this.myModel.getSelectedItem();
            if (methodWrapper == null) {
                return null;
            }
            return methodWrapper.getPsiMethod();
        }
    }

    static class ClassField
    extends EditorTextFieldWithBrowseButton
    implements ActionListener,
    DocumentListener {
        public static final String PROPERTY_PSICLASS = "ClassField.myPsiClass";
        @NotNull
        private final Project myProject;
        @Nullable
        private PsiClass myPsiClass;

        public ClassField(@NotNull Project project, @Nullable PsiClass psiClass) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/dataFlow/MethodCheckerDetailsDialog$ClassField", "<init>"));
            }
            super(project, true, ClassField.buildVisibilityChecker());
            this.myProject = project;
            this.myPsiClass = psiClass;
            this.setPreferredSize(new Dimension(500, (int)this.getPreferredSize().getHeight()));
            if (this.myPsiClass != null) {
                this.setText(this.myPsiClass.getQualifiedName());
            }
            this.addActionListener(this);
            ((EditorTextField)((Object)this.getChildComponent())).addDocumentListener(this);
        }

        private static JavaCodeFragment.VisibilityChecker buildVisibilityChecker() {
            return new JavaCodeFragment.VisibilityChecker(){

                public JavaCodeFragment.VisibilityChecker.Visibility isDeclarationVisible(PsiElement declaration, PsiElement place) {
                    return JavaCodeFragment.VisibilityChecker.Visibility.VISIBLE;
                }
            };
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TreeClassChooser chooser = TreeClassChooserFactory.getInstance((Project)this.myProject).createNoInnerClassesScopeChooser("Choose Class", GlobalSearchScope.allScope((Project)this.myProject), new ClassFilter(){

                public boolean isAccepted(PsiClass aClass) {
                    return !aClass.isAnnotationType();
                }
            }, null);
            chooser.showDialog();
            PsiClass psiClass = chooser.getSelected();
            if (psiClass != null) {
                this.setText(chooser.getSelected().getQualifiedName());
            }
        }

        @Nullable
        public PsiClass getPsiClass() {
            return this.myPsiClass;
        }

        public void beforeDocumentChange(DocumentEvent event) {
        }

        public void documentChanged(DocumentEvent event) {
            String className = event.getDocument().getText();
            PsiClass psiClass = null;
            if (className != null) {
                psiClass = JavaPsiFacade.getInstance((Project)this.myProject).findClass(className, GlobalSearchScope.allScope((Project)this.myProject));
            }
            if (psiClass != null && this.myPsiClass != null) {
                if (!psiClass.equals(this.myPsiClass)) {
                    this.firePropertyChange(PROPERTY_PSICLASS, this.myPsiClass, psiClass);
                    this.myPsiClass = psiClass;
                }
            } else if (psiClass != null) {
                this.firePropertyChange(PROPERTY_PSICLASS, this.myPsiClass, psiClass);
                this.myPsiClass = psiClass;
            } else if (this.myPsiClass != null) {
                this.firePropertyChange(PROPERTY_PSICLASS, this.myPsiClass, psiClass);
                this.myPsiClass = null;
            }
        }
    }
}

