/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.java18StreamApi;

import com.intellij.codeInspection.AnonymousCanBeLambdaInspection;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.java18StreamApi.StaticPseudoFunctionalStyleMethodOptions;
import com.intellij.codeInspection.java18StreamApi.StreamApiConstants;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StaticPseudoFunctionalStyleMethodInspection
extends BaseJavaBatchLocalInspectionTool {
    private static final Logger LOG = Logger.getInstance(StaticPseudoFunctionalStyleMethodInspection.class);
    private final StaticPseudoFunctionalStyleMethodOptions myOptions = new StaticPseudoFunctionalStyleMethodOptions();

    public void readSettings(@NotNull Element node) throws InvalidDataException {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/codeInspection/java18StreamApi/StaticPseudoFunctionalStyleMethodInspection", "readSettings"));
        }
        this.myOptions.readExternal(node);
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/codeInspection/java18StreamApi/StaticPseudoFunctionalStyleMethodInspection", "writeSettings"));
        }
        this.myOptions.writeExternal(node);
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return this.myOptions.createPanel();
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/java18StreamApi/StaticPseudoFunctionalStyleMethodInspection", "buildVisitor"));
        }
        if (!PsiUtil.isLanguageLevel8OrHigher((PsiElement)holder.getFile())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/java18StreamApi/StaticPseudoFunctionalStyleMethodInspection", "buildVisitor"));
            }
            return psiElementVisitor;
        }
        PsiElementVisitor psiElementVisitor = new PsiElementVisitor(){

            public void visitElement(PsiElement element) {
                if (element instanceof PsiMethodCallExpression) {
                    PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)element;
                    String qName = methodCallExpression.getMethodExpression().getQualifiedName();
                    if (qName == null) {
                        return;
                    }
                    qName = StringUtil.getShortName((String)qName);
                    Collection<StaticPseudoFunctionalStyleMethodOptions.PipelineElement> handlerInfos = StaticPseudoFunctionalStyleMethodInspection.this.myOptions.findElementsByMethodName(qName);
                    if (handlerInfos.isEmpty()) {
                        return;
                    }
                    PsiMethod method = methodCallExpression.resolveMethod();
                    if (method == null) {
                        return;
                    }
                    PsiClass aClass = method.getContainingClass();
                    if (aClass == null) {
                        return;
                    }
                    String classQualifiedName = aClass.getQualifiedName();
                    if (classQualifiedName == null) {
                        return;
                    }
                    StaticPseudoFunctionalStyleMethodOptions.PipelineElement suitableHandler = null;
                    for (StaticPseudoFunctionalStyleMethodOptions.PipelineElement h : handlerInfos) {
                        if (!h.getHandlerClass().equals(classQualifiedName)) continue;
                        suitableHandler = h;
                        break;
                    }
                    if (suitableHandler == null) {
                        return;
                    }
                    int lambdaIndex = StaticPseudoFunctionalStyleMethodInspection.validateMethodParameters(methodCallExpression, method, suitableHandler.getStreamApiMethodName() == "#findMatched");
                    if (lambdaIndex != -1) {
                        holder.registerProblem((PsiElement)methodCallExpression.getMethodExpression(), "", new LocalQuickFix[]{new ReplacePseudoLambdaWithLambda(lambdaIndex, methodCallExpression, method, suitableHandler)});
                    }
                }
            }
        };
        if (psiElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/java18StreamApi/StaticPseudoFunctionalStyleMethodInspection", "buildVisitor"));
        }
        return psiElementVisitor;
    }

    private static int validateMethodParameters(PsiMethodCallExpression methodCallExpression, PsiMethod method, boolean canThirdParameterExist) {
        PsiParameter[] expectedParameters;
        PsiType[] argumentTypes = methodCallExpression.getArgumentList().getExpressionTypes();
        if (argumentTypes.length != (expectedParameters = method.getParameterList().getParameters()).length) {
            return -1;
        }
        if (expectedParameters.length == 2 || canThirdParameterExist && expectedParameters.length == 3) {
            int collectionOrArrayIndex = StaticPseudoFunctionalStyleMethodInspection.findCollectionOrArrayPlacement(expectedParameters);
            if (collectionOrArrayIndex == -1) {
                return -1;
            }
            return (1 + collectionOrArrayIndex) % 2;
        }
        return -1;
    }

    private static int findCollectionOrArrayPlacement(PsiParameter[] parameters) {
        int length = parameters.length;
        for (int i = 0; i < length; ++i) {
            PsiParameter parameter = parameters[i];
            PsiType type = parameter.getType();
            if (!(type instanceof PsiClassType) && !(type instanceof PsiArrayType)) continue;
            return i;
        }
        return -1;
    }

    private static PsiExpression convertToJavaLambda(PsiExpression expression, String streamApiMethodName) {
        if (streamApiMethodName.equals("#findMatched")) {
            streamApiMethodName = "filter";
        }
        if (expression instanceof PsiMethodReferenceExpression) {
            return expression;
        }
        if (expression instanceof PsiLambdaExpression) {
            return expression;
        }
        if (expression instanceof PsiMethodCallExpression) {
            PsiMethod method = ((PsiMethodCallExpression)expression).resolveMethod();
            if (method == null) {
                return null;
            }
            PsiType type = method.getReturnType();
            if (!(type instanceof PsiClassType)) {
                return null;
            }
            PsiClass lambdaClass = ((PsiClassType)type).resolve();
            if (lambdaClass == null) {
                return null;
            }
            String methodName = lambdaClass.getMethods()[0].getName();
            if (StaticPseudoFunctionalStyleMethodInspection.tryConvertPseudoLambdaToStreamApi(method, StaticPseudoFunctionalStyleMethodInspection.resolveStreamApiLambdaClass(expression.getProject(), streamApiMethodName))) {
                return expression;
            }
            return JavaPsiFacade.getElementFactory((Project)expression.getProject()).createExpressionFromText(expression.getText() + "::" + methodName, null);
        }
        return AnonymousCanBeLambdaInspection.replacePsiElementWithLambda((PsiElement)expression, true);
    }

    @NotNull
    private static PsiClass resolveStreamApiLambdaClass(Project project, String streamApiMethodName) {
        PsiClass javaUtilStream = JavaPsiFacade.getInstance((Project)project).findClass("java.util.stream.Stream", GlobalSearchScope.notScope((GlobalSearchScope)GlobalSearchScope.projectScope((Project)project)));
        LOG.assertTrue(javaUtilStream != null);
        PsiMethod[] methods = javaUtilStream.findMethodsByName(streamApiMethodName, false);
        LOG.assertTrue(methods.length == 1);
        PsiMethod method = methods[0];
        PsiParameter[] parameters = method.getParameterList().getParameters();
        LOG.assertTrue(parameters.length == 1);
        PsiType type = parameters[0].getType();
        LOG.assertTrue(type instanceof PsiClassType);
        PsiClass resolved = ((PsiClassType)type).resolve();
        LOG.assertTrue(resolved != null);
        PsiClass psiClass = resolved;
        if (psiClass == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/java18StreamApi/StaticPseudoFunctionalStyleMethodInspection", "resolveStreamApiLambdaClass"));
        }
        return psiClass;
    }

    private static boolean tryConvertPseudoLambdaToStreamApi(final @NotNull PsiMethod method, @NotNull PsiClass expectedReturnClass) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInspection/java18StreamApi/StaticPseudoFunctionalStyleMethodInspection", "tryConvertPseudoLambdaToStreamApi"));
        }
        if (expectedReturnClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expectedReturnClass", "com/intellij/codeInspection/java18StreamApi/StaticPseudoFunctionalStyleMethodInspection", "tryConvertPseudoLambdaToStreamApi"));
        }
        PsiType currentReturnType = method.getReturnType();
        if (!(currentReturnType instanceof PsiClassType)) {
            LOG.error("pseudo-lambda return type must be class " + currentReturnType);
            return true;
        }
        PsiClass resolvedCurrentReturnType = ((PsiClassType)currentReturnType).resolve();
        if (expectedReturnClass.getManager().areElementsEquivalent((PsiElement)expectedReturnClass, (PsiElement)resolvedCurrentReturnType)) {
            return true;
        }
        PsiCodeBlock body = method.getBody();
        Collection returnStatements = PsiTreeUtil.findChildrenOfType((PsiElement)body, PsiReturnStatement.class);
        if ((returnStatements = ContainerUtil.filter((Collection)returnStatements, (Condition)new Condition<PsiReturnStatement>(){

            public boolean value(PsiReturnStatement statement) {
                return PsiTreeUtil.getParentOfType((PsiElement)statement, PsiMethod.class) == method;
            }
        })).size() != 1) {
            return false;
        }
        PsiReturnStatement returnStatement = (PsiReturnStatement)ContainerUtil.getFirstItem((Collection)returnStatements);
        assert (returnStatement != null);
        PsiExpression returnValue = returnStatement.getReturnValue();
        if (returnValue instanceof PsiNewExpression) {
            StaticPseudoFunctionalStyleMethodInspection.convertNewExpression(method, (PsiNewExpression)returnValue, expectedReturnClass);
            return true;
        }
        return false;
    }

    private static void convertNewExpression(PsiMethod containingMethod, PsiNewExpression newExpression, PsiClass expectedReturnClass) {
        String expectedReturnQName = expectedReturnClass.getQualifiedName();
        LOG.assertTrue(expectedReturnQName != null);
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)newExpression.getProject());
        PsiAnonymousClass anonymousClass = (PsiAnonymousClass)PsiTreeUtil.findChildOfType((PsiElement)newExpression, PsiAnonymousClass.class);
        LOG.assertTrue(anonymousClass != null);
        PsiJavaCodeReferenceElement referenceElement = (PsiJavaCodeReferenceElement)PsiTreeUtil.findChildOfType((PsiElement)anonymousClass, PsiJavaCodeReferenceElement.class);
        LOG.assertTrue(referenceElement != null);
        PsiReferenceParameterList parameterList = (PsiReferenceParameterList)PsiTreeUtil.findChildOfType((PsiElement)referenceElement, PsiReferenceParameterList.class);
        PsiJavaCodeReferenceElement newCodeReferenceElement = factory.createReferenceFromText(expectedReturnClass.getQualifiedName() + (parameterList == null ? "" : parameterList.getText()), null);
        referenceElement.replace((PsiElement)newCodeReferenceElement);
        List methods = ContainerUtil.filter((Object[])anonymousClass.getMethods(), (Condition)new Condition<PsiMethod>(){

            public boolean value(PsiMethod method) {
                return !"equals".equals(method.getName());
            }
        });
        LOG.assertTrue(methods.size() == 1, (Object)methods);
        PsiMethod method = (PsiMethod)methods.get(0);
        method.setName(expectedReturnClass.getMethods()[0].getName());
        PsiTypeElement element = containingMethod.getReturnTypeElement();
        if (element != null) {
            PsiReferenceParameterList genericParameter = (PsiReferenceParameterList)PsiTreeUtil.findChildOfType((PsiElement)element, PsiReferenceParameterList.class);
            element.replace((PsiElement)factory.createTypeElementFromText(expectedReturnQName + (genericParameter == null ? "" : genericParameter.getText()), null));
        }
    }

    @Nullable
    private static String findSuitableTailMethodForCollection(PsiMethod lambdaHandler) {
        PsiType type = lambdaHandler.getReturnType();
        if (type instanceof PsiArrayType) {
            return "toArray(String[]::new)";
        }
        if (type instanceof PsiClassType) {
            PsiClass resolvedClass = ((PsiClassType)type).resolve();
            if (resolvedClass == null) {
                return null;
            }
            String qName = resolvedClass.getQualifiedName();
            if (qName == null) {
                return null;
            }
            if (qName.equals("java.util.List") || qName.equals("java.util.Collection") || qName.equals("java.lang.Iterable")) {
                return "collect(java.util.stream.Collectors.toList())";
            }
            if (qName.equals("java.util.Set")) {
                return "collect(java.util.stream.Collectors.toSet())";
            }
            if (qName.equals("java.util.Iterator")) {
                return "iterator()";
            }
        }
        return null;
    }

    public static class ReplacePseudoLambdaWithLambda
    implements LocalQuickFix {
        private final int myLambdaIndex;
        private final SmartPsiElementPointer<PsiMethod> myMethodPointer;
        private final StaticPseudoFunctionalStyleMethodOptions.PipelineElement mySuitableHandler;

        private ReplacePseudoLambdaWithLambda(int lambdaIndex, @NotNull PsiMethodCallExpression expression, @NotNull PsiMethod method, @NotNull StaticPseudoFunctionalStyleMethodOptions.PipelineElement suitableHandler) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInspection/java18StreamApi/StaticPseudoFunctionalStyleMethodInspection$ReplacePseudoLambdaWithLambda", "<init>"));
            }
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInspection/java18StreamApi/StaticPseudoFunctionalStyleMethodInspection$ReplacePseudoLambdaWithLambda", "<init>"));
            }
            if (suitableHandler == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suitableHandler", "com/intellij/codeInspection/java18StreamApi/StaticPseudoFunctionalStyleMethodInspection$ReplacePseudoLambdaWithLambda", "<init>"));
            }
            this.myLambdaIndex = lambdaIndex;
            this.myMethodPointer = SmartPointerManager.getInstance((Project)expression.getProject()).createSmartPsiElementPointer((PsiElement)method);
            this.mySuitableHandler = suitableHandler;
        }

        @Nls
        @NotNull
        public String getName() {
            String string = this.getFamilyName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/java18StreamApi/StaticPseudoFunctionalStyleMethodInspection$ReplacePseudoLambdaWithLambda", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            if ("Replace with Java Stream API pipeline" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/java18StreamApi/StaticPseudoFunctionalStyleMethodInspection$ReplacePseudoLambdaWithLambda", "getFamilyName"));
            }
            return "Replace with Java Stream API pipeline";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            String lambdaExpressionText;
            String elementText;
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/java18StreamApi/StaticPseudoFunctionalStyleMethodInspection$ReplacePseudoLambdaWithLambda", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/java18StreamApi/StaticPseudoFunctionalStyleMethodInspection$ReplacePseudoLambdaWithLambda", "applyFix"));
            }
            PsiMethodCallExpression expression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), PsiMethodCallExpression.class);
            LOG.assertTrue(expression != null);
            PsiExpression[] expressions = expression.getArgumentList().getExpressions();
            PsiExpression lambdaExpression = expressions[this.myLambdaIndex];
            lambdaExpression = ReplacePseudoLambdaWithLambda.convertClassTypeExpression(lambdaExpression);
            lambdaExpression = StaticPseudoFunctionalStyleMethodInspection.convertToJavaLambda(lambdaExpression, this.mySuitableHandler.getStreamApiMethodName());
            LOG.assertTrue(lambdaExpression != null);
            PsiExpression collectionExpression = expressions[(1 + this.myLambdaIndex) % 2];
            String pipelineHead = ReplacePseudoLambdaWithLambda.createPipelineHeadText(collectionExpression);
            if (!"#findMatched".equals(this.mySuitableHandler.getStreamApiMethodName())) {
                elementText = this.mySuitableHandler.getStreamApiMethodName();
                lambdaExpressionText = lambdaExpression.getText();
            } else {
                elementText = expressions.length == 3 ? String.format("filter(%s).findFirst().orElseGet(() -> %s)", lambdaExpression.getText(), expressions[2].getText()) : String.format("filter(%s).findFirst().get()", lambdaExpression.getText());
                lambdaExpressionText = null;
            }
            String pipelineTail = ((Set)StreamApiConstants.STREAM_STREAM_API_METHODS.getValue()).contains(this.mySuitableHandler.getStreamApiMethodName()) ? StaticPseudoFunctionalStyleMethodInspection.findSuitableTailMethodForCollection((PsiMethod)this.myMethodPointer.getElement()) : null;
            PsiElement replaced = expression.replace((PsiElement)ReplacePseudoLambdaWithLambda.createPipelineExpression(pipelineHead, elementText, lambdaExpressionText, pipelineTail, project));
            JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(replaced.getParent());
        }

        @NotNull
        private static PsiExpression convertClassTypeExpression(PsiExpression expression) {
            PsiClass resolvedClass;
            PsiType type = expression.getType();
            if (type instanceof PsiClassType && (resolvedClass = ((PsiClassType)type).resolve()) != null && "java.lang.Class".equals(resolvedClass.getQualifiedName())) {
                PsiExpression psiExpression = JavaPsiFacade.getElementFactory((Project)expression.getProject()).createExpressionFromText("(" + expression.getText() + ")::isInstance", null);
                if (psiExpression == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/java18StreamApi/StaticPseudoFunctionalStyleMethodInspection$ReplacePseudoLambdaWithLambda", "convertClassTypeExpression"));
                }
                return psiExpression;
            }
            PsiExpression psiExpression = expression;
            if (psiExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/java18StreamApi/StaticPseudoFunctionalStyleMethodInspection$ReplacePseudoLambdaWithLambda", "convertClassTypeExpression"));
            }
            return psiExpression;
        }

        private static String createPipelineHeadText(PsiExpression collectionExpression) {
            PsiType type = collectionExpression.getType();
            if (type instanceof PsiClassType) {
                PsiClass resolved = ((PsiClassType)type).resolve();
                LOG.assertTrue(resolved != null && resolved.getQualifiedName() != null, (Object)type);
                return collectionExpression.getText() + ".stream()";
            }
            if (type instanceof PsiArrayType) {
                return "java.util.Arrays.stream(" + collectionExpression.getText() + ")";
            }
            throw new AssertionError((Object)("type: " + type + " is unexpected"));
        }

        private static PsiExpression createPipelineExpression(String pipelineHead, String elementText, String lambdaExpression, String pipelineTail, Project project) {
            StringBuilder sb = new StringBuilder();
            sb.append(pipelineHead).append(".").append(elementText);
            if (lambdaExpression != null) {
                sb.append("(").append(lambdaExpression).append(")");
            }
            if (pipelineTail != null) {
                sb.append(".").append(pipelineTail);
            }
            return JavaPsiFacade.getElementFactory((Project)project).createExpressionFromText(sb.toString(), null);
        }
    }
}

