/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.JavaDebugProcess;
import com.intellij.debugger.settings.JavaDebuggerSettings;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.TabbedConfigurable;
import com.intellij.openapi.options.ex.SingleConfigurableEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ui.JBUI;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.impl.ui.tree.actions.XDebuggerTreeActionBase;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class CustomizeContextViewAction
extends XDebuggerTreeActionBase {
    @Override
    public void actionPerformed(AnActionEvent e) {
        this.perform(null, "", e);
    }

    @Override
    protected void perform(XValueNodeImpl node, @NotNull String nodeName, AnActionEvent e) {
        if (nodeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeName", "com/intellij/debugger/actions/CustomizeContextViewAction", "perform"));
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(e.getDataContext());
        Disposable disposable = Disposer.newDisposable();
        SingleConfigurableEditor editor = new SingleConfigurableEditor(project, (Configurable)new TabbedConfigurable(disposable){

            @Override
            protected List<Configurable> createConfigurables() {
                return JavaDebuggerSettings.createDataViewsConfigurable();
            }

            @Override
            public void apply() throws ConfigurationException {
                super.apply();
                NodeRendererSettings.getInstance().fireRenderersChanged();
            }

            public String getDisplayName() {
                return DebuggerBundle.message((String)"title.customize.data.views", (Object[])new Object[0]);
            }

            public String getHelpTopic() {
                return "reference.debug.customize.data.view";
            }

            @Override
            protected void createConfigurableTabs() {
                for (Configurable configurable : this.getConfigurables()) {
                    JComponent component = configurable.createComponent();
                    assert (component != null);
                    component.setBorder((Border)JBUI.Borders.empty((int)8, (int)8));
                    this.myTabbedPane.addTab(configurable.getDisplayName(), component);
                }
            }
        });
        Disposer.register((Disposable)editor.getDisposable(), (Disposable)disposable);
        editor.show();
    }

    @Override
    public void update(AnActionEvent e) {
        XDebugSession currentSession;
        e.getPresentation().setText(ActionsBundle.actionText((String)"Debugger.CustomizeContextView"));
        Project project = CustomizeContextViewAction.getEventProject((AnActionEvent)e);
        if (project != null && (currentSession = XDebuggerManager.getInstance((Project)project).getCurrentSession()) != null) {
            e.getPresentation().setEnabledAndVisible(currentSession.getDebugProcess() instanceof JavaDebugProcess);
            return;
        }
        e.getPresentation().setEnabledAndVisible(false);
    }
}

