/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl;

import com.intellij.debugger.actions.DebuggerAction;
import com.intellij.debugger.apiAdapters.TransportServiceWrapper;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.evaluation.CodeFragmentKind;
import com.intellij.debugger.engine.evaluation.DefaultCodeFragmentFactory;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.engine.evaluation.expression.EvaluatorBuilder;
import com.intellij.debugger.engine.evaluation.expression.EvaluatorBuilderImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.PositionUtil;
import com.intellij.debugger.ui.CompletionEditor;
import com.intellij.debugger.ui.DebuggerExpressionComboBox;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeExpression;
import com.intellij.debugger.ui.tree.DebuggerTreeNode;
import com.intellij.debugger.ui.tree.render.BatchEvaluator;
import com.intellij.execution.ExecutionException;
import com.intellij.ide.util.TreeClassChooser;
import com.intellij.ide.util.TreeClassChooserFactory;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.util.net.NetUtils;
import com.sun.jdi.Value;
import com.sun.jdi.connect.spi.TransportService;
import java.io.IOException;
import org.jdom.Element;

public class DebuggerUtilsImpl
extends DebuggerUtilsEx {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.impl.DebuggerUtilsImpl");

    public PsiExpression substituteThis(PsiExpression expressionWithThis, PsiExpression howToEvaluateThis, Value howToEvaluateThisValue, StackFrameContext context) throws EvaluateException {
        return DebuggerTreeNodeExpression.substituteThis(expressionWithThis, howToEvaluateThis, howToEvaluateThisValue);
    }

    @Override
    public EvaluatorBuilder getEvaluatorBuilder() {
        return EvaluatorBuilderImpl.getInstance();
    }

    @Override
    public DebuggerTreeNode getSelectedNode(DataContext context) {
        return DebuggerAction.getSelectedNode(context);
    }

    public DebuggerContextImpl getDebuggerContext(DataContext context) {
        return DebuggerAction.getDebuggerContext(context);
    }

    public Element writeTextWithImports(TextWithImports text) {
        Element element = new Element("TextWithImports");
        element.setAttribute("text", text.toExternalForm());
        element.setAttribute("type", text.getKind() == CodeFragmentKind.EXPRESSION ? "expression" : "code fragment");
        return element;
    }

    public TextWithImports readTextWithImports(Element element) {
        LOG.assertTrue("TextWithImports".equals(element.getName()));
        String text = element.getAttributeValue("text");
        if ("expression".equals(element.getAttributeValue("type"))) {
            return new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, text);
        }
        return new TextWithImportsImpl(CodeFragmentKind.CODE_BLOCK, text);
    }

    public void writeTextWithImports(Element root, String name, TextWithImports value) {
        LOG.assertTrue(value.getKind() == CodeFragmentKind.EXPRESSION);
        JDOMExternalizerUtil.writeField((Element)root, (String)name, (String)value.toExternalForm());
    }

    public TextWithImports readTextWithImports(Element root, String name) {
        String s = JDOMExternalizerUtil.readField((Element)root, (String)name);
        if (s == null) {
            return null;
        }
        return new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, s);
    }

    public TextWithImports createExpressionWithImports(String expression) {
        return new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, expression);
    }

    public PsiElement getContextElement(StackFrameContext context) {
        return PositionUtil.getContextElement(context);
    }

    public PsiClass chooseClassDialog(String title, Project project) {
        TreeClassChooser dialog = TreeClassChooserFactory.getInstance((Project)project).createAllProjectScopeChooser(title);
        dialog.showDialog();
        return dialog.getSelected();
    }

    @Override
    public CompletionEditor createEditor(Project project, PsiElement context, String recentsId) {
        return new DebuggerExpressionComboBox(project, context, recentsId, DefaultCodeFragmentFactory.getInstance());
    }

    public String findAvailableDebugAddress(boolean useSockets) throws ExecutionException {
        TransportServiceWrapper transportService = TransportServiceWrapper.getTransportService(useSockets);
        if (useSockets) {
            int freePort;
            try {
                freePort = NetUtils.findAvailableSocketPort();
            }
            catch (IOException e) {
                throw new ExecutionException(DebugProcessImpl.processError(e));
            }
            return Integer.toString(freePort);
        }
        try {
            TransportService.ListenKey listenKey = transportService.startListening();
            String address = listenKey.address();
            transportService.stopListening(listenKey);
            return address;
        }
        catch (IOException e) {
            int tryNum = 0;
            while (true) {
                try {
                    TransportService.ListenKey listenKey = transportService.startListening("javadebug_" + (int)(Math.random() * 1000.0));
                    String address = listenKey.address();
                    transportService.stopListening(listenKey);
                    return address;
                }
                catch (Exception ex) {
                    if (tryNum++ <= 10) continue;
                    throw new ExecutionException(DebugProcessImpl.processError(ex));
                }
                break;
            }
        }
    }

    public static boolean isRemote(DebugProcess debugProcess) {
        return Boolean.TRUE.equals(debugProcess.getUserData(BatchEvaluator.REMOTE_SESSION_KEY));
    }
}

