/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XSourcePosition;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AlternativeSourceNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel> {
    private static final Key<EditorNotificationPanel> KEY = Key.create((String)"AlternativeSource");
    private static final Key<Boolean> FILE_PROCESSED_KEY = Key.create((String)"AlternativeSourceCheckDone");
    private final Project myProject;

    public AlternativeSourceNotificationProvider(Project project) {
        this.myProject = project;
    }

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        Key<EditorNotificationPanel> key = KEY;
        if (key == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/AlternativeSourceNotificationProvider", "getKey"));
        }
        return key;
    }

    @Nullable
    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file, @NotNull FileEditor fileEditor) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/debugger/ui/AlternativeSourceNotificationProvider", "createNotificationPanel"));
        }
        if (fileEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileEditor", "com/intellij/debugger/ui/AlternativeSourceNotificationProvider", "createNotificationPanel"));
        }
        XDebugSession session = XDebuggerManager.getInstance((Project)this.myProject).getCurrentSession();
        if (session == null) {
            FILE_PROCESSED_KEY.set((UserDataHolder)file, null);
            return null;
        }
        XSourcePosition position = session.getCurrentPosition();
        if (position == null || !file.equals(position.getFile())) {
            FILE_PROCESSED_KEY.set((UserDataHolder)file, null);
            return null;
        }
        if (file.getFileType() == JavaClassFileType.INSTANCE) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(file);
        if (psiFile == null) {
            return null;
        }
        if (!(psiFile instanceof PsiJavaFile)) {
            return null;
        }
        PsiClass[] classes = ((PsiJavaFile)psiFile).getClasses();
        if (classes.length == 0) {
            return null;
        }
        PsiClass baseClass = classes[0];
        String name = baseClass.getQualifiedName();
        if (name == null) {
            return null;
        }
        if (DumbService.getInstance((Project)this.myProject).isDumb()) {
            return null;
        }
        Object[] alternatives = JavaPsiFacade.getInstance((Project)this.myProject).findClasses(name, GlobalSearchScope.allScope((Project)this.myProject));
        FILE_PROCESSED_KEY.set((UserDataHolder)file, (Object)true);
        if (alternatives.length > 1) {
            ArrayList alts = ContainerUtil.newArrayList((Object[])alternatives);
            for (PsiClass cls : alts) {
                if (!cls.equals(baseClass) && !cls.getNavigationElement().equals(baseClass)) continue;
                alts.remove(cls);
                break;
            }
            alts.add(0, baseClass);
            ComboBoxClassElement[] elems = (ComboBoxClassElement[])ContainerUtil.map2Array((Collection)alts, ComboBoxClassElement.class, (Function)new Function<PsiClass, ComboBoxClassElement>(){

                public ComboBoxClassElement fun(PsiClass psiClass) {
                    return new ComboBoxClassElement(psiClass);
                }
            });
            return new AlternativeSourceNotificationPanel(elems, baseClass, this.myProject, file);
        }
        return null;
    }

    public static boolean fileProcessed(VirtualFile file) {
        return FILE_PROCESSED_KEY.get((UserDataHolder)file) != null;
    }

    private static class AlternativeSourceNotificationPanel
    extends EditorNotificationPanel {
        public AlternativeSourceNotificationPanel(ComboBoxClassElement[] alternatives, PsiClass aClass, final Project project, final VirtualFile file) {
            this.setText(DebuggerBundle.message((String)"editor.notification.alternative.source", (Object[])new Object[]{aClass.getQualifiedName()}));
            final ComboBox switcher = new ComboBox((Object[])alternatives);
            switcher.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FileEditorManager.getInstance((Project)project).closeFile(file);
                    PsiClass item = ((ComboBoxClassElement)switcher.getSelectedItem()).myClass;
                    item = (PsiClass)item.getNavigationElement();
                    DebuggerUtilsEx.setAlternativeSource(file, item.getContainingFile().getVirtualFile());
                    item.navigate(true);
                    XDebugSession session = XDebuggerManager.getInstance((Project)project).getCurrentSession();
                    if (session != null) {
                        session.updateExecutionPosition();
                    }
                }
            });
            this.myLinksPanel.add((Component)switcher);
        }
    }

    private static class ComboBoxClassElement {
        private final PsiClass myClass;
        private String myText;

        public ComboBoxClassElement(PsiClass aClass) {
            this.myClass = aClass;
        }

        public String toString() {
            if (this.myText == null) {
                Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.myClass);
                if (module != null) {
                    this.myText = module.getName();
                } else {
                    VirtualFile virtualFile = this.myClass.getContainingFile().getVirtualFile();
                    ProjectFileIndex index = ProjectRootManager.getInstance((Project)this.myClass.getProject()).getFileIndex();
                    VirtualFile root = index.getSourceRootForFile(virtualFile);
                    if (root == null) {
                        root = index.getClassRootForFile(virtualFile);
                    }
                    this.myText = root != null ? root.getName() : virtualFile.getPath();
                }
            }
            return this.myText;
        }
    }
}

