/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.JavaBreakpointType;
import com.intellij.debugger.ui.breakpoints.JavaLineBreakpointTypeBase;
import com.intellij.debugger.ui.breakpoints.LineBreakpoint;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.SmartList;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointGroupingRule;
import com.intellij.xdebugger.impl.XSourcePositionImpl;
import com.intellij.xdebugger.impl.breakpoints.XLineBreakpointVariant;
import com.intellij.xdebugger.impl.breakpoints.XLineBreakpointVariantsProvider;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.breakpoints.properties.JavaBreakpointProperties;
import org.jetbrains.java.debugger.breakpoints.properties.JavaLineBreakpointProperties;

public class JavaLineBreakpointType
extends JavaLineBreakpointTypeBase<JavaBreakpointProperties>
implements JavaBreakpointType,
XLineBreakpointVariantsProvider<JavaBreakpointVariant> {
    public JavaLineBreakpointType() {
        super("java-line", DebuggerBundle.message((String)"line.breakpoints.tab.title", (Object[])new Object[0]));
    }

    protected String getHelpID() {
        return "debugging.lineBreakpoint";
    }

    public String getDisplayName() {
        return DebuggerBundle.message((String)"line.breakpoints.tab.title", (Object[])new Object[0]);
    }

    public List<XBreakpointGroupingRule<XLineBreakpoint<JavaBreakpointProperties>, ?>> getGroupingRules() {
        return XDebuggerUtil.getInstance().getGroupingByFileRuleAsList();
    }

    @Nullable
    public JavaLineBreakpointProperties createProperties() {
        return new JavaLineBreakpointProperties();
    }

    @Nullable
    public JavaLineBreakpointProperties createBreakpointProperties(@NotNull VirtualFile file, int line) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/debugger/ui/breakpoints/JavaLineBreakpointType", "createBreakpointProperties"));
        }
        return new JavaLineBreakpointProperties();
    }

    @NotNull
    public Breakpoint createJavaBreakpoint(Project project, XBreakpoint breakpoint) {
        LineBreakpoint lineBreakpoint = new LineBreakpoint(project, breakpoint);
        if (lineBreakpoint == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/breakpoints/JavaLineBreakpointType", "createJavaBreakpoint"));
        }
        return lineBreakpoint;
    }

    public int getPriority() {
        return 100;
    }

    @Override
    @NotNull
    public List<JavaBreakpointVariant> computeLineBreakpointVariants(@NotNull Project project, @NotNull XSourcePosition position) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/debugger/ui/breakpoints/JavaLineBreakpointType", "computeLineBreakpointVariants"));
        }
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/debugger/ui/breakpoints/JavaLineBreakpointType", "computeLineBreakpointVariants"));
        }
        PsiFile file = PsiManager.getInstance((Project)project).findFile(position.getFile());
        if (file == null) {
            List<JavaBreakpointVariant> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/breakpoints/JavaLineBreakpointType", "computeLineBreakpointVariants"));
            }
            return list;
        }
        SourcePosition pos = SourcePosition.createFromLine((PsiFile)file, (int)position.getLine());
        List<PsiLambdaExpression> lambdas = DebuggerUtilsEx.collectLambdas(pos, true);
        if (lambdas.isEmpty()) {
            List<JavaBreakpointVariant> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/breakpoints/JavaLineBreakpointType", "computeLineBreakpointVariants"));
            }
            return list;
        }
        NavigatablePsiElement startMethod = (NavigatablePsiElement)PsiTreeUtil.getParentOfType((PsiElement)pos.getElementAt(), (Class[])new Class[]{PsiMethod.class, PsiLambdaExpression.class});
        if (lambdas.contains(startMethod) && lambdas.size() == 1) {
            List<JavaBreakpointVariant> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/breakpoints/JavaLineBreakpointType", "computeLineBreakpointVariants"));
            }
            return list;
        }
        Document document = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file);
        if (document == null) {
            List<JavaBreakpointVariant> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/breakpoints/JavaLineBreakpointType", "computeLineBreakpointVariants"));
            }
            return list;
        }
        SmartList res = new SmartList();
        res.add(new JavaBreakpointVariant(position));
        if (startMethod instanceof PsiMethod) {
            res.add(new ExactJavaBreakpointVariant(position, (PsiElement)startMethod));
        }
        for (PsiLambdaExpression lambda : lambdas) {
            PsiElement firstElem = DebuggerUtilsEx.getFirstElementOnTheLine(lambda, document, position.getLine());
            res.add(new ExactJavaBreakpointVariant((XSourcePosition)XSourcePositionImpl.createByElement(firstElem), (PsiElement)lambda));
        }
        SmartList smartList = res;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/ui/breakpoints/JavaLineBreakpointType", "computeLineBreakpointVariants"));
        }
        return smartList;
    }

    private class ExactJavaBreakpointVariant
    extends JavaBreakpointVariant {
        private final PsiElement myElement;

        public ExactJavaBreakpointVariant(XSourcePosition position, PsiElement element) {
            super(position);
            this.myElement = element;
        }

        @Override
        public Icon getIcon() {
            return this.myElement.getIcon(0);
        }

        @Override
        public String getText() {
            return StringUtil.shortenTextWithEllipsis((String)this.myElement.getText(), (int)100, (int)0);
        }

        @Override
        public TextRange getHighlightRange() {
            return this.myElement.getTextRange();
        }

        @Override
        public JavaLineBreakpointProperties createProperties() {
            JavaLineBreakpointProperties properties = super.createProperties();
            properties.setOffset(this.mySourcePosition.getOffset());
            return properties;
        }
    }

    class JavaBreakpointVariant
    extends XLineBreakpointVariant {
        protected final XSourcePosition mySourcePosition;

        private JavaBreakpointVariant(XSourcePosition position) {
            this.mySourcePosition = position;
        }

        @Override
        public String getText() {
            return "All";
        }

        @Override
        public Icon getIcon() {
            return null;
        }

        @Override
        public TextRange getHighlightRange() {
            return null;
        }

        public JavaLineBreakpointProperties createProperties() {
            return JavaLineBreakpointType.this.createBreakpointProperties(this.mySourcePosition.getFile(), this.mySourcePosition.getLine());
        }
    }
}

