/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.ui.breakpoints.LineBreakpoint;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.sun.jdi.Location;
import com.sun.jdi.ReferenceType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.breakpoints.properties.JavaBreakpointProperties;

public class RunToCursorBreakpoint
extends LineBreakpoint {
    private final boolean myRestoreBreakpoints;
    @NotNull
    protected final SourcePosition myCustomPosition;
    private String mySuspendPolicy;

    protected RunToCursorBreakpoint(@NotNull Project project, @NotNull SourcePosition pos, boolean restoreBreakpoints) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/debugger/ui/breakpoints/RunToCursorBreakpoint", "<init>"));
        }
        if (pos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pos", "com/intellij/debugger/ui/breakpoints/RunToCursorBreakpoint", "<init>"));
        }
        super(project, (XBreakpoint)null);
        this.myCustomPosition = pos;
        this.setVisible(false);
        this.myRestoreBreakpoints = restoreBreakpoints;
    }

    @Override
    public SourcePosition getSourcePosition() {
        return this.myCustomPosition;
    }

    @Override
    public int getLineIndex() {
        return this.myCustomPosition.getLine();
    }

    @Override
    public void reload() {
    }

    @Override
    public String getSuspendPolicy() {
        return this.mySuspendPolicy;
    }

    @Override
    public void setSuspendPolicy(String policy) {
        this.mySuspendPolicy = policy;
    }

    @Override
    protected boolean isLogEnabled() {
        return false;
    }

    @Override
    protected boolean isLogExpressionEnabled() {
        return false;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public boolean isCountFilterEnabled() {
        return false;
    }

    @Override
    public boolean isClassFiltersEnabled() {
        return false;
    }

    @Override
    public boolean isInstanceFiltersEnabled() {
        return false;
    }

    @Override
    protected boolean isConditionEnabled() {
        return false;
    }

    public boolean isRestoreBreakpoints() {
        return this.myRestoreBreakpoints;
    }

    @Override
    public boolean isVisible() {
        return false;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    protected JavaBreakpointProperties getProperties() {
        return null;
    }

    @Override
    protected boolean isMuted(@NotNull DebugProcessImpl debugProcess) {
        if (debugProcess == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugProcess", "com/intellij/debugger/ui/breakpoints/RunToCursorBreakpoint", "isMuted"));
        }
        return false;
    }

    @Override
    protected boolean acceptLocation(final DebugProcessImpl debugProcess, ReferenceType classType, final Location loc) {
        if (!super.acceptLocation(debugProcess, classType, loc)) {
            return false;
        }
        return (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                SourcePosition position = debugProcess.getPositionManager().getSourcePosition(loc);
                if (position == null) {
                    return false;
                }
                return DebuggerUtilsEx.inTheSameMethod(RunToCursorBreakpoint.this.myCustomPosition, position);
            }
        });
    }

    @Nullable
    protected static RunToCursorBreakpoint create(@NotNull Project project, @NotNull XSourcePosition position, boolean restoreBreakpoints) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/debugger/ui/breakpoints/RunToCursorBreakpoint", "create"));
        }
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/debugger/ui/breakpoints/RunToCursorBreakpoint", "create"));
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(position.getFile());
        return new RunToCursorBreakpoint(project, SourcePosition.createFromOffset((PsiFile)psiFile, (int)position.getOffset()), restoreBreakpoints);
    }

    @Override
    protected boolean shouldCreateRequest(DebugProcessImpl debugProcess) {
        return debugProcess.isAttached() && debugProcess.getRequestsManager().findRequests(this).isEmpty();
    }
}

