/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.fragmented;

import com.intellij.diff.DiffContext;
import com.intellij.diff.tools.fragmented.OnesideContentPanel;
import com.intellij.diff.tools.util.base.DiffPanelBase;
import com.intellij.diff.util.DiffUtil;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.project.Project;
import com.intellij.util.ui.AsyncProcessIcon;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OnesideDiffPanel
extends DiffPanelBase {
    private static final String GOOD_CONTENT = "GoodContent";
    private static final String LOADING_CONTENT = "LoadingContent";
    private static final String TOO_BIG_CONTENT = "TooBigContent";
    private static final String OPERATION_CANCELED_CONTENT = "OperationCanceledContent";
    private static final String ERROR_CONTENT = "ErrorContent";
    @NotNull
    private final AsyncProcessIcon.Big myBusyIcon;

    public OnesideDiffPanel(@Nullable Project project, @NotNull OnesideContentPanel content, @NotNull DataProvider provider, @NotNull DiffContext context) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/diff/tools/fragmented/OnesideDiffPanel", "<init>"));
        }
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/diff/tools/fragmented/OnesideDiffPanel", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/fragmented/OnesideDiffPanel", "<init>"));
        }
        super(project, provider, context);
        this.myBusyIcon = new AsyncProcessIcon.Big("OnesideDiff");
        JPanel centerPanel = new JPanel(new BorderLayout());
        centerPanel.add((Component)this.myNotificationsPanel, "North");
        centerPanel.add((Component)content, "Center");
        this.myContentPanel.add((Component)centerPanel, GOOD_CONTENT);
        this.myContentPanel.add((Component)this.myBusyIcon, LOADING_CONTENT);
        this.myContentPanel.add((Component)DiffUtil.createMessagePanel("Can not calculate diff. File is too big and there are too many changes."), TOO_BIG_CONTENT);
        this.myContentPanel.add((Component)DiffUtil.createMessagePanel("Can not calculate diff. Operation canceled."), OPERATION_CANCELED_CONTENT);
        this.myContentPanel.add((Component)DiffUtil.createMessagePanel("Error"), ERROR_CONTENT);
        this.setCurrentCard(LOADING_CONTENT, false);
    }

    public void setLoadingContent() {
        this.setCurrentCard(LOADING_CONTENT);
    }

    public void setGoodContent() {
        this.setCurrentCard(GOOD_CONTENT);
    }

    public void setTooBigContent() {
        this.setCurrentCard(TOO_BIG_CONTENT);
    }

    public void setOperationCanceledContent() {
        this.setCurrentCard(OPERATION_CANCELED_CONTENT);
    }

    public void setErrorContent() {
        this.setCurrentCard(ERROR_CONTENT);
    }

    @Override
    protected void setCurrentCard(@NotNull String card) {
        if (card == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "card", "com/intellij/diff/tools/fragmented/OnesideDiffPanel", "setCurrentCard"));
        }
        if (card == LOADING_CONTENT) {
            this.myBusyIcon.resume();
        } else {
            this.myBusyIcon.suspend();
        }
        super.setCurrentCard(card);
    }

    public boolean isGoodContent() {
        return this.myCurrentCard == GOOD_CONTENT;
    }
}

