/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.fragmented;

import com.intellij.diff.DiffContext;
import com.intellij.diff.actions.BufferedLineIterator;
import com.intellij.diff.actions.DocumentFragmentContent;
import com.intellij.diff.actions.NavigationContextChecker;
import com.intellij.diff.actions.impl.OpenInEditorWithMouseAction;
import com.intellij.diff.comparison.DiffTooBigException;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.fragmented.ChangedBlock;
import com.intellij.diff.tools.fragmented.HighlightRange;
import com.intellij.diff.tools.fragmented.LineCol;
import com.intellij.diff.tools.fragmented.LineNumberConvertor;
import com.intellij.diff.tools.fragmented.OnesideContentPanel;
import com.intellij.diff.tools.fragmented.OnesideDiffChange;
import com.intellij.diff.tools.fragmented.OnesideDiffPanel;
import com.intellij.diff.tools.fragmented.OnesideEditorHighlighter;
import com.intellij.diff.tools.fragmented.OnesideEditorRangeHighlighter;
import com.intellij.diff.tools.fragmented.OnesideFragmentBuilder;
import com.intellij.diff.tools.util.DiffDataKeys;
import com.intellij.diff.tools.util.DiffNotifications;
import com.intellij.diff.tools.util.FoldingModelSupport;
import com.intellij.diff.tools.util.PrevNextDifferenceIterable;
import com.intellij.diff.tools.util.StatusPanel;
import com.intellij.diff.tools.util.base.HighlightPolicy;
import com.intellij.diff.tools.util.base.IgnorePolicy;
import com.intellij.diff.tools.util.base.InitialScrollPositionSupport;
import com.intellij.diff.tools.util.base.TextDiffViewerBase;
import com.intellij.diff.tools.util.twoside.TwosideTextDiffViewer;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.LineRange;
import com.intellij.diff.util.Side;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.LineTokenizer;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ReadOnlyFragmentModificationException;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.actionSystem.ReadonlyFragmentModificationHandler;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.MergingCharSequence;
import gnu.trove.TIntFunction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OnesideDiffViewer
extends TextDiffViewerBase {
    public static final Logger LOG = Logger.getInstance(OnesideDiffViewer.class);
    @NotNull
    protected final EditorEx myEditor;
    @NotNull
    protected final Document myDocument;
    @NotNull
    private final OnesideDiffPanel myPanel;
    @Nullable
    private final DocumentContent myActualContent1;
    @Nullable
    private final DocumentContent myActualContent2;
    @NotNull
    private final TextDiffViewerBase.MySetEditorSettingsAction myEditorSettingsAction;
    @NotNull
    private final PrevNextDifferenceIterable myPrevNextDifferenceIterable;
    @NotNull
    private final MyStatusPanel myStatusPanel;
    @NotNull
    private final MyInitialScrollHelper myInitialScrollHelper;
    @NotNull
    private final MyFoldingModel myFoldingModel;
    @NotNull
    protected Side myMasterSide;
    @Nullable
    private ChangedBlockData myChangedBlockData;
    private final boolean[] myForceReadOnlyFlags;
    private boolean myReadOnlyLockSet;
    private boolean myDuringOnesideDocumentModification;
    private boolean myDuringTwosideDocumentModification;
    private boolean myStateIsOutOfDate;
    private boolean mySuppressEditorTyping;

    public OnesideDiffViewer(@NotNull DiffContext context, @NotNull DiffRequest request) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/fragmented/OnesideDiffViewer", "<init>"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/tools/fragmented/OnesideDiffViewer", "<init>"));
        }
        super(context, (ContentDiffRequest)request);
        this.myInitialScrollHelper = new MyInitialScrollHelper();
        this.myMasterSide = Side.RIGHT;
        this.myReadOnlyLockSet = false;
        this.myPrevNextDifferenceIterable = new MyPrevNextDifferenceIterable();
        this.myStatusPanel = new MyStatusPanel();
        this.myForceReadOnlyFlags = this.checkForceReadOnly();
        List contents = this.myRequest.getContents();
        this.myActualContent1 = contents.get(0) instanceof DocumentContent ? (DocumentContent)contents.get(0) : null;
        DocumentContent documentContent = this.myActualContent2 = contents.get(1) instanceof DocumentContent ? (DocumentContent)contents.get(1) : null;
        assert (this.myActualContent1 != null || this.myActualContent2 != null);
        if (this.myActualContent1 == null) {
            this.myMasterSide = Side.RIGHT;
        }
        if (this.myActualContent2 == null) {
            this.myMasterSide = Side.LEFT;
        }
        boolean leftEditable = this.isEditable(Side.LEFT, false);
        boolean rightEditable = this.isEditable(Side.RIGHT, false);
        if (leftEditable && !rightEditable) {
            this.myMasterSide = Side.LEFT;
        }
        if (!leftEditable && rightEditable) {
            this.myMasterSide = Side.RIGHT;
        }
        this.myDocument = EditorFactory.getInstance().createDocument((CharSequence)"");
        this.myEditor = DiffUtil.createEditor(this.myDocument, this.myProject, true, true);
        List<JComponent> titles = DiffUtil.createTextTitles(this.myRequest, ContainerUtil.list((Object[])new EditorEx[]{this.myEditor, this.myEditor}));
        OnesideContentPanel contentPanel = new OnesideContentPanel(titles, this.myEditor);
        this.myPanel = new OnesideDiffPanel(this.myProject, contentPanel, this, this.myContext);
        this.myFoldingModel = new MyFoldingModel(this.myEditor, (Disposable)this);
        this.myEditorSettingsAction = new TextDiffViewerBase.MySetEditorSettingsAction(this);
        this.myEditorSettingsAction.applyDefaults();
        new MyOpenInEditorWithMouseAction().register(this.getEditors());
    }

    @Override
    protected void onInit() {
        super.onInit();
        this.installTypingSupport();
        this.myPanel.setLoadingContent();
    }

    @Override
    protected void onDispose() {
        super.onDispose();
        EditorFactory.getInstance().releaseEditor((Editor)this.myEditor);
    }

    @Override
    protected void processContextHints() {
        super.processContextHints();
        Side side = (Side)DiffUtil.getUserData((DiffRequest)this.myRequest, this.myContext, DiffUserDataKeys.MASTER_SIDE);
        if (side != null && side.select((Object)this.myActualContent1, (Object)this.myActualContent2) != null) {
            this.myMasterSide = side;
        }
        this.myInitialScrollHelper.processContext((DiffRequest)this.myRequest);
    }

    @Override
    protected void updateContextHints() {
        super.updateContextHints();
        this.myInitialScrollHelper.updateContext((DiffRequest)this.myRequest);
        this.myFoldingModel.updateContext((UserDataHolder)this.myRequest, this.getFoldingModelSettings());
    }

    protected void updateEditorCanBeTyped() {
        this.myEditor.setViewer(this.mySuppressEditorTyping || !this.isEditable(this.myMasterSide, true));
    }

    private void installTypingSupport() {
        if (!this.isEditable(this.myMasterSide, false)) {
            return;
        }
        this.updateEditorCanBeTyped();
        this.myEditor.getColorsScheme().setColor(EditorColors.READONLY_FRAGMENT_BACKGROUND_COLOR, null);
        EditorActionManager.getInstance().setReadonlyFragmentModificationHandler(this.myDocument, (ReadonlyFragmentModificationHandler)new MyReadonlyFragmentModificationHandler());
        this.myDocument.putUserData(DocumentFragmentContent.ORIGINAL_DOCUMENT, (Object)this.getDocument(this.myMasterSide));
        this.myDocument.addDocumentListener((DocumentListener)new MyOnesideDocumentListener());
    }

    @Override
    @NotNull
    public List<AnAction> createToolbarActions() {
        ArrayList<AnAction> group = new ArrayList<AnAction>();
        group.add((AnAction)new MyIgnorePolicySettingAction());
        group.add((AnAction)new MyHighlightPolicySettingAction());
        group.add((AnAction)new MyToggleExpandByDefaultAction());
        group.add((AnAction)new MyReadOnlyLockAction());
        group.add((AnAction)this.myEditorSettingsAction);
        ArrayList<AnAction> arrayList = group;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/OnesideDiffViewer", "createToolbarActions"));
        }
        return arrayList;
    }

    @Override
    @NotNull
    public List<AnAction> createPopupActions() {
        ArrayList<AnAction> group = new ArrayList<AnAction>();
        group.add((AnAction)Separator.getInstance());
        group.add((AnAction)new MyIgnorePolicySettingAction().getPopupGroup());
        group.add((AnAction)Separator.getInstance());
        group.add((AnAction)new MyHighlightPolicySettingAction().getPopupGroup());
        group.add((AnAction)Separator.getInstance());
        group.add((AnAction)new MyToggleExpandByDefaultAction());
        ArrayList<AnAction> arrayList = group;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/OnesideDiffViewer", "createPopupActions"));
        }
        return arrayList;
    }

    @Override
    protected void onSlowRediff() {
        super.onSlowRediff();
        this.myStatusPanel.setBusy(true);
    }

    @Override
    @NotNull
    protected Runnable performRediff(final @NotNull ProgressIndicator indicator) {
        Runnable runnable;
        block15: {
            block14: {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diff/tools/fragmented/OnesideDiffViewer", "performRediff"));
                }
                indicator.checkCanceled();
                assert (this.myActualContent1 != null || this.myActualContent2 != null);
                if (this.myActualContent1 != null) break block14;
                final DocumentContent content = this.myActualContent2;
                final Document document = content.getDocument();
                OnesideDocumentData data = (OnesideDocumentData)ApplicationManager.getApplication().runReadAction((Computable)new Computable<OnesideDocumentData>(){

                    public OnesideDocumentData compute() {
                        EditorHighlighter highlighter = DiffUtil.createEditorHighlighter(OnesideDiffViewer.this.myProject, content);
                        OnesideEditorRangeHighlighter rangeHighlighter = new OnesideEditorRangeHighlighter(OnesideDiffViewer.this.myProject, content.getDocument());
                        return new OnesideDocumentData(document.getImmutableCharSequence(), DiffUtil.getLineCount(document), highlighter, rangeHighlighter);
                    }
                });
                ArrayList<ChangedBlock> blocks = new ArrayList<ChangedBlock>();
                blocks.add(ChangedBlock.createInserted(data.getText().length() + 1, data.getLines()));
                indicator.checkCanceled();
                LineNumberConvertor convertor = LineNumberConvertor.Builder.createRight(data.getLines());
                CombinedEditorData editorData = new CombinedEditorData((CharSequence)new MergingCharSequence(data.getText(), (CharSequence)"\n"), data.getHighlighter(), data.getRangeHighlighter(), content.getContentType(), convertor.createConvertor1(), null);
                Runnable runnable2 = this.apply(editorData, blocks, convertor, Collections.singletonList(new LineRange(0, data.getLines())), false, false);
                if (runnable2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/OnesideDiffViewer", "performRediff"));
                }
                return runnable2;
            }
            if (this.myActualContent2 != null) break block15;
            final DocumentContent content = this.myActualContent1;
            final Document document = content.getDocument();
            OnesideDocumentData data = (OnesideDocumentData)ApplicationManager.getApplication().runReadAction((Computable)new Computable<OnesideDocumentData>(){

                public OnesideDocumentData compute() {
                    EditorHighlighter highlighter = DiffUtil.createEditorHighlighter(OnesideDiffViewer.this.myProject, content);
                    OnesideEditorRangeHighlighter rangeHighlighter = new OnesideEditorRangeHighlighter(OnesideDiffViewer.this.myProject, content.getDocument());
                    return new OnesideDocumentData(document.getImmutableCharSequence(), DiffUtil.getLineCount(document), highlighter, rangeHighlighter);
                }
            });
            ArrayList<ChangedBlock> blocks = new ArrayList<ChangedBlock>();
            blocks.add(ChangedBlock.createDeleted(data.getText().length() + 1, data.getLines()));
            indicator.checkCanceled();
            LineNumberConvertor convertor = LineNumberConvertor.Builder.createLeft(data.getLines());
            CombinedEditorData editorData = new CombinedEditorData((CharSequence)new MergingCharSequence(data.getText(), (CharSequence)"\n"), data.getHighlighter(), data.getRangeHighlighter(), content.getContentType(), convertor.createConvertor2(), null);
            Runnable runnable3 = this.apply(editorData, blocks, convertor, Collections.singletonList(new LineRange(0, data.getLines())), false, false);
            if (runnable3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/OnesideDiffViewer", "performRediff"));
            }
            return runnable3;
        }
        try {
            final DocumentContent content1 = this.myActualContent1;
            final DocumentContent content2 = this.myActualContent2;
            final Document document1 = content1.getDocument();
            final Document document2 = content2.getDocument();
            final DiffUtil.DocumentData documentData = (DiffUtil.DocumentData)ApplicationManager.getApplication().runReadAction((Computable)new Computable<DiffUtil.DocumentData>(){

                public DiffUtil.DocumentData compute() {
                    return new DiffUtil.DocumentData(document1.getImmutableCharSequence(), document2.getImmutableCharSequence(), document1.getModificationStamp(), document2.getModificationStamp());
                }
            });
            boolean innerFragments = this.getDiffConfig().innerFragments;
            final List<LineFragment> fragments = DiffUtil.compareWithCache((DiffRequest)this.myRequest, documentData, this.getDiffConfig(), indicator);
            indicator.checkCanceled();
            TwosideDocumentData data = (TwosideDocumentData)ApplicationManager.getApplication().runReadAction((Computable)new Computable<TwosideDocumentData>(){

                public TwosideDocumentData compute() {
                    indicator.checkCanceled();
                    OnesideFragmentBuilder builder = new OnesideFragmentBuilder(fragments, document1, document2, OnesideDiffViewer.this.myMasterSide);
                    builder.exec();
                    indicator.checkCanceled();
                    EditorHighlighter highlighter = OnesideDiffViewer.this.buildHighlighter(OnesideDiffViewer.this.myProject, content1, content2, documentData.getText1(), documentData.getText2(), builder.getRanges(), builder.getText().length());
                    OnesideEditorRangeHighlighter rangeHighlighter = new OnesideEditorRangeHighlighter(OnesideDiffViewer.this.myProject, document1, document2, builder.getRanges());
                    return new TwosideDocumentData(builder, highlighter, rangeHighlighter);
                }
            });
            OnesideFragmentBuilder builder = data.getBuilder();
            FileType fileType = content2.getContentType() == null ? content1.getContentType() : content2.getContentType();
            LineNumberConvertor convertor = builder.getConvertor();
            List<LineRange> changedLines = builder.getChangedLines();
            boolean isEqual = builder.isEqual();
            CombinedEditorData editorData = new CombinedEditorData(builder.getText(), data.getHighlighter(), data.getRangeHighlighter(), fileType, convertor.createConvertor1(), convertor.createConvertor2());
            runnable = this.apply(editorData, builder.getBlocks(), convertor, changedLines, isEqual, innerFragments);
        }
        catch (DiffTooBigException ignore) {
            Runnable runnable4 = new Runnable(){

                @Override
                public void run() {
                    OnesideDiffViewer.this.clearDiffPresentation();
                    OnesideDiffViewer.this.myPanel.setTooBigContent();
                }
            };
            if (runnable4 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/OnesideDiffViewer", "performRediff"));
            }
            return runnable4;
        }
        catch (ProcessCanceledException ignore) {
            Runnable runnable5 = new Runnable(){

                @Override
                public void run() {
                    OnesideDiffViewer.this.clearDiffPresentation();
                    OnesideDiffViewer.this.myPanel.setOperationCanceledContent();
                }
            };
            if (runnable5 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/OnesideDiffViewer", "performRediff"));
            }
            return runnable5;
        }
        catch (Throwable e) {
            LOG.error(e);
            Runnable runnable6 = new Runnable(){

                @Override
                public void run() {
                    OnesideDiffViewer.this.clearDiffPresentation();
                    OnesideDiffViewer.this.myPanel.setErrorContent();
                }
            };
            if (runnable6 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/OnesideDiffViewer", "performRediff"));
            }
            return runnable6;
        }
        if (runnable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/OnesideDiffViewer", "performRediff"));
        }
        return runnable;
    }

    private void clearDiffPresentation() {
        this.myPanel.resetNotifications();
        this.myStatusPanel.setBusy(false);
        this.destroyChangedBlockData();
        this.myStateIsOutOfDate = false;
        this.mySuppressEditorTyping = false;
        this.updateEditorCanBeTyped();
    }

    protected void markSuppressEditorTyping() {
        this.mySuppressEditorTyping = true;
        this.updateEditorCanBeTyped();
    }

    protected void markStateIsOutOfDate() {
        this.myStateIsOutOfDate = true;
        if (this.myChangedBlockData != null) {
            for (OnesideDiffChange diffChange : this.myChangedBlockData.getDiffChanges()) {
                diffChange.updateGutterActions();
            }
        }
    }

    @Nullable
    private EditorHighlighter buildHighlighter(@Nullable Project project, @NotNull DocumentContent content1, @NotNull DocumentContent content2, @NotNull CharSequence text1, @NotNull CharSequence text2, @NotNull List<HighlightRange> ranges, int textLength) {
        if (content1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content1", "com/intellij/diff/tools/fragmented/OnesideDiffViewer", "buildHighlighter"));
        }
        if (content2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content2", "com/intellij/diff/tools/fragmented/OnesideDiffViewer", "buildHighlighter"));
        }
        if (text1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text1", "com/intellij/diff/tools/fragmented/OnesideDiffViewer", "buildHighlighter"));
        }
        if (text2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text2", "com/intellij/diff/tools/fragmented/OnesideDiffViewer", "buildHighlighter"));
        }
        if (ranges == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ranges", "com/intellij/diff/tools/fragmented/OnesideDiffViewer", "buildHighlighter"));
        }
        EditorHighlighter highlighter1 = DiffUtil.initEditorHighlighter(project, content1, text1);
        EditorHighlighter highlighter2 = DiffUtil.initEditorHighlighter(project, content2, text2);
        if (highlighter1 == null && highlighter2 == null) {
            return null;
        }
        if (highlighter1 == null) {
            highlighter1 = DiffUtil.initEmptyEditorHighlighter(project, text1);
        }
        if (highlighter2 == null) {
            highlighter2 = DiffUtil.initEmptyEditorHighlighter(project, text2);
        }
        return new OnesideEditorHighlighter(this.myDocument, highlighter1, highlighter2, ranges, textLength);
    }

    @NotNull
    private Runnable apply(final @NotNull CombinedEditorData data, final @NotNull List<ChangedBlock> blocks, final @NotNull LineNumberConvertor convertor, final @NotNull List<LineRange> changedLines, final boolean isEqual, final boolean innerFragments) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/diff/tools/fragmented/OnesideDiffViewer", "apply"));
        }
        if (blocks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "blocks", "com/intellij/diff/tools/fragmented/OnesideDiffViewer", "apply"));
        }
        if (convertor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "convertor", "com/intellij/diff/tools/fragmented/OnesideDiffViewer", "apply"));
        }
        if (changedLines == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changedLines", "com/intellij/diff/tools/fragmented/OnesideDiffViewer", "apply"));
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                OnesideDiffViewer.this.myFoldingModel.updateContext((UserDataHolder)OnesideDiffViewer.this.myRequest, OnesideDiffViewer.this.getFoldingModelSettings());
                OnesideDiffViewer.this.clearDiffPresentation();
                if (isEqual) {
                    OnesideDiffViewer.this.myPanel.addNotification(DiffNotifications.EQUAL_CONTENTS);
                }
                TIntFunction separatorLines = OnesideDiffViewer.this.myFoldingModel.getLineNumberConvertor();
                OnesideDiffViewer.this.myEditor.getGutterComponentEx().setLineNumberConvertor(OnesideDiffViewer.mergeConverters(data.getLineConvertor1(), separatorLines), OnesideDiffViewer.mergeConverters(data.getLineConvertor2(), separatorLines));
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        OnesideDiffViewer.this.myDuringOnesideDocumentModification = true;
                        try {
                            OnesideDiffViewer.this.myDocument.setText(data.getText());
                        }
                        finally {
                            OnesideDiffViewer.this.myDuringOnesideDocumentModification = false;
                        }
                    }
                });
                if (data.getHighlighter() != null) {
                    OnesideDiffViewer.this.myEditor.setHighlighter(data.getHighlighter());
                }
                DiffUtil.setEditorCodeStyle(OnesideDiffViewer.this.myProject, OnesideDiffViewer.this.myEditor, data.getFileType());
                if (data.getRangeHighlighter() != null) {
                    data.getRangeHighlighter().apply(OnesideDiffViewer.this.myProject, OnesideDiffViewer.this.myDocument);
                }
                ArrayList<OnesideDiffChange> diffChanges = new ArrayList<OnesideDiffChange>(blocks.size());
                for (Object block : blocks) {
                    diffChanges.add(new OnesideDiffChange(OnesideDiffViewer.this, (ChangedBlock)block, innerFragments));
                }
                ArrayList<RangeMarker> guarderRangeBlocks = new ArrayList<RangeMarker>();
                if (!OnesideDiffViewer.this.myEditor.isViewer()) {
                    for (ChangedBlock block : blocks) {
                        int end;
                        int start = OnesideDiffViewer.this.myMasterSide.select(block.getStartOffset2(), block.getStartOffset1());
                        if (start >= (end = OnesideDiffViewer.this.myMasterSide.select(block.getEndOffset2() - 1, block.getEndOffset1() - 1))) continue;
                        guarderRangeBlocks.add(OnesideDiffViewer.this.createGuardedBlock(start, end));
                    }
                    int textLength = OnesideDiffViewer.this.myDocument.getTextLength();
                    guarderRangeBlocks.add(OnesideDiffViewer.this.createGuardedBlock(textLength, textLength));
                }
                OnesideDiffViewer.this.myChangedBlockData = new ChangedBlockData(diffChanges, guarderRangeBlocks, convertor);
                OnesideDiffViewer.this.myFoldingModel.install(changedLines, (UserDataHolder)OnesideDiffViewer.this.myRequest, OnesideDiffViewer.this.getFoldingModelSettings());
                OnesideDiffViewer.this.myInitialScrollHelper.onRediff();
                OnesideDiffViewer.this.myStatusPanel.update();
                OnesideDiffViewer.this.myPanel.setGoodContent();
            }
        };
        if (runnable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/OnesideDiffViewer", "apply"));
        }
        return runnable;
    }

    @NotNull
    private RangeMarker createGuardedBlock(int start, int end) {
        RangeMarker block = this.myDocument.createGuardedBlock(start, end);
        block.setGreedyToLeft(true);
        block.setGreedyToRight(true);
        RangeMarker rangeMarker = block;
        if (rangeMarker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/OnesideDiffViewer", "createGuardedBlock"));
        }
        return rangeMarker;
    }

    @Contract(value="!null, _ -> !null")
    private static TIntFunction mergeConverters(final @Nullable TIntFunction convertor, final @NotNull TIntFunction separatorLines) {
        if (separatorLines == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "separatorLines", "com/intellij/diff/tools/fragmented/OnesideDiffViewer", "mergeConverters"));
        }
        if (convertor == null) {
            return null;
        }
        return new TIntFunction(){

            public int execute(int value) {
                return convertor.execute(separatorLines.execute(value));
            }
        };
    }

    protected int transferLineToOnesideStrict(@NotNull Side side, int line) {
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/fragmented/OnesideDiffViewer", "transferLineToOnesideStrict"));
        }
        if (this.myChangedBlockData == null) {
            return -1;
        }
        LineNumberConvertor lineConvertor = this.myChangedBlockData.getLineNumberConvertor();
        return side.isLeft() ? lineConvertor.convertInv1(line) : lineConvertor.convertInv2(line);
    }

    protected int transferLineFromOnesideStrict(@NotNull Side side, int line) {
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/fragmented/OnesideDiffViewer", "transferLineFromOnesideStrict"));
        }
        if (this.myChangedBlockData == null) {
            return -1;
        }
        LineNumberConvertor lineConvertor = this.myChangedBlockData.getLineNumberConvertor();
        return side.isLeft() ? lineConvertor.convert1(line) : lineConvertor.convert2(line);
    }

    protected int transferLineToOneside(@NotNull Side side, int line) {
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/fragmented/OnesideDiffViewer", "transferLineToOneside"));
        }
        if (this.myChangedBlockData == null) {
            return line;
        }
        LineNumberConvertor lineConvertor = this.myChangedBlockData.getLineNumberConvertor();
        return side.isLeft() ? lineConvertor.convertApproximateInv1(line) : lineConvertor.convertApproximateInv2(line);
    }

    @NotNull
    protected Pair<int[], Side> transferLineFromOneside(int line) {
        int[] lines = new int[2];
        if (this.myChangedBlockData == null) {
            lines[0] = this.myActualContent1 != null ? line : 0;
            lines[1] = this.myActualContent2 != null ? line : 0;
            Pair pair = Pair.create((Object)lines, (Object)this.myMasterSide);
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/OnesideDiffViewer", "transferLineFromOneside"));
            }
            return pair;
        }
        LineNumberConvertor lineConvertor = this.myChangedBlockData.getLineNumberConvertor();
        Side side = this.myMasterSide;
        lines[0] = lineConvertor.convert1(line);
        lines[1] = lineConvertor.convert2(line);
        if (lines[0] == -1 && lines[1] == -1) {
            lines[0] = lineConvertor.convertApproximate1(line);
            lines[1] = lineConvertor.convertApproximate2(line);
        } else if (lines[0] == -1) {
            lines[0] = lineConvertor.convertApproximate1(line);
            side = Side.RIGHT;
        } else if (lines[1] == -1) {
            lines[1] = lineConvertor.convertApproximate2(line);
            side = Side.LEFT;
        }
        Pair pair = Pair.create((Object)lines, (Object)side);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/OnesideDiffViewer", "transferLineFromOneside"));
        }
        return pair;
    }

    private void destroyChangedBlockData() {
        if (this.myChangedBlockData == null) {
            return;
        }
        for (OnesideDiffChange change : this.myChangedBlockData.getDiffChanges()) {
            change.destroyHighlighter();
        }
        for (RangeMarker block : this.myChangedBlockData.getGuardedRangeBlocks()) {
            this.myDocument.removeGuardedBlock(block);
        }
        this.myChangedBlockData = null;
        OnesideEditorRangeHighlighter.erase(this.myProject, this.myDocument);
        this.myFoldingModel.destroy();
        this.myStatusPanel.update();
    }

    @Override
    protected void onDocumentChange(@NotNull DocumentEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diff/tools/fragmented/OnesideDiffViewer", "onDocumentChange"));
        }
        if (this.myDuringTwosideDocumentModification) {
            return;
        }
        this.markStateIsOutOfDate();
        this.markSuppressEditorTyping();
        this.myFoldingModel.onDocumentChanged(e);
        this.scheduleRediff();
    }

    public void applyChange(@NotNull OnesideDiffChange change, @NotNull Side sourceSide) {
        if (change == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/diff/tools/fragmented/OnesideDiffViewer", "applyChange"));
        }
        if (sourceSide == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceSide", "com/intellij/diff/tools/fragmented/OnesideDiffViewer", "applyChange"));
        }
        if (this.myStateIsOutOfDate || this.myChangedBlockData == null) {
            return;
        }
        Side affectedSide = sourceSide.other();
        if (!this.isEditable(affectedSide, true)) {
            return;
        }
        Document document1 = this.getDocument(Side.LEFT);
        Document document2 = this.getDocument(Side.RIGHT);
        assert (document1 != null && document2 != null);
        LineFragment lineFragment = change.getLineFragment();
        DiffUtil.applyModification((Document)affectedSide.select((Object)document1, (Object)document2), affectedSide.getStartLine(lineFragment), affectedSide.getEndLine(lineFragment), (Document)sourceSide.select((Object)document1, (Object)document2), sourceSide.getStartLine(lineFragment), sourceSide.getEndLine(lineFragment));
        this.scheduleRediff();
    }

    @NotNull
    private DiffUtil.DiffConfig getDiffConfig() {
        DiffUtil.DiffConfig diffConfig = new DiffUtil.DiffConfig(this.getIgnorePolicy(), this.getHighlightPolicy());
        if (diffConfig == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/OnesideDiffViewer", "getDiffConfig"));
        }
        return diffConfig;
    }

    @NotNull
    private HighlightPolicy getHighlightPolicy() {
        HighlightPolicy policy = this.getTextSettings().getHighlightPolicy();
        if (policy == HighlightPolicy.DO_NOT_HIGHLIGHT) {
            HighlightPolicy highlightPolicy = HighlightPolicy.BY_LINE;
            if (highlightPolicy == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/OnesideDiffViewer", "getHighlightPolicy"));
            }
            return highlightPolicy;
        }
        HighlightPolicy highlightPolicy = policy;
        if (highlightPolicy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/OnesideDiffViewer", "getHighlightPolicy"));
        }
        return highlightPolicy;
    }

    @NotNull
    private IgnorePolicy getIgnorePolicy() {
        IgnorePolicy policy = this.getTextSettings().getIgnorePolicy();
        if (policy == IgnorePolicy.IGNORE_WHITESPACES_CHUNKS) {
            IgnorePolicy ignorePolicy = IgnorePolicy.IGNORE_WHITESPACES;
            if (ignorePolicy == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/OnesideDiffViewer", "getIgnorePolicy"));
            }
            return ignorePolicy;
        }
        IgnorePolicy ignorePolicy = policy;
        if (ignorePolicy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/OnesideDiffViewer", "getIgnorePolicy"));
        }
        return ignorePolicy;
    }

    @NotNull
    public EditorEx getEditor() {
        EditorEx editorEx = this.myEditor;
        if (editorEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/OnesideDiffViewer", "getEditor"));
        }
        return editorEx;
    }

    @Override
    @NotNull
    protected List<? extends EditorEx> getEditors() {
        List<EditorEx> list = Collections.singletonList(this.myEditor);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/OnesideDiffViewer", "getEditors"));
        }
        return list;
    }

    @Nullable
    protected List<OnesideDiffChange> getDiffChanges() {
        return this.myChangedBlockData == null ? null : this.myChangedBlockData.getDiffChanges();
    }

    @NotNull
    public JComponent getComponent() {
        OnesideDiffPanel onesideDiffPanel = this.myPanel;
        if (onesideDiffPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/OnesideDiffViewer", "getComponent"));
        }
        return onesideDiffPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        if (!this.myPanel.isGoodContent()) {
            return null;
        }
        return this.myEditor.getContentComponent();
    }

    @Override
    @NotNull
    protected JComponent getStatusPanel() {
        MyStatusPanel myStatusPanel = this.myStatusPanel;
        if (myStatusPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/OnesideDiffViewer", "getStatusPanel"));
        }
        return myStatusPanel;
    }

    public boolean isEditable(@NotNull Side side, boolean respectReadOnlyLock) {
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/fragmented/OnesideDiffViewer", "isEditable"));
        }
        if (this.myReadOnlyLockSet && respectReadOnlyLock) {
            return false;
        }
        if (side.select(this.myForceReadOnlyFlags)) {
            return false;
        }
        Document document = this.getDocument(side);
        return document != null && DiffUtil.canMakeWritable(document);
    }

    @Nullable
    public Document getDocument(@NotNull Side side) {
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/fragmented/OnesideDiffViewer", "getDocument"));
        }
        DocumentContent content = (DocumentContent)side.select((Object)this.myActualContent1, (Object)this.myActualContent2);
        return content != null ? content.getDocument() : null;
    }

    protected boolean isStateIsOutOfDate() {
        return this.myStateIsOutOfDate;
    }

    @Override
    @Nullable
    protected OpenFileDescriptor getOpenFileDescriptor() {
        return this.getOpenFileDescriptor(this.myEditor.getCaretModel().getOffset());
    }

    @Nullable
    protected OnesideDiffChange getCurrentChange() {
        if (this.myChangedBlockData == null) {
            return null;
        }
        int caretLine = this.myEditor.getCaretModel().getLogicalPosition().line;
        for (OnesideDiffChange change : this.myChangedBlockData.getDiffChanges()) {
            if (!DiffUtil.isSelectedByLine(caretLine, change.getLine1(), change.getLine2())) continue;
            return change;
        }
        return null;
    }

    @Nullable
    protected OpenFileDescriptor getOpenFileDescriptor(int offset) {
        assert (this.myActualContent1 != null || this.myActualContent2 != null);
        if (this.myActualContent2 == null) {
            return this.myActualContent1.getOpenFileDescriptor(offset);
        }
        if (this.myActualContent1 == null) {
            return this.myActualContent2.getOpenFileDescriptor(offset);
        }
        LogicalPosition position = this.myEditor.offsetToLogicalPosition(offset);
        Pair<int[], Side> pair = this.transferLineFromOneside(position.line);
        int offset1 = DiffUtil.getOffset(this.myActualContent1.getDocument(), ((int[])pair.first)[0], position.column);
        int offset2 = DiffUtil.getOffset(this.myActualContent2.getDocument(), ((int[])pair.first)[1], position.column);
        OpenFileDescriptor descriptor1 = this.myActualContent1.getOpenFileDescriptor(offset1);
        OpenFileDescriptor descriptor2 = this.myActualContent2.getOpenFileDescriptor(offset2);
        if (descriptor1 == null) {
            return descriptor2;
        }
        if (descriptor2 == null) {
            return descriptor1;
        }
        return (OpenFileDescriptor)((Side)pair.second).select((Object)descriptor1, (Object)descriptor2);
    }

    public static boolean canShowRequest(@NotNull DiffContext context, @NotNull DiffRequest request) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/fragmented/OnesideDiffViewer", "canShowRequest"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/tools/fragmented/OnesideDiffViewer", "canShowRequest"));
        }
        return TwosideTextDiffViewer.canShowRequest(context, request);
    }

    @Override
    @Nullable
    public Object getData(@NonNls String dataId) {
        OnesideDiffChange change;
        if (DiffDataKeys.PREV_NEXT_DIFFERENCE_ITERABLE.is(dataId)) {
            return this.myPrevNextDifferenceIterable;
        }
        if (CommonDataKeys.VIRTUAL_FILE.is(dataId)) {
            return DiffUtil.getVirtualFile(this.myRequest, this.myMasterSide);
        }
        if (DiffDataKeys.CURRENT_EDITOR.is(dataId)) {
            return this.myEditor;
        }
        if (DiffDataKeys.CURRENT_CHANGE_RANGE.is(dataId) && (change = this.getCurrentChange()) != null) {
            return new LineRange(change.getLine1(), change.getLine2());
        }
        return super.getData(dataId);
    }

    private static class MyReadonlyFragmentModificationHandler
    implements ReadonlyFragmentModificationHandler {
        private MyReadonlyFragmentModificationHandler() {
        }

        public void handle(ReadOnlyFragmentModificationException e) {
        }
    }

    private static class MyFoldingModel
    extends FoldingModelSupport {
        public MyFoldingModel(@NotNull EditorEx editor, @NotNull Disposable disposable) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/tools/fragmented/OnesideDiffViewer$MyFoldingModel", "<init>"));
            }
            if (disposable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposable", "com/intellij/diff/tools/fragmented/OnesideDiffViewer$MyFoldingModel", "<init>"));
            }
            super(new EditorEx[]{editor}, disposable);
        }

        public void install(@Nullable List<LineRange> changedLines, @NotNull UserDataHolder context, @NotNull FoldingModelSupport.Settings settings) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/fragmented/OnesideDiffViewer$MyFoldingModel", "install"));
            }
            if (settings == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/diff/tools/fragmented/OnesideDiffViewer$MyFoldingModel", "install"));
            }
            Iterator<int[]> it = MyFoldingModel.map(changedLines, new Function<LineRange, int[]>(){

                public int[] fun(LineRange line) {
                    return new int[]{line.start, line.end};
                }
            });
            this.install(it, context, settings);
        }

        @NotNull
        public TIntFunction getLineNumberConvertor() {
            TIntFunction tIntFunction = this.getLineConvertor(0);
            if (tIntFunction == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/OnesideDiffViewer$MyFoldingModel", "getLineNumberConvertor"));
            }
            return tIntFunction;
        }
    }

    private class MyInitialScrollHelper
    extends InitialScrollPositionSupport.TwosideInitialScrollHelper {
        private MyInitialScrollHelper() {
        }

        @Override
        @NotNull
        protected List<? extends Editor> getEditors() {
            List<? extends EditorEx> list = OnesideDiffViewer.this.getEditors();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/OnesideDiffViewer$MyInitialScrollHelper", "getEditors"));
            }
            return list;
        }

        @Override
        protected void disableSyncScroll(boolean value) {
        }

        @Override
        public void onSlowRediff() {
        }

        @Override
        @Nullable
        protected LogicalPosition[] getCaretPositions() {
            LogicalPosition position = OnesideDiffViewer.this.myEditor.getCaretModel().getLogicalPosition();
            Pair<int[], Side> pair = OnesideDiffViewer.this.transferLineFromOneside(position.line);
            LogicalPosition[] carets = new LogicalPosition[]{this.getPosition(((int[])pair.first)[0], position.column), this.getPosition(((int[])pair.first)[1], position.column)};
            return carets;
        }

        @Override
        protected boolean doScrollToPosition() {
            if (this.myCaretPosition == null) {
                return false;
            }
            LogicalPosition twosidePosition = (LogicalPosition)OnesideDiffViewer.this.myMasterSide.selectNotNull((Object[])this.myCaretPosition);
            int onesideLine = OnesideDiffViewer.this.transferLineToOneside(OnesideDiffViewer.this.myMasterSide, twosidePosition.line);
            LogicalPosition position = new LogicalPosition(onesideLine, twosidePosition.column);
            OnesideDiffViewer.this.myEditor.getCaretModel().moveToLogicalPosition(position);
            if (this.myEditorsPosition != null && this.myEditorsPosition.isSame(position)) {
                DiffUtil.scrollToPoint(OnesideDiffViewer.this.myEditor, this.myEditorsPosition.myPoints[0], false);
            } else {
                DiffUtil.scrollToCaret(OnesideDiffViewer.this.myEditor, false);
            }
            return true;
        }

        @NotNull
        private LogicalPosition getPosition(int line, int column) {
            if (line == -1) {
                LogicalPosition logicalPosition = new LogicalPosition(0, 0);
                if (logicalPosition == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/OnesideDiffViewer$MyInitialScrollHelper", "getPosition"));
                }
                return logicalPosition;
            }
            LogicalPosition logicalPosition = new LogicalPosition(line, column);
            if (logicalPosition == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/OnesideDiffViewer$MyInitialScrollHelper", "getPosition"));
            }
            return logicalPosition;
        }

        private void doScrollToLine(@NotNull Side side, @NotNull LogicalPosition position) {
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/fragmented/OnesideDiffViewer$MyInitialScrollHelper", "doScrollToLine"));
            }
            if (position == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/diff/tools/fragmented/OnesideDiffViewer$MyInitialScrollHelper", "doScrollToLine"));
            }
            int onesideLine = OnesideDiffViewer.this.transferLineToOneside(side, position.line);
            DiffUtil.scrollEditor(OnesideDiffViewer.this.myEditor, onesideLine, position.column, false);
        }

        @Override
        protected boolean doScrollToLine() {
            if (this.myScrollToLine == null) {
                return false;
            }
            this.doScrollToLine((Side)this.myScrollToLine.first, new LogicalPosition(((Integer)this.myScrollToLine.second).intValue(), 0));
            return true;
        }

        private boolean doScrollToChange(@NotNull DiffUserDataKeysEx.ScrollToPolicy scrollToChangePolicy) {
            if (scrollToChangePolicy == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scrollToChangePolicy", "com/intellij/diff/tools/fragmented/OnesideDiffViewer$MyInitialScrollHelper", "doScrollToChange"));
            }
            if (OnesideDiffViewer.this.myChangedBlockData == null) {
                return false;
            }
            List<OnesideDiffChange> changes = OnesideDiffViewer.this.myChangedBlockData.getDiffChanges();
            OnesideDiffChange targetChange = scrollToChangePolicy.select(changes);
            if (targetChange == null) {
                return false;
            }
            DiffUtil.scrollEditor(OnesideDiffViewer.this.myEditor, targetChange.getLine1(), false);
            return true;
        }

        @Override
        protected boolean doScrollToChange() {
            if (this.myScrollToChange == null) {
                return false;
            }
            return this.doScrollToChange(this.myScrollToChange);
        }

        @Override
        protected boolean doScrollToFirstChange() {
            return this.doScrollToChange(DiffUserDataKeysEx.ScrollToPolicy.FIRST_CHANGE);
        }

        @Override
        protected boolean doScrollToContext() {
            if (this.myNavigationContext == null) {
                return false;
            }
            if (OnesideDiffViewer.this.myChangedBlockData == null) {
                return false;
            }
            if (OnesideDiffViewer.this.myActualContent2 == null) {
                return false;
            }
            ChangedLinesIterator changedLinesIterator = new ChangedLinesIterator(Side.RIGHT, OnesideDiffViewer.this.myChangedBlockData.getDiffChanges());
            NavigationContextChecker checker = new NavigationContextChecker(changedLinesIterator, this.myNavigationContext);
            int line = checker.contextMatchCheck();
            if (line == -1) {
                AllLinesIterator allLinesIterator = new AllLinesIterator(Side.RIGHT);
                NavigationContextChecker checker2 = new NavigationContextChecker(allLinesIterator, this.myNavigationContext);
                line = checker2.contextMatchCheck();
            }
            if (line == -1) {
                return false;
            }
            this.doScrollToLine(Side.RIGHT, new LogicalPosition(line, 0));
            return true;
        }
    }

    private static class CombinedEditorData {
        @NotNull
        private final CharSequence myText;
        @Nullable
        private final EditorHighlighter myHighlighter;
        @Nullable
        private final OnesideEditorRangeHighlighter myRangeHighlighter;
        @Nullable
        private final FileType myFileType;
        @NotNull
        private final TIntFunction myLineConvertor1;
        @Nullable
        private final TIntFunction myLineConvertor2;

        public CombinedEditorData(@NotNull CharSequence text, @Nullable EditorHighlighter highlighter, @Nullable OnesideEditorRangeHighlighter rangeHighlighter, @Nullable FileType fileType, @NotNull TIntFunction convertor1, @Nullable TIntFunction convertor2) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/diff/tools/fragmented/OnesideDiffViewer$CombinedEditorData", "<init>"));
            }
            if (convertor1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "convertor1", "com/intellij/diff/tools/fragmented/OnesideDiffViewer$CombinedEditorData", "<init>"));
            }
            this.myText = text;
            this.myHighlighter = highlighter;
            this.myRangeHighlighter = rangeHighlighter;
            this.myFileType = fileType;
            this.myLineConvertor1 = convertor1;
            this.myLineConvertor2 = convertor2;
        }

        @NotNull
        public CharSequence getText() {
            CharSequence charSequence = this.myText;
            if (charSequence == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/OnesideDiffViewer$CombinedEditorData", "getText"));
            }
            return charSequence;
        }

        @Nullable
        public EditorHighlighter getHighlighter() {
            return this.myHighlighter;
        }

        @Nullable
        public OnesideEditorRangeHighlighter getRangeHighlighter() {
            return this.myRangeHighlighter;
        }

        @Nullable
        public FileType getFileType() {
            return this.myFileType;
        }

        @NotNull
        public TIntFunction getLineConvertor1() {
            TIntFunction tIntFunction = this.myLineConvertor1;
            if (tIntFunction == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/OnesideDiffViewer$CombinedEditorData", "getLineConvertor1"));
            }
            return tIntFunction;
        }

        @Nullable
        public TIntFunction getLineConvertor2() {
            return this.myLineConvertor2;
        }
    }

    private static class ChangedBlockData {
        @NotNull
        private final List<OnesideDiffChange> myDiffChanges;
        @NotNull
        private final List<RangeMarker> myGuardedRangeBlocks;
        @NotNull
        private final LineNumberConvertor myLineNumberConvertor;

        public ChangedBlockData(@NotNull List<OnesideDiffChange> diffChanges, @NotNull List<RangeMarker> guarderRangeBlocks, @NotNull LineNumberConvertor lineNumberConvertor) {
            if (diffChanges == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diffChanges", "com/intellij/diff/tools/fragmented/OnesideDiffViewer$ChangedBlockData", "<init>"));
            }
            if (guarderRangeBlocks == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "guarderRangeBlocks", "com/intellij/diff/tools/fragmented/OnesideDiffViewer$ChangedBlockData", "<init>"));
            }
            if (lineNumberConvertor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lineNumberConvertor", "com/intellij/diff/tools/fragmented/OnesideDiffViewer$ChangedBlockData", "<init>"));
            }
            this.myDiffChanges = diffChanges;
            this.myGuardedRangeBlocks = guarderRangeBlocks;
            this.myLineNumberConvertor = lineNumberConvertor;
        }

        @NotNull
        public List<OnesideDiffChange> getDiffChanges() {
            List<OnesideDiffChange> list = this.myDiffChanges;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/OnesideDiffViewer$ChangedBlockData", "getDiffChanges"));
            }
            return list;
        }

        @NotNull
        public List<RangeMarker> getGuardedRangeBlocks() {
            List<RangeMarker> list = this.myGuardedRangeBlocks;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/OnesideDiffViewer$ChangedBlockData", "getGuardedRangeBlocks"));
            }
            return list;
        }

        @NotNull
        public LineNumberConvertor getLineNumberConvertor() {
            LineNumberConvertor lineNumberConvertor = this.myLineNumberConvertor;
            if (lineNumberConvertor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/OnesideDiffViewer$ChangedBlockData", "getLineNumberConvertor"));
            }
            return lineNumberConvertor;
        }
    }

    private static class TwosideDocumentData {
        @NotNull
        private final OnesideFragmentBuilder myBuilder;
        @Nullable
        private final EditorHighlighter myHighlighter;
        @Nullable
        private final OnesideEditorRangeHighlighter myRangeHighlighter;

        public TwosideDocumentData(@NotNull OnesideFragmentBuilder builder, @Nullable EditorHighlighter highlighter, @Nullable OnesideEditorRangeHighlighter rangeHighlighter) {
            if (builder == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/diff/tools/fragmented/OnesideDiffViewer$TwosideDocumentData", "<init>"));
            }
            this.myBuilder = builder;
            this.myHighlighter = highlighter;
            this.myRangeHighlighter = rangeHighlighter;
        }

        @NotNull
        public OnesideFragmentBuilder getBuilder() {
            OnesideFragmentBuilder onesideFragmentBuilder = this.myBuilder;
            if (onesideFragmentBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/OnesideDiffViewer$TwosideDocumentData", "getBuilder"));
            }
            return onesideFragmentBuilder;
        }

        @Nullable
        public EditorHighlighter getHighlighter() {
            return this.myHighlighter;
        }

        @Nullable
        public OnesideEditorRangeHighlighter getRangeHighlighter() {
            return this.myRangeHighlighter;
        }
    }

    private static class OnesideDocumentData {
        @NotNull
        private final CharSequence myText;
        private final int myLines;
        @Nullable
        private final EditorHighlighter myHighlighter;
        @Nullable
        private final OnesideEditorRangeHighlighter myRangeHighlighter;

        public OnesideDocumentData(@NotNull CharSequence text, int lines, @Nullable EditorHighlighter highlighter, @Nullable OnesideEditorRangeHighlighter rangeHighlighter) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/diff/tools/fragmented/OnesideDiffViewer$OnesideDocumentData", "<init>"));
            }
            this.myText = text;
            this.myLines = lines;
            this.myHighlighter = highlighter;
            this.myRangeHighlighter = rangeHighlighter;
        }

        @NotNull
        public CharSequence getText() {
            CharSequence charSequence = this.myText;
            if (charSequence == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/OnesideDiffViewer$OnesideDocumentData", "getText"));
            }
            return charSequence;
        }

        public int getLines() {
            return this.myLines;
        }

        @Nullable
        public EditorHighlighter getHighlighter() {
            return this.myHighlighter;
        }

        @Nullable
        public OnesideEditorRangeHighlighter getRangeHighlighter() {
            return this.myRangeHighlighter;
        }
    }

    private class MyStatusPanel
    extends StatusPanel {
        private MyStatusPanel() {
        }

        @Override
        protected int getChangesCount() {
            return OnesideDiffViewer.this.myChangedBlockData == null ? 0 : OnesideDiffViewer.this.myChangedBlockData.getDiffChanges().size();
        }
    }

    private class ChangedLinesIterator
    extends BufferedLineIterator {
        @NotNull
        private final Side mySide;
        @NotNull
        private final List<OnesideDiffChange> myChanges;
        private int myIndex;

        private ChangedLinesIterator(@NotNull Side side, List<OnesideDiffChange> changes) {
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/fragmented/OnesideDiffViewer$ChangedLinesIterator", "<init>"));
            }
            if (changes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/diff/tools/fragmented/OnesideDiffViewer$ChangedLinesIterator", "<init>"));
            }
            this.myIndex = 0;
            this.mySide = side;
            this.myChanges = changes;
            this.init();
        }

        @Override
        public boolean hasNextBlock() {
            return this.myIndex < this.myChanges.size();
        }

        @Override
        public void loadNextBlock() {
            if (OnesideDiffViewer.this.myActualContent2 == null) {
                return;
            }
            LOG.assertTrue(!OnesideDiffViewer.this.myStateIsOutOfDate);
            OnesideDiffChange change = this.myChanges.get(this.myIndex);
            ++this.myIndex;
            LineFragment lineFragment = change.getLineFragment();
            int insertedStart = lineFragment.getStartOffset2();
            int insertedEnd = lineFragment.getEndOffset2();
            CharSequence insertedText = OnesideDiffViewer.this.myActualContent2.getDocument().getCharsSequence().subSequence(insertedStart, insertedEnd);
            int lineNumber = lineFragment.getStartLine2();
            LineTokenizer tokenizer = new LineTokenizer(insertedText.toString());
            for (String line : tokenizer.execute()) {
                this.addLine(lineNumber, line);
                ++lineNumber;
            }
        }
    }

    private class AllLinesIterator
    implements Iterator<Pair<Integer, CharSequence>> {
        @NotNull
        private final Side mySide;
        @NotNull
        private final Document myDocument;
        private int myLine;

        private AllLinesIterator(Side side) {
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/fragmented/OnesideDiffViewer$AllLinesIterator", "<init>"));
            }
            this.myLine = 0;
            this.mySide = side;
            DocumentContent content = (DocumentContent)this.mySide.select((Object)OnesideDiffViewer.this.myActualContent1, (Object)OnesideDiffViewer.this.myActualContent2);
            assert (content != null);
            this.myDocument = content.getDocument();
        }

        @Override
        public boolean hasNext() {
            return this.myLine < DiffUtil.getLineCount(this.myDocument);
        }

        @Override
        public Pair<Integer, CharSequence> next() {
            int offset1 = this.myDocument.getLineStartOffset(this.myLine);
            int offset2 = this.myDocument.getLineEndOffset(this.myLine);
            CharSequence text = this.myDocument.getImmutableCharSequence().subSequence(offset1, offset2);
            Pair pair = new Pair((Object)this.myLine, (Object)text);
            ++this.myLine;
            return pair;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class MyReadOnlyLockAction
    extends TextDiffViewerBase.ReadOnlyLockAction {
        public MyReadOnlyLockAction() {
            super(OnesideDiffViewer.this);
            this.init();
        }

        @Override
        protected void doApply(boolean readOnly) {
            OnesideDiffViewer.this.myReadOnlyLockSet = readOnly;
            if (OnesideDiffViewer.this.myChangedBlockData != null) {
                for (OnesideDiffChange onesideDiffChange : OnesideDiffViewer.this.myChangedBlockData.getDiffChanges()) {
                    onesideDiffChange.updateGutterActions();
                }
            }
            OnesideDiffViewer.this.updateEditorCanBeTyped();
        }

        @Override
        protected boolean canEdit() {
            return OnesideDiffViewer.this.myActualContent1 != null && !OnesideDiffViewer.this.myForceReadOnlyFlags[0] && DiffUtil.canMakeWritable(OnesideDiffViewer.this.myActualContent1.getDocument()) || OnesideDiffViewer.this.myActualContent2 != null && !OnesideDiffViewer.this.myForceReadOnlyFlags[1] && DiffUtil.canMakeWritable(OnesideDiffViewer.this.myActualContent2.getDocument());
        }
    }

    private class MyIgnorePolicySettingAction
    extends TextDiffViewerBase.IgnorePolicySettingAction {
        private MyIgnorePolicySettingAction() {
            super(OnesideDiffViewer.this);
        }

        @Override
        @NotNull
        protected IgnorePolicy getCurrentSetting() {
            IgnorePolicy ignorePolicy = OnesideDiffViewer.this.getIgnorePolicy();
            if (ignorePolicy == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/OnesideDiffViewer$MyIgnorePolicySettingAction", "getCurrentSetting"));
            }
            return ignorePolicy;
        }

        @Override
        @NotNull
        protected List<IgnorePolicy> getAvailableSettings() {
            ArrayList settings = ContainerUtil.newArrayList((Object[])IgnorePolicy.values());
            settings.remove((Object)IgnorePolicy.IGNORE_WHITESPACES_CHUNKS);
            ArrayList arrayList = settings;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/OnesideDiffViewer$MyIgnorePolicySettingAction", "getAvailableSettings"));
            }
            return arrayList;
        }
    }

    private class MyHighlightPolicySettingAction
    extends TextDiffViewerBase.HighlightPolicySettingAction {
        private MyHighlightPolicySettingAction() {
            super(OnesideDiffViewer.this);
        }

        @Override
        @NotNull
        protected HighlightPolicy getCurrentSetting() {
            HighlightPolicy highlightPolicy = OnesideDiffViewer.this.getHighlightPolicy();
            if (highlightPolicy == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/OnesideDiffViewer$MyHighlightPolicySettingAction", "getCurrentSetting"));
            }
            return highlightPolicy;
        }

        @Override
        @NotNull
        protected List<HighlightPolicy> getAvailableSettings() {
            ArrayList settings = ContainerUtil.newArrayList((Object[])HighlightPolicy.values());
            settings.remove((Object)HighlightPolicy.DO_NOT_HIGHLIGHT);
            ArrayList arrayList = settings;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/OnesideDiffViewer$MyHighlightPolicySettingAction", "getAvailableSettings"));
            }
            return arrayList;
        }
    }

    private class MyToggleExpandByDefaultAction
    extends TextDiffViewerBase.ToggleExpandByDefaultAction {
        private MyToggleExpandByDefaultAction() {
            super(OnesideDiffViewer.this);
        }

        @Override
        protected void expandAll(boolean expand) {
            OnesideDiffViewer.this.myFoldingModel.expandAll(expand);
        }
    }

    private class MyOpenInEditorWithMouseAction
    extends OpenInEditorWithMouseAction {
        private MyOpenInEditorWithMouseAction() {
        }

        @Override
        protected OpenFileDescriptor getDescriptor(@NotNull Editor editor, int line) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/tools/fragmented/OnesideDiffViewer$MyOpenInEditorWithMouseAction", "getDescriptor"));
            }
            if (editor != OnesideDiffViewer.this.myEditor) {
                return null;
            }
            return OnesideDiffViewer.this.getOpenFileDescriptor(OnesideDiffViewer.this.myEditor.logicalPositionToOffset(new LogicalPosition(line, 0)));
        }
    }

    private class MyPrevNextDifferenceIterable
    implements PrevNextDifferenceIterable {
        private MyPrevNextDifferenceIterable() {
        }

        @Override
        public boolean canGoNext() {
            List<OnesideDiffChange> diffChanges = OnesideDiffViewer.this.getDiffChanges();
            if (diffChanges == null || diffChanges.isEmpty()) {
                return false;
            }
            int line = OnesideDiffViewer.this.myEditor.getCaretModel().getLogicalPosition().line;
            OnesideDiffChange lastChange = diffChanges.get(diffChanges.size() - 1);
            return lastChange.getLine1() > line;
        }

        @Override
        public void goNext() {
            List<OnesideDiffChange> diffChanges = OnesideDiffViewer.this.getDiffChanges();
            assert (diffChanges != null);
            int line = OnesideDiffViewer.this.myEditor.getCaretModel().getLogicalPosition().line;
            OnesideDiffChange next = null;
            for (int i = 0; i < diffChanges.size(); ++i) {
                OnesideDiffChange change = diffChanges.get(i);
                if (change.getLine1() <= line) continue;
                next = change;
                break;
            }
            assert (next != null);
            DiffUtil.scrollEditor(OnesideDiffViewer.this.myEditor, next.getLine1(), true);
        }

        @Override
        public boolean canGoPrev() {
            List<OnesideDiffChange> diffChanges = OnesideDiffViewer.this.getDiffChanges();
            if (diffChanges == null || diffChanges.isEmpty()) {
                return false;
            }
            int line = OnesideDiffViewer.this.myEditor.getCaretModel().getLogicalPosition().line;
            OnesideDiffChange firstChange = diffChanges.get(0);
            return firstChange.getLine2() <= line;
        }

        @Override
        public void goPrev() {
            List<OnesideDiffChange> diffChanges = OnesideDiffViewer.this.getDiffChanges();
            assert (diffChanges != null);
            int line = OnesideDiffViewer.this.myEditor.getCaretModel().getLogicalPosition().line;
            OnesideDiffChange prev = null;
            for (int i = 0; i < diffChanges.size(); ++i) {
                OnesideDiffChange change = diffChanges.get(i);
                if (change.getLine2() <= line) continue;
                prev = diffChanges.get(i - 1);
                break;
            }
            if (prev == null) {
                prev = diffChanges.get(diffChanges.size() - 1);
            }
            DiffUtil.scrollEditor(OnesideDiffViewer.this.myEditor, prev.getLine1(), true);
        }
    }

    private class MyOnesideDocumentListener
    extends DocumentAdapter {
        private MyOnesideDocumentListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void beforeDocumentChange(DocumentEvent e) {
            if (OnesideDiffViewer.this.myDuringOnesideDocumentModification) {
                return;
            }
            if (OnesideDiffViewer.this.myChangedBlockData == null) {
                LOG.warn("oneside beforeDocumentChange - myChangedBlockData == null");
                return;
            }
            try {
                OnesideDiffViewer.this.myDuringTwosideDocumentModification = true;
                Document twosideDocument = OnesideDiffViewer.this.getDocument(OnesideDiffViewer.this.myMasterSide);
                assert (twosideDocument != null);
                int offset1 = e.getOffset();
                int offset2 = e.getOffset() + e.getOldLength();
                if (StringUtil.endsWithChar((CharSequence)e.getOldFragment(), (char)'\n') && StringUtil.endsWithChar((CharSequence)e.getNewFragment(), (char)'\n')) {
                    --offset2;
                }
                LineCol onesideStartPosition = LineCol.fromOffset(OnesideDiffViewer.this.myDocument, offset1);
                LineCol onesideEndPosition = LineCol.fromOffset(OnesideDiffViewer.this.myDocument, offset2);
                int shift = StringUtil.countNewLines((CharSequence)e.getNewFragment()) - StringUtil.countNewLines((CharSequence)e.getOldFragment());
                int twosideStartLine = OnesideDiffViewer.this.transferLineFromOnesideStrict(OnesideDiffViewer.this.myMasterSide, onesideStartPosition.line);
                int twosideEndLine = OnesideDiffViewer.this.transferLineFromOnesideStrict(OnesideDiffViewer.this.myMasterSide, onesideEndPosition.line);
                if (twosideStartLine == -1 || twosideEndLine == -1) {
                    this.logDebugInfo(e, onesideStartPosition, onesideEndPosition, twosideStartLine, twosideEndLine);
                    OnesideDiffViewer.this.markSuppressEditorTyping();
                    return;
                }
                int twosideStartOffset = twosideDocument.getLineStartOffset(twosideStartLine) + onesideStartPosition.column;
                int twosideEndOffset = twosideDocument.getLineStartOffset(twosideEndLine) + onesideEndPosition.column;
                twosideDocument.replaceString(twosideStartOffset, twosideEndOffset, e.getNewFragment());
                for (OnesideDiffChange change : OnesideDiffViewer.this.myChangedBlockData.getDiffChanges()) {
                    change.processChange(onesideStartPosition.line, onesideEndPosition.line + 1, shift);
                }
                LineNumberConvertor lineNumberConvertor = OnesideDiffViewer.this.myChangedBlockData.getLineNumberConvertor();
                lineNumberConvertor.handleOnesideChange(onesideStartPosition.line, onesideEndPosition.line + 1, shift, OnesideDiffViewer.this.myMasterSide);
            }
            finally {
                OnesideDiffViewer.this.markStateIsOutOfDate();
                OnesideDiffViewer.this.myFoldingModel.onDocumentChanged(e);
                OnesideDiffViewer.this.scheduleRediff();
                OnesideDiffViewer.this.myDuringTwosideDocumentModification = false;
            }
        }

        private void logDebugInfo(DocumentEvent e, LineCol onesideStartPosition, LineCol onesideEndPosition, int twosideStartLine, int twosideEndLine) {
            StringBuilder info = new StringBuilder();
            Document document1 = OnesideDiffViewer.this.getDocument(Side.LEFT);
            Document document2 = OnesideDiffViewer.this.getDocument(Side.RIGHT);
            info.append("==== OnesideDiffViewer Debug Info ====");
            info.append("myMasterSide - ").append(OnesideDiffViewer.this.myMasterSide).append('\n');
            info.append("myLeftDocument.length() - ").append(document1 != null ? Integer.valueOf(document1.getTextLength()) : null).append('\n');
            info.append("myRightDocument.length() - ").append(document2 != null ? Integer.valueOf(document2.getTextLength()) : null).append('\n');
            info.append("myDocument.length() - ").append(OnesideDiffViewer.this.myDocument.getTextLength()).append('\n');
            info.append("e.getOffset() - ").append(e.getOffset()).append('\n');
            info.append("e.getNewLength() - ").append(e.getNewLength()).append('\n');
            info.append("e.getOldLength() - ").append(e.getOldLength()).append('\n');
            info.append("onesideStartPosition - ").append(onesideStartPosition).append('\n');
            info.append("onesideEndPosition - ").append(onesideEndPosition).append('\n');
            info.append("twosideStartLine - ").append(twosideStartLine).append('\n');
            info.append("twosideEndLine - ").append(twosideEndLine).append('\n');
            Pair<int[], Side> pair1 = OnesideDiffViewer.this.transferLineFromOneside(onesideStartPosition.line);
            Pair<int[], Side> pair2 = OnesideDiffViewer.this.transferLineFromOneside(onesideEndPosition.line);
            info.append("non-strict transferStartLine - ").append(((int[])pair1.first)[0]).append("-").append(((int[])pair1.first)[1]).append(":").append(pair1.second).append('\n');
            info.append("non-strict transferEndLine - ").append(((int[])pair2.first)[0]).append("-").append(((int[])pair2.first)[1]).append(":").append(pair2.second).append('\n');
            info.append("---- OnesideDiffViewer Debug Info ----");
            LOG.warn(info.toString());
        }
    }
}

