/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.simple;

import com.intellij.diff.DiffContext;
import com.intellij.diff.actions.BufferedLineIterator;
import com.intellij.diff.actions.NavigationContextChecker;
import com.intellij.diff.comparison.DiffTooBigException;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.diff.fragments.LineFragmentImpl;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.simple.SimpleDiffChange;
import com.intellij.diff.tools.util.BaseSyncScrollable;
import com.intellij.diff.tools.util.DiffDataKeys;
import com.intellij.diff.tools.util.DiffNotifications;
import com.intellij.diff.tools.util.DiffSplitter;
import com.intellij.diff.tools.util.FoldingModelSupport;
import com.intellij.diff.tools.util.PrevNextDifferenceIterable;
import com.intellij.diff.tools.util.StatusPanel;
import com.intellij.diff.tools.util.SyncScrollSupport;
import com.intellij.diff.tools.util.base.HighlightPolicy;
import com.intellij.diff.tools.util.base.TextDiffViewerBase;
import com.intellij.diff.tools.util.twoside.TwosideTextDiffViewer;
import com.intellij.diff.util.DiffDividerDrawUtil;
import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.LineRange;
import com.intellij.diff.util.Side;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffNavigationContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleDiffViewer
extends TwosideTextDiffViewer {
    public static final Logger LOG = Logger.getInstance(SimpleDiffViewer.class);
    @NotNull
    private final SyncScrollSupport.SyncScrollable mySyncScrollable;
    @NotNull
    private final PrevNextDifferenceIterable myPrevNextDifferenceIterable;
    @NotNull
    private final StatusPanel myStatusPanel;
    @NotNull
    private final List<SimpleDiffChange> myDiffChanges;
    @NotNull
    private final List<SimpleDiffChange> myInvalidDiffChanges;
    @Nullable
    private final MyFoldingModel myFoldingModel;
    @NotNull
    private final MyInitialScrollHelper myInitialScrollHelper;
    @NotNull
    private final ModifierProvider myModifierProvider;

    public SimpleDiffViewer(@NotNull DiffContext context, @NotNull DiffRequest request) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/simple/SimpleDiffViewer", "<init>"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/tools/simple/SimpleDiffViewer", "<init>"));
        }
        super(context, (ContentDiffRequest)request);
        this.myDiffChanges = new ArrayList<SimpleDiffChange>();
        this.myInvalidDiffChanges = new ArrayList<SimpleDiffChange>();
        this.myInitialScrollHelper = new MyInitialScrollHelper();
        this.mySyncScrollable = new MySyncScrollable();
        this.myPrevNextDifferenceIterable = new MyPrevNextDifferenceIterable();
        this.myStatusPanel = new MyStatusPanel();
        this.myFoldingModel = this.createFoldingModel(this.getEditor1(), this.getEditor2());
        this.myModifierProvider = new ModifierProvider();
    }

    @Override
    protected void onInit() {
        super.onInit();
        this.myContentPanel.setPainter(new MyDividerPainter());
        this.myModifierProvider.init();
    }

    @Override
    protected void onDispose() {
        this.myModifierProvider.destroy();
        this.destroyChangedBlocks();
        super.onDispose();
    }

    @Override
    @NotNull
    protected List<AnAction> createToolbarActions() {
        ArrayList<AnAction> group = new ArrayList<AnAction>();
        group.add((AnAction)new TextDiffViewerBase.IgnorePolicySettingAction(this));
        group.add((AnAction)new TextDiffViewerBase.HighlightPolicySettingAction(this));
        group.add((AnAction)new MyToggleExpandByDefaultAction());
        group.add((AnAction)new TextDiffViewerBase.ToggleAutoScrollAction(this));
        group.add((AnAction)new MyReadOnlyLockAction());
        group.add((AnAction)this.myEditorSettingsAction);
        ArrayList<AnAction> arrayList = group;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleDiffViewer", "createToolbarActions"));
        }
        return arrayList;
    }

    @Override
    @Nullable
    protected List<AnAction> createPopupActions() {
        ArrayList<AnAction> group = new ArrayList<AnAction>();
        group.add((AnAction)Separator.getInstance());
        group.add((AnAction)new TextDiffViewerBase.IgnorePolicySettingAction(this).getPopupGroup());
        group.add((AnAction)Separator.getInstance());
        group.add((AnAction)new TextDiffViewerBase.HighlightPolicySettingAction(this).getPopupGroup());
        group.add((AnAction)Separator.getInstance());
        group.add((AnAction)new TextDiffViewerBase.ToggleAutoScrollAction(this));
        group.add((AnAction)new MyToggleExpandByDefaultAction());
        return group;
    }

    @Override
    @NotNull
    protected List<AnAction> createEditorPopupActions() {
        ArrayList<AnAction> group = new ArrayList<AnAction>();
        group.add(new ReplaceSelectedChangesAction());
        group.add(new AppendSelectedChangesAction());
        group.add(new RevertSelectedChangesAction());
        group.add((AnAction)Separator.getInstance());
        group.addAll(super.createEditorPopupActions());
        ArrayList<AnAction> arrayList = group;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleDiffViewer", "createEditorPopupActions"));
        }
        return arrayList;
    }

    @Nullable
    private MyFoldingModel createFoldingModel(@Nullable EditorEx editor1, @Nullable EditorEx editor2) {
        if (editor1 == null || editor2 == null) {
            return null;
        }
        return new MyFoldingModel(editor1, editor2, (Disposable)this);
    }

    @Override
    protected void processContextHints() {
        super.processContextHints();
        this.myInitialScrollHelper.processContext((DiffRequest)this.myRequest);
    }

    @Override
    protected void updateContextHints() {
        super.updateContextHints();
        if (this.myFoldingModel != null) {
            this.myFoldingModel.updateContext((UserDataHolder)this.myRequest, this.getFoldingModelSettings());
        }
        this.myInitialScrollHelper.updateContext((DiffRequest)this.myRequest);
    }

    @Override
    protected void onSlowRediff() {
        super.onSlowRediff();
        this.myStatusPanel.setBusy(true);
        this.myInitialScrollHelper.onSlowRediff();
    }

    @Override
    @NotNull
    protected Runnable performRediff(@NotNull ProgressIndicator indicator) {
        Runnable runnable;
        block16: {
            block15: {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diff/tools/simple/SimpleDiffViewer", "performRediff"));
                }
                indicator.checkCanceled();
                assert (this.getActualContent1() != null || this.getActualContent2() != null);
                if (this.getActualContent1() != null) break block15;
                DocumentContent content = this.getActualContent2();
                final Document document = content.getDocument();
                CompareData data = (CompareData)ApplicationManager.getApplication().runReadAction((Computable)new Computable<CompareData>(){

                    public CompareData compute() {
                        List<LineFragmentImpl> fragments = Collections.singletonList(new LineFragmentImpl(0, 0, 0, DiffUtil.getLineCount(document), 0, 0, 0, document.getTextLength()));
                        return new CompareData(fragments, false);
                    }
                });
                Runnable runnable2 = this.apply(data);
                if (runnable2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleDiffViewer", "performRediff"));
                }
                return runnable2;
            }
            if (this.getActualContent2() != null) break block16;
            DocumentContent content = this.getActualContent1();
            final Document document = content.getDocument();
            CompareData data = (CompareData)ApplicationManager.getApplication().runReadAction((Computable)new Computable<CompareData>(){

                public CompareData compute() {
                    List<LineFragmentImpl> fragments = Collections.singletonList(new LineFragmentImpl(0, DiffUtil.getLineCount(document), 0, 0, 0, document.getTextLength(), 0, 0));
                    return new CompareData(fragments, false);
                }
            });
            Runnable runnable3 = this.apply(data);
            if (runnable3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleDiffViewer", "performRediff"));
            }
            return runnable3;
        }
        try {
            DocumentContent content1 = this.getActualContent1();
            DocumentContent content2 = this.getActualContent2();
            final Document document1 = content1.getDocument();
            final Document document2 = content2.getDocument();
            DiffUtil.DocumentData data = (DiffUtil.DocumentData)ApplicationManager.getApplication().runReadAction((Computable)new Computable<DiffUtil.DocumentData>(){

                public DiffUtil.DocumentData compute() {
                    return new DiffUtil.DocumentData(document1.getImmutableCharSequence(), document2.getImmutableCharSequence(), document1.getModificationStamp(), document2.getModificationStamp());
                }
            });
            List<LineFragment> lineFragments = null;
            if (this.getHighlightPolicy().isShouldCompare()) {
                lineFragments = DiffUtil.compareWithCache((DiffRequest)this.myRequest, data, this.getDiffConfig(), indicator);
            }
            boolean isEqualContents = (lineFragments == null || lineFragments.isEmpty()) && StringUtil.equals((CharSequence)document1.getCharsSequence(), (CharSequence)document2.getCharsSequence());
            runnable = this.apply(new CompareData(lineFragments, isEqualContents));
        }
        catch (DiffTooBigException ignore) {
            Runnable runnable4 = this.applyNotification(DiffNotifications.DIFF_TOO_BIG);
            if (runnable4 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleDiffViewer", "performRediff"));
            }
            return runnable4;
        }
        catch (ProcessCanceledException ignore) {
            Runnable runnable5 = this.applyNotification(DiffNotifications.OPERATION_CANCELED);
            if (runnable5 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleDiffViewer", "performRediff"));
            }
            return runnable5;
        }
        catch (Throwable e) {
            LOG.error(e);
            Runnable runnable6 = this.applyNotification(DiffNotifications.ERROR);
            if (runnable6 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleDiffViewer", "performRediff"));
            }
            return runnable6;
        }
        if (runnable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleDiffViewer", "performRediff"));
        }
        return runnable;
    }

    @NotNull
    private Runnable apply(final @NotNull CompareData data) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/diff/tools/simple/SimpleDiffViewer", "apply"));
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (SimpleDiffViewer.this.myFoldingModel != null) {
                    SimpleDiffViewer.this.myFoldingModel.updateContext((UserDataHolder)SimpleDiffViewer.this.myRequest, SimpleDiffViewer.this.getFoldingModelSettings());
                }
                SimpleDiffViewer.this.clearDiffPresentation();
                if (data.isEqualContent()) {
                    SimpleDiffViewer.this.myPanel.addNotification(DiffNotifications.EQUAL_CONTENTS);
                }
                if (data.getFragments() != null) {
                    for (LineFragment fragment : data.getFragments()) {
                        SimpleDiffViewer.this.myDiffChanges.add(new SimpleDiffChange(SimpleDiffViewer.this, fragment, SimpleDiffViewer.this.getEditor1(), SimpleDiffViewer.this.getEditor2(), SimpleDiffViewer.this.getHighlightPolicy().isFineFragments()));
                    }
                }
                if (SimpleDiffViewer.this.myFoldingModel != null) {
                    SimpleDiffViewer.this.myFoldingModel.install(data.getFragments(), (UserDataHolder)SimpleDiffViewer.this.myRequest, SimpleDiffViewer.this.getFoldingModelSettings());
                }
                SimpleDiffViewer.this.myInitialScrollHelper.onRediff();
                SimpleDiffViewer.this.myContentPanel.repaintDivider();
                SimpleDiffViewer.this.myStatusPanel.update();
            }
        };
        if (runnable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleDiffViewer", "apply"));
        }
        return runnable;
    }

    @NotNull
    private Runnable applyNotification(final @Nullable JComponent notification) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                SimpleDiffViewer.this.clearDiffPresentation();
                if (notification != null) {
                    SimpleDiffViewer.this.myPanel.addNotification(notification);
                }
            }
        };
        if (runnable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleDiffViewer", "applyNotification"));
        }
        return runnable;
    }

    private void clearDiffPresentation() {
        this.myStatusPanel.setBusy(false);
        this.myPanel.resetNotifications();
        this.destroyChangedBlocks();
    }

    @NotNull
    private DiffUtil.DiffConfig getDiffConfig() {
        DiffUtil.DiffConfig diffConfig = new DiffUtil.DiffConfig(this.getTextSettings().getIgnorePolicy(), this.getHighlightPolicy());
        if (diffConfig == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleDiffViewer", "getDiffConfig"));
        }
        return diffConfig;
    }

    @NotNull
    private HighlightPolicy getHighlightPolicy() {
        HighlightPolicy highlightPolicy = this.getTextSettings().getHighlightPolicy();
        if (highlightPolicy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleDiffViewer", "getHighlightPolicy"));
        }
        return highlightPolicy;
    }

    private void destroyChangedBlocks() {
        for (SimpleDiffChange change : this.myDiffChanges) {
            change.destroyHighlighter();
        }
        this.myDiffChanges.clear();
        for (SimpleDiffChange change : this.myInvalidDiffChanges) {
            change.destroyHighlighter();
        }
        this.myInvalidDiffChanges.clear();
        if (this.myFoldingModel != null) {
            this.myFoldingModel.destroy();
        }
        this.myContentPanel.repaintDivider();
        this.myStatusPanel.update();
    }

    @Override
    protected void onBeforeDocumentChange(@NotNull DocumentEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diff/tools/simple/SimpleDiffViewer", "onBeforeDocumentChange"));
        }
        super.onBeforeDocumentChange(e);
        if (this.myDiffChanges.isEmpty()) {
            return;
        }
        if (this.getEditor1() == null || this.getEditor2() == null) {
            return;
        }
        Side side = null;
        if (e.getDocument() == this.getEditor(Side.LEFT).getDocument()) {
            side = Side.LEFT;
        }
        if (e.getDocument() == this.getEditor(Side.RIGHT).getDocument()) {
            side = Side.RIGHT;
        }
        if (side == null) {
            LOG.warn("Unknown document changed");
            return;
        }
        int offset1 = e.getOffset();
        int offset2 = e.getOffset() + e.getOldLength();
        if (StringUtil.endsWithChar((CharSequence)e.getOldFragment(), (char)'\n') && StringUtil.endsWithChar((CharSequence)e.getNewFragment(), (char)'\n')) {
            --offset2;
        }
        int line1 = e.getDocument().getLineNumber(offset1);
        int line2 = e.getDocument().getLineNumber(offset2) + 1;
        int shift = StringUtil.countNewLines((CharSequence)e.getNewFragment()) - StringUtil.countNewLines((CharSequence)e.getOldFragment());
        ArrayList<SimpleDiffChange> invalid = new ArrayList<SimpleDiffChange>();
        for (SimpleDiffChange change : this.myDiffChanges) {
            if (!change.processChange(line1, line2, shift, side)) continue;
            invalid.add(change);
        }
        if (!invalid.isEmpty()) {
            this.myDiffChanges.removeAll(invalid);
            this.myInvalidDiffChanges.addAll(invalid);
        }
    }

    @Override
    protected void onDocumentChange(@NotNull DocumentEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diff/tools/simple/SimpleDiffViewer", "onDocumentChange"));
        }
        super.onDocumentChange(e);
        if (this.myFoldingModel != null) {
            this.myFoldingModel.onDocumentChanged(e);
        }
    }

    protected boolean doScrollToChange(@NotNull DiffUserDataKeysEx.ScrollToPolicy scrollToPolicy) {
        if (scrollToPolicy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scrollToPolicy", "com/intellij/diff/tools/simple/SimpleDiffViewer", "doScrollToChange"));
        }
        if (this.getEditor1() == null || this.getEditor2() == null) {
            return true;
        }
        SimpleDiffChange targetChange = scrollToPolicy.select(this.myDiffChanges);
        if (targetChange == null) {
            return false;
        }
        this.doScrollToChange(targetChange, false);
        return true;
    }

    private void doScrollToChange(@NotNull SimpleDiffChange change, boolean animated) {
        if (change == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/diff/tools/simple/SimpleDiffViewer", "doScrollToChange"));
        }
        if (this.getEditor1() == null || this.getEditor2() == null) {
            return;
        }
        assert (this.mySyncScrollSupport != null);
        int line1 = change.getStartLine(Side.LEFT);
        int line2 = change.getStartLine(Side.RIGHT);
        int endLine1 = change.getEndLine(Side.LEFT);
        int endLine2 = change.getEndLine(Side.RIGHT);
        DiffUtil.moveCaret(this.getEditor1(), line1);
        DiffUtil.moveCaret(this.getEditor2(), line2);
        this.mySyncScrollSupport.makeVisible(this.getCurrentSide(), line1, endLine1, line2, endLine2, animated);
    }

    protected boolean doScrollToContext(@NotNull DiffNavigationContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/simple/SimpleDiffViewer", "doScrollToContext"));
        }
        if (this.getEditor2() == null) {
            return false;
        }
        ChangedLinesIterator changedLinesIterator = new ChangedLinesIterator(Side.RIGHT);
        NavigationContextChecker checker = new NavigationContextChecker(changedLinesIterator, context);
        int line = checker.contextMatchCheck();
        if (line == -1) {
            AllLinesIterator allLinesIterator = new AllLinesIterator(Side.RIGHT);
            NavigationContextChecker checker2 = new NavigationContextChecker(allLinesIterator, context);
            line = checker2.contextMatchCheck();
        }
        if (line == -1) {
            return false;
        }
        this.scrollToLine(Side.RIGHT, line);
        return true;
    }

    @NotNull
    protected List<SimpleDiffChange> getDiffChanges() {
        List<SimpleDiffChange> list = this.myDiffChanges;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleDiffViewer", "getDiffChanges"));
        }
        return list;
    }

    @Override
    @NotNull
    protected SyncScrollSupport.SyncScrollable getSyncScrollable() {
        SyncScrollSupport.SyncScrollable syncScrollable = this.mySyncScrollable;
        if (syncScrollable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleDiffViewer", "getSyncScrollable"));
        }
        return syncScrollable;
    }

    @Override
    @NotNull
    protected JComponent getStatusPanel() {
        StatusPanel statusPanel = this.myStatusPanel;
        if (statusPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleDiffViewer", "getStatusPanel"));
        }
        return statusPanel;
    }

    @NotNull
    public ModifierProvider getModifierProvider() {
        ModifierProvider modifierProvider = this.myModifierProvider;
        if (modifierProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleDiffViewer", "getModifierProvider"));
        }
        return modifierProvider;
    }

    public static boolean canShowRequest(@NotNull DiffContext context, @NotNull DiffRequest request) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/simple/SimpleDiffViewer", "canShowRequest"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/tools/simple/SimpleDiffViewer", "canShowRequest"));
        }
        return TwosideTextDiffViewer.canShowRequest(context, request);
    }

    @NotNull
    private List<SimpleDiffChange> getSelectedChanges(@NotNull Side side) {
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/simple/SimpleDiffViewer", "getSelectedChanges"));
        }
        EditorEx editor = this.getEditor(side);
        if (editor == null) {
            List<SimpleDiffChange> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleDiffViewer", "getSelectedChanges"));
            }
            return list;
        }
        BitSet lines = DiffUtil.getSelectedLines(editor);
        ArrayList<SimpleDiffChange> affectedChanges = new ArrayList<SimpleDiffChange>();
        for (int i = this.myDiffChanges.size() - 1; i >= 0; --i) {
            int line2;
            SimpleDiffChange change = this.myDiffChanges.get(i);
            int line1 = change.getStartLine(side);
            if (!DiffUtil.isSelectedByLine(lines, line1, line2 = change.getEndLine(side))) continue;
            affectedChanges.add(change);
        }
        ArrayList<SimpleDiffChange> arrayList = affectedChanges;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleDiffViewer", "getSelectedChanges"));
        }
        return arrayList;
    }

    @Nullable
    private SimpleDiffChange getSelectedChange(@NotNull Side side) {
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/simple/SimpleDiffViewer", "getSelectedChange"));
        }
        EditorEx editor = this.getEditor(side);
        if (editor == null) {
            return null;
        }
        int caretLine = editor.getCaretModel().getLogicalPosition().line;
        for (SimpleDiffChange change : this.myDiffChanges) {
            int line2;
            int line1 = change.getStartLine(side);
            if (!DiffUtil.isSelectedByLine(caretLine, line1, line2 = change.getEndLine(side))) continue;
            return change;
        }
        return null;
    }

    public void replaceChange(@NotNull SimpleDiffChange change, @NotNull Side sourceSide) {
        if (change == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/diff/tools/simple/SimpleDiffViewer", "replaceChange"));
        }
        if (sourceSide == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceSide", "com/intellij/diff/tools/simple/SimpleDiffViewer", "replaceChange"));
        }
        assert (this.getEditor1() != null && this.getEditor2() != null);
        if (!change.isValid()) {
            return;
        }
        DocumentEx document1 = this.getEditor1().getDocument();
        DocumentEx document2 = this.getEditor2().getDocument();
        DiffUtil.applyModification((Document)sourceSide.other().select((Object)document1, (Object)document2), change.getStartLine(sourceSide.other()), change.getEndLine(sourceSide.other()), (Document)sourceSide.select((Object)document1, (Object)document2), change.getStartLine(sourceSide), change.getEndLine(sourceSide));
        change.destroyHighlighter();
        this.myDiffChanges.remove(change);
    }

    public void appendChange(@NotNull SimpleDiffChange change, @NotNull Side sourceSide) {
        if (change == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/diff/tools/simple/SimpleDiffViewer", "appendChange"));
        }
        if (sourceSide == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceSide", "com/intellij/diff/tools/simple/SimpleDiffViewer", "appendChange"));
        }
        assert (this.getEditor1() != null && this.getEditor2() != null);
        if (!change.isValid()) {
            return;
        }
        if (change.getStartLine(sourceSide) == change.getEndLine(sourceSide)) {
            return;
        }
        DocumentEx document1 = this.getEditor1().getDocument();
        DocumentEx document2 = this.getEditor2().getDocument();
        DiffUtil.applyModification((Document)sourceSide.other().select((Object)document1, (Object)document2), change.getEndLine(sourceSide.other()), change.getEndLine(sourceSide.other()), (Document)sourceSide.select((Object)document1, (Object)document2), change.getStartLine(sourceSide), change.getEndLine(sourceSide));
        change.destroyHighlighter();
        this.myDiffChanges.remove(change);
    }

    @Override
    @Nullable
    public Object getData(@NonNls String dataId) {
        SimpleDiffChange change;
        if (DiffDataKeys.PREV_NEXT_DIFFERENCE_ITERABLE.is(dataId)) {
            return this.myPrevNextDifferenceIterable;
        }
        if (DiffDataKeys.CURRENT_CHANGE_RANGE.is(dataId) && (change = this.getSelectedChange(this.getCurrentSide())) != null) {
            return new LineRange(change.getStartLine(this.getCurrentSide()), change.getEndLine(this.getCurrentSide()));
        }
        return super.getData(dataId);
    }

    private class MyInitialScrollHelper
    extends TwosideTextDiffViewer.MyInitialScrollPositionHelper {
        private MyInitialScrollHelper() {
            super(SimpleDiffViewer.this);
        }

        @Override
        protected boolean doScrollToChange() {
            if (this.myScrollToChange == null) {
                return false;
            }
            return SimpleDiffViewer.this.doScrollToChange(this.myScrollToChange);
        }

        @Override
        protected boolean doScrollToFirstChange() {
            return SimpleDiffViewer.this.doScrollToChange(DiffUserDataKeysEx.ScrollToPolicy.FIRST_CHANGE);
        }

        @Override
        protected boolean doScrollToContext() {
            if (this.myNavigationContext == null) {
                return false;
            }
            return SimpleDiffViewer.this.doScrollToContext(this.myNavigationContext);
        }
    }

    private static class MyFoldingModel
    extends FoldingModelSupport {
        private final FoldingModelSupport.MyPaintable myPaintable;

        public MyFoldingModel(@NotNull EditorEx editor1, @NotNull EditorEx editor2, @NotNull Disposable disposable) {
            if (editor1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor1", "com/intellij/diff/tools/simple/SimpleDiffViewer$MyFoldingModel", "<init>"));
            }
            if (editor2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor2", "com/intellij/diff/tools/simple/SimpleDiffViewer$MyFoldingModel", "<init>"));
            }
            if (disposable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposable", "com/intellij/diff/tools/simple/SimpleDiffViewer$MyFoldingModel", "<init>"));
            }
            super(new EditorEx[]{editor1, editor2}, disposable);
            this.myPaintable = new FoldingModelSupport.MyPaintable(this, 0, 1);
        }

        public void install(@Nullable List<LineFragment> fragments, @NotNull UserDataHolder context, @NotNull FoldingModelSupport.Settings settings) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/simple/SimpleDiffViewer$MyFoldingModel", "install"));
            }
            if (settings == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/diff/tools/simple/SimpleDiffViewer$MyFoldingModel", "install"));
            }
            Iterator<int[]> it = MyFoldingModel.map(fragments, new Function<LineFragment, int[]>(){

                public int[] fun(LineFragment fragment) {
                    return new int[]{fragment.getStartLine1(), fragment.getEndLine1(), fragment.getStartLine2(), fragment.getEndLine2()};
                }
            });
            this.install(it, context, settings);
        }

        public void paintOnDivider(@NotNull Graphics2D gg, @NotNull Component divider) {
            if (gg == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gg", "com/intellij/diff/tools/simple/SimpleDiffViewer$MyFoldingModel", "paintOnDivider"));
            }
            if (divider == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "divider", "com/intellij/diff/tools/simple/SimpleDiffViewer$MyFoldingModel", "paintOnDivider"));
            }
            this.myPaintable.paintOnDivider(gg, divider);
        }
    }

    public class ModifierProvider {
        private boolean myShiftPressed;
        private boolean myCtrlPressed;
        private boolean myAltPressed;
        private Window myWindow;
        private final WindowFocusListener myWindowFocusListener = new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
                ModifierProvider.this.resetState();
            }

            @Override
            public void windowLostFocus(WindowEvent e) {
                ModifierProvider.this.resetState();
            }
        };

        public void init() {
            IdeEventQueue.getInstance().addPostprocessor(new IdeEventQueue.EventDispatcher(){

                @Override
                public boolean dispatch(AWTEvent e) {
                    if (e instanceof KeyEvent) {
                        ModifierProvider.this.onKeyEvent((KeyEvent)e);
                    }
                    return false;
                }
            }, (Disposable)SimpleDiffViewer.this);
            this.myWindow = UIUtil.getWindow((Component)SimpleDiffViewer.this.myPanel);
            if (this.myWindow != null) {
                this.myWindow.addWindowFocusListener(this.myWindowFocusListener);
            }
        }

        public void destroy() {
            if (this.myWindow != null) {
                this.myWindow.removeWindowFocusListener(this.myWindowFocusListener);
            }
        }

        private void onKeyEvent(KeyEvent e) {
            int keyCode = e.getKeyCode();
            if (keyCode == 16) {
                this.myShiftPressed = e.getID() == 401;
                this.updateActions();
            }
            if (keyCode == 17) {
                this.myCtrlPressed = e.getID() == 401;
                this.updateActions();
            }
            if (keyCode == 18) {
                this.myAltPressed = e.getID() == 401;
                this.updateActions();
            }
        }

        private void resetState() {
            this.myShiftPressed = false;
            this.myAltPressed = false;
            this.myCtrlPressed = false;
            this.updateActions();
        }

        public boolean isShiftPressed() {
            return this.myShiftPressed;
        }

        public boolean isCtrlPressed() {
            return this.myCtrlPressed;
        }

        public boolean isAltPressed() {
            return this.myAltPressed;
        }

        public void updateActions() {
            for (SimpleDiffChange change : SimpleDiffViewer.this.myDiffChanges) {
                change.updateGutterActions(false);
            }
        }
    }

    private static class CompareData {
        @Nullable
        private final List<LineFragment> myFragments;
        private final boolean myEqualContent;

        public CompareData(@Nullable List<LineFragment> fragments, boolean equalContent) {
            this.myFragments = fragments;
            this.myEqualContent = equalContent;
        }

        @Nullable
        public List<LineFragment> getFragments() {
            return this.myFragments;
        }

        public boolean isEqualContent() {
            return this.myEqualContent;
        }
    }

    private class MyStatusPanel
    extends StatusPanel {
        private MyStatusPanel() {
        }

        @Override
        protected int getChangesCount() {
            return SimpleDiffViewer.this.myDiffChanges.size() + SimpleDiffViewer.this.myInvalidDiffChanges.size();
        }
    }

    private class MyDividerPainter
    implements DiffSplitter.Painter,
    DiffDividerDrawUtil.DividerPaintable {
        private MyDividerPainter() {
        }

        @Override
        public void paint(@NotNull Graphics g, @NotNull JComponent divider) {
            if (g == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/diff/tools/simple/SimpleDiffViewer$MyDividerPainter", "paint"));
            }
            if (divider == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "divider", "com/intellij/diff/tools/simple/SimpleDiffViewer$MyDividerPainter", "paint"));
            }
            if (SimpleDiffViewer.this.getEditor1() == null || SimpleDiffViewer.this.getEditor2() == null) {
                return;
            }
            Graphics2D gg = DiffDividerDrawUtil.getDividerGraphics(g, divider, SimpleDiffViewer.this.getEditor1().getComponent());
            gg.setColor(DiffDrawUtil.getDividerColor(SimpleDiffViewer.this.getEditor1()));
            gg.fill(gg.getClipBounds());
            DiffDividerDrawUtil.paintPolygons(gg, divider.getWidth(), SimpleDiffViewer.this.getEditor1(), SimpleDiffViewer.this.getEditor2(), this);
            if (SimpleDiffViewer.this.myFoldingModel != null) {
                SimpleDiffViewer.this.myFoldingModel.paintOnDivider(gg, divider);
            }
            gg.dispose();
        }

        @Override
        public void process(@NotNull DiffDividerDrawUtil.DividerPaintable.Handler handler) {
            if (handler == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/diff/tools/simple/SimpleDiffViewer$MyDividerPainter", "process"));
            }
            for (SimpleDiffChange diffChange : SimpleDiffViewer.this.myDiffChanges) {
                if (handler.process(diffChange.getStartLine(Side.LEFT), diffChange.getEndLine(Side.LEFT), diffChange.getStartLine(Side.RIGHT), diffChange.getEndLine(Side.RIGHT), diffChange.getDiffType().getColor(SimpleDiffViewer.this.getEditor1()))) continue;
                return;
            }
        }
    }

    private class MySyncScrollable
    extends BaseSyncScrollable {
        private MySyncScrollable() {
        }

        @Override
        public boolean isSyncScrollEnabled() {
            return SimpleDiffViewer.this.getTextSettings().isEnableSyncScroll();
        }

        @Override
        public int transfer(@NotNull Side baseSide, int line) {
            if (baseSide == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseSide", "com/intellij/diff/tools/simple/SimpleDiffViewer$MySyncScrollable", "transfer"));
            }
            if (SimpleDiffViewer.this.myDiffChanges.isEmpty()) {
                return line;
            }
            return super.transfer(baseSide, line);
        }

        @Override
        protected void processHelper(@NotNull BaseSyncScrollable.ScrollHelper helper) {
            if (helper == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "helper", "com/intellij/diff/tools/simple/SimpleDiffViewer$MySyncScrollable", "processHelper"));
            }
            assert (SimpleDiffViewer.this.getEditor1() != null && SimpleDiffViewer.this.getEditor2() != null);
            if (!helper.process(0, 0)) {
                return;
            }
            for (SimpleDiffChange diffChange : SimpleDiffViewer.this.myDiffChanges) {
                if (!helper.process(diffChange.getStartLine(Side.LEFT), diffChange.getStartLine(Side.RIGHT))) {
                    return;
                }
                if (helper.process(diffChange.getEndLine(Side.LEFT), diffChange.getEndLine(Side.RIGHT))) continue;
                return;
            }
            helper.process(SimpleDiffViewer.this.getEditor1().getDocument().getLineCount(), SimpleDiffViewer.this.getEditor2().getDocument().getLineCount());
        }
    }

    private class ChangedLinesIterator
    extends BufferedLineIterator {
        @NotNull
        private final Side mySide;
        private int myIndex;

        private ChangedLinesIterator(Side side) {
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/simple/SimpleDiffViewer$ChangedLinesIterator", "<init>"));
            }
            this.myIndex = 0;
            this.mySide = side;
            this.init();
        }

        @Override
        public boolean hasNextBlock() {
            return this.myIndex < SimpleDiffViewer.this.myDiffChanges.size();
        }

        @Override
        public void loadNextBlock() {
            SimpleDiffChange change = (SimpleDiffChange)SimpleDiffViewer.this.myDiffChanges.get(this.myIndex);
            ++this.myIndex;
            int line1 = change.getStartLine(this.mySide);
            int line2 = change.getEndLine(this.mySide);
            EditorEx editor = SimpleDiffViewer.this.getEditor(this.mySide);
            assert (editor != null);
            Document document = editor.getDocument();
            for (int i = line1; i < line2; ++i) {
                int offset1 = document.getLineStartOffset(i);
                int offset2 = document.getLineEndOffset(i);
                CharSequence text = document.getImmutableCharSequence().subSequence(offset1, offset2);
                this.addLine(i, text);
            }
        }
    }

    private class AllLinesIterator
    implements Iterator<Pair<Integer, CharSequence>> {
        @NotNull
        private final Side mySide;
        @NotNull
        private final Document myDocument;
        private int myLine;

        private AllLinesIterator(Side side) {
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/simple/SimpleDiffViewer$AllLinesIterator", "<init>"));
            }
            this.myLine = 0;
            this.mySide = side;
            EditorEx editor = SimpleDiffViewer.this.getEditor(this.mySide);
            assert (editor != null);
            this.myDocument = editor.getDocument();
        }

        @Override
        public boolean hasNext() {
            return this.myLine < DiffUtil.getLineCount(this.myDocument);
        }

        @Override
        public Pair<Integer, CharSequence> next() {
            int offset1 = this.myDocument.getLineStartOffset(this.myLine);
            int offset2 = this.myDocument.getLineEndOffset(this.myLine);
            CharSequence text = this.myDocument.getImmutableCharSequence().subSequence(offset1, offset2);
            Pair pair = new Pair((Object)this.myLine, (Object)text);
            ++this.myLine;
            return pair;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class MyToggleExpandByDefaultAction
    extends TextDiffViewerBase.ToggleExpandByDefaultAction {
        private MyToggleExpandByDefaultAction() {
            super(SimpleDiffViewer.this);
        }

        @Override
        protected void expandAll(boolean expand) {
            if (SimpleDiffViewer.this.myFoldingModel != null) {
                SimpleDiffViewer.this.myFoldingModel.expandAll(expand);
            }
        }
    }

    private class RevertSelectedChangesAction
    extends ApplySelectedChangesActionBase {
        public RevertSelectedChangesAction() {
            super("Revert", null, AllIcons.Diff.Remove, false);
        }

        @Override
        @NotNull
        protected Icon getIcon(@NotNull Side side) {
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/simple/SimpleDiffViewer$RevertSelectedChangesAction", "getIcon"));
            }
            Icon icon = AllIcons.Diff.Remove;
            if (icon == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleDiffViewer$RevertSelectedChangesAction", "getIcon"));
            }
            return icon;
        }

        @Override
        protected void apply(@NotNull Side side, @NotNull List<SimpleDiffChange> changes) {
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/simple/SimpleDiffViewer$RevertSelectedChangesAction", "apply"));
            }
            if (changes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/diff/tools/simple/SimpleDiffViewer$RevertSelectedChangesAction", "apply"));
            }
            for (SimpleDiffChange change : changes) {
                SimpleDiffViewer.this.replaceChange(change, side.other());
            }
        }
    }

    private class AppendSelectedChangesAction
    extends ApplySelectedChangesActionBase {
        public AppendSelectedChangesAction() {
            super("Insert", null, AllIcons.Diff.ArrowLeftDown, true);
        }

        @Override
        @NotNull
        protected Icon getIcon(@NotNull Side side) {
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/simple/SimpleDiffViewer$AppendSelectedChangesAction", "getIcon"));
            }
            Icon icon = side.isLeft() ? AllIcons.Diff.ArrowRightDown : AllIcons.Diff.ArrowLeftDown;
            if (icon == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleDiffViewer$AppendSelectedChangesAction", "getIcon"));
            }
            return icon;
        }

        @Override
        protected void apply(@NotNull Side side, @NotNull List<SimpleDiffChange> changes) {
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/simple/SimpleDiffViewer$AppendSelectedChangesAction", "apply"));
            }
            if (changes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/diff/tools/simple/SimpleDiffViewer$AppendSelectedChangesAction", "apply"));
            }
            for (SimpleDiffChange change : changes) {
                SimpleDiffViewer.this.appendChange(change, side);
            }
        }
    }

    private class ReplaceSelectedChangesAction
    extends ApplySelectedChangesActionBase {
        public ReplaceSelectedChangesAction() {
            super("Replace", null, AllIcons.Diff.Arrow, true);
        }

        @Override
        @NotNull
        protected Icon getIcon(@NotNull Side side) {
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/simple/SimpleDiffViewer$ReplaceSelectedChangesAction", "getIcon"));
            }
            Icon icon = side.isLeft() ? AllIcons.Diff.ArrowRight : AllIcons.Diff.Arrow;
            if (icon == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleDiffViewer$ReplaceSelectedChangesAction", "getIcon"));
            }
            return icon;
        }

        @Override
        protected void apply(@NotNull Side side, @NotNull List<SimpleDiffChange> changes) {
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/simple/SimpleDiffViewer$ReplaceSelectedChangesAction", "apply"));
            }
            if (changes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/diff/tools/simple/SimpleDiffViewer$ReplaceSelectedChangesAction", "apply"));
            }
            for (SimpleDiffChange change : changes) {
                SimpleDiffViewer.this.replaceChange(change, side);
            }
        }
    }

    private abstract class ApplySelectedChangesActionBase
    extends AnAction
    implements DumbAware {
        private final boolean myModifyOpposite;

        public ApplySelectedChangesActionBase(@Nullable String text, @Nullable String description, Icon icon, boolean modifyOpposite) {
            super(text, description, icon);
            this.myModifyOpposite = modifyOpposite;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diff/tools/simple/SimpleDiffViewer$ApplySelectedChangesActionBase", "update"));
            }
            Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
            Side side = Side.fromLeft((editor == SimpleDiffViewer.this.getEditor1() ? 1 : 0) != 0);
            if (SimpleDiffViewer.this.getEditor1() == null || SimpleDiffViewer.this.getEditor2() == null) {
                e.getPresentation().setEnabledAndVisible(false);
                return;
            }
            if (editor != SimpleDiffViewer.this.getEditor1() && editor != SimpleDiffViewer.this.getEditor2()) {
                e.getPresentation().setEnabledAndVisible(false);
                return;
            }
            Editor modifiedEditor = (Editor)side.other(this.myModifyOpposite).select((Object)SimpleDiffViewer.this.getEditor1(), (Object)SimpleDiffViewer.this.getEditor2());
            if (!DiffUtil.isEditable(modifiedEditor)) {
                e.getPresentation().setEnabledAndVisible(false);
                return;
            }
            e.getPresentation().setIcon(this.getIcon(side));
            e.getPresentation().setEnabled(this.isSomeChangeSelected(side));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diff/tools/simple/SimpleDiffViewer$ApplySelectedChangesActionBase", "actionPerformed"));
            }
            assert (SimpleDiffViewer.this.getEditor1() != null && SimpleDiffViewer.this.getEditor2() != null);
            Editor editor = (Editor)e.getRequiredData(CommonDataKeys.EDITOR);
            final Side side = Side.fromLeft((editor == SimpleDiffViewer.this.getEditor1() ? 1 : 0) != 0);
            final List selectedChanges = SimpleDiffViewer.this.getSelectedChanges(side);
            Editor modifiedEditor = (Editor)side.other(this.myModifyOpposite).select((Object)SimpleDiffViewer.this.getEditor1(), (Object)SimpleDiffViewer.this.getEditor2());
            String title = e.getPresentation().getText() + " selected changes";
            DiffUtil.executeWriteCommand(modifiedEditor.getDocument(), e.getProject(), title, new Runnable(){

                @Override
                public void run() {
                    ApplySelectedChangesActionBase.this.apply(side, selectedChanges);
                }
            });
        }

        protected boolean isSomeChangeSelected(@NotNull Side side) {
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/simple/SimpleDiffViewer$ApplySelectedChangesActionBase", "isSomeChangeSelected"));
            }
            if (SimpleDiffViewer.this.myDiffChanges.isEmpty()) {
                return false;
            }
            EditorEx editor = SimpleDiffViewer.this.getEditor(side);
            if (editor == null) {
                return false;
            }
            List carets = editor.getCaretModel().getAllCarets();
            if (carets.size() != 1) {
                return true;
            }
            Caret caret = (Caret)carets.get(0);
            if (caret.hasSelection()) {
                return true;
            }
            int line = caret.getLogicalPosition().line;
            for (SimpleDiffChange change : SimpleDiffViewer.this.myDiffChanges) {
                if (!change.isSelectedByLine(line, side)) continue;
                return true;
            }
            return false;
        }

        @NotNull
        protected abstract Icon getIcon(@NotNull Side var1);

        protected abstract void apply(@NotNull Side var1, @NotNull List<SimpleDiffChange> var2);
    }

    private class MyReadOnlyLockAction
    extends TextDiffViewerBase.EditorReadOnlyLockAction {
        private MyReadOnlyLockAction() {
            super(SimpleDiffViewer.this);
        }

        @Override
        protected void doApply(boolean readOnly) {
            super.doApply(readOnly);
            for (SimpleDiffChange change : SimpleDiffViewer.this.myDiffChanges) {
                change.updateGutterActions(true);
            }
        }
    }

    private class MyPrevNextDifferenceIterable
    implements PrevNextDifferenceIterable {
        private MyPrevNextDifferenceIterable() {
        }

        @Override
        public boolean canGoNext() {
            EditorEx editor;
            if (SimpleDiffViewer.this.myDiffChanges.isEmpty()) {
                return false;
            }
            int line = editor.getCaretModel().getLogicalPosition().line;
            editor = SimpleDiffViewer.this.getCurrentEditor();
            if (line == editor.getDocument().getLineCount() - 1) {
                return false;
            }
            SimpleDiffChange lastChange = (SimpleDiffChange)SimpleDiffViewer.this.myDiffChanges.get(SimpleDiffViewer.this.myDiffChanges.size() - 1);
            return lastChange.getStartLine(SimpleDiffViewer.this.getCurrentSide()) > line;
        }

        @Override
        public void goNext() {
            EditorEx editor = SimpleDiffViewer.this.getCurrentEditor();
            int line = editor.getCaretModel().getLogicalPosition().line;
            SimpleDiffChange next = null;
            for (int i = 0; i < SimpleDiffViewer.this.myDiffChanges.size(); ++i) {
                SimpleDiffChange change = (SimpleDiffChange)SimpleDiffViewer.this.myDiffChanges.get(i);
                if (change.getStartLine(SimpleDiffViewer.this.getCurrentSide()) <= line) continue;
                next = change;
                break;
            }
            assert (next != null);
            SimpleDiffViewer.this.doScrollToChange(next, true);
        }

        @Override
        public boolean canGoPrev() {
            if (SimpleDiffViewer.this.myDiffChanges.isEmpty()) {
                return false;
            }
            EditorEx editor = SimpleDiffViewer.this.getCurrentEditor();
            int line = editor.getCaretModel().getLogicalPosition().line;
            if (line == 0) {
                return false;
            }
            SimpleDiffChange firstChange = (SimpleDiffChange)SimpleDiffViewer.this.myDiffChanges.get(0);
            if (firstChange.getEndLine(SimpleDiffViewer.this.getCurrentSide()) > line) {
                return false;
            }
            return firstChange.getStartLine(SimpleDiffViewer.this.getCurrentSide()) < line;
        }

        @Override
        public void goPrev() {
            EditorEx editor = SimpleDiffViewer.this.getCurrentEditor();
            int line = editor.getCaretModel().getLogicalPosition().line;
            SimpleDiffChange prev = null;
            for (int i = 0; i < SimpleDiffViewer.this.myDiffChanges.size(); ++i) {
                SimpleDiffChange next;
                SimpleDiffChange change = (SimpleDiffChange)SimpleDiffViewer.this.myDiffChanges.get(i);
                SimpleDiffChange simpleDiffChange = next = i < SimpleDiffViewer.this.myDiffChanges.size() - 1 ? (SimpleDiffChange)SimpleDiffViewer.this.myDiffChanges.get(i + 1) : null;
                if (next != null && next.getEndLine(SimpleDiffViewer.this.getCurrentSide()) <= line && next.getStartLine(SimpleDiffViewer.this.getCurrentSide()) < line) continue;
                prev = change;
                break;
            }
            assert (prev != null);
            SimpleDiffViewer.this.doScrollToChange(prev, true);
        }
    }
}

