/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.simple;

import com.intellij.diff.comparison.ComparisonManager;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.fragments.MergeLineFragment;
import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.TextDiffType;
import com.intellij.diff.util.ThreeSide;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.SeparatorPlacement;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleThreesideDiffChange {
    @NotNull
    private final MergeLineFragment myFragment;
    @NotNull
    private final List<? extends EditorEx> myEditors;
    @NotNull
    private ConflictType myType;
    @NotNull
    private final List<RangeHighlighter> myHighlighters;
    private int[] myLineStartShifts;
    private int[] myLineEndShifts;

    public SimpleThreesideDiffChange(@NotNull MergeLineFragment fragment, @NotNull List<? extends EditorEx> editors, @NotNull ComparisonPolicy policy) {
        if (fragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragment", "com/intellij/diff/tools/simple/SimpleThreesideDiffChange", "<init>"));
        }
        if (editors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editors", "com/intellij/diff/tools/simple/SimpleThreesideDiffChange", "<init>"));
        }
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/diff/tools/simple/SimpleThreesideDiffChange", "<init>"));
        }
        this.myHighlighters = new ArrayList<RangeHighlighter>();
        this.myLineStartShifts = new int[3];
        this.myLineEndShifts = new int[3];
        this.myFragment = fragment;
        this.myEditors = editors;
        this.myType = SimpleThreesideDiffChange.calcType(fragment, editors, policy);
        this.installHighlighter();
    }

    public void installHighlighter() {
        assert (this.myHighlighters.isEmpty());
        this.createHighlighter(ThreeSide.BASE);
        if (this.myType.isLeftChange()) {
            this.createHighlighter(ThreeSide.LEFT);
        }
        if (this.myType.isRightChange()) {
            this.createHighlighter(ThreeSide.RIGHT);
        }
    }

    public void destroyHighlighter() {
        for (RangeHighlighter highlighter : this.myHighlighters) {
            highlighter.dispose();
        }
        this.myHighlighters.clear();
    }

    private void createHighlighter(@NotNull ThreeSide side) {
        int start;
        int end;
        int endLine;
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/simple/SimpleThreesideDiffChange", "createHighlighter"));
        }
        Editor editor = (Editor)side.select(this.myEditors);
        Document document = editor.getDocument();
        TextDiffType type = this.getDiffType();
        int startLine = this.myFragment.getStartLine(side);
        if (startLine == (endLine = this.myFragment.getEndLine(side))) {
            end = startLine < DiffUtil.getLineCount(document) ? document.getLineStartOffset(startLine) : document.getTextLength();
            start = end;
        } else {
            start = document.getLineStartOffset(startLine);
            end = document.getLineEndOffset(endLine - 1);
            if (end < document.getTextLength()) {
                ++end;
            }
        }
        this.myHighlighters.add(DiffDrawUtil.createHighlighter(editor, start, end, type));
        if (startLine == endLine) {
            if (startLine != 0) {
                this.myHighlighters.add(DiffDrawUtil.createLineMarker(editor, endLine - 1, type, SeparatorPlacement.BOTTOM, true));
            }
        } else {
            this.myHighlighters.add(DiffDrawUtil.createLineMarker(editor, startLine, type, SeparatorPlacement.TOP));
            this.myHighlighters.add(DiffDrawUtil.createLineMarker(editor, endLine - 1, type, SeparatorPlacement.BOTTOM));
        }
    }

    public int getStartLine(@NotNull ThreeSide side) {
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/simple/SimpleThreesideDiffChange", "getStartLine"));
        }
        return this.myFragment.getStartLine(side) + side.select(this.myLineStartShifts);
    }

    public int getEndLine(@NotNull ThreeSide side) {
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/simple/SimpleThreesideDiffChange", "getEndLine"));
        }
        return this.myFragment.getEndLine(side) + side.select(this.myLineEndShifts);
    }

    @NotNull
    public TextDiffType getDiffType() {
        TextDiffType textDiffType = this.myType.getDiffType();
        if (textDiffType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleThreesideDiffChange", "getDiffType"));
        }
        return textDiffType;
    }

    @NotNull
    public ConflictType getType() {
        ConflictType conflictType = this.myType;
        if (conflictType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleThreesideDiffChange", "getType"));
        }
        return conflictType;
    }

    public boolean processChange(int oldLine1, int oldLine2, int shift, @NotNull ThreeSide side) {
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/simple/SimpleThreesideDiffChange", "processChange"));
        }
        int line1 = this.getStartLine(side);
        int line2 = this.getEndLine(side);
        if (line2 <= oldLine1) {
            return false;
        }
        if (line1 >= oldLine2) {
            int n = side.getIndex();
            this.myLineStartShifts[n] = this.myLineStartShifts[n] + shift;
            int n2 = side.getIndex();
            this.myLineEndShifts[n2] = this.myLineEndShifts[n2] + shift;
            return false;
        }
        if (line1 <= oldLine1 && line2 >= oldLine2) {
            int n = side.getIndex();
            this.myLineEndShifts[n] = this.myLineEndShifts[n] + shift;
            return false;
        }
        return true;
    }

    @NotNull
    private static ConflictType calcType(@NotNull MergeLineFragment fragment, @NotNull List<? extends EditorEx> editors, @NotNull ComparisonPolicy policy) {
        if (fragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragment", "com/intellij/diff/tools/simple/SimpleThreesideDiffChange", "calcType"));
        }
        if (editors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editors", "com/intellij/diff/tools/simple/SimpleThreesideDiffChange", "calcType"));
        }
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/diff/tools/simple/SimpleThreesideDiffChange", "calcType"));
        }
        boolean isLeftEmpty = SimpleThreesideDiffChange.isIntervalEmpty(fragment, ThreeSide.LEFT);
        boolean isBaseEmpty = SimpleThreesideDiffChange.isIntervalEmpty(fragment, ThreeSide.BASE);
        boolean isRightEmpty = SimpleThreesideDiffChange.isIntervalEmpty(fragment, ThreeSide.RIGHT);
        assert (!(isLeftEmpty && isBaseEmpty && isRightEmpty));
        if (isBaseEmpty) {
            if (isLeftEmpty) {
                ConflictType conflictType = new ConflictType(TextDiffType.INSERTED, false, true);
                if (conflictType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleThreesideDiffChange", "calcType"));
                }
                return conflictType;
            }
            if (isRightEmpty) {
                ConflictType conflictType = new ConflictType(TextDiffType.INSERTED, true, false);
                if (conflictType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleThreesideDiffChange", "calcType"));
                }
                return conflictType;
            }
            boolean equalModifications = SimpleThreesideDiffChange.compareLeftAndRight(fragment, editors, policy);
            ConflictType conflictType = new ConflictType(equalModifications ? TextDiffType.INSERTED : TextDiffType.CONFLICT);
            if (conflictType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleThreesideDiffChange", "calcType"));
            }
            return conflictType;
        }
        if (isLeftEmpty && isRightEmpty) {
            ConflictType conflictType = new ConflictType(TextDiffType.DELETED);
            if (conflictType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleThreesideDiffChange", "calcType"));
            }
            return conflictType;
        }
        boolean unchangedLeft = SimpleThreesideDiffChange.compareWithBase(fragment, editors, ThreeSide.LEFT);
        boolean unchangedRight = SimpleThreesideDiffChange.compareWithBase(fragment, editors, ThreeSide.RIGHT);
        assert (!unchangedLeft || !unchangedRight);
        if (unchangedLeft) {
            ConflictType conflictType = new ConflictType(isRightEmpty ? TextDiffType.DELETED : TextDiffType.MODIFIED, false, true);
            if (conflictType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleThreesideDiffChange", "calcType"));
            }
            return conflictType;
        }
        if (unchangedRight) {
            ConflictType conflictType = new ConflictType(isLeftEmpty ? TextDiffType.DELETED : TextDiffType.MODIFIED, true, false);
            if (conflictType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleThreesideDiffChange", "calcType"));
            }
            return conflictType;
        }
        boolean equalModifications = SimpleThreesideDiffChange.compareLeftAndRight(fragment, editors, policy);
        ConflictType conflictType = new ConflictType(equalModifications ? TextDiffType.MODIFIED : TextDiffType.CONFLICT);
        if (conflictType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleThreesideDiffChange", "calcType"));
        }
        return conflictType;
    }

    private static boolean compareLeftAndRight(@NotNull MergeLineFragment fragment, @NotNull List<? extends EditorEx> editors, @NotNull ComparisonPolicy policy) {
        if (fragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragment", "com/intellij/diff/tools/simple/SimpleThreesideDiffChange", "compareLeftAndRight"));
        }
        if (editors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editors", "com/intellij/diff/tools/simple/SimpleThreesideDiffChange", "compareLeftAndRight"));
        }
        if (policy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policy", "com/intellij/diff/tools/simple/SimpleThreesideDiffChange", "compareLeftAndRight"));
        }
        CharSequence content1 = SimpleThreesideDiffChange.getRangeContent(fragment, editors, ThreeSide.LEFT);
        CharSequence content2 = SimpleThreesideDiffChange.getRangeContent(fragment, editors, ThreeSide.RIGHT);
        if (policy == ComparisonPolicy.IGNORE_WHITESPACES) {
            if (content1 == null) {
                content1 = "";
            }
            if (content2 == null) {
                content2 = "";
            }
        }
        if (content1 == null && content2 == null) {
            return true;
        }
        if (content1 == null ^ content2 == null) {
            return false;
        }
        return ComparisonManager.getInstance().isEquals(content1, content2, policy);
    }

    private static boolean compareWithBase(@NotNull MergeLineFragment fragment, @NotNull List<? extends EditorEx> editors, @NotNull ThreeSide side) {
        if (fragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragment", "com/intellij/diff/tools/simple/SimpleThreesideDiffChange", "compareWithBase"));
        }
        if (editors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editors", "com/intellij/diff/tools/simple/SimpleThreesideDiffChange", "compareWithBase"));
        }
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/simple/SimpleThreesideDiffChange", "compareWithBase"));
        }
        CharSequence content1 = SimpleThreesideDiffChange.getRangeContent(fragment, editors, ThreeSide.BASE);
        CharSequence content2 = SimpleThreesideDiffChange.getRangeContent(fragment, editors, side);
        return StringUtil.equals((CharSequence)content1, (CharSequence)content2);
    }

    @Nullable
    private static CharSequence getRangeContent(@NotNull MergeLineFragment fragment, @NotNull List<? extends EditorEx> editors, @NotNull ThreeSide side) {
        int line2;
        if (fragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragment", "com/intellij/diff/tools/simple/SimpleThreesideDiffChange", "getRangeContent"));
        }
        if (editors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editors", "com/intellij/diff/tools/simple/SimpleThreesideDiffChange", "getRangeContent"));
        }
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/simple/SimpleThreesideDiffChange", "getRangeContent"));
        }
        DocumentEx document = ((EditorEx)side.select(editors)).getDocument();
        int line1 = fragment.getStartLine(side);
        if (line1 == (line2 = fragment.getEndLine(side))) {
            return null;
        }
        return DiffUtil.getLinesContent(document, line1, line2);
    }

    private static boolean isIntervalEmpty(@NotNull MergeLineFragment fragment, @NotNull ThreeSide side) {
        if (fragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragment", "com/intellij/diff/tools/simple/SimpleThreesideDiffChange", "isIntervalEmpty"));
        }
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/simple/SimpleThreesideDiffChange", "isIntervalEmpty"));
        }
        return fragment.getStartLine(side) == fragment.getEndLine(side);
    }

    public static class ConflictType {
        @NotNull
        private final TextDiffType myType;
        private final boolean myLeftChange;
        private final boolean myRightChange;

        public ConflictType(@NotNull TextDiffType type) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/diff/tools/simple/SimpleThreesideDiffChange$ConflictType", "<init>"));
            }
            this(type, true, true);
        }

        public ConflictType(@NotNull TextDiffType type, boolean leftChange, boolean rightChange) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/diff/tools/simple/SimpleThreesideDiffChange$ConflictType", "<init>"));
            }
            this.myType = type;
            this.myLeftChange = leftChange;
            this.myRightChange = rightChange;
        }

        @NotNull
        public TextDiffType getDiffType() {
            TextDiffType textDiffType = this.myType;
            if (textDiffType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleThreesideDiffChange$ConflictType", "getDiffType"));
            }
            return textDiffType;
        }

        public boolean isLeftChange() {
            return this.myLeftChange;
        }

        public boolean isRightChange() {
            return this.myRightChange;
        }

        public boolean isChange(@NotNull Side side) {
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/simple/SimpleThreesideDiffChange$ConflictType", "isChange"));
            }
            return side.isLeft() ? this.myLeftChange : this.myRightChange;
        }
    }
}

