/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.actions;

import com.intellij.execution.actions.StopAction;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.project.DumbAwareAction;
import java.io.IOException;
import java.io.OutputStream;
import org.jetbrains.annotations.NonNls;

public class EOFAction
extends DumbAwareAction
implements AnAction.TransparentUpdate {
    @NonNls
    public static final String ACTION_ID = "SendEOF";

    public void update(AnActionEvent e) {
        ProcessHandler handler = StopAction.getHandler(e.getDataContext());
        e.getPresentation().setEnabledAndVisible(e.getData(LangDataKeys.CONSOLE_VIEW) != null && e.getData(CommonDataKeys.EDITOR) != null && handler != null && !handler.isProcessTerminated());
    }

    public void actionPerformed(AnActionEvent e) {
        ProcessHandler activeProcessHandler = StopAction.getHandler(e.getDataContext());
        if (activeProcessHandler == null || activeProcessHandler.isProcessTerminated()) {
            return;
        }
        try {
            OutputStream input = activeProcessHandler.getProcessInput();
            if (input != null) {
                ConsoleView console = (ConsoleView)e.getData(LangDataKeys.CONSOLE_VIEW);
                if (console != null) {
                    console.print("^D\n", ConsoleViewContentType.SYSTEM_OUTPUT);
                }
                input.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

