/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.ui;

import com.intellij.execution.ExecutionBundle;
import com.intellij.openapi.progress.util.ColorProgressBar;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.JBProgressBar;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.JBDimension;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class TestStatusLine
extends JPanel {
    private static final SimpleTextAttributes IGNORE_ATTRIBUTES = new SimpleTextAttributes(0, ColorProgressBar.YELLOW);
    private static final SimpleTextAttributes ERROR_ATTRIBUTES = new SimpleTextAttributes(0, ColorProgressBar.RED);
    protected final JProgressBar myProgressBar = new JBProgressBar();
    protected final SimpleColoredComponent myState = new SimpleColoredComponent();

    public TestStatusLine() {
        super(new BorderLayout());
        JPanel progressPanel = new JPanel(new GridBagLayout());
        this.add((Component)progressPanel, "West");
        this.myProgressBar.setMaximum(100);
        JBDimension size = new JBDimension(450, -1);
        progressPanel.setMaximumSize((Dimension)size);
        progressPanel.setMinimumSize((Dimension)size);
        progressPanel.setPreferredSize((Dimension)size);
        progressPanel.add((Component)this.myProgressBar, new GridBagConstraints(0, 0, 0, 0, 1.0, 1.0, 10, 2, new Insets(2, 8, 0, 8), 0, 0));
        this.setStatusColor(ColorProgressBar.GREEN);
        this.add((Component)this.myState, "Center");
        this.myState.append(ExecutionBundle.message((String)"junit.runing.info.starting.label", (Object[])new Object[0]));
    }

    public void formatTestMessage(int testsTotal, int finishedTestsCount, int failuresCount, int ignoredTestsCount, Long duration, long endTime) {
        this.myState.clear();
        if (testsTotal == 0) {
            return;
        }
        if (duration == null || endTime == 0L) {
            this.myState.append(finishedTestsCount + " of " + TestStatusLine.getTestsTotalMessage(testsTotal) + (failuresCount + ignoredTestsCount > 0 ? ": " : ""));
            this.appendFailuresAndIgnores(failuresCount, ignoredTestsCount);
            return;
        }
        String result = "";
        if (finishedTestsCount == testsTotal) {
            if (testsTotal > 1 && (failuresCount == 0 && ignoredTestsCount == 0 || failuresCount == testsTotal || ignoredTestsCount == testsTotal)) {
                result = "All ";
            }
        } else {
            result = "Stopped. " + finishedTestsCount + " of ";
        }
        result = result + TestStatusLine.getTestsTotalMessage(testsTotal);
        if (failuresCount == 0 && ignoredTestsCount == 0) {
            this.myState.append(result + " passed");
        } else if (failuresCount == finishedTestsCount) {
            this.myState.append(result + " failed", ERROR_ATTRIBUTES);
        } else if (ignoredTestsCount == finishedTestsCount) {
            this.myState.append(result + " ignored", IGNORE_ATTRIBUTES);
        } else {
            this.myState.append(result + " done: ");
            this.appendFailuresAndIgnores(failuresCount, ignoredTestsCount);
        }
        this.myState.append(" \u2013 " + StringUtil.formatDuration((long)duration), SimpleTextAttributes.GRAY_ATTRIBUTES);
    }

    private static String getTestsTotalMessage(int testsTotal) {
        return testsTotal + " test" + (testsTotal > 1 ? "s" : "");
    }

    private void appendFailuresAndIgnores(int failuresCount, int ignoredTestsCount) {
        if (failuresCount > 0) {
            this.myState.append(failuresCount + " failed", ERROR_ATTRIBUTES);
        }
        if (ignoredTestsCount > 0) {
            if (failuresCount > 0) {
                this.myState.append(", ", ERROR_ATTRIBUTES);
            }
            this.myState.append(ignoredTestsCount + " ignored", IGNORE_ATTRIBUTES);
        }
    }

    public void setStatusColor(Color color) {
        this.myProgressBar.setForeground(color);
    }

    public Color getStatusColor() {
        return this.myProgressBar.getForeground();
    }

    public void setFraction(double v) {
        int fraction = (int)(v * 100.0);
        this.myProgressBar.setValue(fraction);
    }

    public void setText(String progressStatus_text) {
        this.myState.clear();
        this.myState.append(progressStatus_text);
    }
}

