/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.editorHeaderActions;

import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.find.EditorSearchComponent;
import com.intellij.find.editorHeaderActions.Utils;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.psi.impl.cache.impl.id.IdTableBuilding;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBList;
import com.intellij.util.ArrayUtil;
import com.intellij.util.text.Matcher;
import com.intellij.util.ui.GraphicsUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import javax.swing.JList;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.Nullable;

public class VariantsCompletionAction
extends AnAction {
    private Getter<JTextComponent> myTextField;
    private final EditorSearchComponent myEditorSearchComponent;

    public EditorSearchComponent getEditorSearchComponent() {
        return this.myEditorSearchComponent;
    }

    public VariantsCompletionAction(EditorSearchComponent editorSearchComponent, Getter<JTextComponent> textField) {
        this.myEditorSearchComponent = editorSearchComponent;
        AnAction action = ActionManager.getInstance().getAction("CodeCompletion");
        this.setTextField(textField);
        if (action != null) {
            this.registerCustomShortcutSet(action.getShortcutSet(), this.getTextField());
        }
    }

    public void actionPerformed(AnActionEvent e) {
        String prefix = this.getPrefix();
        if (StringUtil.isEmpty((String)prefix)) {
            return;
        }
        Editor editor = this.getEditorSearchComponent().getEditor();
        if (editor != null) {
            Object[] array = VariantsCompletionAction.calcWords(prefix, editor);
            if (array.length == 0) {
                return;
            }
            FeatureUsageTracker.getInstance().triggerFeatureUsed("find.completion");
            JBList list = new JBList(array){

                protected void paintComponent(Graphics g) {
                    GraphicsUtil.setupAntialiasing((Graphics)g);
                    super.paintComponent(g);
                }
            };
            list.setBackground((Color)new JBColor(EditorSearchComponent.COMPLETION_BACKGROUND_COLOR, new Color(5001041)));
            list.setFont(editor.getColorsScheme().getFont(EditorFontType.PLAIN));
            Utils.showCompletionPopup(e.getInputEvent() instanceof MouseEvent ? this.getEditorSearchComponent().getToolbarComponent() : null, (JList)list, null, this.getTextField(), null);
        }
    }

    @Nullable
    private String getPrefix() {
        int offset = this.getTextField().getCaretPosition();
        return this.getTextField().getText().substring(0, offset);
    }

    public JTextComponent getTextField() {
        return (JTextComponent)this.myTextField.get();
    }

    public void setTextField(Getter<JTextComponent> textField) {
        this.myTextField = textField;
    }

    private static String[] calcWords(String prefix, Editor editor) {
        final Matcher matcher = NameUtil.buildMatcher((String)prefix, (int)0, (boolean)true, (boolean)true);
        final HashSet words = new HashSet();
        CharSequence chars = editor.getDocument().getCharsSequence();
        IdTableBuilding.scanWords(new IdTableBuilding.ScanWordProcessor(){

            @Override
            public void run(CharSequence chars, @Nullable char[] charsArray, int start, int end) {
                String word = chars.subSequence(start, end).toString();
                if (matcher.matches(word)) {
                    words.add(word);
                }
            }
        }, chars, 0, chars.length());
        ArrayList sortedWords = new ArrayList(words);
        Collections.sort(sortedWords);
        return ArrayUtil.toStringArray(sortedWords);
    }
}

