/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.passwordSafe.impl.providers.masterKey;

import com.intellij.ide.passwordSafe.impl.providers.masterKey.MasterKeyPasswordSafe;
import com.intellij.ide.passwordSafe.impl.providers.masterKey.PasswordComponentBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.util.ui.DialogUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JLabel;

public class ResetPasswordComponent
extends PasswordComponentBase {
    private final boolean myFirstTime;

    public ResetPasswordComponent(MasterKeyPasswordSafe safe, boolean firstTime) {
        super(safe, firstTime ? "Setup" : "Reset");
        this.myFirstTime = firstTime;
        UIUtil.setEnabled((Component)this.myPasswordPanel, (boolean)false, (boolean)true);
        this.myPasswordPanel.setVisible(false);
        if (firstTime) {
            this.myNewPasswordLabel.setText(this.myPasswordLabel.getText());
            this.myNewPasswordLabel.setDisplayedMnemonic(this.myPasswordLabel.getDisplayedMnemonic());
            this.myNewPasswordLabel.setDisplayedMnemonicIndex(this.myPasswordLabel.getDisplayedMnemonicIndex());
            DialogUtil.registerMnemonic((JLabel)this.myPasswordLabel, null);
            this.myPromptLabel.setText("<html><br>Specify the new password for the password database.<br>Leave blank to disable the master password protection.</html>");
        } else {
            this.myPromptLabel.setText("<html><br>The password for the password database will be reset.<br><b>All previously stored passwords will be removed!</b></html>");
        }
    }

    @Override
    public String getHelpId() {
        return this.myFirstTime ? "settings_passwords_master_password_init" : "settings_passwords_master_password_reset";
    }

    @Override
    public boolean apply() {
        if (this.myFirstTime || Messages.showYesNoDialog((Project)null, (String)"All stored passwords will be removed! Are you sure you want to proceed?", (String)"Confirm Master Password Reset", (Icon)Messages.getWarningIcon()) == 0) {
            this.mySafe.resetMasterPassword(new String(this.myNewPasswordField.getPassword()), this.myEncryptCheckBox.isSelected());
            return true;
        }
        return false;
    }
}

