/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.idea;

import com.intellij.CommonBundle;
import com.intellij.idea.Main;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.Consumer;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.net.NetUtils;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SocketLock {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.idea.SocketLock");
    public static final int SOCKET_NUMBER_START = 6942;
    public static final int SOCKET_NUMBER_END = 6992;
    private static final int[] FORBIDDEN_PORTS = new int[]{6953, 6969, 6970};
    private final ServerSocket serverSocket;
    private final String[] myLockedPaths = new String[2];
    @NonNls
    private static final String LOCK_THREAD_NAME = "Lock thread";
    @NonNls
    private static final String ACTIVATE_COMMAND = "activate ";
    private final int acquiredPort;
    private volatile Consumer<List<String>> activateListener;

    public SocketLock() {
        this.serverSocket = SocketLock.acquireSocket();
        if (this.serverSocket == null) {
            String productName = ApplicationNamesInfo.getInstance().getProductName();
            if (Main.isHeadless()) {
                throw new RuntimeException("Only one instance of " + productName + " can be run at a time.");
            }
            String pathToLogFile = PathManager.getLogPath() + "/idea.log file".replace('/', File.separatorChar);
            JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), CommonBundle.message((String)"cannot.start.other.instance.is.running.error.message", (Object[])new Object[]{productName, pathToLogFile}), CommonBundle.message((String)"title.warning", (Object[])new Object[0]), 2);
            this.acquiredPort = -1;
        } else {
            this.acquiredPort = this.serverSocket.getLocalPort();
            Thread thread = new Thread((Runnable)new MyRunnable(), LOCK_THREAD_NAME);
            thread.setPriority(1);
            thread.start();
        }
    }

    public void setExternalInstanceListener(@Nullable Consumer<List<String>> consumer) {
        this.activateListener = consumer;
    }

    public void dispose() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("enter: destroyProcess()");
        }
        try {
            this.serverSocket.close();
        }
        catch (IOException e) {
            LOG.debug((Throwable)e);
        }
    }

    public int getAcquiredPort() {
        return this.acquiredPort;
    }

    private static void lockPortMarker(@NotNull File parent, @NotNull List<Closeable> list) throws IOException {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/idea/SocketLock", "lockPortMarker"));
        }
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/idea/SocketLock", "lockPortMarker"));
        }
        FileUtilRt.createDirectory((File)parent);
        FileOutputStream stream = new FileOutputStream(new File(parent, "port.lock"), true);
        list.add(stream);
        stream.getChannel().lock();
    }

    private static void addExistingPort(@NotNull File portMarker, @NotNull String path, @NotNull MultiMap<Integer, String> portToPath) {
        if (portMarker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "portMarker", "com/intellij/idea/SocketLock", "addExistingPort"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/idea/SocketLock", "addExistingPort"));
        }
        if (portToPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "portToPath", "com/intellij/idea/SocketLock", "addExistingPort"));
        }
        if (portMarker.exists()) {
            try {
                portToPath.putValue((Object)Integer.parseInt(FileUtilRt.loadFile((File)portMarker)), (Object)path);
            }
            catch (Throwable e) {
                LOG.debug(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public ActivateStatus lock(@NotNull String configPath, @NotNull String systemPath, String ... args) {
        File portMarkerS;
        File portMarkerC;
        block23: {
            ActivateStatus activateStatus;
            ArrayList<Closeable> closeables;
            block22: {
                if (configPath == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configPath", "com/intellij/idea/SocketLock", "lock"));
                }
                if (systemPath == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "systemPath", "com/intellij/idea/SocketLock", "lock"));
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("enter: lock(configPath='" + configPath + "', systemPath='" + systemPath + "')");
                }
                File config = new File(configPath);
                File system = new File(systemPath);
                portMarkerC = new File(config, "port");
                portMarkerS = new File(system, "port");
                closeables = new ArrayList<Closeable>();
                try {
                    SocketLock.lockPortMarker(config, closeables);
                    SocketLock.lockPortMarker(system, closeables);
                    MultiMap portToPath = MultiMap.createSmart();
                    SocketLock.addExistingPort(portMarkerC, configPath, (MultiMap<Integer, String>)portToPath);
                    SocketLock.addExistingPort(portMarkerS, systemPath, (MultiMap<Integer, String>)portToPath);
                    if (!portToPath.isEmpty()) {
                        for (Map.Entry entry : portToPath.entrySet()) {
                            ActivateStatus status = SocketLock.tryActivate((Integer)entry.getKey(), (Collection)entry.getValue(), args);
                            if (status == ActivateStatus.NO_INSTANCE) continue;
                            ActivateStatus activateStatus2 = status;
                            activateStatus = activateStatus2;
                            break block22;
                        }
                    }
                    byte[] portBytes = Integer.toString(this.acquiredPort).getBytes(CharsetToolkit.UTF8_CHARSET);
                    FileUtil.writeToFile((File)portMarkerC, (byte[])portBytes);
                    FileUtil.writeToFile((File)portMarkerS, (byte[])portBytes);
                    this.myLockedPaths[0] = configPath;
                    this.myLockedPaths[1] = systemPath;
                    break block23;
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                }
            }
            if (activateStatus == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/idea/SocketLock", "lock"));
            }
            return activateStatus;
            finally {
                for (Closeable closeable : closeables) {
                    try {
                        closeable.close();
                    }
                    catch (Throwable e) {
                        LOG.error(e);
                    }
                }
            }
        }
        portMarkerC.deleteOnExit();
        portMarkerS.deleteOnExit();
        ActivateStatus activateStatus = ActivateStatus.NO_INSTANCE;
        if (activateStatus == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/idea/SocketLock", "lock"));
        }
        return activateStatus;
    }

    public static boolean isPortForbidden(int port) {
        for (int forbiddenPort : FORBIDDEN_PORTS) {
            if (port != forbiddenPort) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @NotNull
    private static ActivateStatus tryActivate(int portNumber, @NotNull Collection<String> paths, @NotNull String[] args) {
        block32: {
            if (paths == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paths", "com/intellij/idea/SocketLock", "tryActivate"));
            }
            if (args == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "com/intellij/idea/SocketLock", "tryActivate"));
            }
            Socket socket = null;
            try {
                socket = new Socket(NetUtils.getLoopbackAddress(), portNumber);
                socket.setSoTimeout(300);
                boolean result = false;
                DataInputStream in = new DataInputStream(socket.getInputStream());
                try {
                    while (true) {
                        String path;
                        if (!paths.contains(path = in.readUTF())) {
                            continue;
                        }
                        result = true;
                    }
                }
                catch (IOException ignored) {
                    block33: {
                        ActivateStatus activateStatus;
                        block31: {
                            block34: {
                                block29: {
                                    ActivateStatus activateStatus2;
                                    block30: {
                                        if (!result) break block33;
                                        DataOutputStream out = new DataOutputStream(socket.getOutputStream());
                                        out.writeUTF(ACTIVATE_COMMAND + new File(".").getAbsolutePath() + "\u0000" + StringUtil.join((String[])args, (String)"\u0000"));
                                        out.flush();
                                        String response = in.readUTF();
                                        if (!response.equals("ok")) break block29;
                                        activateStatus2 = ActivateStatus.ACTIVATED;
                                        if (socket == null) break block30;
                                        try {
                                            socket.close();
                                        }
                                        catch (IOException e) {
                                            LOG.debug((Throwable)e);
                                        }
                                    }
                                    ActivateStatus activateStatus3 = activateStatus2;
                                    if (activateStatus3 == null) {
                                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/idea/SocketLock", "tryActivate"));
                                    }
                                    return activateStatus3;
                                }
                                break block34;
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            }
                            activateStatus = ActivateStatus.CANNOT_ACTIVATE;
                            if (socket == null) break block31;
                            try {
                                socket.close();
                            }
                            catch (IOException e) {
                                LOG.debug((Throwable)e);
                            }
                        }
                        ActivateStatus activateStatus4 = activateStatus;
                        if (activateStatus4 == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/idea/SocketLock", "tryActivate"));
                        }
                        return activateStatus4;
                    }
                    if (socket != null) {
                        try {
                            socket.close();
                        }
                        catch (IOException e) {
                            LOG.debug((Throwable)e);
                        }
                    }
                    break block32;
                    catch (IOException e) {
                        LOG.debug((Throwable)e);
                    }
                }
            }
            finally {
                if (socket != null) {
                    try {
                        socket.close();
                    }
                    catch (IOException e) {
                        LOG.debug((Throwable)e);
                    }
                }
            }
        }
        ActivateStatus activateStatus = ActivateStatus.NO_INSTANCE;
        if (activateStatus == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/idea/SocketLock", "tryActivate"));
        }
        return activateStatus;
    }

    @Nullable
    private static ServerSocket acquireSocket() {
        for (int i = 6942; i < 6992; ++i) {
            try {
                if (SocketLock.isPortForbidden(i)) continue;
                return new ServerSocket(i, 50, NetUtils.getLoopbackAddress());
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
            }
        }
        return null;
    }

    private class MyRunnable
    implements Runnable {
        private MyRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                while (true) {
                    try {
                        while (true) {
                            Socket socket = SocketLock.this.serverSocket.accept();
                            socket.setSoTimeout(800);
                            DataOutputStream out = new DataOutputStream(socket.getOutputStream());
                            SocketLock socketLock = SocketLock.this;
                            synchronized (socketLock) {
                                for (String path : SocketLock.this.myLockedPaths) {
                                    if (path == null) continue;
                                    out.writeUTF(path);
                                }
                            }
                            DataInputStream stream = new DataInputStream(socket.getInputStream());
                            String command = stream.readUTF();
                            if (command.startsWith(SocketLock.ACTIVATE_COMMAND)) {
                                List args = StringUtil.split((String)command.substring(SocketLock.ACTIVATE_COMMAND.length()), (String)"\u0000");
                                Consumer listener = SocketLock.this.activateListener;
                                if (listener != null) {
                                    listener.consume((Object)args);
                                }
                                out.writeUTF("ok");
                            }
                            out.close();
                        }
                    }
                    catch (IOException e) {
                        LOG.debug((Throwable)e);
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable throwable) {
                return;
            }
        }
    }

    public static enum ActivateStatus {
        ACTIVATED,
        NO_INSTANCE,
        CANNOT_ACTIVATE;

    }
}

