/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.codeinsight;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonProperty;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;

public class JsonCompletionContributor
extends CompletionContributor {
    private static final Logger LOG = Logger.getInstance(JsonCompletionContributor.class);
    private static final PsiElementPattern.Capture<PsiElement> AFTER_COLON_IN_PROPERTY = (PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().afterLeaf(new String[]{":"})).withSuperParent(2, JsonProperty.class);
    private static final PsiElementPattern.Capture<PsiElement> AFTER_COMMA_OR_BRACKET_IN_ARRAY = (PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().afterLeaf(new String[]{"[", ","})).withSuperParent(2, JsonArray.class);

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/json/codeinsight/JsonCompletionContributor", "fillCompletionVariants"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/json/codeinsight/JsonCompletionContributor", "fillCompletionVariants"));
        }
        LOG.debug(DebugUtil.psiToString((PsiElement)parameters.getPosition().getContainingFile(), true));
        super.fillCompletionVariants(parameters, result);
    }

    public JsonCompletionContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)AFTER_COLON_IN_PROPERTY, MyKeywordsCompletionProvider.INSTANCE);
        this.extend(CompletionType.BASIC, (ElementPattern)AFTER_COMMA_OR_BRACKET_IN_ARRAY, MyKeywordsCompletionProvider.INSTANCE);
    }

    private static class MyKeywordsCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private static final MyKeywordsCompletionProvider INSTANCE = new MyKeywordsCompletionProvider();
        private static final String[] KEYWORDS = new String[]{"null", "true", "false"};

        private MyKeywordsCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
            if (parameters == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/json/codeinsight/JsonCompletionContributor$MyKeywordsCompletionProvider", "addCompletions"));
            }
            if (result == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/json/codeinsight/JsonCompletionContributor$MyKeywordsCompletionProvider", "addCompletions"));
            }
            for (String keyword : KEYWORDS) {
                result.addElement((LookupElement)LookupElementBuilder.create((String)keyword).bold());
            }
        }
    }
}

