/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.task.ui;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.TreeState;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionToolbarPosition;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.externalSystem.ExternalSystemUiAware;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.task.TaskData;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManager;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalSystemTaskActivator;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataManager;
import com.intellij.openapi.externalSystem.service.project.manage.TaskActivationState;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemUiUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.AnActionButtonUpdater;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.treeStructure.CachingSimpleNode;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.ui.treeStructure.SimpleTree;
import com.intellij.ui.treeStructure.SimpleTreeStructure;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.SwingHelper;
import gnu.trove.THashSet;
import icons.ExternalSystemIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigureTasksActivationDialog
extends DialogWrapper {
    @NotNull
    private final Project myProject;
    @NotNull
    private final ExternalSystemTaskActivator myTaskActivator;
    @NotNull
    ProjectSystemId myProjectSystemId;
    private JPanel contentPane;
    private JPanel tasksPanel;
    private JPanel projectFieldPanel;
    private SimpleTree myTree;
    private AbstractTreeBuilder treeBuilder;
    private ComboBox projectCombobox;
    @NotNull
    private final ExternalSystemUiAware uiAware;
    private RootNode myRootNode;

    public ConfigureTasksActivationDialog(@NotNull Project project, @NotNull ProjectSystemId externalSystemId, @NotNull String projectPath) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/task/ui/ConfigureTasksActivationDialog", "<init>"));
        }
        if (externalSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalSystemId", "com/intellij/openapi/externalSystem/service/task/ui/ConfigureTasksActivationDialog", "<init>"));
        }
        if (projectPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectPath", "com/intellij/openapi/externalSystem/service/task/ui/ConfigureTasksActivationDialog", "<init>"));
        }
        super(project, true);
        this.myProject = project;
        this.myProjectSystemId = externalSystemId;
        this.$$$setupUI$$$();
        this.uiAware = ExternalSystemUiUtil.getUiAware(this.myProjectSystemId);
        this.setUpDialog(projectPath);
        this.setModal(true);
        this.setTitle(ExternalSystemBundle.message((String)"external.system.task.activation.title", (Object[])new Object[]{externalSystemId.getReadableName()}));
        this.init();
        this.myTaskActivator = ExternalProjectsManager.getInstance(this.myProject).getTaskActivator();
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{this.getOKAction()};
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/task/ui/ConfigureTasksActivationDialog", "createActions"));
        }
        return actionArray;
    }

    private void setUpDialog(@NotNull String projectPath) {
        if (projectPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectPath", "com/intellij/openapi/externalSystem/service/task/ui/ConfigureTasksActivationDialog", "setUpDialog"));
        }
        AbstractExternalSystemSettings externalSystemSettings = ExternalSystemApiUtil.getSettings((Project)this.myProject, (ProjectSystemId)this.myProjectSystemId);
        Collection projectsSettings = externalSystemSettings.getLinkedProjectsSettings();
        List projects = ContainerUtil.map((Collection)projectsSettings, (Function)new Function<ExternalProjectSettings, ProjectItem>(){

            public ProjectItem fun(ExternalProjectSettings settings) {
                return new ProjectItem(ConfigureTasksActivationDialog.this.uiAware.getProjectRepresentationName(settings.getExternalProjectPath(), null), settings);
            }
        });
        this.myTree = new SimpleTree();
        this.myRootNode = new RootNode();
        this.treeBuilder = ConfigureTasksActivationDialog.createTreeBuilder(this.myProject, (SimpleNode)this.myRootNode, (Tree)this.myTree);
        ExternalProjectSettings currentProjectSettings = externalSystemSettings.getLinkedProjectSettings(projectPath);
        if (currentProjectSettings != null) {
            SwingHelper.updateItems((JComboBox)this.projectCombobox, projects, new ProjectItem(this.uiAware.getProjectRepresentationName(projectPath, null), currentProjectSettings));
        }
        this.projectCombobox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfigureTasksActivationDialog.this.updateTree(ConfigureTasksActivationDialog.this.myRootNode);
            }
        });
    }

    private static AbstractTreeBuilder createTreeBuilder(@NotNull Project project, @NotNull SimpleNode root, @NotNull Tree tree) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/task/ui/ConfigureTasksActivationDialog", "createTreeBuilder"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/openapi/externalSystem/service/task/ui/ConfigureTasksActivationDialog", "createTreeBuilder"));
        }
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/openapi/externalSystem/service/task/ui/ConfigureTasksActivationDialog", "createTreeBuilder"));
        }
        DefaultTreeModel treeModel = new DefaultTreeModel(new DefaultMutableTreeNode(root));
        tree.setModel((TreeModel)treeModel);
        tree.setRootVisible(false);
        tree.getSelectionModel().setSelectionMode(4);
        AbstractTreeBuilder treeBuilder = new AbstractTreeBuilder((JTree)tree, treeModel, (AbstractTreeStructure)new SimpleTreeStructure.Impl(root), null);
        Disposer.register((Disposable)project, (Disposable)treeBuilder);
        return treeBuilder;
    }

    protected JComponent createCenterPanel() {
        ToolbarDecorator decorator = ToolbarDecorator.createDecorator((JTree)this.myTree).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                ChooseProjectStep step;
                ProjectItem projectItem = (ProjectItem)ConfigureTasksActivationDialog.this.projectCombobox.getSelectedItem();
                if (projectItem == null) {
                    return;
                }
                ExternalProjectInfo projectData = ProjectDataManager.getInstance().getExternalProjectData(ConfigureTasksActivationDialog.this.myProject, ConfigureTasksActivationDialog.this.myProjectSystemId, projectItem.myProjectSettings.getExternalProjectPath());
                if (projectData == null || projectData.getExternalProjectStructure() == null) {
                    return;
                }
                ArrayList popupItems = ContainerUtil.newArrayList();
                for (DataNode moduleDataNode : ExternalSystemApiUtil.findAllRecursively((DataNode)projectData.getExternalProjectStructure(), (Key)ProjectKeys.MODULE)) {
                    List tasks = ContainerUtil.map((Collection)ExternalSystemApiUtil.findAll((DataNode)moduleDataNode, (Key)ProjectKeys.TASK), (Function)new Function<DataNode<TaskData>, String>(){

                        public String fun(DataNode<TaskData> node) {
                            return ((TaskData)node.getData()).getName();
                        }
                    });
                    if (tasks.isEmpty()) continue;
                    popupItems.add(new ProjectPopupItem((ModuleData)moduleDataNode.getData(), tasks));
                }
                ChooseProjectStep projectStep = new ChooseProjectStep(popupItems);
                List projectItems = projectStep.getValues();
                ChooseProjectStep chooseProjectStep = step = projectItems.size() == 1 ? (ListPopupStep)projectStep.onChosen((ProjectPopupItem)projectItems.get(0), false) : projectStep;
                assert (step != null);
                JBPopupFactory.getInstance().createListPopup((ListPopupStep)step).show((RelativePoint)ObjectUtils.notNull((Object)button.getPreferredPopupPoint(), (Object)RelativePoint.getSouthEastOf((JComponent)ConfigureTasksActivationDialog.this.projectCombobox)));
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                List tasks = ConfigureTasksActivationDialog.this.findSelectedTasks();
                ConfigureTasksActivationDialog.this.myTaskActivator.removeTasks(tasks);
                ConfigureTasksActivationDialog.this.updateTree(null);
            }
        }).setMoveUpAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                ConfigureTasksActivationDialog.this.moveAction(-1);
            }
        }).setMoveUpActionUpdater(new AnActionButtonUpdater(){

            public boolean isEnabled(AnActionEvent e) {
                return ConfigureTasksActivationDialog.this.isMoveActionEnabled(-1);
            }
        }).setMoveDownAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                ConfigureTasksActivationDialog.this.moveAction(1);
            }
        }).setMoveDownActionUpdater(new AnActionButtonUpdater(){

            public boolean isEnabled(AnActionEvent e) {
                return ConfigureTasksActivationDialog.this.isMoveActionEnabled(1);
            }
        }).setToolbarPosition(ActionToolbarPosition.RIGHT).setToolbarBorder(IdeBorderFactory.createEmptyBorder());
        this.tasksPanel.add(decorator.createPanel());
        return this.contentPane;
    }

    private boolean isMoveActionEnabled(int increment) {
        DefaultMutableTreeNode sibling;
        DefaultMutableTreeNode[] selectedNodes = (DefaultMutableTreeNode[])this.myTree.getSelectedNodes(DefaultMutableTreeNode.class, null);
        if (selectedNodes.length == 0) {
            return false;
        }
        boolean enabled = true;
        for (DefaultMutableTreeNode node : selectedNodes) {
            sibling = increment == -1 ? node.getPreviousSibling() : node.getNextSibling();
            enabled = enabled && node.getUserObject() instanceof TaskNode && sibling != null;
        }
        if (!enabled) {
            enabled = true;
            for (DefaultMutableTreeNode node : selectedNodes) {
                sibling = increment == -1 ? node.getPreviousSibling() : node.getNextSibling();
                enabled = enabled && node.getUserObject() instanceof ProjectNode && sibling != null;
            }
        }
        return enabled;
    }

    private void moveAction(int increment) {
        List<ExternalSystemTaskActivator.TaskActivationEntry> tasks = this.findSelectedTasks();
        if (!tasks.isEmpty()) {
            this.myTaskActivator.moveTasks(tasks, increment);
        } else {
            List<String> projectsPaths = this.findSelectedProjects();
            if (projectsPaths.isEmpty()) {
                return;
            }
            ProjectItem item = (ProjectItem)this.projectCombobox.getSelectedItem();
            this.myTaskActivator.moveProjects(this.myProjectSystemId, projectsPaths, item.myProjectSettings.getModules(), increment);
        }
        ConfigureTasksActivationDialog.moveSelectedRows(this.myTree, increment);
    }

    private static void moveSelectedRows(final @NotNull SimpleTree tree, final int direction) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/openapi/externalSystem/service/task/ui/ConfigureTasksActivationDialog", "moveSelectedRows"));
        }
        Object[] selectionPaths = tree.getSelectionPaths();
        if (selectionPaths == null) {
            return;
        }
        ContainerUtil.sort((Object[])selectionPaths, (Comparator)new Comparator<TreePath>(){

            @Override
            public int compare(TreePath o1, TreePath o2) {
                return -direction * this.compare(tree.getRowForPath(o1), tree.getRowForPath(o2));
            }

            @Override
            private int compare(int x, int y) {
                return x < y ? -1 : (x == y ? 0 : 1);
            }
        });
        for (Object selectionPath : selectionPaths) {
            DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)((TreePath)selectionPath).getLastPathComponent();
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)treeNode.getParent();
            int idx = parent.getIndex(treeNode);
            ((DefaultTreeModel)tree.getModel()).removeNodeFromParent(treeNode);
            ((DefaultTreeModel)tree.getModel()).insertNodeInto(treeNode, parent, idx + direction);
        }
        tree.addSelectionPaths((TreePath[])selectionPaths);
    }

    @NotNull
    private List<ExternalSystemTaskActivator.TaskActivationEntry> findSelectedTasks() {
        List tasks = ContainerUtil.newSmartList();
        for (DefaultMutableTreeNode node : (DefaultMutableTreeNode[])this.myTree.getSelectedNodes(DefaultMutableTreeNode.class, null)) {
            ContainerUtil.addAll((Collection)tasks, this.findTasksUnder((SimpleNode[])ContainerUtil.ar((Object[])new MyNode[]{(MyNode)((Object)node.getUserObject())})));
        }
        List list = tasks;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/task/ui/ConfigureTasksActivationDialog", "findSelectedTasks"));
        }
        return list;
    }

    @NotNull
    private List<ExternalSystemTaskActivator.TaskActivationEntry> findTasksUnder(@NotNull SimpleNode[] nodes) {
        if (nodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodes", "com/intellij/openapi/externalSystem/service/task/ui/ConfigureTasksActivationDialog", "findTasksUnder"));
        }
        List tasks = ContainerUtil.newSmartList();
        for (SimpleNode node : nodes) {
            if (node instanceof TaskNode) {
                TaskNode taskNode = (TaskNode)node;
                String taskName = taskNode.getName();
                PhaseNode phaseNode = (PhaseNode)taskNode.getParent();
                tasks.add(new ExternalSystemTaskActivator.TaskActivationEntry(this.myProjectSystemId, phaseNode.myPhase, phaseNode.myProjectPath, taskName));
                continue;
            }
            ContainerUtil.addAll((Collection)tasks, this.findTasksUnder(node.getChildren()));
        }
        List list = tasks;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/task/ui/ConfigureTasksActivationDialog", "findTasksUnder"));
        }
        return list;
    }

    private List<String> findSelectedProjects() {
        ArrayList tasks = ContainerUtil.newArrayList();
        for (DefaultMutableTreeNode node : (DefaultMutableTreeNode[])this.myTree.getSelectedNodes(DefaultMutableTreeNode.class, null)) {
            if (!(node.getUserObject() instanceof ProjectNode)) continue;
            ProjectNode projectNode = (ProjectNode)((Object)node.getUserObject());
            tasks.add(projectNode.myProjectPath);
        }
        return tasks;
    }

    private MyNode[] buildProjectsNodes(final ExternalProjectSettings projectSettings, final ExternalProjectsManager.ExternalProjectsStateProvider stateProvider, final RootNode parent) {
        ArrayList paths = ContainerUtil.newArrayList(stateProvider.getProjectsTasksActivationMap(this.myProjectSystemId).keySet());
        paths.retainAll(projectSettings.getModules());
        return (MyNode[])ContainerUtil.mapNotNull((Object[])ArrayUtil.toStringArray((Collection)paths), (Function)new Function<String, MyNode>(){

            public MyNode fun(String path) {
                ProjectNode node = new ProjectNode(parent, stateProvider, projectSettings.getExternalProjectPath(), path);
                return node.getChildren().length > 0 ? node : null;
            }
        }, (Object[])new MyNode[0]);
    }

    private MyNode[] buildProjectPhasesNodes(final String projectPath, final TaskActivationState tasksActivation, final MyNode parent) {
        return (MyNode[])ContainerUtil.mapNotNull((Object[])ExternalSystemTaskActivator.Phase.values(), (Function)new Function<ExternalSystemTaskActivator.Phase, MyNode>(){

            public MyNode fun(ExternalSystemTaskActivator.Phase phase) {
                return tasksActivation.getTasks(phase).isEmpty() ? null : new PhaseNode(projectPath, phase, tasksActivation, (SimpleNode)parent);
            }
        }, (Object[])new MyNode[0]);
    }

    private void updateTree(@Nullable CachingSimpleNode nodeToUpdate) {
        THashSet toUpdate = ContainerUtil.newIdentityTroveSet();
        if (nodeToUpdate == null) {
            for (DefaultMutableTreeNode node : (DefaultMutableTreeNode[])this.myTree.getSelectedNodes(DefaultMutableTreeNode.class, null)) {
                Object userObject = node.getUserObject();
                if (!(userObject instanceof SimpleNode) || !(((SimpleNode)userObject).getParent() instanceof CachingSimpleNode)) continue;
                toUpdate.add((CachingSimpleNode)((SimpleNode)userObject).getParent());
            }
        } else {
            toUpdate.add(nodeToUpdate);
        }
        if (toUpdate.isEmpty()) {
            toUpdate.add(this.myRootNode);
        }
        Element treeStateElement = new Element("root");
        try {
            TreeState.createOn((JTree)this.myTree).writeExternal(treeStateElement);
        }
        catch (WriteExternalException writeExternalException) {
            // empty catch block
        }
        for (CachingSimpleNode node : toUpdate) {
            this.cleanUpEmptyNodes(node);
        }
        TreeState treeState = new TreeState();
        try {
            treeState.readExternal(treeStateElement);
            treeState.applyTo((JTree)this.myTree);
        }
        catch (InvalidDataException invalidDataException) {
            // empty catch block
        }
    }

    private void cleanUpEmptyNodes(@NotNull CachingSimpleNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/openapi/externalSystem/service/task/ui/ConfigureTasksActivationDialog", "cleanUpEmptyNodes"));
        }
        node.cleanUpCache();
        this.treeBuilder.addSubtreeToUpdateByElement((Object)node);
        if (node.getChildren().length == 0 && node.getParent() instanceof CachingSimpleNode) {
            this.cleanUpEmptyNodes((CachingSimpleNode)node.getParent());
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        ComboBox comboBox;
        JPanel jPanel2;
        JPanel jPanel3;
        this.contentPane = jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(10, 10));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, "North");
        this.projectFieldPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.projectCombobox = comboBox = new ComboBox();
        jPanel2.add((Component)comboBox, "Center");
        this.tasksPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel4.add((Component)jPanel, new GridConstraints(1, 0, 2, 1, 0, 3, 3, 3, new Dimension(300, 300), null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }

    private class TaskNode
    extends MyNode {
        private final String myTaskName;

        public TaskNode(String taskName, PhaseNode parent) {
            super((SimpleNode)parent);
            this.myTaskName = taskName;
        }

        protected void update(PresentationData presentation) {
            super.update(presentation);
            presentation.setIcon(ConfigureTasksActivationDialog.this.uiAware.getTaskIcon());
        }

        public MyNode[] buildChildren() {
            return new MyNode[0];
        }

        public String getName() {
            return this.myTaskName;
        }

        public boolean isAlwaysLeaf() {
            return true;
        }
    }

    private class PhaseNode
    extends MyNode {
        private final ExternalSystemTaskActivator.Phase myPhase;
        private final TaskActivationState myTaskActivationState;
        private final String myProjectPath;

        public PhaseNode(String projectPath, ExternalSystemTaskActivator.Phase phase, TaskActivationState taskActivationState, SimpleNode parent) {
            super(parent);
            this.myPhase = phase;
            this.myTaskActivationState = taskActivationState;
            this.myProjectPath = projectPath;
        }

        protected void update(PresentationData presentation) {
            super.update(presentation);
            presentation.setIcon(ExternalSystemIcons.TaskGroup);
        }

        public boolean isAutoExpandNode() {
            return true;
        }

        public MyNode[] buildChildren() {
            return (MyNode[])ContainerUtil.map2Array(this.myTaskActivationState.getTasks(this.myPhase), MyNode.class, (Function)new Function<String, MyNode>(){

                public MyNode fun(String taskName) {
                    return new TaskNode(taskName, PhaseNode.this);
                }
            });
        }

        public String getName() {
            return this.myPhase.toString();
        }
    }

    private class ProjectNode
    extends MyNode {
        private final ExternalProjectsManager.ExternalProjectsStateProvider myStateProvider;
        private final String myRootProjectPath;
        private final String myProjectPath;
        private final String myProjectName;

        public ProjectNode(RootNode parent, ExternalProjectsManager.ExternalProjectsStateProvider stateProvider, String rootProjectPath, String projectPath) {
            super((SimpleNode)parent);
            this.myStateProvider = stateProvider;
            this.myProjectPath = projectPath;
            this.myRootProjectPath = rootProjectPath;
            this.myProjectName = ConfigureTasksActivationDialog.this.uiAware.getProjectRepresentationName(this.myProjectPath, this.myRootProjectPath);
        }

        protected void update(PresentationData presentation) {
            super.update(presentation);
            presentation.setIcon(ExternalSystemIcons.TaskGroup);
        }

        public String getName() {
            return this.myProjectName;
        }

        protected MyNode[] buildChildren() {
            TaskActivationState tasksActivation = this.myStateProvider.getTasksActivation(ConfigureTasksActivationDialog.this.myProjectSystemId, this.myProjectPath);
            return ConfigureTasksActivationDialog.this.buildProjectPhasesNodes(this.myProjectPath, tasksActivation, this);
        }
    }

    private class RootNode
    extends MyNode {
        private final ExternalProjectsManager.ExternalProjectsStateProvider myStateProvider;

        public RootNode() {
            super(ConfigureTasksActivationDialog.this.myProject, null);
            this.myStateProvider = ExternalProjectsManager.getInstance(ConfigureTasksActivationDialog.this.myProject).getStateProvider();
        }

        public boolean isAutoExpandNode() {
            return true;
        }

        protected MyNode[] buildChildren() {
            ProjectItem item = (ProjectItem)ConfigureTasksActivationDialog.this.projectCombobox.getSelectedItem();
            if (item == null) {
                return new MyNode[0];
            }
            if (item.myProjectSettings.getModules().isEmpty() || item.myProjectSettings.getModules().size() == 1) {
                TaskActivationState tasksActivation = this.myStateProvider.getTasksActivation(ConfigureTasksActivationDialog.this.myProjectSystemId, item.myProjectSettings.getExternalProjectPath());
                return ConfigureTasksActivationDialog.this.buildProjectPhasesNodes(item.myProjectSettings.getExternalProjectPath(), tasksActivation, this);
            }
            return ConfigureTasksActivationDialog.this.buildProjectsNodes(item.myProjectSettings, this.myStateProvider, this);
        }
    }

    private static abstract class MyNode
    extends CachingSimpleNode {
        protected MyNode(SimpleNode aParent) {
            super(aParent);
        }

        public MyNode(Project aProject, @Nullable NodeDescriptor aParentDescriptor) {
            super(aProject, aParentDescriptor);
        }
    }

    private class ChooseProjectStep
    extends BaseListPopupStep<ProjectPopupItem> {
        protected ChooseProjectStep(List<ProjectPopupItem> values) {
            super("Choose project", values);
        }

        public PopupStep onChosen(final ProjectPopupItem projectPopupItem, boolean finalChoice) {
            return new BaseListPopupStep<ExternalSystemTaskActivator.Phase>("Choose activation phase", ExternalSystemTaskActivator.Phase.values()){

                public PopupStep onChosen(final ExternalSystemTaskActivator.Phase selectedPhase, boolean finalChoice) {
                    Map<String, TaskActivationState> activationMap = ExternalProjectsManager.getInstance(ConfigureTasksActivationDialog.this.myProject).getStateProvider().getProjectsTasksActivationMap(ConfigureTasksActivationDialog.this.myProjectSystemId);
                    final String projectPath = projectPopupItem.myModuleData.getLinkedExternalProjectPath();
                    List<String> tasks = activationMap.get(projectPath).getTasks(selectedPhase);
                    ArrayList tasksToSuggest = ContainerUtil.newArrayList(projectPopupItem.myTasks);
                    tasksToSuggest.removeAll(tasks);
                    return new BaseListPopupStep<String>("Choose task", (List)tasksToSuggest){

                        public PopupStep onChosen(final String taskName, boolean finalChoice) {
                            return this.doFinalStep(new Runnable(){

                                @Override
                                public void run() {
                                    ConfigureTasksActivationDialog.this.myTaskActivator.addTask(new ExternalSystemTaskActivator.TaskActivationEntry(ConfigureTasksActivationDialog.this.myProjectSystemId, selectedPhase, projectPath, taskName));
                                    ConfigureTasksActivationDialog.this.updateTree(ConfigureTasksActivationDialog.this.myRootNode);
                                }
                            });
                        }
                    };
                }

                public boolean hasSubstep(ExternalSystemTaskActivator.Phase phase) {
                    return true;
                }
            };
        }

        public boolean hasSubstep(ProjectPopupItem selectedValue) {
            return true;
        }
    }

    private static class ProjectPopupItem {
        ModuleData myModuleData;
        List<String> myTasks;

        public ProjectPopupItem(ModuleData moduleData, List<String> tasks) {
            this.myModuleData = moduleData;
            this.myTasks = tasks;
        }

        public String toString() {
            return this.myModuleData.getId();
        }
    }

    private static class ProjectItem {
        private static final int MAX_LENGTH = 80;
        @NotNull
        String projectName;
        @NotNull
        ExternalProjectSettings myProjectSettings;

        public ProjectItem(@NotNull String projectName, @NotNull ExternalProjectSettings projectPath) {
            if (projectName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectName", "com/intellij/openapi/externalSystem/service/task/ui/ConfigureTasksActivationDialog$ProjectItem", "<init>"));
            }
            if (projectPath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectPath", "com/intellij/openapi/externalSystem/service/task/ui/ConfigureTasksActivationDialog$ProjectItem", "<init>"));
            }
            this.projectName = projectName;
            this.myProjectSettings = projectPath;
        }

        public String toString() {
            return this.projectName + " (" + ProjectItem.truncate(this.myProjectSettings.getExternalProjectPath()) + ")";
        }

        @NotNull
        private static String truncate(@NotNull String s) {
            if (s == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/openapi/externalSystem/service/task/ui/ConfigureTasksActivationDialog$ProjectItem", "truncate"));
            }
            String string = s.length() < 80 ? s : s.substring(0, 40) + "..." + s.substring(s.length() - 40 - 3);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/task/ui/ConfigureTasksActivationDialog$ProjectItem", "truncate"));
            }
            return string;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ProjectItem)) {
                return false;
            }
            ProjectItem item = (ProjectItem)o;
            return this.myProjectSettings.equals((Object)item.myProjectSettings);
        }

        public int hashCode() {
            return this.myProjectSettings.hashCode();
        }
    }
}

