/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl;

import com.intellij.ide.WelcomeWizardUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManagerListener;
import com.intellij.openapi.keymap.ex.KeymapManagerEx;
import com.intellij.openapi.keymap.impl.DefaultKeymap;
import com.intellij.openapi.keymap.impl.KeymapImpl;
import com.intellij.openapi.keymap.impl.ModifierKeyDoubleClickHandler;
import com.intellij.openapi.keymap.impl.WeakKeymapManagerListener;
import com.intellij.openapi.options.BaseSchemeProcessor;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemeProcessor;
import com.intellij.openapi.options.SchemesManager;
import com.intellij.openapi.options.SchemesManagerFactory;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="KeymapManager", storages={@Storage(file="$APP_CONFIG$/keymap.xml", roamingType=RoamingType.PER_PLATFORM)}, additionalExportFile="$ROOT_CONFIG$/keymaps")
public class KeymapManagerImpl
extends KeymapManagerEx
implements PersistentStateComponent<Element>,
ApplicationComponent {
    static final String KEYMAPS_DIR_PATH = "$ROOT_CONFIG$/keymaps";
    private final List<KeymapManagerListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private String myActiveKeymapName;
    private final Map<String, String> myBoundShortcuts = new HashMap<String, String>();
    @NonNls
    private static final String ACTIVE_KEYMAP = "active_keymap";
    @NonNls
    private static final String NAME_ATTRIBUTE = "name";
    private final SchemesManager<Keymap, KeymapImpl> mySchemesManager;
    public static boolean ourKeymapManagerInitialized = false;

    KeymapManagerImpl(DefaultKeymap defaultKeymap, SchemesManagerFactory factory) {
        BaseSchemeProcessor<KeymapImpl> schemeProcessor = new BaseSchemeProcessor<KeymapImpl>(){

            @NotNull
            public KeymapImpl readScheme(@NotNull Element element) throws InvalidDataException {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/keymap/impl/KeymapManagerImpl$1", "readScheme"));
                }
                KeymapImpl keymap = new KeymapImpl();
                keymap.readExternal(element, KeymapManagerImpl.this.getAllIncludingDefaultsKeymaps());
                KeymapImpl keymapImpl = keymap;
                if (keymapImpl == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/keymap/impl/KeymapManagerImpl$1", "readScheme"));
                }
                return keymapImpl;
            }

            public Element writeScheme(@NotNull KeymapImpl scheme) {
                if (scheme == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/openapi/keymap/impl/KeymapManagerImpl$1", "writeScheme"));
                }
                return scheme.writeExternal();
            }

            @NotNull
            public BaseSchemeProcessor.State getState(@NotNull KeymapImpl scheme) {
                if (scheme == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/openapi/keymap/impl/KeymapManagerImpl$1", "getState"));
                }
                BaseSchemeProcessor.State state = scheme.canModify() ? BaseSchemeProcessor.State.POSSIBLY_CHANGED : BaseSchemeProcessor.State.NON_PERSISTENT;
                if (state == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/keymap/impl/KeymapManagerImpl$1", "getState"));
                }
                return state;
            }
        };
        this.mySchemesManager = factory.createSchemesManager(KEYMAPS_DIR_PATH, (SchemeProcessor)schemeProcessor, RoamingType.PER_USER);
        Keymap[] keymaps = defaultKeymap.getKeymaps();
        String systemDefaultKeymap = WelcomeWizardUtil.getWizardMacKeymap() != null ? WelcomeWizardUtil.getWizardMacKeymap() : defaultKeymap.getDefaultKeymapName();
        for (Keymap keymap : keymaps) {
            this.addKeymap(keymap);
            if (!keymap.getName().equals(systemDefaultKeymap)) continue;
            this.setActiveKeymap(keymap);
        }
        this.mySchemesManager.loadSchemes();
        if (Registry.is((String)"editor.add.carets.on.double.control.arrows")) {
            int modifierKeyCode = SystemInfo.isMac ? 18 : 17;
            ModifierKeyDoubleClickHandler.getInstance().registerAction("EditorCloneCaretAbove", modifierKeyCode, 38);
            ModifierKeyDoubleClickHandler.getInstance().registerAction("EditorCloneCaretBelow", modifierKeyCode, 40);
            ModifierKeyDoubleClickHandler.getInstance().registerAction("EditorLeftWithSelection", modifierKeyCode, 37);
            ModifierKeyDoubleClickHandler.getInstance().registerAction("EditorRightWithSelection", modifierKeyCode, 39);
            ModifierKeyDoubleClickHandler.getInstance().registerAction("EditorLineStartWithSelection", modifierKeyCode, 36);
            ModifierKeyDoubleClickHandler.getInstance().registerAction("EditorLineEndWithSelection", modifierKeyCode, 35);
        }
        ourKeymapManagerInitialized = true;
    }

    @Override
    public Keymap[] getAllKeymaps() {
        ArrayList<Keymap> answer = new ArrayList<Keymap>();
        for (Keymap keymap : this.mySchemesManager.getAllSchemes()) {
            if (keymap.getPresentableName().startsWith("$")) continue;
            answer.add(keymap);
        }
        return answer.toArray(new Keymap[answer.size()]);
    }

    public Keymap[] getAllIncludingDefaultsKeymaps() {
        List keymaps = this.mySchemesManager.getAllSchemes();
        return keymaps.toArray(new Keymap[keymaps.size()]);
    }

    @Nullable
    public Keymap getKeymap(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", NAME_ATTRIBUTE, "com/intellij/openapi/keymap/impl/KeymapManagerImpl", "getKeymap"));
        }
        return (Keymap)this.mySchemesManager.findSchemeByName(name);
    }

    public Keymap getActiveKeymap() {
        return (Keymap)this.mySchemesManager.getCurrentScheme();
    }

    @Override
    public void setActiveKeymap(Keymap activeKeymap) {
        this.mySchemesManager.setCurrentSchemeName(activeKeymap == null ? null : activeKeymap.getName());
        this.fireActiveKeymapChanged();
    }

    @Override
    public void bindShortcuts(String sourceActionId, String targetActionId) {
        this.myBoundShortcuts.put(targetActionId, sourceActionId);
    }

    @Override
    public void unbindShortcuts(String targetActionId) {
        this.myBoundShortcuts.remove(targetActionId);
    }

    @Override
    public Set<String> getBoundActions() {
        return this.myBoundShortcuts.keySet();
    }

    @Override
    public String getActionBinding(String actionId) {
        String next;
        HashSet visited = null;
        String id = actionId;
        while ((next = this.myBoundShortcuts.get(id)) != null) {
            if (visited == null) {
                visited = ContainerUtil.newHashSet();
            }
            if (visited.add(id = next)) continue;
        }
        return Comparing.equal((String)id, (String)actionId) ? null : id;
    }

    @Override
    public SchemesManager<Keymap, KeymapImpl> getSchemesManager() {
        return this.mySchemesManager;
    }

    public void addKeymap(Keymap keymap) {
        this.mySchemesManager.addNewScheme((Scheme)keymap, true);
    }

    public void removeAllKeymapsExceptUnmodifiable() {
        List schemes = this.mySchemesManager.getAllSchemes();
        for (int i = schemes.size() - 1; i >= 0; --i) {
            Keymap keymap = (Keymap)schemes.get(i);
            if (!keymap.canModify()) continue;
            this.mySchemesManager.removeScheme((Scheme)keymap);
        }
        this.mySchemesManager.setCurrentSchemeName(null);
        List keymaps = this.mySchemesManager.getAllSchemes();
        if (!keymaps.isEmpty()) {
            this.mySchemesManager.setCurrentSchemeName(((Keymap)keymaps.iterator().next()).getName());
        }
    }

    public Element getState() {
        Element result = new Element("component");
        if (this.mySchemesManager.getCurrentScheme() != null) {
            Element e = new Element(ACTIVE_KEYMAP);
            Keymap currentScheme = (Keymap)this.mySchemesManager.getCurrentScheme();
            if (currentScheme != null) {
                e.setAttribute(NAME_ATTRIBUTE, currentScheme.getName());
            }
            result.addContent(e);
        }
        return result;
    }

    public void loadState(Element state) {
        Keymap keymap;
        Element child = state.getChild(ACTIVE_KEYMAP);
        if (child != null) {
            this.myActiveKeymapName = child.getAttributeValue(NAME_ATTRIBUTE);
        }
        if (this.myActiveKeymapName != null && (keymap = this.getKeymap(this.myActiveKeymapName)) != null) {
            this.setActiveKeymap(keymap);
        }
    }

    private void fireActiveKeymapChanged() {
        for (KeymapManagerListener listener : this.myListeners) {
            listener.activeKeymapChanged((Keymap)this.mySchemesManager.getCurrentScheme());
        }
    }

    public void addKeymapManagerListener(@NotNull KeymapManagerListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/keymap/impl/KeymapManagerImpl", "addKeymapManagerListener"));
        }
        this.pollQueue();
        this.myListeners.add(listener);
    }

    public void addKeymapManagerListener(final @NotNull KeymapManagerListener listener, @NotNull Disposable parentDisposable) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/keymap/impl/KeymapManagerImpl", "addKeymapManagerListener"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/keymap/impl/KeymapManagerImpl", "addKeymapManagerListener"));
        }
        this.pollQueue();
        this.myListeners.add(listener);
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                KeymapManagerImpl.this.removeKeymapManagerListener(listener);
            }
        });
    }

    private void pollQueue() {
        for (KeymapManagerListener listener : this.myListeners) {
            if (!(listener instanceof WeakKeymapManagerListener) || !((WeakKeymapManagerListener)listener).isDead()) continue;
            this.myListeners.remove(listener);
        }
    }

    public void removeKeymapManagerListener(@NotNull KeymapManagerListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/keymap/impl/KeymapManagerImpl", "removeKeymapManagerListener"));
        }
        this.pollQueue();
        this.myListeners.remove(listener);
    }

    @Override
    public void addWeakListener(@NotNull KeymapManagerListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/keymap/impl/KeymapManagerImpl", "addWeakListener"));
        }
        this.addKeymapManagerListener(new WeakKeymapManagerListener(this, listener));
    }

    @Override
    public void removeWeakListener(@NotNull KeymapManagerListener listenerToRemove) {
        if (listenerToRemove == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listenerToRemove", "com/intellij/openapi/keymap/impl/KeymapManagerImpl", "removeWeakListener"));
        }
        for (KeymapManagerListener listener : this.myListeners) {
            if (!(listener instanceof WeakKeymapManagerListener) || !((WeakKeymapManagerListener)listener).isWrapped(listenerToRemove)) continue;
            this.myListeners.remove(listener);
        }
    }

    @NotNull
    public String getComponentName() {
        if ("KeymapManager" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/keymap/impl/KeymapManagerImpl", "getComponentName"));
        }
        return "KeymapManager";
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }
}

