/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.progress.util.ProgressWindow;
import com.intellij.openapi.progress.util.SmoothProgressAdapter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.SystemNotifications;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.util.concurrent.Future;
import javax.swing.JComponent;
import javax.swing.JFrame;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProgressManagerImpl
extends CoreProgressManager
implements Disposable {
    @Override
    public void setCancelButtonText(String cancelButtonText) {
        ProgressIndicator original;
        ProgressIndicator progressIndicator = this.getProgressIndicator();
        if (progressIndicator != null && progressIndicator instanceof SmoothProgressAdapter && cancelButtonText != null && (original = ((SmoothProgressAdapter)progressIndicator).getOriginalProgressIndicator()) instanceof ProgressWindow) {
            ((ProgressWindow)original).setCancelButtonText(cancelButtonText);
        }
    }

    @Override
    public void executeProcessUnderProgress(@NotNull Runnable process, ProgressIndicator progress) throws ProcessCanceledException {
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/openapi/progress/impl/ProgressManagerImpl", "executeProcessUnderProgress"));
        }
        if (progress instanceof ProgressWindow) {
            this.myCurrentUnsafeProgressCount.incrementAndGet();
        }
        try {
            super.executeProcessUnderProgress(process, progress);
        }
        finally {
            if (progress instanceof ProgressWindow) {
                this.myCurrentUnsafeProgressCount.decrementAndGet();
            }
        }
    }

    public static void runWithAlwaysCheckingCanceled(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/progress/impl/ProgressManagerImpl", "runWithAlwaysCheckingCanceled"));
        }
        Thread fake = new Thread("fake");
        try {
            threadsUnderCanceledIndicator.add(fake);
            runnable.run();
        }
        finally {
            threadsUnderCanceledIndicator.remove(fake);
        }
    }

    @Override
    protected boolean runProcessWithProgressSynchronously(@NotNull Task task, @Nullable JComponent parentComponent) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/progress/impl/ProgressManagerImpl", "runProcessWithProgressSynchronously"));
        }
        long start = System.currentTimeMillis();
        boolean result = super.runProcessWithProgressSynchronously(task, parentComponent);
        if (result) {
            JFrame frame;
            long end = System.currentTimeMillis();
            Task.NotificationInfo notificationInfo = task.notifyFinished();
            long time = end - start;
            if (notificationInfo != null && time > 5000L && (frame = WindowManager.getInstance().getFrame(task.getProject())) != null && !frame.hasFocus()) {
                ProgressManagerImpl.systemNotify(notificationInfo);
            }
        }
        return result;
    }

    private static void systemNotify(@NotNull Task.NotificationInfo info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/openapi/progress/impl/ProgressManagerImpl", "systemNotify"));
        }
        SystemNotifications.getInstance().notify(info.getNotificationName(), info.getNotificationTitle(), info.getNotificationText());
    }

    @Override
    @NotNull
    public Future<?> runProcessWithProgressAsynchronously(@NotNull Task.Backgroundable task) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/progress/impl/ProgressManagerImpl", "runProcessWithProgressAsynchronously"));
        }
        Object progressIndicator = ApplicationManager.getApplication().isHeadlessEnvironment() ? new EmptyProgressIndicator() : new BackgroundableProcessIndicator(task);
        Future<?> future = this.runProcessWithProgressAsynchronously(task, (ProgressIndicator)progressIndicator, null);
        if (future == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/progress/impl/ProgressManagerImpl", "runProcessWithProgressAsynchronously"));
        }
        return future;
    }

    @Override
    @NotNull
    public Future<?> runProcessWithProgressAsynchronously(final @NotNull Task.Backgroundable task, final @NotNull ProgressIndicator progressIndicator, @Nullable Runnable continuation, final @NotNull ModalityState modalityState) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/openapi/progress/impl/ProgressManagerImpl", "runProcessWithProgressAsynchronously"));
        }
        if (progressIndicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressIndicator", "com/intellij/openapi/progress/impl/ProgressManagerImpl", "runProcessWithProgressAsynchronously"));
        }
        if (modalityState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modalityState", "com/intellij/openapi/progress/impl/ProgressManagerImpl", "runProcessWithProgressAsynchronously"));
        }
        if (progressIndicator instanceof Disposable) {
            Disposer.register((Disposable)ApplicationManager.getApplication(), (Disposable)((Disposable)progressIndicator));
        }
        final CoreProgressManager.TaskRunnable process = new CoreProgressManager.TaskRunnable((Task)task, progressIndicator, continuation);
        CoreProgressManager.TaskContainer action = new CoreProgressManager.TaskContainer((Task)task){

            @Override
            public void run() {
                boolean canceled = false;
                long start = System.currentTimeMillis();
                try {
                    ProgressManager.getInstance().runProcess(process, progressIndicator);
                }
                catch (ProcessCanceledException e) {
                    canceled = true;
                }
                long end = System.currentTimeMillis();
                long time = end - start;
                if (canceled || progressIndicator.isCanceled()) {
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            task.onCancel();
                        }
                    }, modalityState);
                } else {
                    Window window;
                    Task.NotificationInfo notificationInfo = task.notifyFinished();
                    if (notificationInfo != null && time > 5000L && ((window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow()) == null || notificationInfo.isShowWhenFocused())) {
                        ProgressManagerImpl.systemNotify(notificationInfo);
                    }
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            task.onSuccess();
                        }
                    }, modalityState);
                }
            }
        };
        Future future = ApplicationManager.getApplication().executeOnPooledThread((Runnable)action);
        if (future == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/progress/impl/ProgressManagerImpl", "runProcessWithProgressAsynchronously"));
        }
        return future;
    }
}

