/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.ProjectRootListener;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.ex.ProjectRoot;
import com.intellij.openapi.projectRoots.ex.ProjectRootContainer;
import com.intellij.openapi.projectRoots.impl.ProjectRootContainerImpl;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.RootProvider;
import com.intellij.openapi.roots.impl.RootProviderBaseImpl;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectJdkImpl
extends UserDataHolderBase
implements JDOMExternalizable,
Sdk,
SdkModificator {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.projectRoots.impl.ProjectJdkImpl");
    private final ProjectRootContainerImpl myRootContainer;
    private String myName;
    private String myVersionString;
    private boolean myVersionDefined = false;
    private String myHomePath = "";
    private final MyRootProvider myRootProvider = new MyRootProvider();
    private ProjectJdkImpl myOrigin = null;
    private SdkAdditionalData myAdditionalData = null;
    private SdkTypeId mySdkType;
    @NonNls
    public static final String ELEMENT_NAME = "name";
    @NonNls
    public static final String ATTRIBUTE_VALUE = "value";
    @NonNls
    public static final String ELEMENT_TYPE = "type";
    @NonNls
    public static final String ELEMENT_VERSION = "version";
    @NonNls
    private static final String ELEMENT_ROOTS = "roots";
    @NonNls
    private static final String ELEMENT_ROOT = "root";
    @NonNls
    private static final String ELEMENT_PROPERTY = "property";
    @NonNls
    private static final String VALUE_JDKHOME = "jdkHome";
    @NonNls
    private static final String ATTRIBUTE_FILE = "file";
    @NonNls
    public static final String ELEMENT_HOMEPATH = "homePath";
    @NonNls
    private static final String ELEMENT_ADDITIONAL = "additional";

    public ProjectJdkImpl(String name, SdkTypeId sdkType) {
        this.mySdkType = sdkType;
        this.myRootContainer = new ProjectRootContainerImpl(true);
        this.myName = name;
        this.myRootContainer.addProjectRootContainerListener(this.myRootProvider);
    }

    public ProjectJdkImpl(String name, SdkTypeId sdkType, String homePath, String version) {
        this(name, sdkType);
        this.myHomePath = homePath;
        this.myVersionString = version;
    }

    @NotNull
    public SdkTypeId getSdkType() {
        if (this.mySdkType == null) {
            this.mySdkType = ProjectJdkTable.getInstance().getDefaultSdkType();
        }
        SdkTypeId sdkTypeId = this.mySdkType;
        if (sdkTypeId == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/projectRoots/impl/ProjectJdkImpl", "getSdkType"));
        }
        return sdkTypeId;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/projectRoots/impl/ProjectJdkImpl", "getName"));
        }
        return string;
    }

    public void setName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ELEMENT_NAME, "com/intellij/openapi/projectRoots/impl/ProjectJdkImpl", "setName"));
        }
        this.myName = name;
    }

    public final void setVersionString(@Nullable String versionString) {
        this.myVersionString = versionString == null || versionString.isEmpty() ? null : versionString;
        this.myVersionDefined = true;
    }

    public String getVersionString() {
        String homePath;
        if (this.myVersionString == null && !this.myVersionDefined && (homePath = this.getHomePath()) != null && !homePath.isEmpty()) {
            this.setVersionString(this.getSdkType().getVersionString((Sdk)this));
        }
        return this.myVersionString;
    }

    public final void resetVersionString() {
        this.myVersionDefined = false;
        this.myVersionString = null;
    }

    public String getHomePath() {
        return this.myHomePath;
    }

    public VirtualFile getHomeDirectory() {
        if (this.myHomePath == null) {
            return null;
        }
        return StandardFileSystems.local().findFileByPath(this.myHomePath);
    }

    public void readExternal(Element element) throws InvalidDataException {
        Element version;
        String sdkTypeName;
        this.myName = element.getChild(ELEMENT_NAME).getAttributeValue(ATTRIBUTE_VALUE);
        Element typeChild = element.getChild(ELEMENT_TYPE);
        String string = sdkTypeName = typeChild != null ? typeChild.getAttributeValue(ATTRIBUTE_VALUE) : null;
        if (sdkTypeName != null) {
            this.mySdkType = ProjectJdkTable.getInstance().getSdkTypeByName(sdkTypeName);
        }
        if ((version = element.getChild(ELEMENT_VERSION)) != null) {
            this.setVersionString(version.getAttributeValue(ATTRIBUTE_VALUE));
        } else {
            this.myVersionDefined = false;
        }
        if (element.getAttribute(ELEMENT_VERSION) == null || !"2".equals(element.getAttributeValue(ELEMENT_VERSION))) {
            this.myRootContainer.startChange();
            this.myRootContainer.readOldVersion(element.getChild(ELEMENT_ROOTS));
            List children = element.getChild(ELEMENT_ROOTS).getChildren(ELEMENT_ROOT);
            for (Object aChildren : children) {
                Element root = (Element)aChildren;
                for (Object o : root.getChildren(ELEMENT_PROPERTY)) {
                    Element prop = (Element)o;
                    if (!ELEMENT_TYPE.equals(prop.getAttributeValue(ELEMENT_NAME)) || !VALUE_JDKHOME.equals(prop.getAttributeValue(ATTRIBUTE_VALUE))) continue;
                    this.myHomePath = VirtualFileManager.extractPath((String)root.getAttributeValue(ATTRIBUTE_FILE));
                }
            }
            this.myRootContainer.finishChange();
        } else {
            this.myHomePath = element.getChild(ELEMENT_HOMEPATH).getAttributeValue(ATTRIBUTE_VALUE);
            this.myRootContainer.readExternal(element.getChild(ELEMENT_ROOTS));
        }
        Element additional = element.getChild(ELEMENT_ADDITIONAL);
        if (additional != null) {
            LOG.assertTrue(this.mySdkType != null);
            this.myAdditionalData = this.mySdkType.loadAdditionalData((Sdk)this, additional);
        } else {
            this.myAdditionalData = null;
        }
    }

    public void writeExternal(Element element) throws WriteExternalException {
        element.setAttribute(ELEMENT_VERSION, "2");
        Element name = new Element(ELEMENT_NAME);
        name.setAttribute(ATTRIBUTE_VALUE, this.myName);
        element.addContent(name);
        if (this.mySdkType != null) {
            Element sdkType = new Element(ELEMENT_TYPE);
            sdkType.setAttribute(ATTRIBUTE_VALUE, this.mySdkType.getName());
            element.addContent(sdkType);
        }
        if (this.myVersionString != null) {
            Element version = new Element(ELEMENT_VERSION);
            version.setAttribute(ATTRIBUTE_VALUE, this.myVersionString);
            element.addContent(version);
        }
        Element home = new Element(ELEMENT_HOMEPATH);
        home.setAttribute(ATTRIBUTE_VALUE, this.myHomePath);
        element.addContent(home);
        Element roots = new Element(ELEMENT_ROOTS);
        this.myRootContainer.writeExternal(roots);
        element.addContent(roots);
        Element additional = new Element(ELEMENT_ADDITIONAL);
        if (this.myAdditionalData != null) {
            LOG.assertTrue(this.mySdkType != null);
            this.mySdkType.saveAdditionalData(this.myAdditionalData, additional);
        }
        element.addContent(additional);
    }

    public void setHomePath(String path) {
        boolean changes = this.myHomePath == null ? path != null : !this.myHomePath.equals(path);
        this.myHomePath = path;
        if (changes) {
            this.resetVersionString();
        }
    }

    @NotNull
    public Object clone() {
        ProjectJdkImpl newJdk = new ProjectJdkImpl("", this.mySdkType);
        this.copyTo(newJdk);
        ProjectJdkImpl projectJdkImpl = newJdk;
        if (projectJdkImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/projectRoots/impl/ProjectJdkImpl", "clone"));
        }
        return projectJdkImpl;
    }

    @NotNull
    public RootProvider getRootProvider() {
        MyRootProvider myRootProvider = this.myRootProvider;
        if (myRootProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/projectRoots/impl/ProjectJdkImpl", "getRootProvider"));
        }
        return myRootProvider;
    }

    public void copyTo(ProjectJdkImpl dest) {
        String name = this.getName();
        dest.setName(name);
        dest.setHomePath(this.getHomePath());
        if (this.myVersionDefined) {
            dest.setVersionString(this.getVersionString());
        } else {
            dest.resetVersionString();
        }
        dest.setSdkAdditionalData(this.getSdkAdditionalData());
        dest.myRootContainer.startChange();
        dest.myRootContainer.removeAllRoots();
        for (OrderRootType rootType : OrderRootType.getAllTypes()) {
            ProjectJdkImpl.copyRoots(this.myRootContainer, dest.myRootContainer, rootType);
        }
        dest.myRootContainer.finishChange();
    }

    private static void copyRoots(ProjectRootContainer srcContainer, ProjectRootContainer destContainer, OrderRootType type) {
        ProjectRoot[] newRoots;
        for (ProjectRoot newRoot : newRoots = srcContainer.getRoots(type)) {
            destContainer.addRoot(newRoot, type);
        }
    }

    @NotNull
    public SdkModificator getSdkModificator() {
        ProjectJdkImpl sdk = (ProjectJdkImpl)((Object)this.clone());
        sdk.myOrigin = this;
        sdk.myRootContainer.startChange();
        sdk.update();
        ProjectJdkImpl projectJdkImpl = sdk;
        if (projectJdkImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/projectRoots/impl/ProjectJdkImpl", "getSdkModificator"));
        }
        return projectJdkImpl;
    }

    public void commitChanges() {
        LOG.assertTrue(this.isWritable());
        this.myRootContainer.finishChange();
        this.copyTo(this.myOrigin);
        this.myOrigin = null;
    }

    public SdkAdditionalData getSdkAdditionalData() {
        return this.myAdditionalData;
    }

    public void setSdkAdditionalData(SdkAdditionalData data) {
        this.myAdditionalData = data;
    }

    public VirtualFile[] getRoots(OrderRootType rootType) {
        ProjectRoot[] roots = this.myRootContainer.getRoots(rootType);
        ArrayList files = new ArrayList(roots.length);
        for (ProjectRoot root : roots) {
            ContainerUtil.addAll(files, (Object[])root.getVirtualFiles());
        }
        return VfsUtilCore.toVirtualFileArray(files);
    }

    public void addRoot(VirtualFile root, OrderRootType rootType) {
        this.myRootContainer.addRoot(root, rootType);
    }

    public void removeRoot(VirtualFile root, OrderRootType rootType) {
        this.myRootContainer.removeRoot(root, rootType);
    }

    public void removeRoots(OrderRootType rootType) {
        this.myRootContainer.removeAllRoots(rootType);
    }

    public void removeAllRoots() {
        this.myRootContainer.removeAllRoots();
    }

    public boolean isWritable() {
        return this.myOrigin != null;
    }

    public void update() {
        try {
            this.myRootContainer.update();
        }
        finally {
            this.resetVersionString();
        }
    }

    public String toString() {
        return this.getName() + ": " + this.getVersionString() + " (" + this.getHomePath() + ")";
    }

    private class MyRootProvider
    extends RootProviderBaseImpl
    implements ProjectRootListener {
        private final List<RootProvider.RootSetChangedListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();

        private MyRootProvider() {
        }

        @NotNull
        public String[] getUrls(@NotNull OrderRootType rootType) {
            if (rootType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootType", "com/intellij/openapi/projectRoots/impl/ProjectJdkImpl$MyRootProvider", "getUrls"));
            }
            ProjectRoot[] rootFiles = ProjectJdkImpl.this.myRootContainer.getRoots(rootType);
            ArrayList result = new ArrayList();
            for (ProjectRoot rootFile : rootFiles) {
                ContainerUtil.addAll(result, (Object[])rootFile.getUrls());
            }
            String[] stringArray = ArrayUtil.toStringArray(result);
            if (stringArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/projectRoots/impl/ProjectJdkImpl$MyRootProvider", "getUrls"));
            }
            return stringArray;
        }

        @NotNull
        public VirtualFile[] getFiles(@NotNull OrderRootType rootType) {
            if (rootType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootType", "com/intellij/openapi/projectRoots/impl/ProjectJdkImpl$MyRootProvider", "getFiles"));
            }
            VirtualFile[] virtualFileArray = ProjectJdkImpl.this.myRootContainer.getRootFiles(rootType);
            if (virtualFileArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/projectRoots/impl/ProjectJdkImpl$MyRootProvider", "getFiles"));
            }
            return virtualFileArray;
        }

        @Override
        public void addRootSetChangedListener(@NotNull RootProvider.RootSetChangedListener listener) {
            if (listener == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/projectRoots/impl/ProjectJdkImpl$MyRootProvider", "addRootSetChangedListener"));
            }
            assert (!this.myListeners.contains(listener));
            this.myListeners.add(listener);
            super.addRootSetChangedListener(listener);
        }

        @Override
        public void addRootSetChangedListener(final @NotNull RootProvider.RootSetChangedListener listener, @NotNull Disposable parentDisposable) {
            if (listener == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/projectRoots/impl/ProjectJdkImpl$MyRootProvider", "addRootSetChangedListener"));
            }
            if (parentDisposable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/projectRoots/impl/ProjectJdkImpl$MyRootProvider", "addRootSetChangedListener"));
            }
            super.addRootSetChangedListener(listener, parentDisposable);
            Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

                public void dispose() {
                    MyRootProvider.this.removeRootSetChangedListener(listener);
                }
            });
        }

        @Override
        public void removeRootSetChangedListener(@NotNull RootProvider.RootSetChangedListener listener) {
            if (listener == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/projectRoots/impl/ProjectJdkImpl$MyRootProvider", "removeRootSetChangedListener"));
            }
            super.removeRootSetChangedListener(listener);
            this.myListeners.remove(listener);
        }

        public void rootsChanged() {
            if (this.myListeners.isEmpty()) {
                return;
            }
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    MyRootProvider.this.fireRootSetChanged();
                }
            });
        }
    }
}

